//
//  Lynkeos
//  $Id: MyPostProcessing.h,v 1.8 2005/01/27 23:12:00 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Wed Dec 10 2003.
//  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __MYPOSTPROCESSING_H
#define __MYPOSTPROCESSING_H

#import <Foundation/Foundation.h>

#include "processing_core.h"

#ifdef GNUSTEP
#import <AppKit/NSBitmapImageRep.h>
#else
#endif

@interface MyPostProcessing : NSObject
{
    RGB*		_source;
    FFT_DATA            _originalSpectrum;
    // Bug 11 : use a sequence number to detect change of input
    long		_spectrum_sequence;
    FFT_DATA            _result;
    FFT_DATA            _unsharpGauss, _deconvGauss;
    double		_unsharpRadius, _deconvRadius;
    u_short		_width, _height;
    REAL		_minValue, _maxValue;
}

- (REAL) minValue ;
- (REAL) maxValue ;

- (void) process :(RGB*)src seqnb:(long)sequence 
            width:(u_short)width height:(u_short)height
     deconvRadius:(double)dRadius deconvThreshold:(double)threshold
    unsharpRadius:(double)uRadius unsharpGain:(double)gain;

- (NSBitmapImageRep*) makeImageWithMin :(REAL)minV Max:(REAL)maxV ;

@end

#endif
