//
//  Lynkeos
//  $Id: MyImageList.h,v 1.8 2005/01/27 23:05:28 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Wed Sep 24 2003.
//  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __MYIMAGELIST_H
#define __MYIMAGELIST_H


#ifdef GNUSTEP
#else
#import <Cocoa/Cocoa.h>
#endif

#include "processing_core.h"
#include "MyImageListItem.h"
#include "MyImageListEnumerator.h"

/*!
 * @class MyImageList
 * @abstract Base model of a list of images to process
 * @discussion The images in the list share a common goal (dark frame, flat 
 *    field or object images.
 * @ingroup Models
 */
@interface MyImageList : NSObject <NSCoding>
{
@private
   // List
   NSMutableArray*	_list;
   // Stack data
   RGB*			_rawStack;
   u_long		_stackSize;
   double		_blackLevel, _whiteLevel;
}

/// \name Read accessors
//@{
   // List
- (NSMutableArray*) imageArray ;
- (MyImageListItem*) firstItem ;
- (MyImageListItem*) lastItem ;
- (MyImageListEnumerator*) imageEnumerator ;
- (MyImageListEnumerator*) imageEnumeratorStartAt:(id)item 
                                      directSense:(BOOL)direct;
   // Stack data
- (RGB*) stack;
- (u_long) stackSize;	//!< Stack size in bytes
- (REAL) blackLevel;
- (REAL) whiteLevel;
- (BOOL) validLevels ;	//!< Were levels set by the user ?
//@}

/// \name Write accessors
/// Returns YES if object was changed
//@{
   // Stack data
- (BOOL) setStack :(RGB*)stack size:(u_long)size ;
- (BOOL) setBlackLevel :(REAL)black whiteLevel:(REAL)white ;
- (BOOL) invalidateLevels ;
//@}

/// \name Actions
//@{
   // List data
- (BOOL) addItem :(MyImageListItem*)item ;
- (BOOL) deleteItem :(MyImageListItem*)item ;
- (BOOL) changeItemSelection :(MyImageListItem*)item value:(BOOL)v ;
//@}

/// \name Initializers and constructors
//@{
- (id) initWithArray :(NSArray*)list ;

+ (id) imageListWithArray :(NSArray*)list ;
//@}

@end

#endif
