## API Report File for "@lumino/messaging"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export class ConflatableMessage extends Message {
    conflate(other: ConflatableMessage): boolean;
    readonly isConflatable: boolean;
}

// @public
export interface IMessageHandler {
    processMessage(msg: Message): void;
}

// @public
export interface IMessageHook {
    messageHook(handler: IMessageHandler, msg: Message): boolean;
}

// @public
export class Message {
    constructor(type: string);
    conflate(other: Message): boolean;
    readonly isConflatable: boolean;
    readonly type: string;
}

// @public
export type MessageHook = IMessageHook | ((handler: IMessageHandler, msg: Message) => boolean);

// @public
export namespace MessageLoop {
    export function clearData(handler: IMessageHandler): void;
    export type ExceptionHandler = (err: Error) => void;
    export function flush(): void;
    export function getExceptionHandler(): ExceptionHandler;
    export function installMessageHook(handler: IMessageHandler, hook: MessageHook): void;
    export function postMessage(handler: IMessageHandler, msg: Message): void;
    export function removeMessageHook(handler: IMessageHandler, hook: MessageHook): void;
    export function sendMessage(handler: IMessageHandler, msg: Message): void;
    export function setExceptionHandler(handler: ExceptionHandler): ExceptionHandler;
}


// (No @packageDocumentation comment for this package)

```
