; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux-gnu    -global-isel -verify-machineinstrs                       < %s -o - | FileCheck %s --check-prefix=X64
; RUN: llc -mtriple=x86_64-apple-darwin -global-isel -verify-machineinstrs -relocation-model=pic < %s -o - | FileCheck %s --check-prefix=X64_DARWIN_PIC
; RUN: llc -mtriple=i386-linux-gnu      -global-isel -verify-machineinstrs                       < %s -o - | FileCheck %s --check-prefix=X32
; RUN: llc -mtriple=x86_64-linux-gnux32 -global-isel -verify-machineinstrs                       < %s -o - | FileCheck %s --check-prefix=X32ABI

@g_int = dso_local global i32 0, align 4

; Function Attrs: noinline nounwind optnone uwtable
define dso_local i32* @test_global_ptrv() #3 {
; X64-LABEL: test_global_ptrv:
; X64:       # %bb.0: # %entry
; X64-NEXT:    leaq g_int, %rax
; X64-NEXT:    retq
;
; X64_DARWIN_PIC-LABEL: test_global_ptrv:
; X64_DARWIN_PIC:       ## %bb.0: ## %entry
; X64_DARWIN_PIC-NEXT:    leaq _g_int(%rip), %rax
; X64_DARWIN_PIC-NEXT:    retq
;
; X32-LABEL: test_global_ptrv:
; X32:       # %bb.0: # %entry
; X32-NEXT:    leal g_int, %eax
; X32-NEXT:    retl
;
; X32ABI-LABEL: test_global_ptrv:
; X32ABI:       # %bb.0: # %entry
; X32ABI-NEXT:    leal g_int, %eax
; X32ABI-NEXT:    retq
entry:
  ret i32* @g_int
}

; Function Attrs: noinline nounwind optnone uwtable
define dso_local i32 @test_global_valv() #3 {
; X64-LABEL: test_global_valv:
; X64:       # %bb.0: # %entry
; X64-NEXT:    leaq g_int, %rax
; X64-NEXT:    movl (%rax), %eax
; X64-NEXT:    retq
;
; X64_DARWIN_PIC-LABEL: test_global_valv:
; X64_DARWIN_PIC:       ## %bb.0: ## %entry
; X64_DARWIN_PIC-NEXT:    leaq _g_int(%rip), %rax
; X64_DARWIN_PIC-NEXT:    movl (%rax), %eax
; X64_DARWIN_PIC-NEXT:    retq
;
; X32-LABEL: test_global_valv:
; X32:       # %bb.0: # %entry
; X32-NEXT:    leal g_int, %eax
; X32-NEXT:    movl (%eax), %eax
; X32-NEXT:    retl
;
; X32ABI-LABEL: test_global_valv:
; X32ABI:       # %bb.0: # %entry
; X32ABI-NEXT:    leal g_int, %eax
; X32ABI-NEXT:    movl (%eax), %eax
; X32ABI-NEXT:    retq
entry:
  %0 = load i32, i32* @g_int, align 4
  ret i32 %0
}

