; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+experimental-zvlsseg,+experimental-zfh \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i16(i16*, <vscale x 16 x i16>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 16 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv16i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i8(i16*, <vscale x 1 x i8>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv1i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 1 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv1i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i8(i16*, <vscale x 16 x i8>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv16i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 16 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv16i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i32(i16*, <vscale x 2 x i32>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv2i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 2 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv2i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i16(i16*, <vscale x 4 x i16>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv4i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 4 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv4i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv32i16(i16*, <vscale x 32 x i16>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv32i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 32 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v20, v16
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv32i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i32(i16*, <vscale x 1 x i32>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv1i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 1 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv1i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i16(i16*, <vscale x 8 x i16>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv8i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 8 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv8i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i8(i16*, <vscale x 8 x i8>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv8i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 8 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv8i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i32(i16*, <vscale x 8 x i32>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv8i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 8 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv8i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv64i8(i16*, <vscale x 64 x i8>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv64i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 64 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v20, v16
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv64i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i8(i16*, <vscale x 4 x i8>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv4i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 4 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv4i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i16(i16*, <vscale x 1 x i16>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv1i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 1 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv1i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv32i8(i16*, <vscale x 32 x i8>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv32i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 32 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv32i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i8(i16*, <vscale x 2 x i8>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv2i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 2 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv2i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i32(i16*, <vscale x 16 x i32>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv16i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 16 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v20, v16
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv16i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i16(i16*, <vscale x 2 x i16>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv2i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 2 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv2i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i32(i16*, <vscale x 4 x i32>, i32)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv4i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 4 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.nxv16i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vloxseg2.mask.nxv16i16.nxv4i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv16i16(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv16i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv16i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv16i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv2i32(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv2i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv4i16(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv4i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv32i16(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv32i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv8i16(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv8i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv8i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv8i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv8i32(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv8i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv64i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 64 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv64i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv4i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv4i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv32i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv32i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv2i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv2i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv16i32(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv16i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv2i16(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv2i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv4i32(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg2.mask.nxv1i8.nxv4i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv16i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv16i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv16i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv16i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv2i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv2i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv4i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv4i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv32i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv32i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv8i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv8i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv8i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv8i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv8i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv8i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv64i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 64 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv64i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv4i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv4i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv32i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv32i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv2i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv2i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv16i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv16i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv2i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv2i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv4i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg3.mask.nxv1i8.nxv4i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv16i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv16i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv16i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv16i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv2i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv2i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv4i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv4i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv32i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv32i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv8i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv8i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv8i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv8i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv8i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv8i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv64i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 64 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv64i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv4i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv4i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv32i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv32i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv2i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv2i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv16i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv16i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv2i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv2i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv4i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg4.mask.nxv1i8.nxv4i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv16i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv16i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv16i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv16i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv2i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv2i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv4i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv4i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv32i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv32i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv8i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv8i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv8i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv8i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv8i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv8i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv64i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 64 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv64i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv4i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv4i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv32i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv32i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv2i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv2i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv16i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv16i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv2i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv2i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv4i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg5.mask.nxv1i8.nxv4i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv16i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv16i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv16i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv16i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv2i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv2i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv4i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv4i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv32i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv32i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv8i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv8i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv8i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv8i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv8i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv8i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv64i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 64 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv64i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv4i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv4i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv32i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv32i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv2i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv2i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv16i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv16i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv2i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv2i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv4i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg6.mask.nxv1i8.nxv4i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv16i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv16i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv16i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv16i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv2i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv2i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv4i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv4i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv32i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv32i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv8i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv8i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv8i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv8i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv8i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv8i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv64i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 64 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv64i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv4i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv4i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv32i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv32i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv2i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv2i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv16i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv16i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv2i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv2i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv4i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg7.mask.nxv1i8.nxv4i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv16i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv16i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv16i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv16i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv2i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv2i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv4i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv4i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv32i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv32i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv8i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv8i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv8i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv8i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv8i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 8 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv8i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv64i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 64 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv64i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv4i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv4i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv32i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 32 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv32i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv2i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv2i8(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv16i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 16 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv16i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv2i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 2 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv2i16(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv4i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, <vscale x 4 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 1
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,mf8,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,mf8,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.nxv1i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %0, 0
  %2 = tail call {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} @llvm.riscv.vloxseg8.mask.nxv1i8.nxv4i32(<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1,<vscale x 1 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>} %2, 1
  ret <vscale x 1 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv1i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv1i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv2i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv2i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv4i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv4i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv32i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv32i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv1i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv1i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv8i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv8i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv8i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv8i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv8i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv8i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv64i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 64 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv64i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv4i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv4i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv1i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv1i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv32i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv32i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv2i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv2i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv2i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv2i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv4i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg2.mask.nxv16i8.nxv4i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv1i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv1i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv2i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv2i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv4i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv4i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv32i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv32i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv1i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv1i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv8i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv8i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv8i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv8i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv8i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv8i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv64i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 64 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv64i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv4i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv4i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv1i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv1i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv32i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv32i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv2i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv2i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv2i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv2i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv4i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg3.mask.nxv16i8.nxv4i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i16(i8*, <vscale x 16 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i8(i8*, <vscale x 1 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv1i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv1i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i8(i8*, <vscale x 16 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i32(i8*, <vscale x 2 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv2i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv2i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i16(i8*, <vscale x 4 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv4i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv4i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv32i16(i8*, <vscale x 32 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv32i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv32i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i32(i8*, <vscale x 1 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv1i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv1i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i16(i8*, <vscale x 8 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv8i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv8i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i8(i8*, <vscale x 8 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv8i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv8i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i32(i8*, <vscale x 8 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv8i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv8i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv64i8(i8*, <vscale x 64 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv64i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 64 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv64i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i8(i8*, <vscale x 4 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv4i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv4i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i16(i8*, <vscale x 1 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv1i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv1i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv32i8(i8*, <vscale x 32 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv32i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv32i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i8(i8*, <vscale x 2 x i8>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv2i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv2i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i32(i8*, <vscale x 16 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i16(i8*, <vscale x 2 x i16>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv2i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv2i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i32(i8*, <vscale x 4 x i32>, i32)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv4i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vloxseg4.mask.nxv16i8.nxv4i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i16(i32*, <vscale x 16 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv16i16(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv16i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i8(i32*, <vscale x 1 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv1i8(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv1i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i8(i32*, <vscale x 16 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv16i8(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv16i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i32(i32*, <vscale x 2 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i16(i32*, <vscale x 4 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv4i16(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv4i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv32i16(i32*, <vscale x 32 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv32i16(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv32i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i32(i32*, <vscale x 1 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv1i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv1i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i16(i32*, <vscale x 8 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv8i16(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv8i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i8(i32*, <vscale x 8 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv8i8(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv8i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i32(i32*, <vscale x 8 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv8i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv8i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv64i8(i32*, <vscale x 64 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv64i8(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 64 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv64i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i8(i32*, <vscale x 4 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv4i8(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv4i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i16(i32*, <vscale x 1 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv1i16(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv1i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv32i8(i32*, <vscale x 32 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv32i8(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv32i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i8(i32*, <vscale x 2 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i32(i32*, <vscale x 16 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv16i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv16i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i16(i32*, <vscale x 2 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i32(i32*, <vscale x 4 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv4i32(<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg2.mask.nxv2i32.nxv4i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i16(i32*, <vscale x 16 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv16i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv16i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i8(i32*, <vscale x 1 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv1i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv1i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i8(i32*, <vscale x 16 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv16i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv16i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i32(i32*, <vscale x 2 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i16(i32*, <vscale x 4 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv4i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv4i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv32i16(i32*, <vscale x 32 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv32i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv32i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i32(i32*, <vscale x 1 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv1i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv1i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i16(i32*, <vscale x 8 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv8i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv8i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i8(i32*, <vscale x 8 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv8i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv8i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i32(i32*, <vscale x 8 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv8i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv8i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv64i8(i32*, <vscale x 64 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv64i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 64 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv64i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i8(i32*, <vscale x 4 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv4i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv4i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i16(i32*, <vscale x 1 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv1i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv1i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv32i8(i32*, <vscale x 32 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv32i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv32i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i8(i32*, <vscale x 2 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i32(i32*, <vscale x 16 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv16i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv16i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i16(i32*, <vscale x 2 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i32(i32*, <vscale x 4 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv4i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg3.mask.nxv2i32.nxv4i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i16(i32*, <vscale x 16 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv16i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv16i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i8(i32*, <vscale x 1 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv1i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv1i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i8(i32*, <vscale x 16 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv16i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv16i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i32(i32*, <vscale x 2 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i16(i32*, <vscale x 4 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv4i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv4i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv32i16(i32*, <vscale x 32 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv32i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv32i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i32(i32*, <vscale x 1 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv1i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv1i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i16(i32*, <vscale x 8 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv8i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv8i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i8(i32*, <vscale x 8 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv8i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv8i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i32(i32*, <vscale x 8 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv8i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv8i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv64i8(i32*, <vscale x 64 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv64i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 64 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv64i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i8(i32*, <vscale x 4 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv4i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv4i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i16(i32*, <vscale x 1 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv1i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv1i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv32i8(i32*, <vscale x 32 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv32i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv32i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i8(i32*, <vscale x 2 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i32(i32*, <vscale x 16 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv16i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv16i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i16(i32*, <vscale x 2 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i32(i32*, <vscale x 4 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv4i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg4.mask.nxv2i32.nxv4i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i16(i32*, <vscale x 16 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv16i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv16i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i8(i32*, <vscale x 1 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv1i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv1i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i8(i32*, <vscale x 16 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv16i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv16i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i32(i32*, <vscale x 2 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i16(i32*, <vscale x 4 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv4i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv4i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv32i16(i32*, <vscale x 32 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv32i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv32i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i32(i32*, <vscale x 1 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv1i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv1i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i16(i32*, <vscale x 8 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv8i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv8i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i8(i32*, <vscale x 8 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv8i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv8i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i32(i32*, <vscale x 8 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv8i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv8i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv64i8(i32*, <vscale x 64 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv64i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 64 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv64i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i8(i32*, <vscale x 4 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv4i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv4i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i16(i32*, <vscale x 1 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv1i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv1i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv32i8(i32*, <vscale x 32 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv32i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv32i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i8(i32*, <vscale x 2 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i32(i32*, <vscale x 16 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv16i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv16i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i16(i32*, <vscale x 2 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i32(i32*, <vscale x 4 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv4i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg5.mask.nxv2i32.nxv4i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i16(i32*, <vscale x 16 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv16i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv16i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i8(i32*, <vscale x 1 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv1i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv1i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i8(i32*, <vscale x 16 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv16i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv16i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i32(i32*, <vscale x 2 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i16(i32*, <vscale x 4 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv4i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv4i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv32i16(i32*, <vscale x 32 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv32i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv32i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i32(i32*, <vscale x 1 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv1i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv1i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i16(i32*, <vscale x 8 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv8i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv8i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i8(i32*, <vscale x 8 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv8i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv8i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i32(i32*, <vscale x 8 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv8i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv8i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv64i8(i32*, <vscale x 64 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv64i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 64 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv64i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i8(i32*, <vscale x 4 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv4i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv4i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i16(i32*, <vscale x 1 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv1i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv1i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv32i8(i32*, <vscale x 32 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv32i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv32i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i8(i32*, <vscale x 2 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i32(i32*, <vscale x 16 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv16i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv16i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i16(i32*, <vscale x 2 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i32(i32*, <vscale x 4 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv4i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg6.mask.nxv2i32.nxv4i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i16(i32*, <vscale x 16 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv16i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv16i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i8(i32*, <vscale x 1 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv1i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv1i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i8(i32*, <vscale x 16 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv16i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv16i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i32(i32*, <vscale x 2 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i16(i32*, <vscale x 4 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv4i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv4i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv32i16(i32*, <vscale x 32 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv32i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv32i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i32(i32*, <vscale x 1 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv1i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv1i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i16(i32*, <vscale x 8 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv8i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv8i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i8(i32*, <vscale x 8 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv8i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv8i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i32(i32*, <vscale x 8 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv8i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv8i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv64i8(i32*, <vscale x 64 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv64i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 64 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv64i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i8(i32*, <vscale x 4 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv4i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv4i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i16(i32*, <vscale x 1 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv1i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv1i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv32i8(i32*, <vscale x 32 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv32i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv32i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i8(i32*, <vscale x 2 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i32(i32*, <vscale x 16 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv16i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv16i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i16(i32*, <vscale x 2 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i32(i32*, <vscale x 4 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv4i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg7.mask.nxv2i32.nxv4i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i16(i32*, <vscale x 16 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv16i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv16i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i8(i32*, <vscale x 1 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv1i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv1i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i8(i32*, <vscale x 16 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv16i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv16i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i32(i32*, <vscale x 2 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i16(i32*, <vscale x 4 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv4i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv4i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv32i16(i32*, <vscale x 32 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv32i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv32i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i32(i32*, <vscale x 1 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv1i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv1i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i16(i32*, <vscale x 8 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv8i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv8i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i8(i32*, <vscale x 8 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv8i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv8i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i32(i32*, <vscale x 8 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv8i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 8 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv8i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv64i8(i32*, <vscale x 64 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv64i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 64 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv64i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i8(i32*, <vscale x 4 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv4i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv4i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i16(i32*, <vscale x 1 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv1i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 1 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv1i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv32i8(i32*, <vscale x 32 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv32i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 32 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv32i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i8(i32*, <vscale x 2 x i8>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i32(i32*, <vscale x 16 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv16i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 16 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv16i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i16(i32*, <vscale x 2 x i16>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i32(i32*, <vscale x 4 x i32>, i32)
declare {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv4i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, i32*, <vscale x 4 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 1
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m1,ta,mu
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m1,tu,mu
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.nxv2i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %0, 0
  %2 = tail call {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} @llvm.riscv.vloxseg8.mask.nxv2i32.nxv4i32(<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1,<vscale x 2 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 2 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>} %2, 1
  ret <vscale x 2 x i32> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i16(i16*, <vscale x 16 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv16i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv16i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i8(i16*, <vscale x 1 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv1i8(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv1i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i8(i16*, <vscale x 16 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv16i8(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv16i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i32(i16*, <vscale x 2 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv2i32(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv2i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i16(i16*, <vscale x 4 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv32i16(i16*, <vscale x 32 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv32i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv32i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i32(i16*, <vscale x 1 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv1i32(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv1i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i16(i16*, <vscale x 8 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv8i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv8i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i8(i16*, <vscale x 8 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv8i8(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv8i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i32(i16*, <vscale x 8 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv8i32(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv8i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv64i8(i16*, <vscale x 64 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv64i8(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 64 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv64i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i8(i16*, <vscale x 4 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i16(i16*, <vscale x 1 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv1i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv1i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv32i8(i16*, <vscale x 32 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv32i8(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv32i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i8(i16*, <vscale x 2 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv2i8(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv2i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i32(i16*, <vscale x 16 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv16i32(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv16i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i16(i16*, <vscale x 2 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv2i16(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv2i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i32(i16*, <vscale x 4 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg2.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i16(i16*, <vscale x 16 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv16i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv16i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i8(i16*, <vscale x 1 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv1i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv1i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i8(i16*, <vscale x 16 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv16i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv16i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i32(i16*, <vscale x 2 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv2i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv2i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i16(i16*, <vscale x 4 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv32i16(i16*, <vscale x 32 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv32i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv32i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i32(i16*, <vscale x 1 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv1i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv1i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i16(i16*, <vscale x 8 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv8i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv8i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i8(i16*, <vscale x 8 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv8i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv8i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i32(i16*, <vscale x 8 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv8i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv8i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv64i8(i16*, <vscale x 64 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv64i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 64 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv64i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i8(i16*, <vscale x 4 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i16(i16*, <vscale x 1 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv1i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv1i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv32i8(i16*, <vscale x 32 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv32i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv32i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i8(i16*, <vscale x 2 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv2i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv2i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i32(i16*, <vscale x 16 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv16i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv16i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i16(i16*, <vscale x 2 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv2i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv2i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i32(i16*, <vscale x 4 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg3.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i16(i16*, <vscale x 16 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv16i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv16i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i8(i16*, <vscale x 1 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv1i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv1i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i8(i16*, <vscale x 16 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv16i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv16i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i32(i16*, <vscale x 2 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv2i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv2i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i16(i16*, <vscale x 4 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv32i16(i16*, <vscale x 32 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv32i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv32i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i32(i16*, <vscale x 1 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv1i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv1i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i16(i16*, <vscale x 8 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv8i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv8i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i8(i16*, <vscale x 8 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv8i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv8i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i32(i16*, <vscale x 8 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv8i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv8i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv64i8(i16*, <vscale x 64 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv64i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 64 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv64i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i8(i16*, <vscale x 4 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i16(i16*, <vscale x 1 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv1i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv1i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv32i8(i16*, <vscale x 32 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv32i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv32i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i8(i16*, <vscale x 2 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv2i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv2i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i32(i16*, <vscale x 16 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv16i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv16i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i16(i16*, <vscale x 2 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv2i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv2i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i32(i16*, <vscale x 4 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg4.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i16(i16*, <vscale x 16 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv16i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv16i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i8(i16*, <vscale x 1 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv1i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv1i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i8(i16*, <vscale x 16 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv16i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv16i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i32(i16*, <vscale x 2 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv2i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv2i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i16(i16*, <vscale x 4 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv32i16(i16*, <vscale x 32 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv32i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv32i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i32(i16*, <vscale x 1 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv1i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv1i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i16(i16*, <vscale x 8 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv8i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv8i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i8(i16*, <vscale x 8 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv8i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv8i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i32(i16*, <vscale x 8 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv8i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv8i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv64i8(i16*, <vscale x 64 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv64i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 64 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv64i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i8(i16*, <vscale x 4 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i16(i16*, <vscale x 1 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv1i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv1i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv32i8(i16*, <vscale x 32 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv32i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv32i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i8(i16*, <vscale x 2 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv2i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv2i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i32(i16*, <vscale x 16 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv16i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv16i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i16(i16*, <vscale x 2 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv2i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv2i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i32(i16*, <vscale x 4 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg5.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i16(i16*, <vscale x 16 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv16i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv16i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i8(i16*, <vscale x 1 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv1i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv1i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i8(i16*, <vscale x 16 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv16i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv16i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i32(i16*, <vscale x 2 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv2i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv2i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i16(i16*, <vscale x 4 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv32i16(i16*, <vscale x 32 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv32i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv32i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i32(i16*, <vscale x 1 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv1i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv1i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i16(i16*, <vscale x 8 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv8i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv8i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i8(i16*, <vscale x 8 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv8i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv8i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i32(i16*, <vscale x 8 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv8i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 8 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv8i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv64i8(i16*, <vscale x 64 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv64i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 64 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv64i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i8(i16*, <vscale x 4 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i16(i16*, <vscale x 1 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv1i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 1 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv1i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv32i8(i16*, <vscale x 32 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv32i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 32 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv32i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i8(i16*, <vscale x 2 x i8>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv2i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv2i8(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i32(i16*, <vscale x 16 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv16i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv16i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i16(i16*, <vscale x 2 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv2i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 2 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv2i16(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i32(i16*, <vscale x 4 x i32>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 4 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 1
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,tu,mu
; CHECK-NEXT:    vloxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.nxv4i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %0, 0
  %2 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg6.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1,<vscale x 4 x i16> %1, i16* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i32 %vl)
  %3 = extractvalue {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} %2, 1
  ret <vscale x 4 x i16> %3
}

declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg7.nxv4i16.nxv16i16(i16*, <vscale x 16 x i16>, i32)
declare {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg7.mask.nxv4i16.nxv16i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, i16*, <vscale x 16 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @test_vloxseg7_nxv4i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m1,ta,mu
; CHECK-NEXT:    vloxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>} @llvm.riscv.vloxseg7.nxv4i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i32 %vl)
  %1 = extractvalue {<vscale x 4 x i16>,<vs