; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s

; shift left

define i32 @and_signbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: and_signbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #8
; CHECK-NEXT:    and w0, w8, #0xff000000
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @and_nosignbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: and_nosignbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #8
; CHECK-NEXT:    and w0, w8, #0xff000000
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @or_signbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: or_signbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #8
; CHECK-NEXT:    orr w0, w8, #0xff000000
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @or_nosignbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: or_nosignbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #8
; CHECK-NEXT:    orr w0, w8, #0xff000000
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @xor_signbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: xor_signbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #8
; CHECK-NEXT:    eor w0, w8, #0xff000000
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @xor_nosignbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: xor_nosignbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #8
; CHECK-NEXT:    eor w0, w8, #0xff000000
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @add_signbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: add_signbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-16777216
; CHECK-NEXT:    add w0, w8, w0, lsl #8
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @add_nosignbit_shl(i32 %x, i32* %dst) {
; CHECK-LABEL: add_nosignbit_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-16777216
; CHECK-NEXT:    add w0, w8, w0, lsl #8
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %r = shl i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

; logical shift right

define i32 @and_signbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: and_signbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    and w0, w8, #0xffff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @and_nosignbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: and_nosignbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    and w0, w8, #0x7fff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @or_signbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: or_signbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    orr w0, w8, #0xffff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @or_nosignbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: or_nosignbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    orr w0, w8, #0x7fff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @xor_signbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: xor_signbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    eor w0, w8, #0xffff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @xor_nosignbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: xor_nosignbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    eor w0, w8, #0x7fff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @add_signbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: add_signbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, #16, lsl #12 // =65536
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @add_nosignbit_lshr(i32 %x, i32* %dst) {
; CHECK-LABEL: add_nosignbit_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147418112
; CHECK-NEXT:    add w8, w0, w8
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %r = lshr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

; arithmetic shift right

define i32 @and_signbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: and_signbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w8, w0, #8
; CHECK-NEXT:    and w0, w8, #0xffffff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @and_nosignbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: and_nosignbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    and w0, w8, #0x7fff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @or_signbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: or_signbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    orr w0, w8, #0xffffff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @or_nosignbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: or_nosignbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w8, w0, #8
; CHECK-NEXT:    orr w0, w8, #0x7fff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @xor_signbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: xor_signbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w8, w0, #8
; CHECK-NEXT:    eor w0, w8, #0xffffff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @xor_nosignbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: xor_nosignbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w8, w0, #8
; CHECK-NEXT:    eor w0, w8, #0x7fff00
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}

define i32 @add_signbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: add_signbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, #16, lsl #12 // =65536
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
define i32 @add_nosignbit_ashr(i32 %x, i32* %dst) {
; CHECK-LABEL: add_nosignbit_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147418112
; CHECK-NEXT:    add w8, w0, w8
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %r = ashr i32 %t0, 8
  store i32 %r, i32* %dst
  ret i32 %r
}
