/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.lisaac.ldt.builder.ILisaacErrorHandler;
import org.lisaac.ldt.model.ILisaacModel;
import org.lisaac.ldt.model.Position;

public class AbstractLisaacParser {
    protected ILisaacErrorHandler reporter;
    protected ILisaacModel model;
    protected String source;
    protected int position;
    protected int pos_cur;
    protected int pos_line;
    protected int pos_col;
    protected int begin_position;
    protected String string_tmp = "";
    protected long lastInteger;
    protected String lastReal;
    protected String lastString;
    protected static String lastComment;
    protected boolean isCatchComment;
    protected boolean isParameterType;
    protected int old_position;
    protected int old_pos_cur;
    protected int old_pos_line;
    protected int old_pos_col;
    private static final String operators = "!@#$%^&<|*-+=~/?\\>";

    public Position getPosition() {
        return this.getPosition(0);
    }

    /*
     * Unable to fully structure code
     */
    public Position getPosition(int len) {
        result = null;
        if (this.position <= this.source.length()) ** GOTO lbl10
        return new Position(this.pos_line, this.pos_col, this.pos_cur, len);
lbl-1000:
        // 1 sources

        {
            if (this.source.charAt(this.pos_cur) == '\n') {
                this.pos_col = 0;
                ++this.pos_line;
            } else {
                ++this.pos_col;
            }
            ++this.pos_cur;
lbl10:
            // 2 sources

            ** while (this.pos_cur < this.position)
        }
lbl11:
        // 1 sources

        if (this.pos_line > 32767) {
            result = new Position(32767, this.pos_col, this.pos_cur);
            this.reporter.syntaxError("Line counter overflow.", result);
        }
        if (this.pos_col > 255) {
            result = new Position(this.pos_line, 255, this.pos_cur);
            this.reporter.syntaxError("Column counter overflow (line too long).", result);
        }
        result = new Position(this.pos_line, this.pos_col, this.pos_cur, len);
        return result;
    }

    public Position getLine() {
        Position result = null;
        int startLine = this.pos_cur;
        int endLine = this.position + 1;
        while (this.pos_cur < this.position && !this.isEOF()) {
            if (this.source.charAt(this.pos_cur) == '\n') {
                this.pos_col = 0;
                ++this.pos_line;
                startLine = this.pos_cur + 1;
            } else {
                ++this.pos_col;
            }
            ++this.pos_cur;
        }
        if (this.pos_line > Short.MAX_VALUE) {
            result = new Position(Short.MAX_VALUE, this.pos_col, this.pos_cur);
            this.reporter.syntaxError("Line counter overflow.", result);
        }
        if (this.pos_col > 255) {
            result = new Position(this.pos_line, 255, this.pos_cur);
            this.reporter.syntaxError("Column counter overflow (line too long).", result);
        }
        while (endLine <= this.source.length() - 1) {
            if (this.source.charAt(endLine) == '\n') break;
            ++endLine;
        }
        result = new Position(this.pos_line, this.pos_col, endLine, endLine - startLine);
        return result;
    }

    public void updateLine() {
        while (this.pos_cur < this.position) {
            if (this.source.charAt(this.pos_cur) == '\n') {
                this.pos_col = 0;
                ++this.pos_line;
            } else {
                ++this.pos_col;
            }
            ++this.pos_cur;
        }
    }

    public int getOffset() {
        return this.position;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isEOF() {
        return this.position > this.source.length() - 1;
    }

    public void setPosition(int pos) {
        this.initialize();
        this.position = pos;
    }

    protected void setCatchComment() {
        this.isCatchComment = true;
        lastComment = "";
    }

    protected void setCatchCommentOff() {
        this.isCatchComment = false;
    }

    public String getLastString() {
        return this.lastString;
    }

    public char lastCharacter() {
        if (this.position >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.position);
    }

    protected void saveContext() {
        this.old_position = this.position;
        this.old_pos_cur = this.pos_cur;
        this.old_pos_line = this.pos_line;
        this.old_pos_col = this.pos_col;
    }

    protected void restoreContext() {
        this.position = this.old_position;
        this.pos_cur = this.old_pos_cur;
        this.pos_line = this.old_pos_line;
        this.pos_col = this.old_pos_col;
    }

    public AbstractLisaacParser(InputStream contents, ILisaacModel model) {
        this.model = model;
        this.reporter = model.getReporter();
        try {
            InputStreamReader reader = new InputStreamReader(contents);
            BufferedReader buffer = new BufferedReader(reader);
            StringWriter writer = new StringWriter();
            String line = "";
            do {
                if ((line = buffer.readLine()) == null) continue;
                writer.write(String.valueOf(line) + "\n");
            } while (line != null);
            this.source = writer.toString();
        }
        catch (IOException iOException) {
            return;
        }
        this.initialize();
    }

    public AbstractLisaacParser(String contents) {
        this.reporter = new ILisaacErrorHandler(){

            public void fatalError(String msg, Position position) {
            }

            public void semanticError(String msg, Position position) {
            }

            public void syntaxError(String msg, Position position) {
            }

            public void warning(String msg, Position position) {
            }

            public void enableErrorReport(boolean enable) {
            }
        };
        this.source = contents;
        this.initialize();
    }

    public void initialize() {
        this.position = 0;
        this.pos_cur = 0;
        this.pos_line = 1;
        this.pos_col = 0;
    }

    public boolean readSpace() {
        int level_comment = 0;
        int pos = this.position;
        int posold = -1;
        while (posold != this.position) {
            posold = this.position;
            while (this.lastCharacter() != '\u0000' && this.lastCharacter() <= ' ') {
                ++this.position;
            }
            if (this.position < this.source.length() - 1 && this.lastCharacter() == '/' && this.source.charAt(this.position + 1) == '/') {
                this.position += 2;
                if (this.isCatchComment) {
                    lastComment = String.valueOf(lastComment) + "\t";
                }
                while (this.lastCharacter() != '\u0000' && this.lastCharacter() != '\n') {
                    if (this.isCatchComment) {
                        lastComment = String.valueOf(lastComment) + this.lastCharacter();
                    }
                    this.lastCharacter();
                    ++this.position;
                }
                if (this.isCatchComment) {
                    lastComment = String.valueOf(lastComment) + "\n";
                }
            }
            if (this.position >= this.source.length() - 1 || this.lastCharacter() != '/' || this.source.charAt(this.position + 1) != '*') continue;
            this.position += 2;
            ++level_comment;
            while (this.lastCharacter() != '\u0000' && level_comment != 0) {
                if (this.lastCharacter() == '/' && this.source.charAt(this.position + 1) == '*') {
                    this.position += 2;
                    ++level_comment;
                    continue;
                }
                if (this.lastCharacter() == '*' && this.source.charAt(this.position + 1) == '/') {
                    this.position += 2;
                    --level_comment;
                    continue;
                }
                ++this.position;
            }
            if (level_comment == 0) continue;
            this.reporter.syntaxError("End of comment not found !", this.getPosition());
        }
        this.begin_position = this.position;
        return this.position != pos || this.lastCharacter() != '\u0000';
    }

    public boolean readSymbol(String st) {
        boolean result = false;
        if (!this.readSpace()) {
            result = false;
        } else {
            int posold = this.position;
            int j = 0;
            while (this.lastCharacter() != '\u0000' && j <= st.length() - 1 && this.lastCharacter() == st.charAt(j)) {
                ++this.position;
                ++j;
            }
            if (j > st.length() - 1) {
                result = true;
                this.lastString = st;
            } else {
                this.position = posold;
                result = false;
            }
        }
        return result;
    }

    public boolean readCharacter(char ch) {
        boolean result = false;
        if (!this.readSpace()) {
            result = false;
        } else if (this.lastCharacter() == ch) {
            ++this.position;
            result = true;
        }
        return result;
    }

    public boolean readAffect() {
        return this.readSymbol(":=") || this.readSymbol("?=") || this.readSymbol("<-");
    }

    public char readStyle() {
        int result = this.readCharacter('-') ? 45 : (this.readCharacter('+') ? 43 : 32);
        return (char)result;
    }

    public boolean readIdentifier() {
        boolean result = false;
        if (!this.readSpace() || !Character.isLowerCase(this.lastCharacter())) {
            result = false;
        } else {
            int posold = this.position;
            this.string_tmp = "";
            while (this.lastCharacter() != '\u0000' && (Character.isLowerCase(this.lastCharacter()) || Character.isDigit(this.lastCharacter()) || this.lastCharacter() == '_')) {
                this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                ++this.position;
            }
            if (this.string_tmp.length() > 0) {
                int idx = this.string_tmp.lastIndexOf("__");
                if (idx != -1) {
                    this.position = posold + idx;
                    this.reporter.syntaxError("Identifier is incorrect.", this.getPosition());
                }
                this.lastString = this.getString(this.string_tmp);
                result = true;
            }
        }
        return result;
    }

    public boolean readWord(String st) {
        boolean result = false;
        if (!this.readSpace()) {
            result = false;
        } else {
            int posold = this.position;
            int idx = 0;
            while (idx <= st.length() - 1 && this.lastCharacter() == st.charAt(idx)) {
                ++this.position;
                ++idx;
            }
            if (idx > st.length() - 1) {
                this.lastString = st;
                result = true;
            } else {
                this.position = posold;
            }
        }
        return result;
    }

    public boolean readThisKeyword(String st) {
        return this.readWord(st);
    }

    public boolean readKeyword() {
        boolean result = false;
        if (!this.readSpace() || !Character.isUpperCase(this.lastCharacter())) {
            result = false;
        } else {
            this.string_tmp = "";
            this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
            ++this.position;
            if (Character.isLowerCase(this.lastCharacter())) {
                this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                ++this.position;
                while (this.lastCharacter() != '\u0000' && (Character.isLowerCase(this.lastCharacter()) || Character.isDigit(this.lastCharacter()) || this.lastCharacter() == '_')) {
                    this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                    ++this.position;
                }
                this.lastString = this.getString(this.string_tmp);
                result = true;
            } else {
                --this.position;
                result = false;
            }
        }
        return result;
    }

    public boolean readCapIdentifier() {
        boolean result = false;
        if (!this.readSpace() || !Character.isUpperCase(this.lastCharacter())) {
            result = false;
        } else {
            int posold = this.position++;
            this.string_tmp = "" + this.lastCharacter();
            this.isParameterType = true;
            while (this.lastCharacter() != '\u0000' && (Character.isUpperCase(this.lastCharacter()) || Character.isDigit(this.lastCharacter()) || this.lastCharacter() == '_')) {
                char car = this.lastCharacter();
                this.isParameterType = this.isParameterType && Character.isDigit(car);
                this.string_tmp = String.valueOf(this.string_tmp) + car;
                ++this.position;
            }
            if (Character.isLetter(this.lastCharacter()) || Character.isDigit(this.lastCharacter()) || this.lastCharacter() == '_') {
                this.reporter.syntaxError("Identifier is incorrect.", this.getPosition());
                return false;
            }
            int idx = this.string_tmp.lastIndexOf("__");
            if (idx != -1) {
                this.position = posold + idx;
                this.reporter.syntaxError("Identifier is incorrect.", this.getPosition());
                return false;
            }
            this.lastString = this.getString(this.string_tmp);
            result = true;
        }
        return result;
    }

    public boolean readInteger() {
        boolean result = false;
        if (this.readSpace() && Character.isDigit(this.lastCharacter())) {
            result = true;
            this.string_tmp = "" + this.lastCharacter();
            ++this.position;
            while (this.isHexadecimalDigit(this.lastCharacter()) || this.lastCharacter() == '_') {
                if (this.lastCharacter() != '_') {
                    this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                }
                ++this.position;
            }
            if (this.lastCharacter() == 'h') {
                try {
                    Integer integer = Integer.valueOf(this.string_tmp, 16);
                    this.lastInteger = integer.intValue();
                }
                catch (Exception exception) {
                    this.lastInteger = 0L;
                }
                ++this.position;
            } else {
                if (this.string_tmp.charAt(this.string_tmp.length() - 1) > '9') {
                    this.string_tmp = this.string_tmp.substring(0, this.string_tmp.length() - 1);
                    --this.position;
                }
                if (this.lastCharacter() == 'o') {
                    if (!this.isOctal(this.string_tmp)) {
                        this.reporter.syntaxError("Incorrect octal number.", this.getPosition());
                    }
                    this.lastInteger = Integer.valueOf(this.string_tmp, 8).intValue();
                    ++this.position;
                } else if (this.lastCharacter() == 'b') {
                    if (!this.isBinary(this.string_tmp)) {
                        this.reporter.syntaxError("Incorrect binary number.", this.getPosition());
                    }
                    this.lastInteger = Integer.valueOf(this.string_tmp, 2).intValue();
                    ++this.position;
                } else {
                    if (this.lastCharacter() == 'd') {
                        ++this.position;
                    }
                    if (!this.isInteger(this.string_tmp)) {
                        this.reporter.syntaxError("Incorrect decimal number.", this.getPosition());
                    }
                    this.lastInteger = Integer.valueOf(this.string_tmp).intValue();
                }
            }
        }
        return result;
    }

    private boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean isBinary(String s) {
        int i = s.length() - 1;
        boolean result = true;
        while (result && i != 0) {
            result = s.charAt(i) == '0' || s.charAt(i) == '1';
            --i;
        }
        return result;
    }

    private boolean isOctal(String s) {
        try {
            Integer.parseInt(s, 8);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean isHexadecimalDigit(char c) {
        boolean result = false;
        if (Character.isDigit(c)) {
            result = true;
        } else if (c >= 'a') {
            result = c <= 'f';
        } else if (c >= 'A') {
            result = c <= 'F';
        }
        return result;
    }

    public boolean readReal() {
        boolean result = false;
        if (this.readSpace() && Character.isDigit(this.lastCharacter())) {
            this.string_tmp = "" + this.lastCharacter();
            int pos_old = this.position++;
            while (Character.isDigit(this.lastCharacter()) || this.lastCharacter() == '_') {
                if (this.lastCharacter() != '_') {
                    this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                }
                ++this.position;
            }
            if (this.lastCharacter() == '.') {
                this.string_tmp = String.valueOf(this.string_tmp) + '.';
                ++this.position;
                if (Character.isDigit(this.lastCharacter())) {
                    result = true;
                    this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                    ++this.position;
                    while (Character.isDigit(this.lastCharacter())) {
                        this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                        ++this.position;
                    }
                }
                if (this.lastCharacter() == 'E') {
                    result = true;
                    this.string_tmp = String.valueOf(this.string_tmp) + 'E';
                    ++this.position;
                    if (this.lastCharacter() == '+' || this.lastCharacter() == '-') {
                        this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                        ++this.position;
                    }
                    if (Character.isDigit(this.lastCharacter())) {
                        this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                        ++this.position;
                        while (Character.isDigit(this.lastCharacter())) {
                            this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                            ++this.position;
                        }
                    } else {
                        this.reporter.syntaxError("Incorrect real number.", this.getPosition());
                    }
                }
            }
            if (result) {
                this.lastReal = this.getString(this.string_tmp);
            } else {
                this.position = pos_old;
            }
        }
        return result;
    }

    public void readEscapeCharacter() {
        if (this.isSeparator(this.lastCharacter())) {
            ++this.position;
            while (this.lastCharacter() != '\u0000' && this.isSeparator(this.lastCharacter())) {
                ++this.position;
            }
            if (this.lastCharacter() == '\\') {
                this.string_tmp.substring(0, this.string_tmp.length() - 2);
                ++this.position;
            } else if (this.lastCharacter() != '\u0000') {
                this.reporter.syntaxError("Unknown escape sequence.", this.getPosition());
            }
        } else if (this.lastCharacter() != '\u0000') {
            char c = this.lastCharacter();
            if (c == 'a' || c == 'b' || c == 'f' || c == 'n' || c == 'r' || c == 't' || c == 'v' || c == '\\' || c == '?' || c == '\'' || c == '\"') {
                this.string_tmp = String.valueOf(this.string_tmp) + c;
                ++this.position;
            } else if (this.lastCharacter() >= '0' && this.lastCharacter() <= '9') {
                if (this.lastCharacter() == '0' && this.position < this.source.length() && !this.isHexadecimalDigit(this.source.charAt(this.position + 1))) {
                    this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                    ++this.position;
                } else {
                    String string_tmp2 = new String(this.string_tmp);
                    this.readInteger();
                    this.string_tmp = string_tmp2;
                    if (this.lastInteger > 255L) {
                        this.reporter.syntaxError("Invalid range character number [0,255].", this.getPosition());
                    }
                    int val = (int)this.lastInteger;
                    this.string_tmp = String.valueOf(this.string_tmp) + val / 64;
                    this.string_tmp = String.valueOf(this.string_tmp) + val % 64 / 8;
                    this.string_tmp = String.valueOf(this.string_tmp) + val % 8;
                    if (this.lastCharacter() == '\\') {
                        ++this.position;
                    } else {
                        this.reporter.syntaxError("Character '' is needed.", this.getPosition());
                    }
                }
            } else {
                this.reporter.syntaxError("Unknown escape sequence.", this.getPosition());
            }
        }
    }

    public boolean readCharacters() {
        boolean result = false;
        int count = 0;
        if (this.readSpace() && this.lastCharacter() == '\'') {
            ++this.position;
            this.string_tmp = "";
            while (this.lastCharacter() != '\u0000' && this.lastCharacter() != '\n' && this.lastCharacter() != '\'') {
                this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                if (this.lastCharacter() == '\\') {
                    ++this.position;
                    this.readEscapeCharacter();
                    ++count;
                    continue;
                }
                ++this.position;
                ++count;
            }
            if (this.lastCharacter() == '\'') {
                ++this.position;
                this.lastString = this.getString(this.string_tmp);
                if (count != 1) {
                    this.position = this.begin_position;
                    this.reporter.syntaxError("Character constant too long.", this.getPosition());
                }
                result = true;
            } else {
                this.position = this.begin_position;
                this.reporter.syntaxError("Unterminated character constant.", this.getPosition());
            }
        }
        return result;
    }

    public boolean readString() {
        boolean result = false;
        if (this.readSpace() && this.lastCharacter() == '\"') {
            ++this.position;
            this.string_tmp = "";
            while (this.lastCharacter() != '\u0000' && this.lastCharacter() != '\n' && this.lastCharacter() != '\"') {
                this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                if (this.lastCharacter() == '\\') {
                    ++this.position;
                    this.readEscapeCharacter();
                    continue;
                }
                ++this.position;
            }
            if (this.lastCharacter() == '\"') {
                ++this.position;
                this.lastString = this.getString(this.string_tmp);
                result = true;
            } else {
                this.position = this.begin_position;
                this.reporter.syntaxError("Unterminated string constant.", this.getPosition());
            }
        }
        return result;
    }

    public boolean readExternal() {
        boolean result = false;
        if (!this.readSpace() || this.lastCharacter() != '`') {
            result = false;
        } else {
            ++this.position;
            this.string_tmp = "";
            while (this.lastCharacter() != '\u0000' && this.lastCharacter() != '`') {
                this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                if (this.lastCharacter() == '\\') {
                    ++this.position;
                    this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                    if (this.lastCharacter() == '\u0000') continue;
                    ++this.position;
                    continue;
                }
                ++this.position;
            }
            if (this.lastCharacter() != '\u0000') {
                ++this.position;
                this.lastString = this.getString(this.string_tmp);
                result = true;
            } else {
                result = false;
            }
        }
        return result;
    }

    public static boolean isOperatorSymbol(char c) {
        return operators.indexOf(c) != -1;
    }

    public boolean readOperator() {
        boolean result = false;
        this.readSpace();
        this.string_tmp = "";
        while (this.lastCharacter() != '\u0000' && operators.indexOf(this.lastCharacter()) != -1) {
            this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
            ++this.position;
        }
        if (this.string_tmp.length() > 0) {
            this.lastString = this.getString(this.string_tmp);
            if (this.lastString.equals(":=") || this.lastString.equals("<-") || this.lastString.equals("?=")) {
                this.reporter.syntaxError("Incorrect operator.", this.getPosition());
            }
            result = true;
        }
        return result;
    }

    private boolean isSeparator(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\u0000' || c == '\f';
    }

    public String getString(String str) {
        if (this.model == null) {
            return str;
        }
        return this.model.getAliasString().get(str);
    }

    public ILisaacErrorHandler getReporter() {
        return this.reporter;
    }

    public void readTokenAt(int line, int column) {
        char c;
        while (!this.isEOF()) {
            if (this.source.charAt(this.pos_cur) == '\n') {
                this.pos_col = 0;
                ++this.pos_line;
            } else {
                ++this.pos_col;
            }
            if (this.pos_line == line && this.pos_col == column) {
                this.position = this.pos_cur;
                break;
            }
            ++this.pos_cur;
        }
        while (this.position >= 0) {
            c = this.lastCharacter();
            if (this.isSeparator(c)) break;
            --this.position;
        }
        ++this.position;
        this.string_tmp = "";
        while (!this.isEOF()) {
            c = this.lastCharacter();
            if (this.isSeparator(c)) break;
            this.string_tmp = String.valueOf(this.string_tmp) + c;
            ++this.position;
        }
        this.lastString = this.string_tmp;
    }
}

