/*
 * Copyright (c) 2012-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <mach/rpm-regulator-smd.h>
#include <mach/msm_bus_board.h>
#include <mach/msm_bus.h>
#include <mach/socinfo.h>

#include "acpuclock.h"
#include "acpuclock-krait.h"

/* Corner type vreg VDD values */
#define LVL_NONE	RPM_REGULATOR_CORNER_NONE
#define LVL_LOW		RPM_REGULATOR_CORNER_SVS_SOC
#define LVL_NOM		RPM_REGULATOR_CORNER_NORMAL
#define LVL_HIGH	RPM_REGULATOR_CORNER_SUPER_TURBO

static struct hfpll_data hfpll_data __initdata = {
	.mode_offset = 0x00,
	.l_offset = 0x04,
	.m_offset = 0x08,
	.n_offset = 0x0C,
	.has_user_reg = true,
	.user_offset = 0x10,
	.config_offset = 0x14,
	.user_val = 0x8,
	.user_vco_mask = BIT(20),
	.config_val = 0x04D0405D,
	.has_lock_status = true,
	.status_offset = 0x1C,
	.low_vco_l_max = 65,
	.low_vdd_l_max = 52,
	.nom_vdd_l_max = 104,
	.vdd[HFPLL_VDD_NONE] = LVL_NONE,
	.vdd[HFPLL_VDD_LOW]  = LVL_LOW,
	.vdd[HFPLL_VDD_NOM]  = LVL_NOM,
	.vdd[HFPLL_VDD_HIGH] = LVL_HIGH,
};

static struct scalable scalable[] __initdata = {
	[CPU0] = {
		.hfpll_phys_base = 0xF908A000,
		.l2cpmr_iaddr = 0x4501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait0",     1100000 },
		.vreg[VREG_MEM]  = { "krait0_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait0_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait0_hfpll", 1800000 },
	},
	[CPU1] = {
		.hfpll_phys_base = 0xF909A000,
		.l2cpmr_iaddr = 0x5501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait1",     1100000 },
		.vreg[VREG_MEM]  = { "krait1_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait1_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait1_hfpll", 1800000 },
	},
	[CPU2] = {
		.hfpll_phys_base = 0xF90AA000,
		.l2cpmr_iaddr = 0x6501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait2",     1100000 },
		.vreg[VREG_MEM]  = { "krait2_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait2_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait2_hfpll", 1800000 },
	},
	[CPU3] = {
		.hfpll_phys_base = 0xF90BA000,
		.l2cpmr_iaddr = 0x7501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait3",     1100000 },
		.vreg[VREG_MEM]  = { "krait3_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait3_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait3_hfpll", 1800000 },
	},
	[L2] = {
		.hfpll_phys_base = 0xF9016000,
		.l2cpmr_iaddr = 0x0500,
		.sec_clk_sel = 2,
		.vreg[VREG_HFPLL_A] = { "l2_hfpll", 1800000 },
	},
};

static struct msm_bus_paths bw_level_tbl_v1[] __initdata = {
	[0] =  BW_MBPS(600), /* At least  75 MHz on bus. */
	[1] =  BW_MBPS(800), /* At least 100 MHz on bus. */
	[2] = BW_MBPS(1200), /* At least 150 MHz on bus. */
	[3] = BW_MBPS(1600), /* At least 200 MHz on bus. */
	[4] = BW_MBPS(2224), /* At least 278 MHz on bus. */
	[5] = BW_MBPS(3200), /* At least 400 MHz on bus. */
	[6] = BW_MBPS(4448), /* At least 556 MHz on bus. */
	[7] = BW_MBPS(6400), /* At least 800 MHz on bus. */
};

static struct l2_level l2_freq_tbl_v1[] __initdata = {
	[0]  = { {  300000, PLL_0, 0,   0 }, LVL_LOW,   950000, 0 },
	[1]  = { {  345600, HFPLL, 2,  36 }, LVL_NOM,   950000, 1 },
	[2]  = { {  422400, HFPLL, 2,  44 }, LVL_NOM,   950000, 1 },
	[3]  = { {  499200, HFPLL, 2,  52 }, LVL_NOM,   950000, 2 },
	[4]  = { {  576000, HFPLL, 1,  30 }, LVL_NOM,   950000, 3 },
	[5]  = { {  652800, HFPLL, 1,  34 }, LVL_NOM,   950000, 3 },
	[6]  = { {  729600, HFPLL, 1,  38 }, LVL_NOM,   950000, 3 },
	[7]  = { {  806400, HFPLL, 1,  42 }, LVL_HIGH, 1050000, 4 },
	[8]  = { {  883200, HFPLL, 1,  46 }, LVL_HIGH, 1050000, 4 },
	[9]  = { {  960000, HFPLL, 1,  50 }, LVL_HIGH, 1050000, 4 },
	[10] = { { 1036800, HFPLL, 1,  54 }, LVL_HIGH, 1050000, 5 },
	[11] = { { 1113600, HFPLL, 1,  58 }, LVL_HIGH, 1050000, 5 },
	[12] = { { 1190400, HFPLL, 1,  62 }, LVL_HIGH, 1050000, 6 },
	[13] = { { 1267200, HFPLL, 1,  66 }, LVL_HIGH, 1050000, 6 },
	[14] = { { 1344000, HFPLL, 1,  70 }, LVL_HIGH, 1050000, 7 },
	[15] = { { 1420800, HFPLL, 1,  74 }, LVL_HIGH, 1050000, 7 },
	[16] = { { 1497600, HFPLL, 1,  78 }, LVL_HIGH, 1050000, 7 },
	{ }
};

static struct acpu_level acpu_freq_tbl_v1_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 }, L2(0),   825000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 }, L2(3),   825000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 }, L2(3),   825000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 }, L2(6),   825000, 124 },
	{ 1, {  576000, HFPLL, 1,  30 }, L2(6),   825000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 }, L2(7),   825000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 }, L2(7),   825000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 }, L2(10),  835000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 }, L2(10),  845000, 229 },
	{ 0, {  960000, HFPLL, 1,  50 }, L2(10),  860000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  880000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(12),  905000, 298 },
	{ 0, { 1190400, HFPLL, 1,  62 }, L2(12),  920000, 321 },
	{ 0, { 1267200, HFPLL, 1,  66 }, L2(12),  940000, 346 },
	{ 1, { 1344000, HFPLL, 1,  70 }, L2(12),  960000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(16),  980000, 397 },
	{ 0, { 1497600, HFPLL, 1,  78 }, L2(16),  995000, 423 },
	{ 0, { 1574400, HFPLL, 1,  82 }, L2(16), 1015000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(16), 1030000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(16), 1050000, 506 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_v1_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 }, L2(0),   825000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 }, L2(3),   825000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 }, L2(3),   825000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 }, L2(6),   825000, 124 },
	{ 1, {  576000, HFPLL, 1,  30 }, L2(6),   825000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 }, L2(7),   825000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 }, L2(7),   825000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 }, L2(10),  835000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 }, L2(10),  845000, 229 },
	{ 0, {  960000, HFPLL, 1,  50 }, L2(10),  860000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  880000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(12),  905000, 298 },
	{ 0, { 1190400, HFPLL, 1,  62 }, L2(12),  920000, 321 },
	{ 0, { 1267200, HFPLL, 1,  66 }, L2(12),  940000, 346 },
	{ 1, { 1344000, HFPLL, 1,  70 }, L2(12),  960000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(16),  980000, 397 },
	{ 0, { 1497600, HFPLL, 1,  78 }, L2(16),  995000, 423 },
	{ 0, { 1574400, HFPLL, 1,  82 }, L2(16), 1015000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(16), 1030000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(16), 1050000, 506 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_v1_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 }, L2(0),   825000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 }, L2(3),   825000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 }, L2(3),   825000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 }, L2(6),   825000, 124 },
	{ 1, {  576000, HFPLL, 1,  30 }, L2(6),   825000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 }, L2(7),   825000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 }, L2(7),   825000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 }, L2(10),  825000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 }, L2(10),  825000, 229 },
	{ 0, {  960000, HFPLL, 1,  50 }, L2(10),  835000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  855000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(12),  875000, 298 },
	{ 0, { 1190400, HFPLL, 1,  62 }, L2(12),  895000, 321 },
	{ 0, { 1267200, HFPLL, 1,  66 }, L2(12),  915000, 346 },
	{ 1, { 1344000, HFPLL, 1,  70 }, L2(12),  930000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(16),  945000, 397 },
	{ 0, { 1497600, HFPLL, 1,  78 }, L2(16),  960000, 423 },
	{ 0, { 1574400, HFPLL, 1,  82 }, L2(16),  975000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(16),  990000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(16), 1000000, 506 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_v1_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 }, L2(0),   825000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 }, L2(3),   825000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 }, L2(3),   825000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 }, L2(6),   825000, 124 },
	{ 1, {  576000, HFPLL, 1,  30 }, L2(6),   825000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 }, L2(7),   825000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 }, L2(7),   825000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 }, L2(10),  825000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 }, L2(10),  825000, 229 },
	{ 0, {  960000, HFPLL, 1,  50 }, L2(10),  835000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  855000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(12),  875000, 298 },
	{ 0, { 1190400, HFPLL, 1,  62 }, L2(12),  895000, 321 },
	{ 0, { 1267200, HFPLL, 1,  66 }, L2(12),  915000, 346 },
	{ 1, { 1344000, HFPLL, 1,  70 }, L2(12),  930000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(16),  945000, 397 },
	{ 0, { 1497600, HFPLL, 1,  78 }, L2(16),  960000, 423 },
	{ 0, { 1574400, HFPLL, 1,  82 }, L2(16),  975000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(16),  990000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(16), 1000000, 506 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_v1_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 }, L2(0),  825000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 }, L2(3),  825000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 }, L2(3),  825000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 }, L2(6),  825000, 124 },
	{ 1, {  576000, HFPLL, 1,  30 }, L2(6),  825000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 }, L2(7),  825000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 }, L2(7),  825000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 }, L2(10), 825000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 }, L2(10), 825000, 229 },
	{ 0, {  960000, HFPLL, 1,  50 }, L2(10), 825000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10), 825000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(12), 835000, 298 },
	{ 0, { 1190400, HFPLL, 1,  62 }, L2(12), 855000, 321 },
	{ 0, { 1267200, HFPLL, 1,  66 }, L2(12), 870000, 346 },
	{ 1, { 1344000, HFPLL, 1,  70 }, L2(12), 885000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(16), 900000, 397 },
	{ 0, { 1497600, HFPLL, 1,  78 }, L2(16), 910000, 423 },
	{ 0, { 1574400, HFPLL, 1,  82 }, L2(16), 925000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(16), 940000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(16), 950000, 506 },
	{ 0, { 0 } }
};

static struct msm_bus_paths bw_level_tbl_v2[] __initdata = {
	[0] =  BW_MBPS(600), /* At least  75 MHz on bus. */
	[1] =  BW_MBPS(800), /* At least 100 MHz on bus. */
	[2] = BW_MBPS(1200), /* At least 150 MHz on bus. */
	[3] = BW_MBPS(1600), /* At least 200 MHz on bus. */
	[4] = BW_MBPS(2456), /* At least 307 MHz on bus. */
	[5] = BW_MBPS(3680), /* At least 460 MHz on bus. */
	[6] = BW_MBPS(4912), /* At least 614 MHz on bus. */
	[7] = BW_MBPS(6400), /* At least 800 MHz on bus. */
	[8] = BW_MBPS(7448), /* At least 931 MHz on bus. */
};

static struct l2_level l2_freq_tbl_v2[] __initdata = {
	[0]  = { {  300000, PLL_0, 0,   0 }, LVL_LOW,   950000, 0 },
	[1]  = { {  345600, HFPLL, 2,  36 }, LVL_LOW,   950000, 1 },
	[2]  = { {  422400, HFPLL, 2,  44 }, LVL_LOW,   950000, 2 },
	[3]  = { {  499200, HFPLL, 2,  52 }, LVL_LOW,   950000, 3 },
	[4]  = { {  576000, HFPLL, 1,  30 }, LVL_LOW,   950000, 4 },
	[5]  = { {  652800, HFPLL, 1,  34 }, LVL_NOM,   950000, 4 },
	[6]  = { {  729600, HFPLL, 1,  38 }, LVL_NOM,   950000, 4 },
	[7]  = { {  806400, HFPLL, 1,  42 }, LVL_NOM,   950000, 4 },
	[8]  = { {  883200, HFPLL, 1,  46 }, LVL_NOM,   950000, 5 },
	[9]  = { {  960000, HFPLL, 1,  50 }, LVL_NOM,   950000, 5 },
	[10] = { { 1036800, HFPLL, 1,  54 }, LVL_NOM,   950000, 5 },
	[11] = { { 1113600, HFPLL, 1,  58 }, LVL_HIGH, 1050000, 6 },
	[12] = { { 1190400, HFPLL, 1,  62 }, LVL_HIGH, 1050000, 6 },
	[13] = { { 1267200, HFPLL, 1,  66 }, LVL_HIGH, 1050000, 6 },
	[14] = { { 1344000, HFPLL, 1,  70 }, LVL_HIGH, 1050000, 6 },
	[15] = { { 1420800, HFPLL, 1,  74 }, LVL_HIGH, 1050000, 6 },
	[16] = { { 1497600, HFPLL, 1,  78 }, LVL_HIGH, 1050000, 6 },
	[17] = { { 1574400, HFPLL, 1,  82 }, LVL_HIGH, 1050000, 7 },
	[18] = { { 1651200, HFPLL, 1,  86 }, LVL_HIGH, 1050000, 7 },
	[19] = { { 1728000, HFPLL, 1,  90 }, LVL_HIGH, 1050000, 8 },
	{ }
};

static struct acpu_level acpu_freq_tbl_2g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  815000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  825000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  835000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  845000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  855000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  865000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  875000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  890000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  900000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  915000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  925000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  940000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  950000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  965000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  980000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  995000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16), 1010000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17), 1025000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17), 1040000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1055000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1070000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1085000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1100000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  810000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  820000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  830000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  840000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  850000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  860000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  875000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  885000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  895000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  910000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  920000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  930000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  945000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  960000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  975000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  990000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17), 1005000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17), 1020000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1030000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1045000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1060000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1075000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  785000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  795000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  805000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  815000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  825000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  835000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  845000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  855000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  865000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  875000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  890000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  900000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  910000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  925000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  940000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  955000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  970000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  980000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  995000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1005000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1020000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1035000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1050000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  780000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  790000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  810000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  820000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  830000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  840000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  850000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  860000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  875000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  885000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  895000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  910000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  925000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  935000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  950000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  960000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  970000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  985000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  995000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1010000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1025000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  780000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  790000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  810000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  820000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  830000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  840000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  850000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  860000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  870000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  880000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  895000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  910000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  920000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  930000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  940000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  950000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  960000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  975000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  985000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1000000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  760000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  770000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  780000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  790000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  810000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  820000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  830000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  840000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  850000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  860000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  870000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  880000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  890000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  900000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  920000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  930000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  940000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  955000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  965000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  975000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  760000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  770000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  780000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  790000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  810000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  820000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  830000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  840000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  850000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  860000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  870000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  875000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  885000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  895000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  905000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  915000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  920000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  930000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  940000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  950000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  805000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  815000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  825000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  835000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  845000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  855000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  865000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  875000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  890000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  900000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  915000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  925000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  940000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  950000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  965000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  980000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  995000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1010000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1025000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1040000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1055000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1070000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1085000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1100000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  810000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  820000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  830000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  840000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  850000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  860000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  875000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  885000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  895000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  910000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  920000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  930000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  945000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  960000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  975000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  990000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1005000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1020000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1030000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1045000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1060000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1075000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  785000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  795000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  805000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  815000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  825000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  835000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  845000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  855000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  865000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  875000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  890000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  900000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  910000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  925000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  940000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  955000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  970000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  980000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  995000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1005000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1020000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1035000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1050000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  780000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  790000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  810000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  820000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  830000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  840000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  850000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  860000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  875000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  885000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  895000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  925000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  935000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  950000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  960000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  970000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  985000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  995000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1010000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1025000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  780000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  790000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  800000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  810000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  820000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  830000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  840000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  850000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  860000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  870000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  880000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  895000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  910000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  920000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  930000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  940000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  950000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  960000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  975000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  985000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1000000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  760000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  770000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  780000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  790000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  800000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  810000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  820000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  830000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  840000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  850000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  860000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  870000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  880000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  890000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  900000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  910000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  920000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  930000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  940000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  955000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  965000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19),  975000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  760000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  770000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  780000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  790000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  800000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  810000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  820000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  830000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  840000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  860000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  875000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  885000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  895000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  905000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  915000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  920000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  930000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  940000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19),  950000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  805000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  815000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  825000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  835000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  845000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  855000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  865000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  875000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  890000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  900000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  915000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  925000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  940000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  950000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  965000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  980000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  995000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1010000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1025000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1040000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1055000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1070000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1085000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1100000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  810000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  820000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  830000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  840000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  850000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  860000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  875000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  885000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  895000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  910000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  920000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  930000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  945000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  960000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  975000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  990000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1005000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1020000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1030000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1045000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1060000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1075000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  785000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  795000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  805000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  815000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  825000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  835000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  845000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  855000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  865000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  875000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  890000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  900000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  925000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  940000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  955000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  970000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  980000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  995000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1005000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1020000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1035000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1050000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  780000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  790000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  800000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  810000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  820000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  830000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  840000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  850000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  860000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  875000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  885000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  895000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  910000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  925000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  935000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  950000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  960000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  970000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  985000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  995000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1010000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1025000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  780000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  790000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  800000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  810000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  820000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  830000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  840000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  850000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  860000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  870000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  880000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  895000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  910000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  920000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  930000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  940000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  950000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  960000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  975000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  985000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1000000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  760000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  770000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  780000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  790000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  800000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  810000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  820000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  830000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  840000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  860000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  880000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  890000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  900000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  910000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  920000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  930000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  940000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  955000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  965000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  975000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  760000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  770000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  780000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  790000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  800000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  810000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  820000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  830000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  840000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  850000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  860000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  870000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  875000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  885000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  895000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  905000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  915000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  920000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  930000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  940000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  950000, 691 },
	{ 0, { 0 } }
};

static struct pvs_table pvs_v1[NUM_SPEED_BINS][NUM_PVS] __initdata = {
	/* 8974v1 1.7GHz Parts */
	[0][0] = { acpu_freq_tbl_v1_pvs0, sizeof(acpu_freq_tbl_v1_pvs0) },
	[0][1] = { acpu_freq_tbl_v1_pvs1, sizeof(acpu_freq_tbl_v1_pvs1) },
	[0][2] = { acpu_freq_tbl_v1_pvs2, sizeof(acpu_freq_tbl_v1_pvs2) },
	[0][3] = { acpu_freq_tbl_v1_pvs3, sizeof(acpu_freq_tbl_v1_pvs3) },
	[0][4] = { acpu_freq_tbl_v1_pvs4, sizeof(acpu_freq_tbl_v1_pvs4) },
};

static struct pvs_table pvs_v2[NUM_SPEED_BINS][NUM_PVS] __initdata = {
	/* 8974v2 2.0GHz Parts */
	[0][0] = { acpu_freq_tbl_2g_pvs0, sizeof(acpu_freq_tbl_2g_pvs0) },
	[0][1] = { acpu_freq_tbl_2g_pvs1, sizeof(acpu_freq_tbl_2g_pvs1) },
	[0][2] = { acpu_freq_tbl_2g_pvs2, sizeof(acpu_freq_tbl_2g_pvs2) },
	[0][3] = { acpu_freq_tbl_2g_pvs3, sizeof(acpu_freq_tbl_2g_pvs3) },
	[0][4] = { acpu_freq_tbl_2g_pvs4, sizeof(acpu_freq_tbl_2g_pvs4) },
	[0][5] = { acpu_freq_tbl_2g_pvs5, sizeof(acpu_freq_tbl_2g_pvs5) },
	[0][6] = { acpu_freq_tbl_2g_pvs6, sizeof(acpu_freq_tbl_2g_pvs6) },
	[0][7] = { acpu_freq_tbl_2g_pvs6, sizeof(acpu_freq_tbl_2g_pvs6) },

	/* 8974v2 2.3GHz Parts */
	[1][0] = { acpu_freq_tbl_2p3g_pvs0, sizeof(acpu_freq_tbl_2p3g_pvs0) },
	[1][1] = { acpu_freq_tbl_2p3g_pvs1, sizeof(acpu_freq_tbl_2p3g_pvs1) },
	[1][2] = { acpu_freq_tbl_2p3g_pvs2, sizeof(acpu_freq_tbl_2p3g_pvs2) },
	[1][3] = { acpu_freq_tbl_2p3g_pvs3, sizeof(acpu_freq_tbl_2p3g_pvs3) },
	[1][4] = { acpu_freq_tbl_2p3g_pvs4, sizeof(acpu_freq_tbl_2p3g_pvs4) },
	[1][5] = { acpu_freq_tbl_2p3g_pvs5, sizeof(acpu_freq_tbl_2p3g_pvs5) },
	[1][6] = { acpu_freq_tbl_2p3g_pvs6, sizeof(acpu_freq_tbl_2p3g_pvs6) },
	[1][7] = { acpu_freq_tbl_2p3g_pvs6, sizeof(acpu_freq_tbl_2p3g_pvs6) },

	/* 8974v2 2.0GHz Parts */
	[2][0] = { acpu_freq_tbl_2p2g_pvs0, sizeof(acpu_freq_tbl_2p2g_pvs0) },
	[2][1] = { acpu_freq_tbl_2p2g_pvs1, sizeof(acpu_freq_tbl_2p2g_pvs1) },
	[2][2] = { acpu_freq_tbl_2p2g_pvs2, sizeof(acpu_freq_tbl_2p2g_pvs2) },
	[2][3] = { acpu_freq_tbl_2p2g_pvs3, sizeof(acpu_freq_tbl_2p2g_pvs3) },
	[2][4] = { acpu_freq_tbl_2p2g_pvs4, sizeof(acpu_freq_tbl_2p2g_pvs4) },
	[2][5] = { acpu_freq_tbl_2p2g_pvs5, sizeof(acpu_freq_tbl_2p2g_pvs5) },
	[2][6] = { acpu_freq_tbl_2p2g_pvs6, sizeof(acpu_freq_tbl_2p2g_pvs6) },
	[2][7] = { acpu_freq_tbl_2p2g_pvs6, sizeof(acpu_freq_tbl_2p2g_pvs6) },

};

static struct msm_bus_scale_pdata bus_scale_data __initdata = {
	.usecase = bw_level_tbl_v2,
	.num_usecases = ARRAY_SIZE(bw_level_tbl_v2),
	.active_only = 1,
	.name = "acpuclk-8974",
};

static struct acpuclk_krait_params acpuclk_8974_params __initdata = {
	.scalable = scalable,
	.scalable_size = sizeof(scalable),
	.hfpll_data = &hfpll_data,
	.pvs_tables = pvs_v2,
	.l2_freq_tbl = l2_freq_tbl_v2,
	.l2_freq_tbl_size = sizeof(l2_freq_tbl_v2),
	.bus_scale = &bus_scale_data,
	.pte_efuse_phys = 0xFC4B80B0,
	.get_bin_info = get_krait_bin_format_b,
	.stby_khz = 300000,
};

static void __init apply_v1_l2_workaround(void)
{
	static struct l2_level resticted_l2_tbl[] __initdata = {
		[0] = { {  300000, PLL_0, 0,   0 }, LVL_LOW,  1050000, 0 },
		[1] = { { 1497600, HFPLL, 1,  78 }, LVL_HIGH, 1050000, 7 },
		{ }
	};
	struct acpu_level *l;
	int s, p;

	for (s = 0; s < NUM_SPEED_BINS; s++)
		for (p = 0; p < NUM_PVS; p++)
			for (l = pvs_v1[s][p].table; l && l->speed.khz; l++)
				l->l2_level = l->l2_level > 5 ? 1 : 0;

	acpuclk_8974_params.l2_freq_tbl = resticted_l2_tbl;
	acpuclk_8974_params.l2_freq_tbl_size = sizeof(resticted_l2_tbl);
}

static int __init acpuclk_8974_probe(struct platform_device *pdev)
{
	if (SOCINFO_VERSION_MAJOR(socinfo_get_version()) == 1) {
		acpuclk_8974_params.pvs_tables = pvs_v1;
		acpuclk_8974_params.l2_freq_tbl = l2_freq_tbl_v1;
		bus_scale_data.usecase = bw_level_tbl_v1;
		bus_scale_data.num_usecases = ARRAY_SIZE(bw_level_tbl_v1);
		acpuclk_8974_params.l2_freq_tbl_size = sizeof(l2_freq_tbl_v1);

		/*
		 * 8974 hardware revisions older than v1.2 may experience L2
		 * parity errors when running at some performance points between
		 * 300MHz and 1497.6MHz (non-inclusive), or when vdd_mx is less
		 * than 1.05V. Restrict L2 operation to safe performance points
		 * on these devices.
		 */
		if (SOCINFO_VERSION_MINOR(socinfo_get_version()) < 2)
			apply_v1_l2_workaround();
	}

	return acpuclk_krait_init(&pdev->dev, &acpuclk_8974_params);
}

static struct of_device_id acpuclk_8974_match_table[] = {
	{ .compatible = "qcom,acpuclk-8974" },
	{}
};

static struct platform_driver acpuclk_8974_driver = {
	.driver = {
		.name = "acpuclk-8974",
		.of_match_table = acpuclk_8974_match_table,
		.owner = THIS_MODULE,
	},
};

static int __init acpuclk_8974_init(void)
{
	return platform_driver_probe(&acpuclk_8974_driver,
				     acpuclk_8974_probe);
}
device_initcall(acpuclk_8974_init);
