/* See LICENSE for licensing and NOTICE for copyright. */
package org.ldaptive.extended;

import java.util.UUID;
import org.ldaptive.asn1.DefaultDERBuffer;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * Unit test for {@link SyncInfoMessage}.
 *
 * @author  Middleware Services
 */
public class SyncInfoMessageTest
{


  /**
   * Sync info test data.
   *
   * @return  response test data
   */
  @DataProvider(name = "response")
  public Object[][] createData()
  {
    return
      new Object[][] {
        // refresh delete with cookie
        new Object[] {
          new byte[] {
            (byte) 0xA1, 0x36, 0x04, 0x34, 0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D,
            0x32, 0x30, 0x31, 0x32, 0x30, 0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36,
            0x34, 0x39, 0x31, 0x35, 0x5A, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23,
            0x30, 0x30, 0x30, 0x30, 0x30, 0x30},
          SyncInfoMessage.builder()
            .type(SyncInfoMessage.Type.REFRESH_DELETE)
            .cookie(
              new byte[] {
                0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32, 0x30, 0x31, 0x32, 0x30,
                0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36, 0x34, 0x39, 0x31, 0x35, 0x5A,
                0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30,
                0x30}).build(),
        },
        // new cookie
        new Object[] {
          new byte[] {
            (byte) 0x80, 0x34, 0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32, 0x30,
            0x31, 0x32, 0x30, 0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36, 0x34, 0x39,
            0x31, 0x35, 0x5A, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30,
            0x30, 0x30, 0x30, 0x30},
          SyncInfoMessage.builder()
            .type(SyncInfoMessage.Type.NEW_COOKIE)
            .cookie(
              new byte[] {
                0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32, 0x30, 0x31, 0x32, 0x30,
                0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36, 0x34, 0x39, 0x31, 0x35, 0x5A,
                0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30,
                0x30}).build(),
        },
        // refresh present with cookie, refresh done false
        new Object[] {
          new byte[] {
            (byte) 0xA2, 0x39, 0x04, 0x34, 0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32,
            0x30, 0x31, 0x32, 0x30, 0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36, 0x34, 0x39,
            0x31, 0x35, 0x5A, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30,
            0x30, 0x30, 0x30, 0x01, 0x01, 0x00},
          SyncInfoMessage.builder()
            .type(SyncInfoMessage.Type.REFRESH_PRESENT)
            .refreshDone(false)
            .cookie(
              new byte[] {
                0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32, 0x30, 0x31, 0x32, 0x30,
                0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36, 0x34, 0x39, 0x31, 0x35, 0x5A,
                0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30,
                0x30})
            .refreshDone(false).build(),
        },
        // sync id set, refresh deletes true
        new Object[] {
          new byte[] {
            (byte) 0xA3, 0x5F, 0x04, 0x34, 0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32,
            0x30, 0x31, 0x32, 0x30, 0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36, 0x34, 0x39,
            0x31, 0x35, 0x5A, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30,
            0x30, 0x30, 0x30, 0x01, 0x01, (byte) 0xFF, 0x31, 0x24, 0x04, 0x10, 0x5D, 0x5D, (byte) 0xA5, (byte) 0xD0,
            0x5B, (byte) 0xE2, 0x10, 0x31, (byte) 0x82, (byte) 0x84, 0x11, 0x6F, (byte) 0xF5, 0x6E, 0x4E, 0x59, 0x04,
            0x10, (byte) 0x84, 0x31, 0x77, (byte) 0xEC, 0x5B, 0x0E, 0x10, 0x31, (byte) 0x82, 0x7F, 0x11, 0x6F,
            (byte) 0xF5, 0x6E, 0x4E, 0x59},
          SyncInfoMessage.builder()
            .type(SyncInfoMessage.Type.SYNC_ID_SET)
            .cookie(
              new byte[] {
                0x72, 0x69, 0x64, 0x3D, 0x30, 0x30, 0x30, 0x2C, 0x63, 0x73, 0x6E, 0x3D, 0x32, 0x30, 0x31, 0x32, 0x30,
                0x37, 0x30, 0x39, 0x32, 0x30, 0x31, 0x33, 0x31, 0x39, 0x2E, 0x37, 0x36, 0x34, 0x39, 0x31, 0x35, 0x5A,
                0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30,
                0x30})
            .refreshDeletes(true)
            .uuids(
              UUID.fromString("5d5da5d0-5be2-1031-8284-116ff56e4e59"),
              UUID.fromString("843177ec-5b0e-1031-827f-116ff56e4e59")).build(),
        },
      };
  }

  /**
   * @param  berValue  encoded response.
   * @param  response  expected decoded response.
   *
   * @throws  Exception  On test failure.
   */
  @Test(dataProvider = "response")
  public void encode(final byte[] berValue, final SyncInfoMessage response)
    throws Exception
  {
    final SyncInfoMessage info = new SyncInfoMessage();
    info.getResponseValueParseHandler().handle(null, new DefaultDERBuffer(berValue));
    Assert.assertEquals(info, response);
  }
}
