.TH LARSMENU 1x
.SH NAME
larsmenu \- create a menu to run commands
.SH SYNOPSIS
.B larsmenu
[
.BI \-bg " background-color"
] [
.BI \-display " displayname"
] [
.BI \-file " name"
] [
.BI \-fg " foreground-color"
] [
.BI \-font " fname"
] [
.BI \-geometry " geom"
] [
.B \-iconic
] [
.BI \-label " name"
] [
.B \-path
] [
.B \-popdown
] [
.B \-popup
] [
.BI \-shell " prog"
] [
.B \-teleport
] [
.B \-version
] [
.B \-warp
]
.IR menuitem [: command ]
\&...

.SH DESCRIPTION

larsmenu is a simple program that accepts a list of menu item and command
pairs on the command line.
It creates a window that consists of nothing but a menu.
When a particular item is selected, the corresponding command is executed.
.PP
Any mouse button may be used to select an item.
Alternatively, the UP-ARROW and DOWN-ARROW cursor keys may be used to
highlight different items, with ENTER used to select the
highlighted item. ESCAPE exits the menu without selecting an entry.
.PP
Menu items and commands are separated by a colon.  The colon and command
are optional. If they are missing, then the menu item is assumed to be
a command that can be executed directly.
.PP
A menu item consisting of the word
.B exit
causes larsmenu to exit when it is selected. Otherwise, to stop
larsmenu, delete it using the window manager.
If a command is supplied along with the
.B exit
item, that command is executed before larsmenu exits.
.PP
If a command starts with the word
.BR exec ,
larsmenu ceases operating after launching it.
.PP
larsmenu accepts the following command line options,
listed alphabetically:
.RS
.TP
.BI \-bg " background-color"
Set the background color to
.IR background-color .
By default, the background color is white.
.TP
.BI \-display " displayname"
Use the X display
.IR displayname ,
instead of the default display.
.TP
.BI \-file " filename"
Read items to display from
.IR filename ,
in addition to any other command line arguments.  This is intended for use
with
.B #!
in scripts.
.TP
.BI \-fg " foreground-color"
Set the foreground color to
.IR foreground-color .
By default, the foreground color is black.
.TP
.BI \-font " fname"
Use the font
.IR fname ,
instead of fixed.
.TP
.BI \-geometry " geom"
Use
.I geom
(a geometry in standard X format) as the geometry of the menu.
This is most useful for specifying the initial location of the menu.
Note that larsmenu overrides the size part of the geometry specification.
The window is always just large enough to hold the menu.
.TP
.B \-iconic
Start up in the iconified state.
.TP
.BI \-label " name"
Change both the window and icon labels of the window to
.IR name .
.TP
.B \-path
Append the current directory to the command search path.
.TP
.B \-popdown
Once an item is selected, the menu window automatically iconifies itself.
.TP
.B \-popup
Act like a pop-up menu. Once a menu item is selected, larsmenu exits.
This option overrides
.BR \-popdown .
.TP
.BI \-shell " prog"
Use
.I prog
as the shell to run commands, instead of
.BR /bin/sh .
If the shell cannot be executed, larsmenu then silently falls back to using
.BR /bin/sh .
.TP
.B \-teleport
Move the menu to where the mouse is when the menu is uniconified.
This option is particularly useful when combined with
.BR \-popdown .
.TP
.B \-version
This option prints the version of larsmenu on the standard output,
and then exits with an exit value of zero.
.TP
.B \-warp
Warp the mouse to the menu when the menu is uniconified.
After the selection is made, restore the mouse to where it was.
This option is particularly useful when combined with
.BR \-popdown .
.RE

.SH EXAMPLE

.ft B
.nf
larsmenu -popup "XTerm:xterm" "Calculator:xcalc"
.ft
.fi

.SH LICENSE

This is a modified version of 9menu, which has this license:

---

9menu is free software, and is Copyright (c) 1994 by David Hogan and
Arnold Robbins. Permission is granted to all sentient beings to use
this software, to make copies of it, and to distribute those copies,
provided that:

(1) the copyright and licence notices are left intact

(2) the recipients are aware that it is free software

(3) any unapproved changes in functionality are either

(i) only distributed as patches

or (ii) distributed as a new program which is not called 9menu
and whose documentation gives credit where it is due

(4) the authors are not held responsible for any defects

or shortcomings in the software, or damages caused by it.

There is no warranty for this software.  Have a nice day.

---

Please consider my code to be under the same type of
license as 9menu, inserting my name where appropriate.

.SH SEE ALSO

larsclock(1x), larsremote(1x), larswm(1x)

.SH AUTHORS

larsmenu was created by Lars Bernhardsson <lab@fnurt.net> by building on
9menu by David Hogan and Arnold Robbins.
