
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPixmap.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPixmap>
#include <QBitmap>
#include <QColor>
#include <QIODevice>
#include <QImage>
#include <QImageReader>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPainter>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QSize>
#include <QSizeF>
#include <QTransform>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPixmap

// qint64 QPixmap::cacheKey()


static void _init_f_cacheKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheKey_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QPixmap *)cls)->cacheKey ());
}


// bool QPixmap::convertFromImage(const QImage &img, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_convertFromImage_5137 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("img");
  decl->add_arg<const QImage & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_convertFromImage_5137 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg2 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<bool > ((bool)((QPixmap *)cls)->convertFromImage (arg1, arg2));
}


// QPixmap QPixmap::copy(int x, int y, int width, int height)


static void _init_f_copy_c2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QPixmap > ();
}

static void _call_f_copy_c2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->copy (arg1, arg2, arg3, arg4));
}


// QPixmap QPixmap::copy(const QRect &rect)


static void _init_f_copy_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRect()");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QPixmap > ();
}

static void _call_f_copy_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args ? gsi::arg_reader<const QRect & >() (args, heap) : gsi::arg_maker<const QRect & >() (QRect(), heap);
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->copy (arg1));
}


// QBitmap QPixmap::createHeuristicMask(bool clipTight)


static void _init_f_createHeuristicMask_c864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clipTight", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<QBitmap > ();
}

static void _call_f_createHeuristicMask_c864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  ret.write<QBitmap > ((QBitmap)((QPixmap *)cls)->createHeuristicMask (arg1));
}


// QBitmap QPixmap::createMaskFromColor(const QColor &maskColor, Qt::MaskMode mode)


static void _init_f_createMaskFromColor_c3331 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maskColor");
  decl->add_arg<const QColor & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::MaskInColor");
  decl->add_arg<const qt_gsi::Converter<Qt::MaskMode>::target_type & > (argspec_1);
  decl->set_return<QBitmap > ();
}

static void _call_f_createMaskFromColor_c3331 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  const qt_gsi::Converter<Qt::MaskMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::MaskMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::MaskMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::MaskMode>(heap, Qt::MaskInColor), heap);
  ret.write<QBitmap > ((QBitmap)((QPixmap *)cls)->createMaskFromColor (arg1, qt_gsi::QtToCppAdaptor<Qt::MaskMode>(arg2).cref()));
}


// int QPixmap::depth()


static void _init_f_depth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_depth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPixmap *)cls)->depth ());
}


// void QPixmap::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap *)cls)->detach ();
}


// QSizeF QPixmap::deviceIndependentSize()


static void _init_f_deviceIndependentSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_deviceIndependentSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QPixmap *)cls)->deviceIndependentSize ());
}


// double QPixmap::devicePixelRatio()


static void _init_f_devicePixelRatio_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_devicePixelRatio_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QPixmap *)cls)->devicePixelRatio ());
}


// void QPixmap::fill(const QColor &fillColor)


static void _init_f_fill_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fillColor", true, "Qt::white");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fill_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = args ? gsi::arg_reader<const QColor & >() (args, heap) : gsi::arg_maker<const QColor & >() (Qt::white, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap *)cls)->fill (arg1);
}


// bool QPixmap::hasAlpha()


static void _init_f_hasAlpha_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAlpha_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPixmap *)cls)->hasAlpha ());
}


// bool QPixmap::hasAlphaChannel()


static void _init_f_hasAlphaChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAlphaChannel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPixmap *)cls)->hasAlphaChannel ());
}


// int QPixmap::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPixmap *)cls)->height ());
}


// bool QPixmap::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPixmap *)cls)->isDetached ());
}


// bool QPixmap::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPixmap *)cls)->isNull ());
}


// bool QPixmap::isQBitmap()


static void _init_f_isQBitmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isQBitmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPixmap *)cls)->isQBitmap ());
}


// bool QPixmap::load(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_load_6908 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_load_6908 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  QFlags<Qt::ImageConversionFlag> arg3 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<bool > ((bool)((QPixmap *)cls)->load (arg1, arg2, arg3));
}


// bool QPixmap::loadFromData(const unsigned char *buf, unsigned int len, const char *format, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_loadFromData_9283 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buf");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<unsigned int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_9283 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const unsigned char *arg1 = gsi::arg_reader<const unsigned char * >() (args, heap);
  unsigned int arg2 = gsi::arg_reader<unsigned int >() (args, heap);
  const char *arg3 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  QFlags<Qt::ImageConversionFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<bool > ((bool)((QPixmap *)cls)->loadFromData (arg1, arg2, arg3, arg4));
}


// bool QPixmap::loadFromData(const QByteArray &data, const char *format, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_loadFromData_7192 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_7192 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  QFlags<Qt::ImageConversionFlag> arg3 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<bool > ((bool)((QPixmap *)cls)->loadFromData (arg1, arg2, arg3));
}


// QBitmap QPixmap::mask()


static void _init_f_mask_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBitmap > ();
}

static void _call_f_mask_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBitmap > ((QBitmap)((QPixmap *)cls)->mask ());
}


// bool QPixmap::operator!()


static void _init_f_operator_excl__c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPixmap *)cls)->operator! ());
}


// QPixmap &QPixmap::operator=(const QPixmap &)


static void _init_f_operator_eq__2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<QPixmap & > ();
}

static void _call_f_operator_eq__2017 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPixmap &arg1 = gsi::arg_reader<const QPixmap & >() (args, heap);
  ret.write<QPixmap & > ((QPixmap &)((QPixmap *)cls)->operator= (arg1));
}


// QPaintEngine *QPixmap::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPixmap *)cls)->paintEngine ());
}


// QRect QPixmap::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPixmap *)cls)->rect ());
}


// bool QPixmap::save(const QString &fileName, const char *format, int quality)


static void _init_f_save_c4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c4307 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<bool > ((bool)((QPixmap *)cls)->save (arg1, arg2, arg3));
}


// bool QPixmap::save(QIODevice *device, const char *format, int quality)


static void _init_f_save_c3729 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c3729 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<bool > ((bool)((QPixmap *)cls)->save (arg1, arg2, arg3));
}


// QPixmap QPixmap::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6100 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_3);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaled_c6100 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio), heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaled (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg3).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg4).cref()));
}


// QPixmap QPixmap::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6479 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaled_c6479 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio), heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaled (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg3).cref()));
}


// QPixmap QPixmap::scaledToHeight(int h, Qt::TransformationMode mode)


static void _init_f_scaledToHeight_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaledToHeight_c3292 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaledToHeight (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}


// QPixmap QPixmap::scaledToWidth(int w, Qt::TransformationMode mode)


static void _init_f_scaledToWidth_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaledToWidth_c3292 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaledToWidth (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}


// void QPixmap::scroll(int dx, int dy, int x, int y, int width, int height, QRegion *exposed)


static void _init_f_scroll_5269 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("width");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("height");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("exposed", true, "nullptr");
  decl->add_arg<QRegion * > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_scroll_5269 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  int arg6 = gsi::arg_reader<int >() (args, heap);
  QRegion *arg7 = args ? gsi::arg_reader<QRegion * >() (args, heap) : gsi::arg_maker<QRegion * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap *)cls)->scroll (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}


// void QPixmap::scroll(int dx, int dy, const QRect &rect, QRegion *exposed)


static void _init_f_scroll_4317 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("exposed", true, "nullptr");
  decl->add_arg<QRegion * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_scroll_4317 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  QRegion *arg4 = args ? gsi::arg_reader<QRegion * >() (args, heap) : gsi::arg_maker<QRegion * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap *)cls)->scroll (arg1, arg2, arg3, arg4);
}


// void QPixmap::setDevicePixelRatio(double scaleFactor)


static void _init_f_setDevicePixelRatio_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scaleFactor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevicePixelRatio_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap *)cls)->setDevicePixelRatio (arg1);
}


// void QPixmap::setMask(const QBitmap &)


static void _init_f_setMask_1999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QBitmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMask_1999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBitmap &arg1 = gsi::arg_reader<const QBitmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap *)cls)->setMask (arg1);
}


// QSize QPixmap::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPixmap *)cls)->size ());
}


// void QPixmap::swap(QPixmap &other)


static void _init_f_swap_1322 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QPixmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1322 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPixmap &arg1 = gsi::arg_reader<QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap *)cls)->swap (arg1);
}


// QImage QPixmap::toImage()


static void _init_f_toImage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_toImage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImage > ((QImage)((QPixmap *)cls)->toImage ());
}


// QPixmap QPixmap::transformed(const QTransform &, Qt::TransformationMode mode)


static void _init_f_transformed_c4875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_transformed_c4875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->transformed (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}


// int QPixmap::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPixmap *)cls)->width ());
}


// static int QPixmap::defaultDepth()


static void _init_f_defaultDepth_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_defaultDepth_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QPixmap::defaultDepth ());
}


// static QPixmap QPixmap::fromImage(const QImage &image, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_fromImage_5137 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_fromImage_5137 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg2 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<QPixmap > ((QPixmap)QPixmap::fromImage (arg1, arg2));
}


// static QPixmap QPixmap::fromImageReader(QImageReader *imageReader, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_fromImageReader_5041 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("imageReader");
  decl->add_arg<QImageReader * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_fromImageReader_5041 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QImageReader *arg1 = gsi::arg_reader<QImageReader * >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg2 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<QPixmap > ((QPixmap)QPixmap::fromImageReader (arg1, arg2));
}


// static QTransform QPixmap::trueMatrix(const QTransform &m, int w, int h)


static void _init_f_trueMatrix_3668 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QTransform > ();
}

static void _call_f_trueMatrix_3668 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTransform > ((QTransform)QPixmap::trueMatrix (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QPixmap () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("cacheKey", "@brief Method qint64 QPixmap::cacheKey()\n", true, &_init_f_cacheKey_c0, &_call_f_cacheKey_c0);
  methods += new qt_gsi::GenericMethod ("convertFromImage", "@brief Method bool QPixmap::convertFromImage(const QImage &img, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_convertFromImage_5137, &_call_f_convertFromImage_5137);
  methods += new qt_gsi::GenericMethod ("copy", "@brief Method QPixmap QPixmap::copy(int x, int y, int width, int height)\n", true, &_init_f_copy_c2744, &_call_f_copy_c2744);
  methods += new qt_gsi::GenericMethod ("copy", "@brief Method QPixmap QPixmap::copy(const QRect &rect)\n", true, &_init_f_copy_c1792, &_call_f_copy_c1792);
  methods += new qt_gsi::GenericMethod ("createHeuristicMask", "@brief Method QBitmap QPixmap::createHeuristicMask(bool clipTight)\n", true, &_init_f_createHeuristicMask_c864, &_call_f_createHeuristicMask_c864);
  methods += new qt_gsi::GenericMethod ("createMaskFromColor", "@brief Method QBitmap QPixmap::createMaskFromColor(const QColor &maskColor, Qt::MaskMode mode)\n", true, &_init_f_createMaskFromColor_c3331, &_call_f_createMaskFromColor_c3331);
  methods += new qt_gsi::GenericMethod ("depth", "@brief Method int QPixmap::depth()\n", true, &_init_f_depth_c0, &_call_f_depth_c0);
  methods += new qt_gsi::GenericMethod ("detach", "@brief Method void QPixmap::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
  methods += new qt_gsi::GenericMethod ("deviceIndependentSize", "@brief Method QSizeF QPixmap::deviceIndependentSize()\n", true, &_init_f_deviceIndependentSize_c0, &_call_f_deviceIndependentSize_c0);
  methods += new qt_gsi::GenericMethod (":devicePixelRatio", "@brief Method double QPixmap::devicePixelRatio()\n", true, &_init_f_devicePixelRatio_c0, &_call_f_devicePixelRatio_c0);
  methods += new qt_gsi::GenericMethod ("fill", "@brief Method void QPixmap::fill(const QColor &fillColor)\n", false, &_init_f_fill_1905, &_call_f_fill_1905);
  methods += new qt_gsi::GenericMethod ("hasAlpha", "@brief Method bool QPixmap::hasAlpha()\n", true, &_init_f_hasAlpha_c0, &_call_f_hasAlpha_c0);
  methods += new qt_gsi::GenericMethod ("hasAlphaChannel", "@brief Method bool QPixmap::hasAlphaChannel()\n", true, &_init_f_hasAlphaChannel_c0, &_call_f_hasAlphaChannel_c0);
  methods += new qt_gsi::GenericMethod ("height", "@brief Method int QPixmap::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QPixmap::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QPixmap::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("isQBitmap?", "@brief Method bool QPixmap::isQBitmap()\n", true, &_init_f_isQBitmap_c0, &_call_f_isQBitmap_c0);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method bool QPixmap::load(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_load_6908, &_call_f_load_6908);
  methods += new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QPixmap::loadFromData(const unsigned char *buf, unsigned int len, const char *format, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_loadFromData_9283, &_call_f_loadFromData_9283);
  methods += new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QPixmap::loadFromData(const QByteArray &data, const char *format, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_loadFromData_7192, &_call_f_loadFromData_7192);
  methods += new qt_gsi::GenericMethod (":mask", "@brief Method QBitmap QPixmap::mask()\n", true, &_init_f_mask_c0, &_call_f_mask_c0);
  methods += new qt_gsi::GenericMethod ("!", "@brief Method bool QPixmap::operator!()\n", true, &_init_f_operator_excl__c0, &_call_f_operator_excl__c0);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QPixmap &QPixmap::operator=(const QPixmap &)\n", false, &_init_f_operator_eq__2017, &_call_f_operator_eq__2017);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QPixmap::paintEngine()\nThis is a reimplementation of QPaintDevice::paintEngine", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
  methods += new qt_gsi::GenericMethod ("rect", "@brief Method QRect QPixmap::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method bool QPixmap::save(const QString &fileName, const char *format, int quality)\n", true, &_init_f_save_c4307, &_call_f_save_c4307);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method bool QPixmap::save(QIODevice *device, const char *format, int quality)\n", true, &_init_f_save_c3729, &_call_f_save_c3729);
  methods += new qt_gsi::GenericMethod ("scaled", "@brief Method QPixmap QPixmap::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6100, &_call_f_scaled_c6100);
  methods += new qt_gsi::GenericMethod ("scaled", "@brief Method QPixmap QPixmap::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6479, &_call_f_scaled_c6479);
  methods += new qt_gsi::GenericMethod ("scaledToHeight", "@brief Method QPixmap QPixmap::scaledToHeight(int h, Qt::TransformationMode mode)\n", true, &_init_f_scaledToHeight_c3292, &_call_f_scaledToHeight_c3292);
  methods += new qt_gsi::GenericMethod ("scaledToWidth", "@brief Method QPixmap QPixmap::scaledToWidth(int w, Qt::TransformationMode mode)\n", true, &_init_f_scaledToWidth_c3292, &_call_f_scaledToWidth_c3292);
  methods += new qt_gsi::GenericMethod ("scroll", "@brief Method void QPixmap::scroll(int dx, int dy, int x, int y, int width, int height, QRegion *exposed)\n", false, &_init_f_scroll_5269, &_call_f_scroll_5269);
  methods += new qt_gsi::GenericMethod ("scroll", "@brief Method void QPixmap::scroll(int dx, int dy, const QRect &rect, QRegion *exposed)\n", false, &_init_f_scroll_4317, &_call_f_scroll_4317);
  methods += new qt_gsi::GenericMethod ("setDevicePixelRatio|devicePixelRatio=", "@brief Method void QPixmap::setDevicePixelRatio(double scaleFactor)\n", false, &_init_f_setDevicePixelRatio_1071, &_call_f_setDevicePixelRatio_1071);
  methods += new qt_gsi::GenericMethod ("setMask|mask=", "@brief Method void QPixmap::setMask(const QBitmap &)\n", false, &_init_f_setMask_1999, &_call_f_setMask_1999);
  methods += new qt_gsi::GenericMethod ("size", "@brief Method QSize QPixmap::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QPixmap::swap(QPixmap &other)\n", false, &_init_f_swap_1322, &_call_f_swap_1322);
  methods += new qt_gsi::GenericMethod ("toImage", "@brief Method QImage QPixmap::toImage()\n", true, &_init_f_toImage_c0, &_call_f_toImage_c0);
  methods += new qt_gsi::GenericMethod ("transformed", "@brief Method QPixmap QPixmap::transformed(const QTransform &, Qt::TransformationMode mode)\n", true, &_init_f_transformed_c4875, &_call_f_transformed_c4875);
  methods += new qt_gsi::GenericMethod ("width", "@brief Method int QPixmap::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += new qt_gsi::GenericStaticMethod ("defaultDepth", "@brief Static method int QPixmap::defaultDepth()\nThis method is static and can be called without an instance.", &_init_f_defaultDepth_0, &_call_f_defaultDepth_0);
  methods += new qt_gsi::GenericStaticMethod ("fromImage", "@brief Static method QPixmap QPixmap::fromImage(const QImage &image, QFlags<Qt::ImageConversionFlag> flags)\nThis method is static and can be called without an instance.", &_init_f_fromImage_5137, &_call_f_fromImage_5137);
  methods += new qt_gsi::GenericStaticMethod ("fromImageReader", "@brief Static method QPixmap QPixmap::fromImageReader(QImageReader *imageReader, QFlags<Qt::ImageConversionFlag> flags)\nThis method is static and can be called without an instance.", &_init_f_fromImageReader_5041, &_call_f_fromImageReader_5041);
  methods += new qt_gsi::GenericStaticMethod ("trueMatrix", "@brief Static method QTransform QPixmap::trueMatrix(const QTransform &m, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_trueMatrix_3668, &_call_f_trueMatrix_3668);
  return methods;
}

gsi::Class<QPaintDevice> &qtdecl_QPaintDevice ();

gsi::Class<QPixmap> decl_QPixmap (qtdecl_QPaintDevice (), "QtGui", "QPixmap_Native",
  methods_QPixmap (),
  "@hide\n@alias QPixmap");

GSI_QTGUI_PUBLIC gsi::Class<QPixmap> &qtdecl_QPixmap () { return decl_QPixmap; }

}


class QPixmap_Adaptor : public QPixmap, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPixmap_Adaptor();

  //  [adaptor ctor] QPixmap::QPixmap()
  QPixmap_Adaptor() : QPixmap()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(int w, int h)
  QPixmap_Adaptor(int w, int h) : QPixmap(w, h)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QSize &)
  QPixmap_Adaptor(const QSize &arg1) : QPixmap(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)
  QPixmap_Adaptor(const QString &fileName) : QPixmap(fileName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)
  QPixmap_Adaptor(const QString &fileName, const char *format) : QPixmap(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)
  QPixmap_Adaptor(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags) : QPixmap(fileName, format, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QPixmap &)
  QPixmap_Adaptor(const QPixmap &arg1) : QPixmap(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QPixmap QPixmap::fromImageInPlace(QImage &image, QFlags<Qt::ImageConversionFlag> flags)
  static QPixmap fp_QPixmap_fromImageInPlace_4442 (QImage &image, QFlags<Qt::ImageConversionFlag> flags) {
    return QPixmap::fromImageInPlace(image, flags);
  }

  //  [adaptor impl] QPaintEngine *QPixmap::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPixmap::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPixmap_Adaptor, QPaintEngine *>(&QPixmap_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPixmap::paintEngine();
    }
  }

  //  [adaptor impl] void QPixmap::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QPixmap::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QPixmap_Adaptor, QPainter *>(&QPixmap_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QPixmap::initPainter(painter);
    }
  }

  //  [adaptor impl] int QPixmap::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPixmap::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPixmap_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPixmap_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPixmap::metric(arg1);
    }
  }

  //  [adaptor impl] QPaintDevice *QPixmap::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QPixmap::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QPixmap_Adaptor, QPaintDevice *, QPoint *>(&QPixmap_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QPixmap::redirected(offset);
    }
  }

  //  [adaptor impl] QPainter *QPixmap::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QPixmap::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QPixmap_Adaptor, QPainter *>(&QPixmap_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QPixmap::sharedPainter();
    }
  }

  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_sharedPainter_c0_0;
};

QPixmap_Adaptor::~QPixmap_Adaptor() { }

//  Constructor QPixmap::QPixmap() (adaptor class)

static void _init_ctor_QPixmap_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPixmap_Adaptor> ();
}

static void _call_ctor_QPixmap_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor ());
}


//  Constructor QPixmap::QPixmap(int w, int h) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QPixmap_Adaptor> ();
}

static void _call_ctor_QPixmap_Adaptor_1426 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1, arg2));
}


//  Constructor QPixmap::QPixmap(const QSize &) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_1805 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return_new<QPixmap_Adaptor> ();
}

static void _call_ctor_QPixmap_Adaptor_1805 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1));
}


//  Constructor QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_6908 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_2);
  decl->set_return_new<QPixmap_Adaptor> ();
}

static void _call_ctor_QPixmap_Adaptor_6908 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  QFlags<Qt::ImageConversionFlag> arg3 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1, arg2, arg3));
}


//  Constructor QPixmap::QPixmap(const QPixmap &) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_2017 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return_new<QPixmap_Adaptor> ();
}

static void _call_ctor_QPixmap_Adaptor_2017 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPixmap &arg1 = gsi::arg_reader<const QPixmap & >() (args, heap);
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1));
}


// exposed QPixmap QPixmap::fromImageInPlace(QImage &image, QFlags<Qt::ImageConversionFlag> flags)

static void _init_fp_fromImageInPlace_4442 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<QImage & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_fp_fromImageInPlace_4442 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QImage &arg1 = gsi::arg_reader<QImage & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg2 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<QPixmap > ((QPixmap)QPixmap_Adaptor::fp_QPixmap_fromImageInPlace_4442 (arg1, arg2));
}


// void QPixmap::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPixmap_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QPixmap_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// int QPixmap::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPixmap_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPixmap_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QPaintEngine *QPixmap::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPixmap_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPixmap_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// QPaintDevice *QPixmap::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPixmap_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QPixmap_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// QPainter *QPixmap::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QPixmap_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPixmap_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QPixmap> &qtdecl_QPixmap ();

static gsi::Methods methods_QPixmap_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap()\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_0, &_call_ctor_QPixmap_Adaptor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(int w, int h)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_1426, &_call_ctor_QPixmap_Adaptor_1426);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(const QSize &)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_1805, &_call_ctor_QPixmap_Adaptor_1805);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_6908, &_call_ctor_QPixmap_Adaptor_6908);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(const QPixmap &)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_2017, &_call_ctor_QPixmap_Adaptor_2017);
  methods += new qt_gsi::GenericStaticMethod ("*fromImageInPlace", "@brief Method QPixmap QPixmap::fromImageInPlace(QImage &image, QFlags<Qt::ImageConversionFlag> flags)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_fromImageInPlace_4442, &_call_fp_fromImageInPlace_4442);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QPixmap::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPixmap::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPixmap::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QPixmap::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QPixmap::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  return methods;
}

gsi::Class<QPixmap_Adaptor> decl_QPixmap_Adaptor (qtdecl_QPixmap (), "QtGui", "QPixmap",
  methods_QPixmap_Adaptor (),
  "@qt\n@brief Binding of QPixmap");

}

