/*
 *  Copyright (C) 2018 KeePassXC Team <team@keepassxc.org>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 or (at your option)
 *  version 3 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "NewDatabaseWizardPageMasterKey.h"
#include "gui/dbsettings/DatabaseSettingsWidgetMasterKey.h"
#include <QApplication>

NewDatabaseWizardPageMasterKey::NewDatabaseWizardPageMasterKey(QWidget* parent)
    : NewDatabaseWizardPage(parent)
{
    setPageWidget(new DatabaseSettingsWidgetMasterKey());

    setTitle(tr("Database Master Key"));
    setSubTitle(tr("A master key known only to you protects your database."));

    connect(pageWidget(), SIGNAL(sizeChanged()), SLOT(updateWindowSize()));
}

NewDatabaseWizardPageMasterKey::~NewDatabaseWizardPageMasterKey()
{
}

void NewDatabaseWizardPageMasterKey::updateWindowSize()
{
    // ugly workaround for QWizard not managing to react to size changes automatically
    QApplication::activeWindow()->adjustSize();
}
