require 'benchmark'

def bench_backref(bm)
  str = "abcdefghij"
  reg = /(cde)(fgh)/
  reg.match(str)

  bm.report("control: 100k block with self") do
    100_000.times { self }
  end

  bm.report("100k times 100 $~ accesses") do
    100_000.times do
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
      $~; $~; $~; $~; $~; $~; $~; $~; $~; $~
    end
  end

  bm.report("100k times 100 $& accesses") do
    100_000.times do
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
      $&; $&; $&; $&; $&; $&; $&; $&; $&; $&
    end
  end

  bm.report("100k times 100 $` accesses") do
    100_000.times do
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
      $`; $`; $`; $`; $`; $`; $`; $`; $`; $`
    end
  end

  bm.report("100k times 100 $' accesses") do
    100_000.times do
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
      $'; $'; $'; $'; $'; $'; $'; $'; $'; $'
    end
  end

  bm.report("100k times 100 $+ accesses") do
    100_000.times do
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
      $+; $+; $+; $+; $+; $+; $+; $+; $+; $+
    end
  end
end

if $0 == __FILE__
  (ARGV[0] || 10).to_i.times { Benchmark.bm(30) {|bm| bench_backref(bm)} }
end