/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  The camera path with the focal path, focal path band, and a camera path header
//

#ifndef ICAMERAPATH_H
#define ICAMERAPATH_H


#include "ieventobserver.h"


#include "icolor.h"

class iActor;
class iSplineWidget;
class iViewModule;

class vtkConeSource;
class vtkPoints;
class vtkPolyData;


class iCameraPath : public iEventObserver
{
	
	IPOINTER_AS_PART(ViewModule);

public:

	vtkTypeMacro(iCameraPath,iEventObserver);
	static iCameraPath* New(iViewModule *vm = 0);

	virtual void SetEnabled(bool s);
	bool GetEnabled() const;

	virtual void SetNumberOfHandles(int n);
	int GetNumberOfHandles() const;
//	int GetNumberOfIntervals() const;
	
	virtual void SetClosed(bool s);
	bool GetClosed() const;
	
	virtual void SetFocalPathEnabled(bool s);
	bool GetFocalPathEnabled() const { return mIsFocalPath; }
	
	virtual void SetFocalPathToPoint(bool s);
	bool GetFocalPathToPoint() const { return mIsFocalPathToPoint; }
	
	void SetLineColor(iColor &c);
	void SetHandleOpacity(float v);

	void SetCameraPathHandlePosition(int n, double x[3]);
	void GetCameraPathHandlePosition(int n, double x[3]) const;
	void SetFocalPathHandlePosition(int n, double x[3]);
	void GetFocalPathHandlePosition(int n, double x[3]) const;

	//
	//  Special forms for Animator packing/unpacking
	//
	void SetCameraPathHandlePositions(int dir, const float *x);
	void GetCameraPathHandlePositions(float *x1, float *x2, float *x3) const;
	void SetFocalPathHandlePositions(int dir, const float *x);
	void GetFocalPathHandlePositions(float *x1, float *x2, float *x3) const;

	vtkPoints* GetCameraPathPoints();
	vtkPoints* GetFocalPathPoints();

protected:
	
	virtual ~iCameraPath();

	virtual void ExecuteBody(vtkObject *caller, unsigned long event, void *data);

private:
	
	iCameraPath(iViewModule *vm);

	iSplineWidget *mCamPathWidget, *mFocPathWidget;
	iActor *mCamPathHeadActor, *mFocPathBandActor;
	vtkConeSource *mCamPathHeadSource;
	vtkPolyData *mCamPathData, *mFocPathData, *mFocPathBandSource;

	bool mIsFocalPath, mIsFocalPathToPoint;
	double mDxPrev[3];

	const int mNumIntervalsPerSegment;
};

#endif // ICAMERAPATH_H

