package CParse::Op::ArraySubscript;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;

use CExpr::ArraySubscript;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $right = shift;

    my $self = {right => $right,
               };
    bless $self, $class;
    return $self;
  }

sub set_prefix
  {
    my $self = shift;
    $self->{left} = shift;
  }

sub args
  {
    my $self = shift;
    return ($self->{left}, $self->{right});
  }

sub dump_c
  {
    my $self = shift;
    my $left = $self->{left}->dump_c;
    my $right = $self->{right}->dump_c;

    return "($left\[$right\])";
  }

sub get_expr
  {
    my $self = shift;
    my $namespace = shift;

    my $left = $self->{left}->get_expr($namespace);
    my $right = $self->{right}->get_expr($namespace);

    return new CExpr::ArraySubscript $left, $right;
  }

1;
