{-# LANGUAGE DeriveDataTypeable #-}
{-# LANGUAGE OverloadedStrings #-}
{-# OPTIONS_GHC -fno-warn-missing-fields #-}
{-# OPTIONS_GHC -fno-warn-missing-signatures #-}
{-# OPTIONS_GHC -fno-warn-name-shadowing #-}
{-# OPTIONS_GHC -fno-warn-unused-imports #-}
{-# OPTIONS_GHC -fno-warn-unused-matches #-}

-----------------------------------------------------------------
-- Autogenerated by Thrift
--                                                             --
-- DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
--  @generated
-----------------------------------------------------------------

module MyService_Fuzzer (main) where
import qualified Service_Types
import qualified MyService_Client as Client
import qualified Module_Types
import qualified Includes_Types

import Prelude ( Bool(..), Enum, Float, IO, Double, String, Maybe(..),
                 Eq, Show, Ord,
                 concat, error, fromIntegral, fromEnum, length, map,
                 maybe, not, null, otherwise, return, show, toEnum,
                 enumFromTo, Bounded, minBound, maxBound, seq, succ,
                 pred, enumFrom, enumFromThen, enumFromThenTo,
                 (.), (&&), (||), (==), (++), ($), (-), (>>=), (>>))

import qualified Control.Applicative as Applicative (ZipList(..))
import Control.Applicative ( (<*>) )
import qualified Control.DeepSeq as DeepSeq
import qualified Control.Exception as Exception
import qualified Control.Monad as Monad ( liftM, ap, when )
import qualified Data.ByteString.Lazy as BS
import Data.Functor ( (<$>) )
import qualified Data.Hashable as Hashable
import qualified Data.Int as Int
import Data.List
import qualified Data.Maybe as Maybe (catMaybes)
import qualified Data.Text.Lazy.Encoding as Encoding ( decodeUtf8, encodeUtf8 )
import qualified Data.Text.Lazy as LT
import qualified Data.Typeable as Typeable ( Typeable )
import qualified Data.HashMap.Strict as Map
import qualified Data.HashSet as Set
import qualified Data.Vector as Vector
import qualified Test.QuickCheck.Arbitrary as Arbitrary ( Arbitrary(..) )
import qualified Test.QuickCheck as QuickCheck ( elements )

import qualified Thrift
import qualified Thrift.Types as Types
import qualified Thrift.Serializable as Serializable
import qualified Thrift.Arbitraries as Arbitraries

import qualified Module_Types as Module_Types
import qualified Includes_Types as Includes_Types

import Prelude ((>>), print)
import qualified Prelude as P
import Control.Monad (forM)
import qualified Data.List as L
import Data.Maybe (fromJust)
import qualified Data.Map as Map
import GHC.Int (Int64, Int32)
import Data.ByteString.Lazy (ByteString)
import System.Environment (getArgs)
import Test.QuickCheck (arbitrary)
import Test.QuickCheck.Gen (Gen(..))
import Thrift.FuzzerSupport


handleOptions :: ([Options -> Options], [String], [String]) -> Options
handleOptions (transformers, (serviceName:[]), []) | serviceName `P.elem` serviceNames
    = (P.foldl (P.flip ($)) defaultOptions transformers) { opt_service = serviceName } 
handleOptions (_, (serviceName:[]), []) | P.otherwise
    = P.error $ usage ++ "\nUnknown serviceName " ++ serviceName ++ ", should be one of " ++ (P.show serviceNames)
handleOptions (_, [], _) = P.error $ usage ++ "\nMissing mandatory serviceName to fuzz."
handleOptions (_, _a, []) = P.error $ usage ++ "\nToo many serviceNames, pick one."
handleOptions (_, _, e) = P.error $ usage ++ (P.show e)

main :: IO ()
main = do
    args <- getArgs
    let config = handleOptions (getOptions args)
    fuzz config

selectFuzzer :: Options -> (Options -> IO ())
selectFuzzer (Options _host _port service _timeout _framed _verbose) 
    = fromJust $ P.lookup service fuzzerFunctions

fuzz :: Options -> IO ()
fuzz config = (selectFuzzer config) config

-- Dynamic content

-- Configuration via command-line parsing

serviceNames :: [String]
serviceNames = ["query", "has_arg_docs"]

fuzzerFunctions :: [(String, (Options -> IO ()))]
fuzzerFunctions = [("query", query_fuzzer), ("has_arg_docs", has_arg_docs_fuzzer)]

-- Random data generation
inf_Includes_Types_Included :: IO [Includes_Types.Included]
inf_Includes_Types_Included = infexamples (Arbitrary.arbitrary :: Gen Includes_Types.Included)

inf_Module_Types_MyStruct :: IO [Module_Types.MyStruct]
inf_Module_Types_MyStruct = infexamples (Arbitrary.arbitrary :: Gen Module_Types.MyStruct)

-- Fuzzers and exception handlers
query_fuzzer :: Options -> IO ()
query_fuzzer opts = do
  a1 <- Applicative.ZipList <$> inf_Module_Types_MyStruct
  a2 <- Applicative.ZipList <$> inf_Includes_Types_Included
  _ <- P.sequence . Applicative.getZipList $ query_fuzzFunc <$> a1 <*> a2
  return ()
  where
  query_fuzzFunc a1 a2 = let param = (a1, a2) in
    if opt_framed opts
    then withThriftDo opts (withFramedTransport opts) (query_fuzzOnce param) (query_exceptionHandler param)
    else withThriftDo opts (withHandle opts) (query_fuzzOnce param) (query_exceptionHandler param)

query_exceptionHandler :: (Show a1, Show a2) => (a1, a2) -> IO ()
query_exceptionHandler (a1, a2) = do
  P.putStrLn $ "Got exception on data:"
  P.putStrLn $ "(" ++ show a1 ++ show a2 ++ ")"
query_fuzzOnce (a1, a2) client = Client.query client a1 a2 >> return ()

has_arg_docs_fuzzer :: Options -> IO ()
has_arg_docs_fuzzer opts = do
  a1 <- Applicative.ZipList <$> inf_Module_Types_MyStruct
  a2 <- Applicative.ZipList <$> inf_Includes_Types_Included
  _ <- P.sequence . Applicative.getZipList $ has_arg_docs_fuzzFunc <$> a1 <*> a2
  return ()
  where
  has_arg_docs_fuzzFunc a1 a2 = let param = (a1, a2) in
    if opt_framed opts
    then withThriftDo opts (withFramedTransport opts) (has_arg_docs_fuzzOnce param) (has_arg_docs_exceptionHandler param)
    else withThriftDo opts (withHandle opts) (has_arg_docs_fuzzOnce param) (has_arg_docs_exceptionHandler param)

has_arg_docs_exceptionHandler :: (Show a1, Show a2) => (a1, a2) -> IO ()
has_arg_docs_exceptionHandler (a1, a2) = do
  P.putStrLn $ "Got exception on data:"
  P.putStrLn $ "(" ++ show a1 ++ show a2 ++ ")"
has_arg_docs_fuzzOnce (a1, a2) client = Client.has_arg_docs client a1 a2 >> return ()

