//! @file hfst_twolc_doxygen_header.h
//!
//! @author Miikka Silfverberg
//!
//! @brief This file contains only the Doxygen documentation main page.
 
#ifndef HFST_TWOLC_DOXYGEN_HEADER_H
#define HFST_TWOLC_DOXYGEN_HEADER_H

//! \mainpage hfst-twolc documentation (under construction)
//! hfst-twolc is a compiler for two level morphologies (see
//! [Koskenniemi 1983]). The compiler should be able to compile all grammars
//! which follow the Xerox twolc documentation (see [Beesley and Karttunen
//! 2003], [Karttunen et al. 1987]). There is some difficulty in obtaining full
//! compliance with Xerox, since different documents give slightly different
//! information about the Xerox twolc compiler (e.g. use of the keywords
//! FREELY and MIXED varies).
//!
//! hfst-twolc is open source and is released under the GPL license ([see Free
//! Software Foundation 2007]).
//!
//! This documentation is mainly intended for developers of hfst-twolc. It
//! documents the C++ classes used in compiling twolc grammars. The compiler
//! additionally includes flex scanners (see [The Flex Project 2008]) and bison
//! compilers (see [Free Software Foundation 2010]) which have in file
//! documentation.
//!
//! Documentation for the end-user of hfst-twolc is available
//! <a href="https://kitwiki.csc.fi/twiki/bin/view/KitWiki/HfstTwolC">here</a>.
//!
//! Beesely and Karttunen 2003:
//! <a href="http://www.stanford.edu/~laurik/.book2software/twolc.pdf">
//! Two-Level Rule Compiler</a>
//!
//! The Flex Project 2008:
//! <a href="http://flex.sourceforge.net/manual/">Lexical Analysis With Flex
//! </a>
//!
//! Free SoftWare Foundation 2010:
//! <a href="http://www.gnu.org/software/bison/manual/bison.html">
//! Bison 2.4.3</a>
//!
//! Free SoftWare Foundation 2007:
//! <a href="http://www.gnu.org/licenses/gpl-3.0.html">GNU GENERAL PUBLIC
//! LICENSE</a>
//!
//! Karttunen, Koskenniemi and Kaplan 1987:
//! <a href=
//! "http://www2.parc.com/istl/members/karttune/publications/archive/
//! twolcomp.pdf">A Compiler for Two-level Phonological Rules</a>
//!
//! Koskenniemi 1983: <a
//! href="http://www.ling.helsinki.fi/~koskenni/doc/Two-LevelMorphology.pdf">
//! Two-level Morphology:
//! A General Computational Model for Word-Form Recognition and Production</a>,
//! University of Helsinki.
#endif
