/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class TreeBasedTableTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testCellSetToString_ordered() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testCellSetToString_ordered();
}

public void testClear() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testClear();
}

public void testColumn() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumn();
}

public void testColumnComparator() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnComparator();
}

public void testColumnKeySet_empty() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnKeySet_empty();
}

public void testColumnKeySet_isSorted() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnKeySet_isSorted();
}

public void testColumnKeySet_isSortedWithRealComparator() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnKeySet_isSortedWithRealComparator();
}

public void testColumnKeySet_oneColumn() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnKeySet_oneColumn();
}

public void testColumnKeySet_oneEntry() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnKeySet_oneEntry();
}

public void testColumnKeySet_oneRow() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnKeySet_oneRow();
}

public void testColumnNull() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnNull();
}

public void testColumnSetPartialOverlap() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testColumnSetPartialOverlap();
}

public void testContains() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testContains();
}

public void testContainsColumn() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testContainsColumn();
}

public void testContainsRow() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testContainsRow();
}

public void testContainsValue() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testContainsValue();
}

public void testCreateCopy() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testCreateCopy();
}

public void testCreateExplicitComparators() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testCreateExplicitComparators();
}

public void testEquals() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testEquals();
}

public void testGet() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testGet();
}

public void testHashCode() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testHashCode();
}

public void testIsEmpty() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testIsEmpty();
}

public void testPut() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testPut();
}

public void testPutAllTable() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testPutAllTable();
}

public void testPutNull() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testPutNull();
}

public void testPutNullReplace() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testPutNullReplace();
}

public void testRemove() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRemove();
}

public void testRow() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRow();
}

public void testRowClearAndPut() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowClearAndPut();
}

public void testRowComparator() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowComparator();
}

public void testRowEntrySetContains() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowEntrySetContains();
}

public void testRowEntrySetRemove() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowEntrySetRemove();
}

public void testRowKeyMapHeadMap() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeyMapHeadMap();
}

public void testRowKeyMapSubMap() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeyMapSubMap();
}

public void testRowKeyMapTailMap() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeyMapTailMap();
}

public void testRowKeySetComparator() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeySetComparator();
}

public void testRowKeySetFirst() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeySetFirst();
}

public void testRowKeySetHeadSet() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeySetHeadSet();
}

public void testRowKeySetLast() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeySetLast();
}

public void testRowKeySetSubSet() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeySetSubSet();
}

public void testRowKeySetTailSet() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeySetTailSet();
}

public void testRowKeySetToString_ordered() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowKeySetToString_ordered();
}

public void testRowMapComparator() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowMapComparator();
}

public void testRowMapFirstKey() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowMapFirstKey();
}

public void testRowMapLastKey() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowMapLastKey();
}

public void testRowMapValuesAreSorted() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowMapValuesAreSorted();
}

public void testRowNull() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowNull();
}

public void testRowSize() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testRowSize();
}

public void testSize() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testSize();
}

public void testSubRowClearAndPut() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testSubRowClearAndPut();
}

public void testToStringSize1() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testToStringSize1();
}

public void testToString_ordered() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testToString_ordered();
}

public void testValuesToString_ordered() throws Exception {
  com.google.common.collect.TreeBasedTableTest testCase = new com.google.common.collect.TreeBasedTableTest();
  testCase.setUp();
  testCase.testValuesToString_ordered();
}

public void testClear__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testClear();
}

public void testClearSubMapOfRowMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testClearSubMapOfRowMap();
}

public void testContainsKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testContainsKey();
}

public void testContainsValue__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testContainsValue();
}

public void testEntrySet__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testGetNull();
}

public void testHashCode__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testSize();
}

public void testTailMapClearThrough__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testTailMapWriteThrough();
}

public void testValues__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValues();
}

public void testValuesClear__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeRowTest() throws Exception {
  com.google.common.collect.TreeBasedTableTest.TreeRowTest testCase = new com.google.common.collect.TreeBasedTableTest.TreeRowTest();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
