/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013,2014, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS sparc64_hpc_ace_double kernel generator.
 */
#include "gmxpre.h"

#include "config.h"

#include <math.h>

#include "../nb_kernel.h"
#include "gromacs/legacyheaders/types/simple.h"
#include "gromacs/math/vec.h"
#include "gromacs/legacyheaders/nrnb.h"

#include "kernelutil_sparc64_hpc_ace_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSh_VdwNone_GeomW3W3_VF_sparc64_hpc_ace_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecEwSh_VdwNone_GeomW3W3_VF_sparc64_hpc_ace_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with double precision SIMD, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    _fjsp_v2r8       tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    _fjsp_v2r8       ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    _fjsp_v2r8       ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    _fjsp_v2r8       ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B;
    _fjsp_v2r8       jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    _fjsp_v2r8       jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    _fjsp_v2r8       jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    _fjsp_v2r8       dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    _fjsp_v2r8       dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    _fjsp_v2r8       dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    _fjsp_v2r8       dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    _fjsp_v2r8       dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    _fjsp_v2r8       dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    _fjsp_v2r8       dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    _fjsp_v2r8       dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    _fjsp_v2r8       dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    _fjsp_v2r8       velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    _fjsp_v2r8       ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    _fjsp_v2r8       itab_tmp;
    _fjsp_v2r8       dummy_mask,cutoff_mask;
    _fjsp_v2r8       one     = gmx_fjsp_set1_v2r8(1.0);
    _fjsp_v2r8       two     = gmx_fjsp_set1_v2r8(2.0);
    union { _fjsp_v2r8 simd; long long int i[2]; } vfconv,gbconv,ewconv;

    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = gmx_fjsp_set1_v2r8(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = gmx_fjsp_set1_v2r8(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = gmx_fjsp_set1_v2r8(fr->ic->tabq_scale);
    ewtabhalfspace   = gmx_fjsp_set1_v2r8(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+0]));
    iq1              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+1]));
    iq2              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+2]));

    jq0              = gmx_fjsp_set1_v2r8(charge[inr+0]);
    jq1              = gmx_fjsp_set1_v2r8(charge[inr+1]);
    jq2              = gmx_fjsp_set1_v2r8(charge[inr+2]);
    qq00             = _fjsp_mul_v2r8(iq0,jq0);
    qq01             = _fjsp_mul_v2r8(iq0,jq1);
    qq02             = _fjsp_mul_v2r8(iq0,jq2);
    qq10             = _fjsp_mul_v2r8(iq1,jq0);
    qq11             = _fjsp_mul_v2r8(iq1,jq1);
    qq12             = _fjsp_mul_v2r8(iq1,jq2);
    qq20             = _fjsp_mul_v2r8(iq2,jq0);
    qq21             = _fjsp_mul_v2r8(iq2,jq1);
    qq22             = _fjsp_mul_v2r8(iq2,jq2);

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = gmx_fjsp_set1_v2r8(rcutoff_scalar);
    rcutoff2         = _fjsp_mul_v2r8(rcutoff,rcutoff);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_fjsp_load_shift_and_3rvec_broadcast_v2r8(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _fjsp_setzero_v2r8();
        fiy0             = _fjsp_setzero_v2r8();
        fiz0             = _fjsp_setzero_v2r8();
        fix1             = _fjsp_setzero_v2r8();
        fiy1             = _fjsp_setzero_v2r8();
        fiz1             = _fjsp_setzero_v2r8();
        fix2             = _fjsp_setzero_v2r8();
        fiy2             = _fjsp_setzero_v2r8();
        fiz2             = _fjsp_setzero_v2r8();

        /* Reset potential sums */
        velecsum         = _fjsp_setzero_v2r8();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_fjsp_load_3rvec_2ptr_swizzle_v2r8(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx01             = _fjsp_sub_v2r8(ix0,jx1);
            dy01             = _fjsp_sub_v2r8(iy0,jy1);
            dz01             = _fjsp_sub_v2r8(iz0,jz1);
            dx02             = _fjsp_sub_v2r8(ix0,jx2);
            dy02             = _fjsp_sub_v2r8(iy0,jy2);
            dz02             = _fjsp_sub_v2r8(iz0,jz2);
            dx10             = _fjsp_sub_v2r8(ix1,jx0);
            dy10             = _fjsp_sub_v2r8(iy1,jy0);
            dz10             = _fjsp_sub_v2r8(iz1,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx20             = _fjsp_sub_v2r8(ix2,jx0);
            dy20             = _fjsp_sub_v2r8(iy2,jy0);
            dz20             = _fjsp_sub_v2r8(iz2,jz0);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq01            = gmx_fjsp_calc_rsq_v2r8(dx01,dy01,dz01);
            rsq02            = gmx_fjsp_calc_rsq_v2r8(dx02,dy02,dz02);
            rsq10            = gmx_fjsp_calc_rsq_v2r8(dx10,dy10,dz10);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq20            = gmx_fjsp_calc_rsq_v2r8(dx20,dy20,dz20);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);

            rinv00           = gmx_fjsp_invsqrt_v2r8(rsq00);
            rinv01           = gmx_fjsp_invsqrt_v2r8(rsq01);
            rinv02           = gmx_fjsp_invsqrt_v2r8(rsq02);
            rinv10           = gmx_fjsp_invsqrt_v2r8(rsq10);
            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv20           = gmx_fjsp_invsqrt_v2r8(rsq20);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);

            rinvsq00         = _fjsp_mul_v2r8(rinv00,rinv00);
            rinvsq01         = _fjsp_mul_v2r8(rinv01,rinv01);
            rinvsq02         = _fjsp_mul_v2r8(rinv02,rinv02);
            rinvsq10         = _fjsp_mul_v2r8(rinv10,rinv10);
            rinvsq11         = _fjsp_mul_v2r8(rinv11,rinv11);
            rinvsq12         = _fjsp_mul_v2r8(rinv12,rinv12);
            rinvsq20         = _fjsp_mul_v2r8(rinv20,rinv20);
            rinvsq21         = _fjsp_mul_v2r8(rinv21,rinv21);
            rinvsq22         = _fjsp_mul_v2r8(rinv22,rinv22);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq00,rcutoff2))
            {

            r00              = _fjsp_mul_v2r8(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r00,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq00,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv00,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq00,rinv00),_fjsp_sub_v2r8(rinvsq00,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq00,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq01,rcutoff2))
            {

            r01              = _fjsp_mul_v2r8(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r01,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq01,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv01,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq01,rinv01),_fjsp_sub_v2r8(rinvsq01,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq01,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx01,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy01,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz01,fscal,fiz0);
            
            fjx1             = _fjsp_madd_v2r8(dx01,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy01,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz01,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq02,rcutoff2))
            {

            r02              = _fjsp_mul_v2r8(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r02,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq02,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv02,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq02,rinv02),_fjsp_sub_v2r8(rinvsq02,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq02,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx02,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy02,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz02,fscal,fiz0);
            
            fjx2             = _fjsp_madd_v2r8(dx02,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy02,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz02,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq10,rcutoff2))
            {

            r10              = _fjsp_mul_v2r8(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r10,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq10,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv10,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq10,rinv10),_fjsp_sub_v2r8(rinvsq10,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq10,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx10,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy10,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz10,fscal,fiz1);
            
            fjx0             = _fjsp_madd_v2r8(dx10,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy10,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz10,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq11,rcutoff2))
            {

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r11,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq11,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv11,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,rinv11),_fjsp_sub_v2r8(rinvsq11,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq11,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq12,rcutoff2))
            {

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r12,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq12,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv12,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,rinv12),_fjsp_sub_v2r8(rinvsq12,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq12,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq20,rcutoff2))
            {

            r20              = _fjsp_mul_v2r8(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r20,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq20,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv20,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq20,rinv20),_fjsp_sub_v2r8(rinvsq20,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq20,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx20,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy20,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz20,fscal,fiz2);
            
            fjx0             = _fjsp_madd_v2r8(dx20,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy20,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz20,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq21,rcutoff2))
            {

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r21,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq21,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv21,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,rinv21),_fjsp_sub_v2r8(rinvsq21,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq21,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq22,rcutoff2))
            {

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r22,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq22,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv22,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,rinv22),_fjsp_sub_v2r8(rinvsq22,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq22,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            }

            gmx_fjsp_decrement_3rvec_2ptr_swizzle_v2r8(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 441 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_fjsp_load_3rvec_1ptr_swizzle_v2r8(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx01             = _fjsp_sub_v2r8(ix0,jx1);
            dy01             = _fjsp_sub_v2r8(iy0,jy1);
            dz01             = _fjsp_sub_v2r8(iz0,jz1);
            dx02             = _fjsp_sub_v2r8(ix0,jx2);
            dy02             = _fjsp_sub_v2r8(iy0,jy2);
            dz02             = _fjsp_sub_v2r8(iz0,jz2);
            dx10             = _fjsp_sub_v2r8(ix1,jx0);
            dy10             = _fjsp_sub_v2r8(iy1,jy0);
            dz10             = _fjsp_sub_v2r8(iz1,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx20             = _fjsp_sub_v2r8(ix2,jx0);
            dy20             = _fjsp_sub_v2r8(iy2,jy0);
            dz20             = _fjsp_sub_v2r8(iz2,jz0);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq01            = gmx_fjsp_calc_rsq_v2r8(dx01,dy01,dz01);
            rsq02            = gmx_fjsp_calc_rsq_v2r8(dx02,dy02,dz02);
            rsq10            = gmx_fjsp_calc_rsq_v2r8(dx10,dy10,dz10);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq20            = gmx_fjsp_calc_rsq_v2r8(dx20,dy20,dz20);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);

            rinv00           = gmx_fjsp_invsqrt_v2r8(rsq00);
            rinv01           = gmx_fjsp_invsqrt_v2r8(rsq01);
            rinv02           = gmx_fjsp_invsqrt_v2r8(rsq02);
            rinv10           = gmx_fjsp_invsqrt_v2r8(rsq10);
            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv20           = gmx_fjsp_invsqrt_v2r8(rsq20);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);

            rinvsq00         = _fjsp_mul_v2r8(rinv00,rinv00);
            rinvsq01         = _fjsp_mul_v2r8(rinv01,rinv01);
            rinvsq02         = _fjsp_mul_v2r8(rinv02,rinv02);
            rinvsq10         = _fjsp_mul_v2r8(rinv10,rinv10);
            rinvsq11         = _fjsp_mul_v2r8(rinv11,rinv11);
            rinvsq12         = _fjsp_mul_v2r8(rinv12,rinv12);
            rinvsq20         = _fjsp_mul_v2r8(rinv20,rinv20);
            rinvsq21         = _fjsp_mul_v2r8(rinv21,rinv21);
            rinvsq22         = _fjsp_mul_v2r8(rinv22,rinv22);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq00,rcutoff2))
            {

            r00              = _fjsp_mul_v2r8(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r00,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq00,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv00,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq00,rinv00),_fjsp_sub_v2r8(rinvsq00,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq00,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq01,rcutoff2))
            {

            r01              = _fjsp_mul_v2r8(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r01,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq01,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv01,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq01,rinv01),_fjsp_sub_v2r8(rinvsq01,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq01,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx01,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy01,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz01,fscal,fiz0);
            
            fjx1             = _fjsp_madd_v2r8(dx01,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy01,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz01,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq02,rcutoff2))
            {

            r02              = _fjsp_mul_v2r8(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r02,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq02,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv02,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq02,rinv02),_fjsp_sub_v2r8(rinvsq02,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq02,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx02,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy02,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz02,fscal,fiz0);
            
            fjx2             = _fjsp_madd_v2r8(dx02,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy02,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz02,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq10,rcutoff2))
            {

            r10              = _fjsp_mul_v2r8(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r10,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq10,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv10,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq10,rinv10),_fjsp_sub_v2r8(rinvsq10,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq10,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx10,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy10,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz10,fscal,fiz1);
            
            fjx0             = _fjsp_madd_v2r8(dx10,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy10,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz10,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq11,rcutoff2))
            {

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r11,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq11,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv11,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,rinv11),_fjsp_sub_v2r8(rinvsq11,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq11,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq12,rcutoff2))
            {

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r12,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq12,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv12,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,rinv12),_fjsp_sub_v2r8(rinvsq12,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq12,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq20,rcutoff2))
            {

            r20              = _fjsp_mul_v2r8(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r20,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq20,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv20,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq20,rinv20),_fjsp_sub_v2r8(rinvsq20,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq20,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx20,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy20,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz20,fscal,fiz2);
            
            fjx0             = _fjsp_madd_v2r8(dx20,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy20,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz20,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq21,rcutoff2))
            {

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r21,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq21,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv21,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,rinv21),_fjsp_sub_v2r8(rinvsq21,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq21,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq22,rcutoff2))
            {

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r22,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            ewtabF           = _fjsp_load_v2r8( ewtab + 4*ewconv.i[0] );
            ewtabD           = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabF,ewtabD);
            ewtabV           = _fjsp_loadl_v2r8(_fjsp_setzero_v2r8(), ewtab + 4*ewconv.i[0] +2);
            ewtabFn          = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(ewtabV,ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabD,ewtabF);
            velec            = _fjsp_nmsub_v2r8(_fjsp_mul_v2r8(ewtabhalfspace,eweps) ,_fjsp_add_v2r8(ewtabF,felec), ewtabV);
            velec            = _fjsp_mul_v2r8(qq22,_fjsp_sub_v2r8(_fjsp_sub_v2r8(rinv22,sh_ewald),velec));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,rinv22),_fjsp_sub_v2r8(rinvsq22,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq22,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_and_v2r8(velec,cutoff_mask);
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            }

            gmx_fjsp_decrement_3rvec_1ptr_swizzle_v2r8(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 441 flops */
        }

        /* End of innermost loop */

        gmx_fjsp_update_iforce_3atom_swizzle_v2r8(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_fjsp_update_1pot_v2r8(velecsum,kernel_data->energygrp_elec+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 19 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W3W3_VF,outeriter*19 + inneriter*441);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSh_VdwNone_GeomW3W3_F_sparc64_hpc_ace_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water3-Water3
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecEwSh_VdwNone_GeomW3W3_F_sparc64_hpc_ace_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with double precision SIMD, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    _fjsp_v2r8       tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    _fjsp_v2r8       ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    _fjsp_v2r8       ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    _fjsp_v2r8       ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwjidx0A,vdwjidx0B;
    _fjsp_v2r8       jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    _fjsp_v2r8       jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    _fjsp_v2r8       jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    _fjsp_v2r8       dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    _fjsp_v2r8       dx01,dy01,dz01,rsq01,rinv01,rinvsq01,r01,qq01,c6_01,c12_01;
    _fjsp_v2r8       dx02,dy02,dz02,rsq02,rinv02,rinvsq02,r02,qq02,c6_02,c12_02;
    _fjsp_v2r8       dx10,dy10,dz10,rsq10,rinv10,rinvsq10,r10,qq10,c6_10,c12_10;
    _fjsp_v2r8       dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    _fjsp_v2r8       dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    _fjsp_v2r8       dx20,dy20,dz20,rsq20,rinv20,rinvsq20,r20,qq20,c6_20,c12_20;
    _fjsp_v2r8       dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    _fjsp_v2r8       dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    _fjsp_v2r8       velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    _fjsp_v2r8       ewtabscale,eweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    _fjsp_v2r8       itab_tmp;
    _fjsp_v2r8       dummy_mask,cutoff_mask;
    _fjsp_v2r8       one     = gmx_fjsp_set1_v2r8(1.0);
    _fjsp_v2r8       two     = gmx_fjsp_set1_v2r8(2.0);
    union { _fjsp_v2r8 simd; long long int i[2]; } vfconv,gbconv,ewconv;

    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = gmx_fjsp_set1_v2r8(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = gmx_fjsp_set1_v2r8(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_F;
    ewtabscale       = gmx_fjsp_set1_v2r8(fr->ic->tabq_scale);
    ewtabhalfspace   = gmx_fjsp_set1_v2r8(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq0              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+0]));
    iq1              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+1]));
    iq2              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+2]));

    jq0              = gmx_fjsp_set1_v2r8(charge[inr+0]);
    jq1              = gmx_fjsp_set1_v2r8(charge[inr+1]);
    jq2              = gmx_fjsp_set1_v2r8(charge[inr+2]);
    qq00             = _fjsp_mul_v2r8(iq0,jq0);
    qq01             = _fjsp_mul_v2r8(iq0,jq1);
    qq02             = _fjsp_mul_v2r8(iq0,jq2);
    qq10             = _fjsp_mul_v2r8(iq1,jq0);
    qq11             = _fjsp_mul_v2r8(iq1,jq1);
    qq12             = _fjsp_mul_v2r8(iq1,jq2);
    qq20             = _fjsp_mul_v2r8(iq2,jq0);
    qq21             = _fjsp_mul_v2r8(iq2,jq1);
    qq22             = _fjsp_mul_v2r8(iq2,jq2);

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = gmx_fjsp_set1_v2r8(rcutoff_scalar);
    rcutoff2         = _fjsp_mul_v2r8(rcutoff,rcutoff);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_fjsp_load_shift_and_3rvec_broadcast_v2r8(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2);

        fix0             = _fjsp_setzero_v2r8();
        fiy0             = _fjsp_setzero_v2r8();
        fiz0             = _fjsp_setzero_v2r8();
        fix1             = _fjsp_setzero_v2r8();
        fiy1             = _fjsp_setzero_v2r8();
        fiz1             = _fjsp_setzero_v2r8();
        fix2             = _fjsp_setzero_v2r8();
        fiy2             = _fjsp_setzero_v2r8();
        fiz2             = _fjsp_setzero_v2r8();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_fjsp_load_3rvec_2ptr_swizzle_v2r8(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx01             = _fjsp_sub_v2r8(ix0,jx1);
            dy01             = _fjsp_sub_v2r8(iy0,jy1);
            dz01             = _fjsp_sub_v2r8(iz0,jz1);
            dx02             = _fjsp_sub_v2r8(ix0,jx2);
            dy02             = _fjsp_sub_v2r8(iy0,jy2);
            dz02             = _fjsp_sub_v2r8(iz0,jz2);
            dx10             = _fjsp_sub_v2r8(ix1,jx0);
            dy10             = _fjsp_sub_v2r8(iy1,jy0);
            dz10             = _fjsp_sub_v2r8(iz1,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx20             = _fjsp_sub_v2r8(ix2,jx0);
            dy20             = _fjsp_sub_v2r8(iy2,jy0);
            dz20             = _fjsp_sub_v2r8(iz2,jz0);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq01            = gmx_fjsp_calc_rsq_v2r8(dx01,dy01,dz01);
            rsq02            = gmx_fjsp_calc_rsq_v2r8(dx02,dy02,dz02);
            rsq10            = gmx_fjsp_calc_rsq_v2r8(dx10,dy10,dz10);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq20            = gmx_fjsp_calc_rsq_v2r8(dx20,dy20,dz20);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);

            rinv00           = gmx_fjsp_invsqrt_v2r8(rsq00);
            rinv01           = gmx_fjsp_invsqrt_v2r8(rsq01);
            rinv02           = gmx_fjsp_invsqrt_v2r8(rsq02);
            rinv10           = gmx_fjsp_invsqrt_v2r8(rsq10);
            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv20           = gmx_fjsp_invsqrt_v2r8(rsq20);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);

            rinvsq00         = _fjsp_mul_v2r8(rinv00,rinv00);
            rinvsq01         = _fjsp_mul_v2r8(rinv01,rinv01);
            rinvsq02         = _fjsp_mul_v2r8(rinv02,rinv02);
            rinvsq10         = _fjsp_mul_v2r8(rinv10,rinv10);
            rinvsq11         = _fjsp_mul_v2r8(rinv11,rinv11);
            rinvsq12         = _fjsp_mul_v2r8(rinv12,rinv12);
            rinvsq20         = _fjsp_mul_v2r8(rinv20,rinv20);
            rinvsq21         = _fjsp_mul_v2r8(rinv21,rinv21);
            rinvsq22         = _fjsp_mul_v2r8(rinv22,rinv22);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq00,rcutoff2))
            {

            r00              = _fjsp_mul_v2r8(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r00,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq00,rinv00),_fjsp_sub_v2r8(rinvsq00,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq00,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq01,rcutoff2))
            {

            r01              = _fjsp_mul_v2r8(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r01,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq01,rinv01),_fjsp_sub_v2r8(rinvsq01,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq01,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx01,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy01,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz01,fscal,fiz0);
            
            fjx1             = _fjsp_madd_v2r8(dx01,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy01,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz01,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq02,rcutoff2))
            {

            r02              = _fjsp_mul_v2r8(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r02,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq02,rinv02),_fjsp_sub_v2r8(rinvsq02,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq02,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx02,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy02,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz02,fscal,fiz0);
            
            fjx2             = _fjsp_madd_v2r8(dx02,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy02,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz02,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq10,rcutoff2))
            {

            r10              = _fjsp_mul_v2r8(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r10,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq10,rinv10),_fjsp_sub_v2r8(rinvsq10,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq10,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx10,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy10,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz10,fscal,fiz1);
            
            fjx0             = _fjsp_madd_v2r8(dx10,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy10,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz10,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq11,rcutoff2))
            {

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r11,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,rinv11),_fjsp_sub_v2r8(rinvsq11,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq11,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq12,rcutoff2))
            {

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r12,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,rinv12),_fjsp_sub_v2r8(rinvsq12,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq12,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq20,rcutoff2))
            {

            r20              = _fjsp_mul_v2r8(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r20,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq20,rinv20),_fjsp_sub_v2r8(rinvsq20,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq20,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx20,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy20,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz20,fscal,fiz2);
            
            fjx0             = _fjsp_madd_v2r8(dx20,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy20,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz20,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq21,rcutoff2))
            {

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r21,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,rinv21),_fjsp_sub_v2r8(rinvsq21,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq21,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq22,rcutoff2))
            {

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r22,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_2pair_swizzle_v2r8(ewtab+ewconv.i[0],ewtab+ewconv.i[1],
                                         &ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,rinv22),_fjsp_sub_v2r8(rinvsq22,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq22,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            }

            gmx_fjsp_decrement_3rvec_2ptr_swizzle_v2r8(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 378 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_fjsp_load_3rvec_1ptr_swizzle_v2r8(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,&jy2,&jz2);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx01             = _fjsp_sub_v2r8(ix0,jx1);
            dy01             = _fjsp_sub_v2r8(iy0,jy1);
            dz01             = _fjsp_sub_v2r8(iz0,jz1);
            dx02             = _fjsp_sub_v2r8(ix0,jx2);
            dy02             = _fjsp_sub_v2r8(iy0,jy2);
            dz02             = _fjsp_sub_v2r8(iz0,jz2);
            dx10             = _fjsp_sub_v2r8(ix1,jx0);
            dy10             = _fjsp_sub_v2r8(iy1,jy0);
            dz10             = _fjsp_sub_v2r8(iz1,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx20             = _fjsp_sub_v2r8(ix2,jx0);
            dy20             = _fjsp_sub_v2r8(iy2,jy0);
            dz20             = _fjsp_sub_v2r8(iz2,jz0);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq01            = gmx_fjsp_calc_rsq_v2r8(dx01,dy01,dz01);
            rsq02            = gmx_fjsp_calc_rsq_v2r8(dx02,dy02,dz02);
            rsq10            = gmx_fjsp_calc_rsq_v2r8(dx10,dy10,dz10);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq20            = gmx_fjsp_calc_rsq_v2r8(dx20,dy20,dz20);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);

            rinv00           = gmx_fjsp_invsqrt_v2r8(rsq00);
            rinv01           = gmx_fjsp_invsqrt_v2r8(rsq01);
            rinv02           = gmx_fjsp_invsqrt_v2r8(rsq02);
            rinv10           = gmx_fjsp_invsqrt_v2r8(rsq10);
            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv20           = gmx_fjsp_invsqrt_v2r8(rsq20);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);

            rinvsq00         = _fjsp_mul_v2r8(rinv00,rinv00);
            rinvsq01         = _fjsp_mul_v2r8(rinv01,rinv01);
            rinvsq02         = _fjsp_mul_v2r8(rinv02,rinv02);
            rinvsq10         = _fjsp_mul_v2r8(rinv10,rinv10);
            rinvsq11         = _fjsp_mul_v2r8(rinv11,rinv11);
            rinvsq12         = _fjsp_mul_v2r8(rinv12,rinv12);
            rinvsq20         = _fjsp_mul_v2r8(rinv20,rinv20);
            rinvsq21         = _fjsp_mul_v2r8(rinv21,rinv21);
            rinvsq22         = _fjsp_mul_v2r8(rinv22,rinv22);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq00,rcutoff2))
            {

            r00              = _fjsp_mul_v2r8(rsq00,rinv00);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r00,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq00,rinv00),_fjsp_sub_v2r8(rinvsq00,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq00,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq01,rcutoff2))
            {

            r01              = _fjsp_mul_v2r8(rsq01,rinv01);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r01,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq01,rinv01),_fjsp_sub_v2r8(rinvsq01,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq01,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx01,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy01,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz01,fscal,fiz0);
            
            fjx1             = _fjsp_madd_v2r8(dx01,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy01,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz01,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq02,rcutoff2))
            {

            r02              = _fjsp_mul_v2r8(rsq02,rinv02);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r02,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq02,rinv02),_fjsp_sub_v2r8(rinvsq02,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq02,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx02,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy02,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz02,fscal,fiz0);
            
            fjx2             = _fjsp_madd_v2r8(dx02,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy02,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz02,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq10,rcutoff2))
            {

            r10              = _fjsp_mul_v2r8(rsq10,rinv10);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r10,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq10,rinv10),_fjsp_sub_v2r8(rinvsq10,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq10,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx10,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy10,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz10,fscal,fiz1);
            
            fjx0             = _fjsp_madd_v2r8(dx10,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy10,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz10,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq11,rcutoff2))
            {

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r11,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,rinv11),_fjsp_sub_v2r8(rinvsq11,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq11,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq12,rcutoff2))
            {

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r12,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,rinv12),_fjsp_sub_v2r8(rinvsq12,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq12,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq20,rcutoff2))
            {

            r20              = _fjsp_mul_v2r8(rsq20,rinv20);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r20,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq20,rinv20),_fjsp_sub_v2r8(rinvsq20,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq20,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx20,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy20,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz20,fscal,fiz2);
            
            fjx0             = _fjsp_madd_v2r8(dx20,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy20,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz20,fscal,fjz0);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq21,rcutoff2))
            {

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r21,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,rinv21),_fjsp_sub_v2r8(rinvsq21,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq21,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_fjsp_any_lt_v2r8(rsq22,rcutoff2))
            {

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _fjsp_mul_v2r8(r22,ewtabscale);
            itab_tmp         = _fjsp_dtox_v2r8(ewrt);
            eweps            = _fjsp_sub_v2r8(ewrt,_fjsp_xtod_v2r8(itab_tmp));
	    _fjsp_store_v2r8(&ewconv.simd,itab_tmp);

            gmx_fjsp_load_1pair_swizzle_v2r8(ewtab+ewconv.i[0],&ewtabF,&ewtabFn);
            felec            = _fjsp_madd_v2r8(eweps,ewtabFn,_fjsp_nmsub_v2r8(eweps,ewtabF,ewtabF));
            felec            = _fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,rinv22),_fjsp_sub_v2r8(rinvsq22,felec));

            cutoff_mask      = _fjsp_cmplt_v2r8(rsq22,rcutoff2);

            fscal            = felec;

            fscal            = _fjsp_and_v2r8(fscal,cutoff_mask);

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            }

            gmx_fjsp_decrement_3rvec_1ptr_swizzle_v2r8(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2);

            /* Inner loop uses 378 flops */
        }

        /* End of innermost loop */

        gmx_fjsp_update_iforce_3atom_swizzle_v2r8(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,
                                              f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W3W3_F,outeriter*18 + inneriter*378);
}
