/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 1991-2000, University of Groningen, The Netherlands.
 * Copyright (c) 2001-2004, The GROMACS development team,
 * check out http://www.gromacs.org for more information.
 * Copyright (c) 2012,2013, by the GROMACS development team, led by
 * David van der Spoel, Berk Hess, Erik Lindahl, and including many
 * others, as listed in the AUTHORS file in the top-level source
 * directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/* This file is completely threadsafe - keep it that way! */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* just put something here to avoid empty file warnings */
const int crecipdata_stub;

#ifdef SOFTWARE_RECIP
const unsigned int crecipexptab[256] = {
    0x7e800000, 0x7e000000, 0x7d800000, 0x7d000000, 0x7c800000, 0x7c000000, 0x7b800000, 0x7b000000,
    0x7a800000, 0x7a000000, 0x79800000, 0x79000000, 0x78800000, 0x78000000, 0x77800000, 0x77000000,
    0x76800000, 0x76000000, 0x75800000, 0x75000000, 0x74800000, 0x74000000, 0x73800000, 0x73000000,
    0x72800000, 0x72000000, 0x71800000, 0x71000000, 0x70800000, 0x70000000, 0x6f800000, 0x6f000000,
    0x6e800000, 0x6e000000, 0x6d800000, 0x6d000000, 0x6c800000, 0x6c000000, 0x6b800000, 0x6b000000,
    0x6a800000, 0x6a000000, 0x69800000, 0x69000000, 0x68800000, 0x68000000, 0x67800000, 0x67000000,
    0x66800000, 0x66000000, 0x65800000, 0x65000000, 0x64800000, 0x64000000, 0x63800000, 0x63000000,
    0x62800000, 0x62000000, 0x61800000, 0x61000000, 0x60800000, 0x60000000, 0x5f800000, 0x5f000000,
    0x5e800000, 0x5e000000, 0x5d800000, 0x5d000000, 0x5c800000, 0x5c000000, 0x5b800000, 0x5b000000,
    0x5a800000, 0x5a000000, 0x59800000, 0x59000000, 0x58800000, 0x58000000, 0x57800000, 0x57000000,
    0x56800000, 0x56000000, 0x55800000, 0x55000000, 0x54800000, 0x54000000, 0x53800000, 0x53000000,
    0x52800000, 0x52000000, 0x51800000, 0x51000000, 0x50800000, 0x50000000, 0x4f800000, 0x4f000000,
    0x4e800000, 0x4e000000, 0x4d800000, 0x4d000000, 0x4c800000, 0x4c000000, 0x4b800000, 0x4b000000,
    0x4a800000, 0x4a000000, 0x49800000, 0x49000000, 0x48800000, 0x48000000, 0x47800000, 0x47000000,
    0x46800000, 0x46000000, 0x45800000, 0x45000000, 0x44800000, 0x44000000, 0x43800000, 0x43000000,
    0x42800000, 0x42000000, 0x41800000, 0x41000000, 0x40800000, 0x40000000, 0x3f800000, 0x3f000000,
    0x3e800000, 0x3e000000, 0x3d800000, 0x3d000000, 0x3c800000, 0x3c000000, 0x3b800000, 0x3b000000,
    0x3a800000, 0x3a000000, 0x39800000, 0x39000000, 0x38800000, 0x38000000, 0x37800000, 0x37000000,
    0x36800000, 0x36000000, 0x35800000, 0x35000000, 0x34800000, 0x34000000, 0x33800000, 0x33000000,
    0x32800000, 0x32000000, 0x31800000, 0x31000000, 0x30800000, 0x30000000, 0x2f800000, 0x2f000000,
    0x2e800000, 0x2e000000, 0x2d800000, 0x2d000000, 0x2c800000, 0x2c000000, 0x2b800000, 0x2b000000,
    0x2a800000, 0x2a000000, 0x29800000, 0x29000000, 0x28800000, 0x28000000, 0x27800000, 0x27000000,
    0x26800000, 0x26000000, 0x25800000, 0x25000000, 0x24800000, 0x24000000, 0x23800000, 0x23000000,
    0x22800000, 0x22000000, 0x21800000, 0x21000000, 0x20800000, 0x20000000, 0x1f800000, 0x1f000000,
    0x1e800000, 0x1e000000, 0x1d800000, 0x1d000000, 0x1c800000, 0x1c000000, 0x1b800000, 0x1b000000,
    0x1a800000, 0x1a000000, 0x19800000, 0x19000000, 0x18800000, 0x18000000, 0x17800000, 0x17000000,
    0x16800000, 0x16000000, 0x15800000, 0x15000000, 0x14800000, 0x14000000, 0x13800000, 0x13000000,
    0x12800000, 0x12000000, 0x11800000, 0x11000000, 0x10800000, 0x10000000, 0xf800000, 0xf000000,
    0xe800000, 0xe000000, 0xd800000, 0xd000000, 0xc800000, 0xc000000, 0xb800000, 0xb000000,
    0xa800000, 0xa000000, 0x9800000, 0x9000000, 0x8800000, 0x8000000, 0x7800000, 0x7000000,
    0x6800000, 0x6000000, 0x5800000, 0x5000000, 0x4800000, 0x4000000, 0x3800000, 0x3000000,
    0x2800000, 0x2000000, 0x1800000, 0x1000000, 0x800000, 0x0, 0x7f800000, 0x7f000000
};

const unsigned int crecipfracttab[4096] = {
    0x7fffff, 0x7fe004, 0x7fc010, 0x7fa024, 0x7f8040, 0x7f6064, 0x7f4090, 0x7f20c3,
    0x7f00ff, 0x7ee143, 0x7ec18e, 0x7ea1e1, 0x7e823d, 0x7e62a0, 0x7e430b, 0x7e237d,
    0x7e03f8, 0x7de47a, 0x7dc505, 0x7da597, 0x7d8631, 0x7d66d2, 0x7d477b, 0x7d282d,
    0x7d08e5, 0x7ce9a6, 0x7cca6e, 0x7cab3e, 0x7c8c16, 0x7c6cf5, 0x7c4ddc, 0x7c2ecb,
    0x7c0fc1, 0x7bf0bf, 0x7bd1c4, 0x7bb2d2, 0x7b93e6, 0x7b7503, 0x7b5627, 0x7b3752,
    0x7b1885, 0x7af9c0, 0x7adb02, 0x7abc4c, 0x7a9d9d, 0x7a7ef6, 0x7a6056, 0x7a41be,
    0x7a232d, 0x7a04a4, 0x79e622, 0x79c7a7, 0x79a934, 0x798ac9, 0x796c64, 0x794e08,
    0x792fb2, 0x791164, 0x78f31d, 0x78d4de, 0x78b6a6, 0x789876, 0x787a4c, 0x785c2a,
    0x783e10, 0x781ffc, 0x7801f0, 0x77e3eb, 0x77c5ee, 0x77a7f7, 0x778a08, 0x776c20,
    0x774e40, 0x773066, 0x771294, 0x76f4c9, 0x76d705, 0x76b949, 0x769b93, 0x767de5,
    0x76603e, 0x76429e, 0x762505, 0x760773, 0x75e9e8, 0x75cc64, 0x75aee8, 0x759172,
    0x757404, 0x75569c, 0x75393c, 0x751be3, 0x74fe91, 0x74e145, 0x74c401, 0x74a6c4,
    0x74898d, 0x746c5e, 0x744f36, 0x743214, 0x7414fa, 0x73f7e6, 0x73dada, 0x73bdd4,
    0x73a0d5, 0x7383dd, 0x7366ec, 0x734a02, 0x732d1f, 0x731042, 0x72f36d, 0x72d69e,
    0x72b9d6, 0x729d15, 0x72805b, 0x7263a7, 0x7246fb, 0x722a55, 0x720db6, 0x71f11d,
    0x71d48c, 0x71b801, 0x719b7d, 0x717eff, 0x716289, 0x714619, 0x7129af, 0x710d4d,
    0x70f0f1, 0x70d49c, 0x70b84d, 0x709c05, 0x707fc4, 0x706389, 0x704755, 0x702b28,
    0x700f01, 0x6ff2e1, 0x6fd6c7, 0x6fbab4, 0x6f9ea8, 0x6f82a2, 0x6f66a2, 0x6f4aa9,
    0x6f2eb7, 0x6f12cb, 0x6ef6e6, 0x6edb07, 0x6ebf2f, 0x6ea35d, 0x6e8792, 0x6e6bcd,
    0x6e500f, 0x6e3457, 0x6e18a6, 0x6dfcfb, 0x6de156, 0x6dc5b8, 0x6daa20, 0x6d8e8f,
    0x6d7304, 0x6d577f, 0x6d3c01, 0x6d2089, 0x6d0518, 0x6ce9ac, 0x6cce48, 0x6cb2e9,
    0x6c9791, 0x6c7c3f, 0x6c60f4, 0x6c45af, 0x6c2a70, 0x6c0f37, 0x6bf405, 0x6bd8d9,
    0x6bbdb3, 0x6ba293, 0x6b877a, 0x6b6c67, 0x6b515a, 0x6b3653, 0x6b1b52, 0x6b0058,
    0x6ae564, 0x6aca76, 0x6aaf8e, 0x6a94ad, 0x6a79d1, 0x6a5efc, 0x6a442d, 0x6a2964,
    0x6a0ea1, 0x69f3e4, 0x69d92d, 0x69be7d, 0x69a3d2, 0x69892e, 0x696e90, 0x6953f7,
    0x693965, 0x691ed9, 0x690453, 0x68e9d3, 0x68cf59, 0x68b4e5, 0x689a77, 0x68800f,
    0x6865ac, 0x684b50, 0x6830fa, 0x6816aa, 0x67fc60, 0x67e21c, 0x67c7de, 0x67ada5,
    0x679373, 0x677946, 0x675f20, 0x6744ff, 0x672ae4, 0x6710d0, 0x66f6c1, 0x66dcb8,
    0x66c2b4, 0x66a8b7, 0x668ebf, 0x6674ce, 0x665ae2, 0x6640fc, 0x66271c, 0x660d41,
    0x65f36d, 0x65d99e, 0x65bfd5, 0x65a612, 0x658c54, 0x65729d, 0x6558eb, 0x653f3f,
    0x652598, 0x650bf8, 0x64f25d, 0x64d8c7, 0x64bf38, 0x64a5ae, 0x648c2a, 0x6472ac,
    0x645933, 0x643fc0, 0x642652, 0x640ceb, 0x63f389, 0x63da2c, 0x63c0d6, 0x63a784,
    0x638e39, 0x6374f3, 0x635bb3, 0x634278, 0x632943, 0x631014, 0x62f6ea, 0x62ddc5,
    0x62c4a7, 0x62ab8d, 0x62927a, 0x62796c, 0x626063, 0x624760, 0x622e63, 0x62156b,
    0x61fc78, 0x61e38b, 0x61caa4, 0x61b1c2, 0x6198e5, 0x61800e, 0x61673d, 0x614e70,
    0x6135aa, 0x611ce9, 0x61042d, 0x60eb77, 0x60d2c6, 0x60ba1a, 0x60a174, 0x6088d3,
    0x607038, 0x6057a2, 0x603f12, 0x602687, 0x600e01, 0x5ff580, 0x5fdd05, 0x5fc490,
    0x5fac1f, 0x5f93b4, 0x5f7b4f, 0x5f62ee, 0x5f4a93, 0x5f323e, 0x5f19ed, 0x5f01a2,
    0x5ee95c, 0x5ed11c, 0x5eb8e0, 0x5ea0aa, 0x5e887a, 0x5e704e, 0x5e5828, 0x5e4007,
    0x5e27eb, 0x5e0fd5, 0x5df7c3, 0x5ddfb7, 0x5dc7b0, 0x5dafaf, 0x5d97b2, 0x5d7fbb,
    0x5d67c9, 0x5d4fdc, 0x5d37f4, 0x5d2011, 0x5d0834, 0x5cf05b, 0x5cd888, 0x5cc0ba,
    0x5ca8f1, 0x5c912e, 0x5c796f, 0x5c61b5, 0x5c4a01, 0x5c3251, 0x5c1aa7, 0x5c0302,
    0x5beb62, 0x5bd3c7, 0x5bbc31, 0x5ba4a0, 0x5b8d14, 0x5b758d, 0x5b5e0c, 0x5b468f,
    0x5b2f17, 0x5b17a4, 0x5b0037, 0x5ae8ce, 0x5ad16a, 0x5aba0c, 0x5aa2b2, 0x5a8b5d,
    0x5a740e, 0x5a5cc3, 0x5a457d, 0x5a2e3c, 0x5a1700, 0x59ffca, 0x59e898, 0x59d16a,
    0x59ba42, 0x59a31f, 0x598c01, 0x5974e7, 0x595dd3, 0x5946c3, 0x592fb9, 0x5918b3,
    0x5901b2, 0x58eab6, 0x58d3bf, 0x58bccc, 0x58a5df, 0x588ef6, 0x587813, 0x586134,
    0x584a5a, 0x583384, 0x581cb4, 0x5805e8, 0x57ef21, 0x57d85f, 0x57c1a2, 0x57aaea,
    0x579436, 0x577d87, 0x5766dd, 0x575038, 0x573997, 0x5722fb, 0x570c64, 0x56f5d2,
    0x56df44, 0x56c8bb, 0x56b237, 0x569bb7, 0x56853d, 0x566ec7, 0x565855, 0x5641e9,
    0x562b81, 0x56151e, 0x55febf, 0x55e865, 0x55d210, 0x55bbbf, 0x55a573, 0x558f2c,
    0x5578e9, 0x5562ac, 0x554c72, 0x55363d, 0x55200d, 0x5509e2, 0x54f3bb, 0x54dd99,
    0x54c77b, 0x54b162, 0x549b4d, 0x54853e, 0x546f32, 0x54592b, 0x544329, 0x542d2c,
    0x541733, 0x54013e, 0x53eb4e, 0x53d563, 0x53bf7c, 0x53a999, 0x5393bb, 0x537de2,
    0x53680d, 0x53523d, 0x533c71, 0x5326aa, 0x5310e7, 0x52fb28, 0x52e56f, 0x52cfb9,
    0x52ba08, 0x52a45c, 0x528eb4, 0x527910, 0x526371, 0x524dd6, 0x523840, 0x5222ae,
    0x520d21, 0x51f798, 0x51e213, 0x51cc93, 0x51b717, 0x51a1a0, 0x518c2d, 0x5176be,
    0x516154, 0x514bee, 0x51368d, 0x512130, 0x510bd7, 0x50f683, 0x50e133, 0x50cbe7,
    0x50b6a0, 0x50a15d, 0x508c1e, 0x5076e4, 0x5061ae, 0x504c7c, 0x50374f, 0x502226,
    0x500d01, 0x4ff7e0, 0x4fe2c4, 0x4fcdac, 0x4fb899, 0x4fa389, 0x4f8e7e, 0x4f7977,
    0x4f6475, 0x4f4f76, 0x4f3a7c, 0x4f2586, 0x4f1095, 0x4efba7, 0x4ee6be, 0x4ed1d9,
    0x4ebcf9, 0x4ea81c, 0x4e9344, 0x4e7e70, 0x4e69a0, 0x4e54d4, 0x4e400d, 0x4e2b4a,
    0x4e168a, 0x4e01d0, 0x4ded19, 0x4dd866, 0x4dc3b8, 0x4daf0d, 0x4d9a67, 0x4d85c5,
    0x4d7127, 0x4d5c8e, 0x4d47f8, 0x4d3367, 0x4d1ed9, 0x4d0a50, 0x4cf5cb, 0x4ce14a,
    0x4ccccd, 0x4cb854, 0x4ca3df, 0x4c8f6f, 0x4c7b02, 0x4c669a, 0x4c5235, 0x4c3dd5,
    0x4c2978, 0x4c1520, 0x4c00cc, 0x4bec7c, 0x4bd830, 0x4bc3e8, 0x4bafa4, 0x4b9b64,
    0x4b8728, 0x4b72f0, 0x4b5ebc, 0x4b4a8c, 0x4b3660, 0x4b2238, 0x4b0e14, 0x4af9f4,
    0x4ae5d8, 0x4ad1c0, 0x4abdac, 0x4aa99c, 0x4a9590, 0x4a8188, 0x4a6d84, 0x4a5984,
    0x4a4588, 0x4a3190, 0x4a1d9b, 0x4a09ab, 0x49f5bf, 0x49e1d6, 0x49cdf1, 0x49ba11,
    0x49a634, 0x49925b, 0x497e86, 0x496ab5, 0x4956e8, 0x49431f, 0x492f59, 0x491b98,
    0x4907da, 0x48f421, 0x48e06b, 0x48ccb9, 0x48b90b, 0x48a560, 0x4891ba, 0x487e17,
    0x486a79, 0x4856de, 0x484347, 0x482fb3, 0x481c24, 0x480898, 0x47f511, 0x47e18d,
    0x47ce0c, 0x47ba90, 0x47a718, 0x4793a3, 0x478032, 0x476cc5, 0x47595b, 0x4745f6,
    0x473294, 0x471f36, 0x470bdb, 0x46f885, 0x46e532, 0x46d1e3, 0x46be98, 0x46ab50,
    0x46980c, 0x4684cc, 0x467190, 0x465e57, 0x464b22, 0x4637f1, 0x4624c4, 0x46119a,
    0x45fe74, 0x45eb52, 0x45d833, 0x45c518, 0x45b201, 0x459eed, 0x458bdd, 0x4578d1,
    0x4565c8, 0x4552c4, 0x453fc2, 0x452cc5, 0x4519cb, 0x4506d5, 0x44f3e2, 0x44e0f3,
    0x44ce08, 0x44bb20, 0x44a83c, 0x44955b, 0x44827f, 0x446fa5, 0x445cd0, 0x4449fe,
    0x443730, 0x442465, 0x44119e, 0x43feda, 0x43ec1a, 0x43d95e, 0x43c6a5, 0x43b3f0,
    0x43a13e, 0x438e90, 0x437be5, 0x43693e, 0x43569b, 0x4343fb, 0x43315f, 0x431ec6,
    0x430c31, 0x42f99f, 0x42e711, 0x42d486, 0x42c1ff, 0x42af7c, 0x429cfc, 0x428a7f,
    0x427806, 0x426591, 0x42531f, 0x4240b0, 0x422e45, 0x421bde, 0x420979, 0x41f719,
    0x41e4bc, 0x41d262, 0x41c00c, 0x41adb9, 0x419b6a, 0x41891f, 0x4176d6, 0x416491,
    0x415250, 0x414012, 0x412dd8, 0x411ba1, 0x41096d, 0x40f73d, 0x40e510, 0x40d2e7,
    0x40c0c1, 0x40ae9e, 0x409c7f, 0x408a63, 0x40784b, 0x406636, 0x405425, 0x404217,
    0x40300c, 0x401e05, 0x400c01, 0x3ffa00, 0x3fe803, 0x3fd609, 0x3fc413, 0x3fb220,
    0x3fa030, 0x3f8e44, 0x3f7c5b, 0x3f6a75, 0x3f5892, 0x3f46b4, 0x3f34d8, 0x3f2300,
    0x3f112b, 0x3eff59, 0x3eed8b, 0x3edbc0, 0x3ec9f8, 0x3eb833, 0x3ea672, 0x3e94b5,
    0x3e82fa, 0x3e7143, 0x3e5f8f, 0x3e4dde, 0x3e3c31, 0x3e2a87, 0x3e18e0, 0x3e073d,
    0x3df59d, 0x3de400, 0x3dd266, 0x3dc0d0, 0x3daf3c, 0x3d9dac, 0x3d8c20, 0x3d7a96,
    0x3d6910, 0x3d578d, 0x3d460e, 0x3d3491, 0x3d2318, 0x3d11a2, 0x3d002f, 0x3ceec0,
    0x3cdd53, 0x3ccbea, 0x3cba84, 0x3ca922, 0x3c97c2, 0x3c8666, 0x3c750d, 0x3c63b7,
    0x3c5264, 0x3c4114, 0x3c2fc8, 0x3c1e7f, 0x3c0d39, 0x3bfbf6, 0x3beab6, 0x3bd97a,
    0x3bc841, 0x3bb70a, 0x3ba5d7, 0x3b94a7, 0x3b837b, 0x3b7251, 0x3b612b, 0x3b5007,
    0x3b3ee7, 0x3b2dca, 0x3b1cb0, 0x3b0b99, 0x3afa86, 0x3ae975, 0x3ad868, 0x3ac75d,
    0x3ab656, 0x3aa552, 0x3a9451, 0x3a8353, 0x3a7258, 0x3a6160, 0x3a506c, 0x3a3f7a,
    0x3a2e8c, 0x3a1da0, 0x3a0cb8, 0x39fbd3, 0x39eaf0, 0x39da11, 0x39c935, 0x39b85c,
    0x39a786, 0x3996b3, 0x3985e3, 0x397517, 0x39644d, 0x395386, 0x3942c2, 0x393202,
    0x392144, 0x391089, 0x38ffd2, 0x38ef1d, 0x38de6c, 0x38cdbd, 0x38bd11, 0x38ac69,
    0x389bc3, 0x388b21, 0x387a81, 0x3869e5, 0x38594b, 0x3848b5, 0x383821, 0x382791,
    0x381703, 0x380678, 0x37f5f1, 0x37e56c, 0x37d4ea, 0x37c46b, 0x37b3ef, 0x37a377,
    0x379301, 0x37828e, 0x37721e, 0x3761b1, 0x375147, 0x3740df, 0x37307b, 0x37201a,
    0x370fbb, 0x36ff60, 0x36ef07, 0x36deb2, 0x36ce5f, 0x36be0f, 0x36adc2, 0x369d78,
    0x368d31, 0x367ced, 0x366cac, 0x365c6d, 0x364c32, 0x363bf9, 0x362bc4, 0x361b91,
    0x360b61, 0x35fb34, 0x35eb09, 0x35dae2, 0x35cabe, 0x35ba9c, 0x35aa7d, 0x359a61,
    0x358a48, 0x357a32, 0x356a1f, 0x355a0e, 0x354a01, 0x3539f6, 0x3529ee, 0x3519e9,
    0x3509e7, 0x34f9e7, 0x34e9ea, 0x34d9f1, 0x34c9fa, 0x34ba05, 0x34aa14, 0x349a26,
    0x348a3a, 0x347a51, 0x346a6b, 0x345a87, 0x344aa7, 0x343ac9, 0x342aee, 0x341b16,
    0x340b41, 0x33fb6e, 0x33eb9e, 0x33dbd1, 0x33cc07, 0x33bc40, 0x33ac7b, 0x339cb9,
    0x338cfa, 0x337d3d, 0x336d84, 0x335dcd, 0x334e19, 0x333e67, 0x332eb8, 0x331f0d,
    0x330f63, 0x32ffbd, 0x32f019, 0x32e078, 0x32d0da, 0x32c13e, 0x32b1a6, 0x32a210,
    0x32927c, 0x3282ec, 0x32735e, 0x3263d2, 0x32544a, 0x3244c4, 0x323541, 0x3225c1,
    0x321643, 0x3206c8, 0x31f74f, 0x31e7da, 0x31d867, 0x31c8f7, 0x31b989, 0x31aa1e,
    0x319ab6, 0x318b50, 0x317bed, 0x316c8d, 0x315d2f, 0x314dd5, 0x313e7c, 0x312f27,
    0x311fd4, 0x311083, 0x310136, 0x30f1eb, 0x30e2a2, 0x30d35d, 0x30c41a, 0x30b4d9,
    0x30a59b, 0x309660, 0x308727, 0x3077f2, 0x3068be, 0x30598d, 0x304a5f, 0x303b34,
    0x302c0b, 0x301ce5, 0x300dc1, 0x2ffea0, 0x2fef82, 0x2fe066, 0x2fd14c, 0x2fc236,
    0x2fb322, 0x2fa410, 0x2f9501, 0x2f85f5, 0x2f76eb, 0x2f67e4, 0x2f58df, 0x2f49dd,
    0x2f3ade, 0x2f2be1, 0x2f1ce7, 0x2f0def, 0x2efefa, 0x2ef007, 0x2ee117, 0x2ed229,
    0x2ec33e, 0x2eb456, 0x2ea570, 0x2e968c, 0x2e87ab, 0x2e78cd, 0x2e69f1, 0x2e5b18,
    0x2e4c41, 0x2e3d6d, 0x2e2e9b, 0x2e1fcc, 0x2e1100, 0x2e0236, 0x2df36e, 0x2de4a9,
    0x2dd5e6, 0x2dc726, 0x2db869, 0x2da9ad, 0x2d9af5, 0x2d8c3f, 0x2d7d8b, 0x2d6eda,
    0x2d602b, 0x2d517f, 0x2d42d6, 0x2d342e, 0x2d258a, 0x2d16e7, 0x2d0848, 0x2cf9aa,
    0x2ceb10, 0x2cdc77, 0x2ccde1, 0x2cbf4e, 0x2cb0bd, 0x2ca22e, 0x2c93a2, 0x2c8519,
    0x2c7692, 0x2c680d, 0x2c598b, 0x2c4b0b, 0x2c3c8d, 0x2c2e12, 0x2c1f9a, 0x2c1124,
    0x2c02b0, 0x2bf43f, 0x2be5d0, 0x2bd764, 0x2bc8fa, 0x2bba92, 0x2bac2d, 0x2b9dca,
    0x2b8f6a, 0x2b810c, 0x2b72b0, 0x2b6457, 0x2b5601, 0x2b47ac, 0x2b395a, 0x2b2b0b,
    0x2b1cbe, 0x2b0e73, 0x2b002b, 0x2af1e5, 0x2ae3a1, 0x2ad560, 0x2ac721, 0x2ab8e5,
    0x2aaaab, 0x2a9c73, 0x2a8e3e, 0x2a800b, 0x2a71da, 0x2a63ac, 0x2a5580, 0x2a4756,
    0x2a392f, 0x2a2b0a, 0x2a1ce8, 0x2a0ec8, 0x2a00aa, 0x29f28f, 0x29e475, 0x29d65f,
    0x29c84a, 0x29ba38, 0x29ac28, 0x299e1b, 0x299010, 0x298207, 0x297401, 0x2965fd,
    0x2957fb, 0x2949fb, 0x293bfe, 0x292e03, 0x29200b, 0x291214, 0x290420, 0x28f62f,
    0x28e83f, 0x28da52, 0x28cc68, 0x28be7f, 0x28b099, 0x28a2b5, 0x2894d3, 0x2886f4,
    0x287917, 0x286b3c, 0x285d64, 0x284f8e, 0x2841ba, 0x2833e8, 0x282619, 0x28184c,
    0x280a81, 0x27fcb8, 0x27eef2, 0x27e12e, 0x27d36c, 0x27c5ac, 0x27b7ef, 0x27aa34,
    0x279c7b, 0x278ec5, 0x278110, 0x27735e, 0x2765ae, 0x275801, 0x274a55, 0x273cac,
    0x272f05, 0x272161, 0x2713be, 0x27061e, 0x26f880, 0x26eae4, 0x26dd4a, 0x26cfb3,
    0x26c21e, 0x26b48b, 0x26a6fa, 0x26996c, 0x268bdf, 0x267e55, 0x2670cd, 0x266348,
    0x2655c4, 0x264843, 0x263ac4, 0x262d47, 0x261fcc, 0x261254, 0x2604dd, 0x25f769,
    0x25e9f7, 0x25dc87, 0x25cf19, 0x25c1ae, 0x25b445, 0x25a6dd, 0x259978, 0x258c16,
    0x257eb5, 0x257157, 0x2563fa, 0x2556a0, 0x254948, 0x253bf2, 0x252e9e, 0x25214d,
    0x2513fd, 0x2506b0, 0x24f965, 0x24ec1c, 0x24ded5, 0x24d190, 0x24c44e, 0x24b70d,
    0x24a9cf, 0x249c93, 0x248f59, 0x248221, 0x2474eb, 0x2467b7, 0x245a86, 0x244d56,
    0x244029, 0x2432fe, 0x2425d5, 0x2418ae, 0x240b89, 0x23fe66, 0x23f145, 0x23e427,
    0x23d70a, 0x23c9f0, 0x23bcd8, 0x23afc1, 0x23a2ad, 0x23959b, 0x23888b, 0x237b7d,
    0x236e72, 0x236168, 0x235460, 0x23475b, 0x233a57, 0x232d56, 0x232057, 0x231359,
    0x23065e, 0x22f965, 0x22ec6e, 0x22df79, 0x22d286, 0x22c595, 0x22b8a7, 0x22abba,
    0x229ecf, 0x2291e6, 0x228500, 0x22781b, 0x226b39, 0x225e58, 0x22517a, 0x22449e,
    0x2237c3, 0x222aeb, 0x221e15, 0x221140, 0x22046e, 0x21f79e, 0x21ead0, 0x21de04,
    0x21d13a, 0x21c471, 0x21b7ab, 0x21aae7, 0x219e25, 0x219165, 0x2184a7, 0x2177eb,
    0x216b31, 0x215e79, 0x2151c3, 0x21450f, 0x21385d, 0x212bad, 0x211eff, 0x211253,
    0x2105a9, 0x20f901, 0x20ec5b, 0x20dfb7, 0x20d315, 0x20c675, 0x20b9d7, 0x20ad3b,
    0x20a0a1, 0x209408, 0x208772, 0x207ade, 0x206e4c, 0x2061bc, 0x20552d, 0x2048a1,
    0x203c17, 0x202f8e, 0x202308, 0x201683, 0x200a01, 0x1ffd80, 0x1ff101, 0x1fe485,
    0x1fd80a, 0x1fcb91, 0x1fbf1a, 0x1fb2a5, 0x1fa633, 0x1f99c2, 0x1f8d52, 0x1f80e5,
    0x1f747a, 0x1f6811, 0x1f5ba9, 0x1f4f44, 0x1f42e1, 0x1f367f, 0x1f2a1f, 0x1f1dc2,
    0x1f1166, 0x1f050c, 0x1ef8b4, 0x1eec5e, 0x1ee00a, 0x1ed3b8, 0x1ec767, 0x1ebb19,
    0x1eaecd, 0x1ea282, 0x1e9639, 0x1e89f3, 0x1e7dae, 0x1e716b, 0x1e652a, 0x1e58ea,
    0x1e4cad, 0x1e4072, 0x1e3438, 0x1e2801, 0x1e1bcb, 0x1e0f97, 0x1e0365, 0x1df735,
    0x1deb07, 0x1ddeda, 0x1dd2b0, 0x1dc687, 0x1dba61, 0x1dae3c, 0x1da219, 0x1d95f8,
    0x1d89d9, 0x1d7dbb, 0x1d71a0, 0x1d6586, 0x1d596e, 0x1d4d58, 0x1d4144, 0x1d3532,
    0x1d2922, 0x1d1d13, 0x1d1107, 0x1d04fc, 0x1cf8f3, 0x1cecec, 0x1ce0e6, 0x1cd4e3,
    0x1cc8e1, 0x1cbce2, 0x1cb0e4, 0x1ca4e8, 0x1c98ed, 0x1c8cf5, 0x1c80fe, 0x1c750a,
    0x1c6917, 0x1c5d25, 0x1c5136, 0x1c4549, 0x1c395d, 0x1c2d73, 0x1c218b, 0x1c15a5,
    0x1c09c1, 0x1bfdde, 0x1bf1fd, 0x1be61e, 0x1bda41, 0x1bce66, 0x1bc28c, 0x1bb6b5,
    0x1baadf, 0x1b9f0a, 0x1b9338, 0x1b8768, 0x1b7b99, 0x1b6fcc, 0x1b6401, 0x1b5837,
    0x1b4c70, 0x1b40aa, 0x1b34e6, 0x1b2924, 0x1b1d63, 0x1b11a4, 0x1b05e7, 0x1afa2c,
    0x1aee73, 0x1ae2bb, 0x1ad706, 0x1acb52, 0x1abf9f, 0x1ab3ef, 0x1aa840, 0x1a9c93,
    0x1a90e8, 0x1a853e, 0x1a7997, 0x1a6df1, 0x1a624d, 0x1a56aa, 0x1a4b09, 0x1a3f6b,
    0x1a33cd, 0x1a2832, 0x1a1c98, 0x1a1100, 0x1a056a, 0x19f9d6, 0x19ee43, 0x19e2b2,
    0x19d723, 0x19cb95, 0x19c00a, 0x19b480, 0x19a8f7, 0x199d71, 0x1991ec, 0x198669,
    0x197ae7, 0x196f68, 0x1963ea, 0x19586e, 0x194cf3, 0x19417a, 0x193603, 0x192a8e,
    0x191f1a, 0x1913a8, 0x190838, 0x18fcca, 0x18f15d, 0x18e5f2, 0x18da88, 0x18cf21,
    0x18c3bb, 0x18b857, 0x18acf4, 0x18a193, 0x189634, 0x188ad6, 0x187f7b, 0x187420,
    0x1868c8, 0x185d71, 0x18521c, 0x1846c9, 0x183b77, 0x183027, 0x1824d9, 0x18198c,
    0x180e41, 0x1802f8, 0x17f7b0, 0x17ec6b, 0x17e126, 0x17d5e4, 0x17caa3, 0x17bf64,
    0x17b426, 0x17a8ea, 0x179db0, 0x179277, 0x178740, 0x177c0b, 0x1770d7, 0x1765a5,
    0x175a75, 0x174f46, 0x174419, 0x1738ee, 0x172dc4, 0x17229c, 0x171776, 0x170c51,
    0x17012e, 0x16f60d, 0x16eaed, 0x16dfce, 0x16d4b2, 0x16c997, 0x16be7e, 0x16b366,
    0x16a850, 0x169d3c, 0x169229, 0x168718, 0x167c08, 0x1670fa, 0x1665ee, 0x165ae3,
    0x164fda, 0x1644d3, 0x1639cd, 0x162ec9, 0x1623c7, 0x1618c6, 0x160dc6, 0x1602c9,
    0x15f7cc, 0x15ecd2, 0x15e1d9, 0x15d6e2, 0x15cbec, 0x15c0f8, 0x15b606, 0x15ab15,
    0x15a025, 0x159538, 0x158a4c, 0x157f61, 0x157478, 0x156991, 0x155eab, 0x1553c7,
    0x1548e5, 0x153e04, 0x153324, 0x152847, 0x151d6a, 0x151290, 0x1507b7, 0x14fcdf,
    0x14f209, 0x14e735, 0x14dc62, 0x14d191, 0x14c6c2, 0x14bbf4, 0x14b127, 0x14a65c,
    0x149b93, 0x1490cb, 0x148605, 0x147b40, 0x14707d, 0x1465bc, 0x145afc, 0x14503d,
    0x144581, 0x143ac5, 0x14300c, 0x142553, 0x141a9d, 0x140fe8, 0x140534, 0x13fa82,
    0x13efd2, 0x13e523, 0x13da76, 0x13cfca, 0x13c51f, 0x13ba77, 0x13afd0, 0x13a52a,
    0x139a86, 0x138fe3, 0x138542, 0x137aa3, 0x137005, 0x136568, 0x135acd, 0x135034,
    0x13459c, 0x133b06, 0x133071, 0x1325dd, 0x131b4c, 0x1310bb, 0x13062d, 0x12fb9f,
    0x12f114, 0x12e689, 0x12dc01, 0x12d179, 0x12c6f4, 0x12bc6f, 0x12b1ed, 0x12a76c,
    0x129cec, 0x12926e, 0x1287f1, 0x127d76, 0x1272fc, 0x126884, 0x125e0d, 0x125398,
    0x124925, 0x123eb2, 0x123442, 0x1229d2, 0x121f65, 0x1214f9, 0x120a8e, 0x120025,
    0x11f5bd, 0x11eb56, 0x11e0f2, 0x11d68e, 0x11cc2c, 0x11c1cc, 0x11b76d, 0x11ad10,
    0x11a2b4, 0x119859, 0x118e00, 0x1183a9, 0x117953, 0x116efe, 0x1164ab, 0x115a59,
    0x115009, 0x1145ba, 0x113b6d, 0x113121, 0x1126d7, 0x111c8e, 0x111247, 0x110801,
    0x10fdbc, 0x10f379, 0x10e937, 0x10def7, 0x10d4b8, 0x10ca7b, 0x10c03f, 0x10b605,
    0x10abcc, 0x10a195, 0x10975e, 0x108d2a, 0x1082f7, 0x1078c5, 0x106e95, 0x106466,
    0x105a38, 0x10500c, 0x1045e2, 0x103bb9, 0x103191, 0x10276b, 0x101d46, 0x101323,
    0x100901, 0xffee0, 0xff4c1, 0xfeaa3, 0xfe087, 0xfd66c, 0xfcc53, 0xfc23b,
    0xfb824, 0xfae0f, 0xfa3fb, 0xf99e9, 0xf8fd8, 0xf85c8, 0xf7bba, 0xf71ad,
    0xf67a2, 0xf5d98, 0xf538f, 0xf4988, 0xf3f83, 0xf357e, 0xf2b7b, 0xf217a,
    0xf177a, 0xf0d7b, 0xf037e, 0xef982, 0xeef87, 0xee58e, 0xedb97, 0xed1a0,
    0xec7ab, 0xebdb8, 0xeb3c5, 0xea9d5, 0xe9fe5, 0xe95f7, 0xe8c0b, 0xe821f,
    0xe7835, 0xe6e4d, 0xe6466, 0xe5a80, 0xe509c, 0xe46b9, 0xe3cd7, 0xe32f7,
    0xe2918, 0xe1f3a, 0xe155e, 0xe0b83, 0xe01aa, 0xdf7d2, 0xdedfb, 0xde426,
    0xdda52, 0xdd07f, 0xdc6ae, 0xdbcde, 0xdb310, 0xda943, 0xd9f77, 0xd95ac,
    0xd8be3, 0xd821c, 0xd7855, 0xd6e90, 0xd64cc, 0xd5b0a, 0xd5149, 0xd4789,
    0xd3dcb, 0xd340e, 0xd2a52, 0xd2098, 0xd16df, 0xd0d28, 0xd0371, 0xcf9bc,
    0xcf009, 0xce657, 0xcdca6, 0xcd2f6, 0xcc948, 0xcbf9b, 0xcb5ef, 0xcac45,
    0xca29c, 0xc98f4, 0xc8f4e, 0xc85a9, 0xc7c05, 0xc7263, 0xc68c2, 0xc5f22,
    0xc5584, 0xc4be7, 0xc424b, 0xc38b1, 0xc2f18, 0xc2580, 0xc1bea, 0xc1254,
    0xc08c1, 0xbff2e, 0xbf59d, 0xbec0d, 0xbe27e, 0xbd8f1, 0xbcf65, 0xbc5da,
    0xbbc51, 0xbb2c9, 0xba942, 0xb9fbc, 0xb9638, 0xb8cb5, 0xb8334, 0xb79b3,
    0xb7034, 0xb66b7, 0xb5d3a, 0xb53bf, 0xb4a45, 0xb40cd, 0xb3755, 0xb2ddf,
    0xb246b, 0xb1af7, 0xb1185, 0xb0814, 0xafea5, 0xaf536, 0xaebc9, 0xae25d,
    0xad8f3, 0xacf8a, 0xac622, 0xabcbb, 0xab356, 0xaa9f2, 0xaa08f, 0xa972d,
    0xa8dcd, 0xa846e, 0xa7b10, 0xa71b4, 0xa6859, 0xa5eff, 0xa55a6, 0xa4c4f,
    0xa42f8, 0xa39a4, 0xa3050, 0xa26fe, 0xa1dac, 0xa145d, 0xa0b0e, 0xa01c1,
    0x9f874, 0x9ef2a, 0x9e5e0, 0x9dc98, 0x9d350, 0x9ca0b, 0x9c0c6, 0x9b783,
    0x9ae41, 0x9a500, 0x99bc0, 0x99282, 0x98944, 0x98009, 0x976ce, 0x96d95,
    0x9645c, 0x95b25, 0x951f0, 0x948bb, 0x93f88, 0x93656, 0x92d25, 0x923f6,
    0x91ac7, 0x9119a, 0x9086e, 0x8ff44, 0x8f61a, 0x8ecf2, 0x8e3cb, 0x8daa5,
    0x8d181, 0x8c85e, 0x8bf3b, 0x8b61b, 0x8acfb, 0x8a3dd, 0x89abf, 0x891a3,
    0x88889, 0x87f6f, 0x87657, 0x86d3f, 0x8642a, 0x85b15, 0x85201, 0x848ef,
    0x83fde, 0x836ce, 0x82dbf, 0x824b2, 0x81ba6, 0x8129b, 0x80991, 0x80088,
    0x7f781, 0x7ee7a, 0x7e575, 0x7dc71, 0x7d36f, 0x7ca6d, 0x7c16d, 0x7b86e,
    0x7af70, 0x7a673, 0x79d78, 0x7947d, 0x78b84, 0x7828c, 0x77995, 0x770a0,
    0x767ab, 0x75eb8, 0x755c6, 0x74cd5, 0x743e6, 0x73af7, 0x7320a, 0x7291e,
    0x72033, 0x71749, 0x70e60, 0x70579, 0x6fc93, 0x6f3ae, 0x6eaca, 0x6e1e7,
    0x6d905, 0x6d025, 0x6c746, 0x6be68, 0x6b58b, 0x6acaf, 0x6a3d4, 0x69afb,
    0x69223, 0x6894c, 0x68076, 0x677a1, 0x66ecd, 0x665fb, 0x65d2a, 0x65459,
    0x64b8a, 0x642bd, 0x639f0, 0x63124, 0x6285a, 0x61f91, 0x616c9, 0x60e02,
    0x6053c, 0x5fc78, 0x5f3b4, 0x5eaf2, 0x5e231, 0x5d971, 0x5d0b2, 0x5c7f4,
    0x5bf37, 0x5b67c, 0x5adc2, 0x5a508, 0x59c50, 0x59399, 0x58ae4, 0x5822f,
    0x5797c, 0x570c9, 0x56818, 0x55f68, 0x556b9, 0x54e0b, 0x5455e, 0x53cb3,
    0x53408, 0x52b5f, 0x522b7, 0x51a10, 0x5116a, 0x508c5, 0x50021, 0x4f77f,
    0x4eedd, 0x4e63d, 0x4dd9e, 0x4d500, 0x4cc63, 0x4c3c7, 0x4bb2c, 0x4b292,
    0x4a9fa, 0x4a162, 0x498cc, 0x49037, 0x487a3, 0x47f10, 0x4767e, 0x46ded,
    0x4655e, 0x45ccf, 0x45442, 0x44bb5, 0x4432a, 0x43aa0, 0x43217, 0x4298f,
    0x42108, 0x41883, 0x40ffe, 0x4077a, 0x3fef8, 0x3f677, 0x3edf6, 0x3e577,
    0x3dcf9, 0x3d47c, 0x3cc01, 0x3c386, 0x3bb0c, 0x3b294, 0x3aa1c, 0x3a1a6,
    0x39930, 0x390bc, 0x38849, 0x37fd7, 0x37766, 0x36ef6, 0x36687, 0x35e1a,
    0x355ad, 0x34d41, 0x344d7, 0x33c6d, 0x33405, 0x32b9e, 0x32338, 0x31ad3,
    0x3126f, 0x30a0c, 0x301aa, 0x2f949, 0x2f0e9, 0x2e88b, 0x2e02d, 0x2d7d0,
    0x2cf75, 0x2c71b, 0x2bec1, 0x2b669, 0x2ae12, 0x2a5bc, 0x29d67, 0x29513,
    0x28cc0, 0x2846e, 0x27c1d, 0x273cd, 0x26b7f, 0x26331, 0x25ae4, 0x25299,
    0x24a4e, 0x24205, 0x239bd, 0x23175, 0x2292f, 0x220ea, 0x218a6, 0x21063,
    0x20821, 0x1ffe0, 0x1f7a0, 0x1ef61, 0x1e723, 0x1dee6, 0x1d6aa, 0x1ce6f,
    0x1c636, 0x1bdfd, 0x1b5c5, 0x1ad8f, 0x1a559, 0x19d25, 0x194f1, 0x18cbf,
    0x1848e, 0x17c5d, 0x1742e, 0x16c00, 0x163d3, 0x15ba6, 0x1537b, 0x14b51,
    0x14328, 0x13b00, 0x132d9, 0x12ab3, 0x1228e, 0x11a6a, 0x11247, 0x10a25,
    0x10204, 0xf9e4, 0xf1c5, 0xe9a7, 0xe18b, 0xd96f, 0xd154, 0xc93a,
    0xc122, 0xb90a, 0xb0f3, 0xa8de, 0xa0c9, 0x98b5, 0x90a3, 0x8891,
    0x8081, 0x7871, 0x7062, 0x6855, 0x6048, 0x583d, 0x5032, 0x4829,
    0x4020, 0x3819, 0x3012, 0x280d, 0x2008, 0x1805, 0x1002, 0x801,
    0x7fffff, 0x7fe004, 0x7fc010, 0x7fa024, 0x7f8040, 0x7f6064, 0x7f4090, 0x7f20c3,
    0x7f00ff, 0x7ee143, 0x7ec18e, 0x7ea1e1, 0x7e823d, 0x7e62a0, 0x7e430b, 0x7e237d,
    0x7e03f8, 0x7de47a, 0x7dc505, 0x7da597, 0x7d8631, 0x7d66d2, 0x7d477b, 0x7d282d,
    0x7d08e5, 0x7ce9a6, 0x7cca6e, 0x7cab3e, 0x7c8c16, 0x7c6cf5, 0x7c4ddc, 0x7c2ecb,
    0x7c0fc1, 0x7bf0bf, 0x7bd1c4, 0x7bb2d2, 0x7b93e6, 0x7b7503, 0x7b5627, 0x7b3752,
    0x7b1885, 0x7af9c0, 0x7adb02, 0x7abc4c, 0x7a9d9d, 0x7a7ef6, 0x7a6056, 0x7a41be,
    0x7a232d, 0x7a04a4, 0x79e622, 0x79c7a7, 0x79a934, 0x798ac9, 0x796c64, 0x794e08,
    0x792fb2, 0x791164, 0x78f31d, 0x78d4de, 0x78b6a6, 0x789876, 0x787a4c, 0x785c2a,
    0x783e10, 0x781ffc, 0x7801f0, 0x77e3eb, 0x77c5ee, 0x77a7f7, 0x778a08, 0x776c20,
    0x774e40, 0x773066, 0x771294, 0x76f4c9, 0x76d705, 0x76b949, 0x769b93, 0x767de5,
    0x76603e, 0x76429e, 0x762505, 0x760773, 0x75e9e8, 0x75cc64, 0x75aee8, 0x759172,
    0x757404, 0x75569c, 0x75393c, 0x751be3, 0x74fe91, 0x74e145, 0x74c401, 0x74a6c4,
    0x74898d, 0x746c5e, 0x744f36, 0x743214, 0x7414fa, 0x73f7e6, 0x73dada, 0x73bdd4,
    0x73a0d5, 0x7383dd, 0x7366ec, 0x734a02, 0x732d1f, 0x731042, 0x72f36d, 0x72d69e,
    0x72b9d6, 0x729d15, 0x72805b, 0x7263a7, 0x7246fb, 0x722a55, 0x720db6, 0x71f11d,
    0x71d48c, 0x71b801, 0x719b7d, 0x717eff, 0x716289, 0x714619, 0x7129af, 0x710d4d,
    0x70f0f1, 0x70d49c, 0x70b84d, 0x709c05, 0x707fc4, 0x706389, 0x704755, 0x702b28,
    0x700f01, 0x6ff2e1, 0x6fd6c7, 0x6fbab4, 0x6f9ea8, 0x6f82a2, 0x6f66a2, 0x6f4aa9,
    0x6f2eb7, 0x6f12cb, 0x6ef6e6, 0x6edb07, 0x6ebf2f, 0x6ea35d, 0x6e8792, 0x6e6bcd,
    0x6e500f, 0x6e3457, 0x6e18a6, 0x6dfcfb, 0x6de156, 0x6dc5b8, 0x6daa20, 0x6d8e8f,
    0x6d7304, 0x6d577f, 0x6d3c01, 0x6d2089, 0x6d0518, 0x6ce9ac, 0x6cce48, 0x6cb2e9,
    0x6c9791, 0x6c7c3f, 0x6c60f4, 0x6c45af, 0x6c2a70, 0x6c0f37, 0x6bf405, 0x6bd8d9,
    0x6bbdb3, 0x6ba293, 0x6b877a, 0x6b6c67, 0x6b515a, 0x6b3653, 0x6b1b52, 0x6b0058,
    0x6ae564, 0x6aca76, 0x6aaf8e, 0x6a94ad, 0x6a79d1, 0x6a5efc, 0x6a442d, 0x6a2964,
    0x6a0ea1, 0x69f3e4, 0x69d92d, 0x69be7d, 0x69a3d2, 0x69892e, 0x696e90, 0x6953f7,
    0x693965, 0x691ed9, 0x690453, 0x68e9d3, 0x68cf59, 0x68b4e5, 0x689a77, 0x68800f,
    0x6865ac, 0x684b50, 0x6830fa, 0x6816aa, 0x67fc60, 0x67e21c, 0x67c7de, 0x67ada5,
    0x679373, 0x677946, 0x675f20, 0x6744ff, 0x672ae4, 0x6710d0, 0x66f6c1, 0x66dcb8,
    0x66c2b4, 0x66a8b7, 0x668ebf, 0x6674ce, 0x665ae2, 0x6640fc, 0x66271c, 0x660d41,
    0x65f36d, 0x65d99e, 0x65bfd5, 0x65a612, 0x658c54, 0x65729d, 0x6558eb, 0x653f3f,
    0x652598, 0x650bf8, 0x64f25d, 0x64d8c7, 0x64bf38, 0x64a5ae, 0x648c2a, 0x6472ac,
    0x645933, 0x643fc0, 0x642652, 0x640ceb, 0x63f389, 0x63da2c, 0x63c0d6, 0x63a784,
    0x638e39, 0x6374f3, 0x635bb3, 0x634278, 0x632943, 0x631014, 0x62f6ea, 0x62ddc5,
    0x62c4a7, 0x62ab8d, 0x62927a, 0x62796c, 0x626063, 0x624760, 0x622e63, 0x62156b,
    0x61fc78, 0x61e38b, 0x61caa4, 0x61b1c2, 0x6198e5, 0x61800e, 0x61673d, 0x614e70,
    0x6135aa, 0x611ce9, 0x61042d, 0x60eb77, 0x60d2c6, 0x60ba1a, 0x60a174, 0x6088d3,
    0x607038, 0x6057a2, 0x603f12, 0x602687, 0x600e01, 0x5ff580, 0x5fdd05, 0x5fc490,
    0x5fac1f, 0x5f93b4, 0x5f7b4f, 0x5f62ee, 0x5f4a93, 0x5f323e, 0x5f19ed, 0x5f01a2,
    0x5ee95c, 0x5ed11c, 0x5eb8e0, 0x5ea0aa, 0x5e887a, 0x5e704e, 0x5e5828, 0x5e4007,
    0x5e27eb, 0x5e0fd5, 0x5df7c3, 0x5ddfb7, 0x5dc7b0, 0x5dafaf, 0x5d97b2, 0x5d7fbb,
    0x5d67c9, 0x5d4fdc, 0x5d37f4, 0x5d2011, 0x5d0834, 0x5cf05b, 0x5cd888, 0x5cc0ba,
    0x5ca8f1, 0x5c912e, 0x5c796f, 0x5c61b5, 0x5c4a01, 0x5c3251, 0x5c1aa7, 0x5c0302,
    0x5beb62, 0x5bd3c7, 0x5bbc31, 0x5ba4a0, 0x5b8d14, 0x5b758d, 0x5b5e0c, 0x5b468f,
    0x5b2f17, 0x5b17a4, 0x5b0037, 0x5ae8ce, 0x5ad16a, 0x5aba0c, 0x5aa2b2, 0x5a8b5d,
    0x5a740e, 0x5a5cc3, 0x5a457d, 0x5a2e3c, 0x5a1700, 0x59ffca, 0x59e898, 0x59d16a,
    0x59ba42, 0x59a31f, 0x598c01, 0x5974e7, 0x595dd3, 0x5946c3, 0x592fb9, 0x5918b3,
    0x5901b2, 0x58eab6, 0x58d3bf, 0x58bccc, 0x58a5df, 0x588ef6, 0x587813, 0x586134,
    0x584a5a, 0x583384, 0x581cb4, 0x5805e8, 0x57ef21, 0x57d85f, 0x57c1a2, 0x57aaea,
    0x579436, 0x577d87, 0x5766dd, 0x575038, 0x573997, 0x5722fb, 0x570c64, 0x56f5d2,
    0x56df44, 0x56c8bb, 0x56b237, 0x569bb7, 0x56853d, 0x566ec7, 0x565855, 0x5641e9,
    0x562b81, 0x56151e, 0x55febf, 0x55e865, 0x55d210, 0x55bbbf, 0x55a573, 0x558f2c,
    0x5578e9, 0x5562ac, 0x554c72, 0x55363d, 0x55200d, 0x5509e2, 0x54f3bb, 0x54dd99,
    0x54c77b, 0x54b162, 0x549b4d, 0x54853e, 0x546f32, 0x54592b, 0x544329, 0x542d2c,
    0x541733, 0x54013e, 0x53eb4e, 0x53d563, 0x53bf7c, 0x53a999, 0x5393bb, 0x537de2,
    0x53680d, 0x53523d, 0x533c71, 0x5326aa, 0x5310e7, 0x52fb28, 0x52e56f, 0x52cfb9,
    0x52ba08, 0x52a45c, 0x528eb4, 0x527910, 0x526371, 0x524dd6, 0x523840, 0x5222ae,
    0x520d21, 0x51f798, 0x51e213, 0x51cc93, 0x51b717, 0x51a1a0, 0x518c2d, 0x5176be,
    0x516154, 0x514bee, 0x51368d, 0x512130, 0x510bd7, 0x50f683, 0x50e133, 0x50cbe7,
    0x50b6a0, 0x50a15d, 0x508c1e, 0x5076e4, 0x5061ae, 0x504c7c, 0x50374f, 0x502226,
    0x500d01, 0x4ff7e0, 0x4fe2c4, 0x4fcdac, 0x4fb899, 0x4fa389, 0x4f8e7e, 0x4f7977,
    0x4f6475, 0x4f4f76, 0x4f3a7c, 0x4f2586, 0x4f1095, 0x4efba7, 0x4ee6be, 0x4ed1d9,
    0x4ebcf9, 0x4ea81c, 0x4e9344, 0x4e7e70, 0x4e69a0, 0x4e54d4, 0x4e400d, 0x4e2b4a,
    0x4e168a, 0x4e01d0, 0x4ded19, 0x4dd866, 0x4dc3b8, 0x4daf0d, 0x4d9a67, 0x4d85c5,
    0x4d7127, 0x4d5c8e, 0x4d47f8, 0x4d3367, 0x4d1ed9, 0x4d0a50, 0x4cf5cb, 0x4ce14a,
    0x4ccccd, 0x4cb854, 0x4ca3df, 0x4c8f6f, 0x4c7b02, 0x4c669a, 0x4c5235, 0x4c3dd5,
    0x4c2978, 0x4c1520, 0x4c00cc, 0x4bec7c, 0x4bd830, 0x4bc3e8, 0x4bafa4, 0x4b9b64,
    0x4b8728, 0x4b72f0, 0x4b5ebc, 0x4b4a8c, 0x4b3660, 0x4b2238, 0x4b0e14, 0x4af9f4,
    0x4ae5d8, 0x4ad1c0, 0x4abdac, 0x4aa99c, 0x4a9590, 0x4a8188, 0x4a6d84, 0x4a5984,
    0x4a4588, 0x4a3190, 0x4a1d9b, 0x4a09ab, 0x49f5bf, 0x49e1d6, 0x49cdf1, 0x49ba11,
    0x49a634, 0x49925b, 0x497e86, 0x496ab5, 0x4956e8, 0x49431f, 0x492f59, 0x491b98,
    0x4907da, 0x48f421, 0x48e06b, 0x48ccb9, 0x48b90b, 0x48a560, 0x4891ba, 0x487e17,
    0x486a79, 0x4856de, 0x484347, 0x482fb3, 0x481c24, 0x480898, 0x47f511, 0x47e18d,
    0x47ce0c, 0x47ba90, 0x47a718, 0x4793a3, 0x478032, 0x476cc5, 0x47595b, 0x4745f6,
    0x473294, 0x471f36, 0x470bdb, 0x46f885, 0x46e532, 0x46d1e3, 0x46be98, 0x46ab50,
    0x46980c, 0x4684cc, 0x467190, 0x465e57, 0x464b22, 0x4637f1, 0x4624c4, 0x46119a,
    0x45fe74, 0x45eb52, 0x45d833, 0x45c518, 0x45b201, 0x459eed, 0x458bdd, 0x4578d1,
    0x4565c8, 0x4552c4, 0x453fc2, 0x452cc5, 0x4519cb, 0x4506d5, 0x44f3e2, 0x44e0f3,
    0x44ce08, 0x44bb20, 0x44a83c, 0x44955b, 0x44827f, 0x446fa5, 0x445cd0, 0x4449fe,
    0x443730, 0x442465, 0x44119e, 0x43feda, 0x43ec1a, 0x43d95e, 0x43c6a5, 0x43b3f0,
    0x43a13e, 0x438e90, 0x437be5, 0x43693e, 0x43569b, 0x4343fb, 0x43315f, 0x431ec6,
    0x430c31, 0x42f99f, 0x42e711, 0x42d486, 0x42c1ff, 0x42af7c, 0x429cfc, 0x428a7f,
    0x427806, 0x426591, 0x42531f, 0x4240b0, 0x422e45, 0x421bde, 0x420979, 0x41f719,
    0x41e4bc, 0x41d262, 0x41c00c, 0x41adb9, 0x419b6a, 0x41891f, 0x4176d6, 0x416491,
    0x415250, 0x414012, 0x412dd8, 0x411ba1, 0x41096d, 0x40f73d, 0x40e510, 0x40d2e7,
    0x40c0c1, 0x40ae9e, 0x409c7f, 0x408a63, 0x40784b, 0x406636, 0x405425, 0x404217,
    0x40300c, 0x401e05, 0x400c01, 0x3ffa00, 0x3fe803, 0x3fd609, 0x3fc413, 0x3fb220,
    0x3fa030, 0x3f8e44, 0x3f7c5b, 0x3f6a75, 0x3f5892, 0x3f46b4, 0x3f34d8, 0x3f2300,
    0x3f112b, 0x3eff59, 0x3eed8b, 0x3edbc0, 0x3ec9f8, 0x3eb833, 0x3ea672, 0x3e94b5,
    0x3e82fa, 0x3e7143, 0x3e5f8f, 0x3e4dde, 0x3e3c31, 0x3e2a87, 0x3e18e0, 0x3e073d,
    0x3df59d, 0x3de400, 0x3dd266, 0x3dc0d0, 0x3daf3c, 0x3d9dac, 0x3d8c20, 0x3d7a96,
    0x3d6910, 0x3d578d, 0x3d460e, 0x3d3491, 0x3d2318, 0x3d11a2, 0x3d002f, 0x3ceec0,
    0x3cdd53, 0x3ccbea, 0x3cba84, 0x3ca922, 0x3c97c2, 0x3c8666, 0x3c750d, 0x3c63b7,
    0x3c5264, 0x3c4114, 0x3c2fc8, 0x3c1e7f, 0x3c0d39, 0x3bfbf6, 0x3beab6, 0x3bd97a,
    0x3bc841, 0x3bb70a, 0x3ba5d7, 0x3b94a7, 0x3b837b, 0x3b7251, 0x3b612b, 0x3b5007,
    0x3b3ee7, 0x3b2dca, 0x3b1cb0, 0x3b0b99, 0x3afa86, 0x3ae975, 0x3ad868, 0x3ac75d,
    0x3ab656, 0x3aa552, 0x3a9451, 0x3a8353, 0x3a7258, 0x3a6160, 0x3a506c, 0x3a3f7a,
    0x3a2e8c, 0x3a1da0, 0x3a0cb8, 0x39fbd3, 0x39eaf0, 0x39da11, 0x39c935, 0x39b85c,
    0x39a786, 0x3996b3, 0x3985e3, 0x397517, 0x39644d, 0x395386, 0x3942c2, 0x393202,
    0x392144, 0x391089, 0x38ffd2, 0x38ef1d, 0x38de6c, 0x38cdbd, 0x38bd11, 0x38ac69,
    0x389bc3, 0x388b21, 0x387a81, 0x3869e5, 0x38594b, 0x3848b5, 0x383821, 0x382791,
    0x381703, 0x380678, 0x37f5f1, 0x37e56c, 0x37d4ea, 0x37c46b, 0x37b3ef, 0x37a377,
    0x379301, 0x37828e, 0x37721e, 0x3761b1, 0x375147, 0x3740df, 0x37307b, 0x37201a,
    0x370fbb, 0x36ff60, 0x36ef07, 0x36deb2, 0x36ce5f, 0x36be0f, 0x36adc2, 0x369d78,
    0x368d31, 0x367ced, 0x366cac, 0x365c6d, 0x364c32, 0x363bf9, 0x362bc4, 0x361b91,
    0x360b61, 0x35fb34, 0x35eb09, 0x35dae2, 0x35cabe, 0x35ba9c, 0x35aa7d, 0x359a61,
    0x358a48, 0x357a32, 0x356a1f, 0x355a0e, 0x354a01, 0x3539f6, 0x3529ee, 0x3519e9,
    0x3509e7, 0x34f9e7, 0x34e9ea, 0x34d9f1, 0x34c9fa, 0x34ba05, 0x34aa14, 0x349a26,
    0x348a3a, 0x347a51, 0x346a6b, 0x345a87, 0x344aa7, 0x343ac9, 0x342aee, 0x341b16,
    0x340b41, 0x33fb6e, 0x33eb9e, 0x33dbd1, 0x33cc07, 0x33bc40, 0x33ac7b, 0x339cb9,
    0x338cfa, 0x337d3d, 0x336d84, 0x335dcd, 0x334e19, 0x333e67, 0x332eb8, 0x331f0d,
    0x330f63, 0x32ffbd, 0x32f019, 0x32e078, 0x32d0da, 0x32c13e, 0x32b1a6, 0x32a210,
    0x32927c, 0x3282ec, 0x32735e, 0x3263d2, 0x32544a, 0x3244c4, 0x323541, 0x3225c1,
    0x321643, 0x3206c8, 0x31f74f, 0x31e7da, 0x31d867, 0x31c8f7, 0x31b989, 0x31aa1e,
    0x319ab6, 0x318b50, 0x317bed, 0x316c8d, 0x315d2f, 0x314dd5, 0x313e7c, 0x312f27,
    0x311fd4, 0x311083, 0x310136, 0x30f1eb, 0x30e2a2, 0x30d35d, 0x30c41a, 0x30b4d9,
    0x30a59b, 0x309660, 0x308727, 0x3077f2, 0x3068be, 0x30598d, 0x304a5f, 0x303b34,
    0x302c0b, 0x301ce5, 0x300dc1, 0x2ffea0, 0x2fef82, 0x2fe066, 0x2fd14c, 0x2fc236,
    0x2fb322, 0x2fa410, 0x2f9501, 0x2f85f5, 0x2f76eb, 0x2f67e4, 0x2f58df, 0x2f49dd,
    0x2f3ade, 0x2f2be1, 0x2f1ce7, 0x2f0def, 0x2efefa, 0x2ef007, 0x2ee117, 0x2ed229,
    0x2ec33e, 0x2eb456, 0x2ea570, 0x2e968c, 0x2e87ab, 0x2e78cd, 0x2e69f1, 0x2e5b18,
    0x2e4c41, 0x2e3d6d, 0x2e2e9b, 0x2e1fcc, 0x2e1100, 0x2e0236, 0x2df36e, 0x2de4a9,
    0x2dd5e6, 0x2dc726, 0x2db869, 0x2da9ad, 0x2d9af5, 0x2d8c3f, 0x2d7d8b, 0x2d6eda,
    0x2d602b, 0x2d517f, 0x2d42d6, 0x2d342e, 0x2d258a, 0x2d16e7, 0x2d0848, 0x2cf9aa,
    0x2ceb10, 0x2cdc77, 0x2ccde1, 0x2cbf4e, 0x2cb0bd, 0x2ca22e, 0x2c93a2, 0x2c8519,
    0x2c7692, 0x2c680d, 0x2c598b, 0x2c4b0b, 0x2c3c8d, 0x2c2e12, 0x2c1f9a, 0x2c1124,
    0x2c02b0, 0x2bf43f, 0x2be5d0, 0x2bd764, 0x2bc8fa, 0x2bba92, 0x2bac2d, 0x2b9dca,
    0x2b8f6a, 0x2b810c, 0x2b72b0, 0x2b6457, 0x2b5601, 0x2b47ac, 0x2b395a, 0x2b2b0b,
    0x2b1cbe, 0x2b0e73, 0x2b002b, 0x2af1e5, 0x2ae3a1, 0x2ad560, 0x2ac721, 0x2ab8e5,
    0x2aaaab, 0x2a9c73, 0x2a8e3e, 0x2a800b, 0x2a71da, 0x2a63ac, 0x2a5580, 0x2a4756,
    0x2a392f, 0x2a2b0a, 0x2a1ce8, 0x2a0ec8, 0x2a00aa, 0x29f28f, 0x29e475, 0x29d65f,
    0x29c84a, 0x29ba38, 0x29ac28, 0x299e1b, 0x299010, 0x298207, 0x297401, 0x2965fd,
    0x2957fb, 0x2949fb, 0x293bfe, 0x292e03, 0x29200b, 0x291214, 0x290420, 0x28f62f,
    0x28e83f, 0x28da52, 0x28cc68, 0x28be7f, 0x28b099, 0x28a2b5, 0x2894d3, 0x2886f4,
    0x287917, 0x286b3c, 0x285d64, 0x284f8e, 0x2841ba, 0x2833e8, 0x282619, 0x28184c,
    0x280a81, 0x27fcb8, 0x27eef2, 0x27e12e, 0x27d36c, 0x27c5ac, 0x27b7ef, 0x27aa34,
    0x279c7b, 0x278ec5, 0x278110, 0x27735e, 0x2765ae, 0x275801, 0x274a55, 0x273cac,
    0x272f05, 0x272161, 0x2713be, 0x27061e, 0x26f880, 0x26eae4, 0x26dd4a, 0x26cfb3,
    0x26c21e, 0x26b48b, 0x26a6fa, 0x26996c, 0x268bdf, 0x267e55, 0x2670cd, 0x266348,
    0x2655c4, 0x264843, 0x263ac4, 0x262d47, 0x261fcc, 0x261254, 0x2604dd, 0x25f769,
    0x25e9f7, 0x25dc87, 0x25cf19, 0x25c1ae, 0x25b445, 0x25a6dd, 0x259978, 0x258c16,
    0x257eb5, 0x257157, 0x2563fa, 0x2556a0, 0x254948, 0x253bf2, 0x252e9e, 0x25214d,
    0x2513fd, 0x2506b0, 0x24f965, 0x24ec1c, 0x24ded5, 0x24d190, 0x24c44e, 0x24b70d,
    0x24a9cf, 0x249c93, 0x248f59, 0x248221, 0x2474eb, 0x2467b7, 0x245a86, 0x244d56,
    0x244029, 0x2432fe, 0x2425d5, 0x2418ae, 0x240b89, 0x23fe66, 0x23f145, 0x23e427,
    0x23d70a, 0x23c9f0, 0x23bcd8, 0x23afc1, 0x23a2ad, 0x23959b, 0x23888b, 0x237b7d,
    0x236e72, 0x236168, 0x235460, 0x23475b, 0x233a57, 0x232d56, 0x232057, 0x231359,
    0x23065e, 0x22f965, 0x22ec6e, 0x22df79, 0x22d286, 0x22c595, 0x22b8a7, 0x22abba,
    0x229ecf, 0x2291e6, 0x228500, 0x22781b, 0x226b39, 0x225e58, 0x22517a, 0x22449e,
    0x2237c3, 0x222aeb, 0x221e15, 0x221140, 0x22046e, 0x21f79e, 0x21ead0, 0x21de04,
    0x21d13a, 0x21c471, 0x21b7ab, 0x21aae7, 0x219e25, 0x219165, 0x2184a7, 0x2177eb,
    0x216b31, 0x215e79, 0x2151c3, 0x21450f, 0x21385d, 0x212bad, 0x211eff, 0x211253,
    0x2105a9, 0x20f901, 0x20ec5b, 0x20dfb7, 0x20d315, 0x20c675, 0x20b9d7, 0x20ad3b,
    0x20a0a1, 0x209408, 0x208772, 0x207ade, 0x206e4c, 0x2061bc, 0x20552d, 0x2048a1,
    0x203c17, 0x202f8e, 0x202308, 0x201683, 0x200a01, 0x1ffd80, 0x1ff101, 0x1fe485,
    0x1fd80a, 0x1fcb91, 0x1fbf1a, 0x1fb2a5, 0x1fa633, 0x1f99c2, 0x1f8d52, 0x1f80e5,
    0x1f747a, 0x1f6811, 0x1f5ba9, 0x1f4f44, 0x1f42e1, 0x1f367f, 0x1f2a1f, 0x1f1dc2,
    0x1f1166, 0x1f050c, 0x1ef8b4, 0x1eec5e, 0x1ee00a, 0x1ed3b8, 0x1ec767, 0x1ebb19,
    0x1eaecd, 0x1ea282, 0x1e9639, 0x1e89f3, 0x1e7dae, 0x1e716b, 0x1e652a, 0x1e58ea,
    0x1e4cad, 0x1e4072, 0x1e3438, 0x1e2801, 0x1e1bcb, 0x1e0f97, 0x1e0365, 0x1df735,
    0x1deb07, 0x1ddeda, 0x1dd2b0, 0x1dc687, 0x1dba61, 0x1dae3c, 0x1da219, 0x1d95f8,
    0x1d89d9, 0x1d7dbb, 0x1d71a0, 0x1d6586, 0x1d596e, 0x1d4d58, 0x1d4144, 0x1d3532,
    0x1d2922, 0x1d1d13, 0x1d1107, 0x1d04fc, 0x1cf8f3, 0x1cecec, 0x1ce0e6, 0x1cd4e3,
    0x1cc8e1, 0x1cbce2, 0x1cb0e4, 0x1ca4e8, 0x1c98ed, 0x1c8cf5, 0x1c80fe, 0x1c750a,
    0x1c6917, 0x1c5d25, 0x1c5136, 0x1c4549, 0x1c395d, 0x1c2d73, 0x1c218b, 0x1c15a5,
    0x1c09c1, 0x1bfdde, 0x1bf1fd, 0x1be61e, 0x1bda41, 0x1bce66, 0x1bc28c, 0x1bb6b5,
    0x1baadf, 0x1b9f0a, 0x1b9338, 0x1b8768, 0x1b7b99, 0x1b6fcc, 0x1b6401, 0x1b5837,
    0x1b4c70, 0x1b40aa, 0x1b34e6, 0x1b2924, 0x1b1d63, 0x1b11a4, 0x1b05e7, 0x1afa2c,
    0x1aee73, 0x1ae2bb, 0x1ad706, 0x1acb52, 0x1abf9f, 0x1ab3ef, 0x1aa840, 0x1a9c93,
    0x1a90e8, 0x1a853e, 0x1a7997, 0x1a6df1, 0x1a624d, 0x1a56aa, 0x1a4b09, 0x1a3f6b,
    0x1a33cd, 0x1a2832, 0x1a1c98, 0x1a1100, 0x1a056a, 0x19f9d6, 0x19ee43, 0x19e2b2,
    0x19d723, 0x19cb95, 0x19c00a, 0x19b480, 0x19a8f7, 0x199d71, 0x1991ec, 0x198669,
    0x197ae7, 0x196f68, 0x1963ea, 0x19586e, 0x194cf3, 0x19417a, 0x193603, 0x192a8e,
    0x191f1a, 0x1913a8, 0x190838, 0x18fcca, 0x18f15d, 0x18e5f2, 0x18da88, 0x18cf21,
    0x18c3bb, 0x18b857, 0x18acf4, 0x18a193, 0x189634, 0x188ad6, 0x187f7b, 0x187420,
    0x1868c8, 0x185d71, 0x18521c, 0x1846c9, 0x183b77, 0x183027, 0x1824d9, 0x18198c,
    0x180e41, 0x1802f8, 0x17f7b0, 0x17ec6b, 0x17e126, 0x17d5e4, 0x17caa3, 0x17bf64,
    0x17b426, 0x17a8ea, 0x179db0, 0x179277, 0x178740, 0x177c0b, 0x1770d7, 0x1765a5,
    0x175a75, 0x174f46, 0x174419, 0x1738ee, 0x172dc4, 0x17229c, 0x171776, 0x170c51,
    0x17012e, 0x16f60d, 0x16eaed, 0x16dfce, 0x16d4b2, 0x16c997, 0x16be7e, 0x16b366,
    0x16a850, 0x169d3c, 0x169229, 0x168718, 0x167c08, 0x1670fa, 0x1665ee, 0x165ae3,
    0x164fda, 0x1644d3, 0x1639cd, 0x162ec9, 0x1623c7, 0x1618c6, 0x160dc6, 0x1602c9,
    0x15f7cc, 0x15ecd2, 0x15e1d9, 0x15d6e2, 0x15cbec, 0x15c0f8, 0x15b606, 0x15ab15,
    0x15a025, 0x159538, 0x158a4c, 0x157f61, 0x157478, 0x156991, 0x155eab, 0x1553c7,
    0x1548e5, 0x153e04, 0x153324, 0x152847, 0x151d6a, 0x151290, 0x1507b7, 0x14fcdf,
    0x14f209, 0x14e735, 0x14dc62, 0x14d191, 0x14c6c2, 0x14bbf4, 0x14b127, 0x14a65c,
    0x149b93, 0x1490cb, 0x148605, 0x147b40, 0x14707d, 0x1465bc, 0x145afc, 0x14503d,
    0x144581, 0x143ac5, 0x14300c, 0x142553, 0x141a9d, 0x140fe8, 0x140534, 0x13fa82,
    0x13efd2, 0x13e523, 0x13da76, 0x13cfca, 0x13c51f, 0x13ba77, 0x13afd0, 0x13a52a,
    0x139a86, 0x138fe3, 0x138542, 0x137aa3, 0x137005, 0x136568, 0x135acd, 0x135034,
    0x13459c, 0x133b06, 0x133071, 0x1325dd, 0x131b4c, 0x1310bb, 0x13062d, 0x12fb9f,
    0x12f114, 0x12e689, 0x12dc01, 0x12d179, 0x12c6f4, 0x12bc6f, 0x12b1ed, 0x12a76c,
    0x129cec, 0x12926e, 0x1287f1, 0x127d76, 0x1272fc, 0x126884, 0x125e0d, 0x125398,
    0x124925, 0x123eb2, 0x123442, 0x1229d2, 0x121f65, 0x1214f9, 0x120a8e, 0x120025,
    0x11f5bd, 0x11eb56, 0x11e0f2, 0x11d68e, 0x11cc2c, 0x11c1cc, 0x11b76d, 0x11ad10,
    0x11a2b4, 0x119859, 0x118e00, 0x1183a9, 0x117953, 0x116efe, 0x1164ab, 0x115a59,
    0x115009, 0x1145ba, 0x113b6d, 0x113121, 0x1126d7, 0x111c8e, 0x111247, 0x110801,
    0x10fdbc, 0x10f379, 0x10e937, 0x10def7, 0x10d4b8, 0x10ca7b, 0x10c03f, 0x10b605,
    0x10abcc, 0x10a195, 0x10975e, 0x108d2a, 0x1082f7, 0x1078c5, 0x106e95, 0x106466,
    0x105a38, 0x10500c, 0x1045e2, 0x103bb9, 0x103191, 0x10276b, 0x101d46, 0x101323,
    0x100901, 0xffee0, 0xff4c1, 0xfeaa3, 0xfe087, 0xfd66c, 0xfcc53, 0xfc23b,
    0xfb824, 0xfae0f, 0xfa3fb, 0xf99e9, 0xf8fd8, 0xf85c8, 0xf7bba, 0xf71ad,
    0xf67a2, 0xf5d98, 0xf538f, 0xf4988, 0xf3f83, 0xf357e, 0xf2b7b, 0xf217a,
    0xf177a, 0xf0d7b, 0xf037e, 0xef982, 0xeef87, 0xee58e, 0xedb97, 0xed1a0,
    0xec7ab, 0xebdb8, 0xeb3c5, 0xea9d5, 0xe9fe5, 0xe95f7, 0xe8c0b, 0xe821f,
    0xe7835, 0xe6e4d, 0xe6466, 0xe5a80, 0xe509c, 0xe46b9, 0xe3cd7, 0xe32f7,
    0xe2918, 0xe1f3a, 0xe155e, 0xe0b83, 0xe01aa, 0xdf7d2, 0xdedfb, 0xde426,
    0xdda52, 0xdd07f, 0xdc6ae, 0xdbcde, 0xdb310, 0xda943, 0xd9f77, 0xd95ac,
    0xd8be3, 0xd821c, 0xd7855, 0xd6e90, 0xd64cc, 0xd5b0a, 0xd5149, 0xd4789,
    0xd3dcb, 0xd340e, 0xd2a52, 0xd2098, 0xd16df, 0xd0d28, 0xd0371, 0xcf9bc,
    0xcf009, 0xce657, 0xcdca6, 0xcd2f6, 0xcc948, 0xcbf9b, 0xcb5ef, 0xcac45,
    0xca29c, 0xc98f4, 0xc8f4e, 0xc85a9, 0xc7c05, 0xc7263, 0xc68c2, 0xc5f22,
    0xc5584, 0xc4be7, 0xc424b, 0xc38b1, 0xc2f18, 0xc2580, 0xc1bea, 0xc1254,
    0xc08c1, 0xbff2e, 0xbf59d, 0xbec0d, 0xbe27e, 0xbd8f1, 0xbcf65, 0xbc5da,
    0xbbc51, 0xbb2c9, 0xba942, 0xb9fbc, 0xb9638, 0xb8cb5, 0xb8334, 0xb79b3,
    0xb7034, 0xb66b7, 0xb5d3a, 0xb53bf, 0xb4a45, 0xb40cd, 0xb3755, 0xb2ddf,
    0xb246b, 0xb1af7, 0xb1185, 0xb0814, 0xafea5, 0xaf536, 0xaebc9, 0xae25d,
    0xad8f3, 0xacf8a, 0xac622, 0xabcbb, 0xab356, 0xaa9f2, 0xaa08f, 0xa972d,
    0xa8dcd, 0xa846e, 0xa7b10, 0xa71b4, 0xa6859, 0xa5eff, 0xa55a6, 0xa4c4f,
    0xa42f8, 0xa39a4, 0xa3050, 0xa26fe, 0xa1dac, 0xa145d, 0xa0b0e, 0xa01c1,
    0x9f874, 0x9ef2a, 0x9e5e0, 0x9dc98, 0x9d350, 0x9ca0b, 0x9c0c6, 0x9b783,
    0x9ae41, 0x9a500, 0x99bc0, 0x99282, 0x98944, 0x98009, 0x976ce, 0x96d95,
    0x9645c, 0x95b25, 0x951f0, 0x948bb, 0x93f88, 0x93656, 0x92d25, 0x923f6,
    0x91ac7, 0x9119a, 0x9086e, 0x8ff44, 0x8f61a, 0x8ecf2, 0x8e3cb, 0x8daa5,
    0x8d181, 0x8c85e, 0x8bf3b, 0x8b61b, 0x8acfb, 0x8a3dd, 0x89abf, 0x891a3,
    0x88889, 0x87f6f, 0x87657, 0x86d3f, 0x8642a, 0x85b15, 0x85201, 0x848ef,
    0x83fde, 0x836ce, 0x82dbf, 0x824b2, 0x81ba6, 0x8129b, 0x80991, 0x80088,
    0x7f781, 0x7ee7a, 0x7e575, 0x7dc71, 0x7d36f, 0x7ca6d, 0x7c16d, 0x7b86e,
    0x7af70, 0x7a673, 0x79d78, 0x7947d, 0x78b84, 0x7828c, 0x77995, 0x770a0,
    0x767ab, 0x75eb8, 0x755c6, 0x74cd5, 0x743e6, 0x73af7, 0x7320a, 0x7291e,
    0x72033, 0x71749, 0x70e60, 0x70579, 0x6fc93, 0x6f3ae, 0x6eaca, 0x6e1e7,
    0x6d905, 0x6d025, 0x6c746, 0x6be68, 0x6b58b, 0x6acaf, 0x6a3d4, 0x69afb,
    0x69223, 0x6894c, 0x68076, 0x677a1, 0x66ecd, 0x665fb, 0x65d2a, 0x65459,
    0x64b8a, 0x642bd, 0x639f0, 0x63124, 0x6285a, 0x61f91, 0x616c9, 0x60e02,
    0x6053c, 0x5fc78, 0x5f3b4, 0x5eaf2, 0x5e231, 0x5d971, 0x5d0b2, 0x5c7f4,
    0x5bf37, 0x5b67c, 0x5adc2, 0x5a508, 0x59c50, 0x59399, 0x58ae4, 0x5822f,
    0x5797c, 0x570c9, 0x56818, 0x55f68, 0x556b9, 0x54e0b, 0x5455e, 0x53cb3,
    0x53408, 0x52b5f, 0x522b7, 0x51a10, 0x5116a, 0x508c5, 0x50021, 0x4f77f,
    0x4eedd, 0x4e63d, 0x4dd9e, 0x4d500, 0x4cc63, 0x4c3c7, 0x4bb2c, 0x4b292,
    0x4a9fa, 0x4a162, 0x498cc, 0x49037, 0x487a3, 0x47f10, 0x4767e, 0x46ded,
    0x4655e, 0x45ccf, 0x45442, 0x44bb5, 0x4432a, 0x43aa0, 0x43217, 0x4298f,
    0x42108, 0x41883, 0x40ffe, 0x4077a, 0x3fef8, 0x3f677, 0x3edf6, 0x3e577,
    0x3dcf9, 0x3d47c, 0x3cc01, 0x3c386, 0x3bb0c, 0x3b294, 0x3aa1c, 0x3a1a6,
    0x39930, 0x390bc, 0x38849, 0x37fd7, 0x37766, 0x36ef6, 0x36687, 0x35e1a,
    0x355ad, 0x34d41, 0x344d7, 0x33c6d, 0x33405, 0x32b9e, 0x32338, 0x31ad3,
    0x3126f, 0x30a0c, 0x301aa, 0x2f949, 0x2f0e9, 0x2e88b, 0x2e02d, 0x2d7d0,
    0x2cf75, 0x2c71b, 0x2bec1, 0x2b669, 0x2ae12, 0x2a5bc, 0x29d67, 0x29513,
    0x28cc0, 0x2846e, 0x27c1d, 0x273cd, 0x26b7f, 0x26331, 0x25ae4, 0x25299,
    0x24a4e, 0x24205, 0x239bd, 0x23175, 0x2292f, 0x220ea, 0x218a6, 0x21063,
    0x20821, 0x1ffe0, 0x1f7a0, 0x1ef61, 0x1e723, 0x1dee6, 0x1d6aa, 0x1ce6f,
    0x1c636, 0x1bdfd, 0x1b5c5, 0x1ad8f, 0x1a559, 0x19d25, 0x194f1, 0x18cbf,
    0x1848e, 0x17c5d, 0x1742e, 0x16c00, 0x163d3, 0x15ba6, 0x1537b, 0x14b51,
    0x14328, 0x13b00, 0x132d9, 0x12ab3, 0x1228e, 0x11a6a, 0x11247, 0x10a25,
    0x10204, 0xf9e4, 0xf1c5, 0xe9a7, 0xe18b, 0xd96f, 0xd154, 0xc93a,
    0xc122, 0xb90a, 0xb0f3, 0xa8de, 0xa0c9, 0x98b5, 0x90a3, 0x8891,
    0x8081, 0x7871, 0x7062, 0x6855, 0x6048, 0x583d, 0x5032, 0x4829,
    0x4020, 0x3819, 0x3012, 0x280d, 0x2008, 0x1805, 0x1002, 0x801
};
#endif
