/*
Copyright (C) 2002-2013  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.*/

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
extern int indent;
extern int indentlevel;
void gencastf(FILE *fout, int n, int nt, int f)
{
  int t=tree[n].t;
  int tnt=typemax[t][nt];
  int i;
  if (t==nt)
  {
    /*bottom of the recursion*/
    if (f)
      genparens(fout,n);
    else
      gencode(fout,n);
    return;
  }
  if (gencastcode(fout,n,t,nt,f))
    return;
  /*the interesting case */
  if (is_subtype(t,nt))
    for (i=0;i<s_GPtype.n;i++)
      if (is_subtype(t,i) && is_subtype(i,nt))
        if (gencastcode(fout,n,i,nt,f))
          return;
  if (is_subtype(nt,t))
    for (i=0;i<s_GPtype.n;i++)
      if (is_subtype(i,t) && is_subtype(nt,i))
        if (gencastcode(fout,n,i,nt,f))
          return;
  if (gencastcode(fout,n,tnt,nt,f))
    return;
  if (debug)
    warning(-1,"No conversion method defined for %s->%s",GPname(t),GPname(nt));
  for(i=0;i<s_GPtype.n;i++)
    if ( is_subtype(i,tnt) && is_subtype(nt,i))
      if (gencastcode(fout,n,i,nt,f))
          return;
  die(-1,"No conversion method defined for %s->%s",GPname(t),GPname(nt));
}

void gencast(FILE *fout, int n, int nt)
{
  if (nt<s_GPtype.n)
    gencastf(fout,n,nt,0);
  else
    gencode(fout,n);
}

int gencastcode(FILE *fout, int n, int t, int nt, int f)
{
  int i;
  gpfunc *gp=lfunc+FC_cast;
  gpdesc *dsc=gp->dsc;
  for(i=0; i<dsc->nb; i++)
  {
    gpdescarg *rule=dsc->a+i;
    descargatom atom=rule->args[0];
    if (rule->type!=nt || (atom.mode&tree[n].m)!=atom.mode)
      continue;
    switch(atom.t)
    {
    case AAherevalue:
      if(tree[n].f!=Fsmall && tree[n].f!=Fconst) continue;
    case AAtype:
      if(atom.type!=t) continue;
      break;
    case AAsmall:
      if (tree[n].f!=Fsmall || atom.misc!=tree[n].x) continue;
      break;
    default:
      continue;
    }
    if (rule->cname[0]==0)
      gencastf(fout,n,t,f);
    else
    {
      if (f && rule->mode&(1<<Mparens))
        fprintf(fout,"(");
      gencodedesc(fout,1,&n,rule,n,FC_cast);
      if (f && rule->mode&(1<<Mparens))
        fprintf(fout,")");
    }
    return 1;
  }
  return 0;
}
