GOPHIAN(1)

# NAME

gophian - Tools to help with Debianizing Go software

# SYNOPSIS

*gophian* <SUBCOMMAND> [OPTIONS]

# DESCRIPTION

The currently recommended dh-make-golang tool is known to be unreliable and
relies on various outdated and deprecated libraries to function. Gophian seeks
to change that by providing a tool that works out of the box, as well as adding
on more features and more intelligence to improve the Go packaging experience.
It achieves this by replicating the functionality of "go get", avoiding the need
to rely on the golang.org/x/tools/go/vcs library.

So you want to package some nifty piece of software you found, and it's written
in Go? Look no further than Gophian! To start out, make sure that it hasn't
already been packaged using _https://packages.debian.org_ or "apt search".
Ensure that there isn't already an existing effort by checking for any open
Intent to Package (ITP) bugs using _wnpp-check_(1).

Next, you'll want to use _gophian-estimate_(1) to estimate the amount of work
that will be needed to package this software for Debian. This subcommand will
list any dependencies that are not available as packages in Debian yet in a tree
format. _gophian-estimate-graphviz_(1) may also be useful to create a visual
tree with Graphviz, especially for large or complex dependency graphs.

Then, you can use _gophian-make_(1) to prepare some initial Debian packaging for
the software, including setting up a Git repo, importing the latest upstream
version, and creating some packaging templates, inferring and filling in values
for you when available. Refer to _gophian-make_(1) for an in-depth explanation
of this subcommand's use.

Refer to the individual subcommand manual pages for more detailed information.

# SUBCOMMANDS

*create-salsa-repo* - See _gophian-create-salsa-repo_(1)

*estimate* - See _gophian-estimate_(1)

*estimate-graphviz* - See _gophian-estimate-graphviz_(1)

*license-text* - See _gophian-license-text_(1)

*make* - See _gophian-make_(1)

*search* - See _gophian-search_(1)

*show* - See _gophian-show_(1)

# OPTIONS

*--version* - Print version and exit.

*--copyright* - Print copyright notice and exit.

*--help* - Show help message and exit.

# ENVIRONMENT

The gophian utility supports the standard _DEBFULLNAME_ and _DEBEMAIL_
environment variables. See _devscripts_(1) for more information about these
variables.

# AUTHORS

Maintained by Maytham Alsudany <maytha8thedev@gmail.com>.

# REPORTING BUGS

Please submit bugs to https://codeberg.org/Maytha8/gophian/issues.
Alternatively, you may send an email directly to the author, see *AUTHORS*.

# SEE ALSO

_gophian-create-salsa-repo_(1), _gophian-estimate_(1),
_gophian-estimate-graphviz_(1), _gophian-license-text_(1), _gophian-make_(1),
_gophian-search_(1), _gophian-show_(1)
