/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import java.math.BigDecimal;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusEnvironmentPcc
extends AntPlusCommonPcc {
    ITemperatureDataReceiver mTemperatureDataReceiver;

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 0;
    }

    public static PccReleaseHandle<AntPlusEnvironmentPcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusEnvironmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusEnvironmentPcc potentialRetObj = new AntPlusEnvironmentPcc();
        return AntPlusEnvironmentPcc.requestAccess_Helper_SearchActivity(userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusEnvironmentPcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusEnvironmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusEnvironmentPcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusEnvironmentPcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusEnvironmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusEnvironmentPcc potentialRetObj = new AntPlusEnvironmentPcc();
        return AntPlusEnvironmentPcc.requestAccess_Helper_AsyncSearchByDevNumber(bindToContext, antDeviceNumber, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static AsyncScanController<AntPlusEnvironmentPcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver) {
        AntPlusEnvironmentPcc potentialRetObj = new AntPlusEnvironmentPcc();
        return AntPlusEnvironmentPcc.requestAccess_Helper_AsyncScanController(bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusEnvironmentPcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.environment.EnvironmentService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Environment";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mTemperatureDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal currentTemperature = (BigDecimal)b.getSerializable("decimal_currentTemperature");
                long eventCount = b.getLong("long_eventCount");
                BigDecimal lowLast24Hours = (BigDecimal)b.getSerializable("decimal_lowLast24Hours");
                BigDecimal highLast24Hours = (BigDecimal)b.getSerializable("decimal_highLast24Hours");
                this.mTemperatureDataReceiver.onNewTemperatureData(estTimestamp, eventFlags, currentTemperature, eventCount, lowLast24Hours, highLast24Hours);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeTemperatureDataEvent(ITemperatureDataReceiver TemperatureDataReceiver) {
        this.mTemperatureDataReceiver = TemperatureDataReceiver;
        if (TemperatureDataReceiver != null) {
            this.subscribeToEvent(201);
        } else {
            this.unsubscribeFromEvent(201);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITemperatureDataReceiver {
        public void onNewTemperatureData(long var1, EnumSet<EventFlag> var3, BigDecimal var4, long var5, BigDecimal var7, BigDecimal var8);
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_ENVIRONMENTPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_ENVIRONMENTPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.environment.EnvironmentService";
        public static final int MSG_EVENT_ENVIRONMENT_whatTEMPERATUREDATA = 201;
        public static final String MSG_EVENT_ENVIRONMENT_TEMPERATUREDATA_PARAM_decimalCURRENTTEMPERATURE = "decimal_currentTemperature";
        public static final String MSG_EVENT_ENVIRONMENT_TEMPERATUREDATA_PARAM_longEVENTCOUNT = "long_eventCount";
        public static final String MSG_EVENT_ENVIRONMENT_TEMPERATUREDATA_PARAM_decimalLOWLAST24HOURS = "decimal_lowLast24Hours";
        public static final String MSG_EVENT_ENVIRONMENT_TEMPERATUREDATA_PARAM_decimalHIGHLAST24HOURS = "decimal_highLast24Hours";
    }
}

