package batch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccountKeyType enumerates the values for account key type.
type AccountKeyType string

const (
	// Primary ...
	Primary AccountKeyType = "Primary"
	// Secondary ...
	Secondary AccountKeyType = "Secondary"
)

// PossibleAccountKeyTypeValues returns an array of possible values for the AccountKeyType const type.
func PossibleAccountKeyTypeValues() []AccountKeyType {
	return []AccountKeyType{Primary, Secondary}
}

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "Resizing"
	// Steady ...
	Steady AllocationState = "Steady"
	// Stopping ...
	Stopping AllocationState = "Stopping"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady, Stopping}
}

// AutoUserScope enumerates the values for auto user scope.
type AutoUserScope string

const (
	// AutoUserScopePool ...
	AutoUserScopePool AutoUserScope = "Pool"
	// AutoUserScopeTask ...
	AutoUserScopeTask AutoUserScope = "Task"
)

// PossibleAutoUserScopeValues returns an array of possible values for the AutoUserScope const type.
func PossibleAutoUserScopeValues() []AutoUserScope {
	return []AutoUserScope{AutoUserScopePool, AutoUserScopeTask}
}

// CachingType enumerates the values for caching type.
type CachingType string

const (
	// None ...
	None CachingType = "None"
	// ReadOnly ...
	ReadOnly CachingType = "ReadOnly"
	// ReadWrite ...
	ReadWrite CachingType = "ReadWrite"
)

// PossibleCachingTypeValues returns an array of possible values for the CachingType const type.
func PossibleCachingTypeValues() []CachingType {
	return []CachingType{None, ReadOnly, ReadWrite}
}

// CertificateFormat enumerates the values for certificate format.
type CertificateFormat string

const (
	// Cer ...
	Cer CertificateFormat = "Cer"
	// Pfx ...
	Pfx CertificateFormat = "Pfx"
)

// PossibleCertificateFormatValues returns an array of possible values for the CertificateFormat const type.
func PossibleCertificateFormatValues() []CertificateFormat {
	return []CertificateFormat{Cer, Pfx}
}

// CertificateProvisioningState enumerates the values for certificate provisioning state.
type CertificateProvisioningState string

const (
	// Deleting ...
	Deleting CertificateProvisioningState = "Deleting"
	// Failed ...
	Failed CertificateProvisioningState = "Failed"
	// Succeeded ...
	Succeeded CertificateProvisioningState = "Succeeded"
)

// PossibleCertificateProvisioningStateValues returns an array of possible values for the CertificateProvisioningState const type.
func PossibleCertificateProvisioningStateValues() []CertificateProvisioningState {
	return []CertificateProvisioningState{Deleting, Failed, Succeeded}
}

// CertificateStoreLocation enumerates the values for certificate store location.
type CertificateStoreLocation string

const (
	// CurrentUser ...
	CurrentUser CertificateStoreLocation = "CurrentUser"
	// LocalMachine ...
	LocalMachine CertificateStoreLocation = "LocalMachine"
)

// PossibleCertificateStoreLocationValues returns an array of possible values for the CertificateStoreLocation const type.
func PossibleCertificateStoreLocationValues() []CertificateStoreLocation {
	return []CertificateStoreLocation{CurrentUser, LocalMachine}
}

// CertificateVisibility enumerates the values for certificate visibility.
type CertificateVisibility string

const (
	// CertificateVisibilityRemoteUser ...
	CertificateVisibilityRemoteUser CertificateVisibility = "RemoteUser"
	// CertificateVisibilityStartTask ...
	CertificateVisibilityStartTask CertificateVisibility = "StartTask"
	// CertificateVisibilityTask ...
	CertificateVisibilityTask CertificateVisibility = "Task"
)

// PossibleCertificateVisibilityValues returns an array of possible values for the CertificateVisibility const type.
func PossibleCertificateVisibilityValues() []CertificateVisibility {
	return []CertificateVisibility{CertificateVisibilityRemoteUser, CertificateVisibilityStartTask, CertificateVisibilityTask}
}

// ComputeNodeDeallocationOption enumerates the values for compute node deallocation option.
type ComputeNodeDeallocationOption string

const (
	// Requeue ...
	Requeue ComputeNodeDeallocationOption = "Requeue"
	// RetainedData ...
	RetainedData ComputeNodeDeallocationOption = "RetainedData"
	// TaskCompletion ...
	TaskCompletion ComputeNodeDeallocationOption = "TaskCompletion"
	// Terminate ...
	Terminate ComputeNodeDeallocationOption = "Terminate"
)

// PossibleComputeNodeDeallocationOptionValues returns an array of possible values for the ComputeNodeDeallocationOption const type.
func PossibleComputeNodeDeallocationOptionValues() []ComputeNodeDeallocationOption {
	return []ComputeNodeDeallocationOption{Requeue, RetainedData, TaskCompletion, Terminate}
}

// ComputeNodeFillType enumerates the values for compute node fill type.
type ComputeNodeFillType string

const (
	// Pack ...
	Pack ComputeNodeFillType = "Pack"
	// Spread ...
	Spread ComputeNodeFillType = "Spread"
)

// PossibleComputeNodeFillTypeValues returns an array of possible values for the ComputeNodeFillType const type.
func PossibleComputeNodeFillTypeValues() []ComputeNodeFillType {
	return []ComputeNodeFillType{Pack, Spread}
}

// ElevationLevel enumerates the values for elevation level.
type ElevationLevel string

const (
	// Admin ...
	Admin ElevationLevel = "Admin"
	// NonAdmin ...
	NonAdmin ElevationLevel = "NonAdmin"
)

// PossibleElevationLevelValues returns an array of possible values for the ElevationLevel const type.
func PossibleElevationLevelValues() []ElevationLevel {
	return []ElevationLevel{Admin, NonAdmin}
}

// InboundEndpointProtocol enumerates the values for inbound endpoint protocol.
type InboundEndpointProtocol string

const (
	// TCP ...
	TCP InboundEndpointProtocol = "TCP"
	// UDP ...
	UDP InboundEndpointProtocol = "UDP"
)

// PossibleInboundEndpointProtocolValues returns an array of possible values for the InboundEndpointProtocol const type.
func PossibleInboundEndpointProtocolValues() []InboundEndpointProtocol {
	return []InboundEndpointProtocol{TCP, UDP}
}

// InterNodeCommunicationState enumerates the values for inter node communication state.
type InterNodeCommunicationState string

const (
	// Disabled ...
	Disabled InterNodeCommunicationState = "Disabled"
	// Enabled ...
	Enabled InterNodeCommunicationState = "Enabled"
)

// PossibleInterNodeCommunicationStateValues returns an array of possible values for the InterNodeCommunicationState const type.
func PossibleInterNodeCommunicationStateValues() []InterNodeCommunicationState {
	return []InterNodeCommunicationState{Disabled, Enabled}
}

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid NameAvailabilityReason = "Invalid"
)

// PossibleNameAvailabilityReasonValues returns an array of possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{AlreadyExists, Invalid}
}

// NetworkSecurityGroupRuleAccess enumerates the values for network security group rule access.
type NetworkSecurityGroupRuleAccess string

const (
	// Allow ...
	Allow NetworkSecurityGroupRuleAccess = "Allow"
	// Deny ...
	Deny NetworkSecurityGroupRuleAccess = "Deny"
)

// PossibleNetworkSecurityGroupRuleAccessValues returns an array of possible values for the NetworkSecurityGroupRuleAccess const type.
func PossibleNetworkSecurityGroupRuleAccessValues() []NetworkSecurityGroupRuleAccess {
	return []NetworkSecurityGroupRuleAccess{Allow, Deny}
}

// PackageState enumerates the values for package state.
type PackageState string

const (
	// Active ...
	Active PackageState = "Active"
	// Pending ...
	Pending PackageState = "Pending"
	// Unmapped ...
	Unmapped PackageState = "Unmapped"
)

// PossiblePackageStateValues returns an array of possible values for the PackageState const type.
func PossiblePackageStateValues() []PackageState {
	return []PackageState{Active, Pending, Unmapped}
}

// PoolAllocationMode enumerates the values for pool allocation mode.
type PoolAllocationMode string

const (
	// BatchService ...
	BatchService PoolAllocationMode = "BatchService"
	// UserSubscription ...
	UserSubscription PoolAllocationMode = "UserSubscription"
)

// PossiblePoolAllocationModeValues returns an array of possible values for the PoolAllocationMode const type.
func PossiblePoolAllocationModeValues() []PoolAllocationMode {
	return []PoolAllocationMode{BatchService, UserSubscription}
}

// PoolProvisioningState enumerates the values for pool provisioning state.
type PoolProvisioningState string

const (
	// PoolProvisioningStateDeleting ...
	PoolProvisioningStateDeleting PoolProvisioningState = "Deleting"
	// PoolProvisioningStateSucceeded ...
	PoolProvisioningStateSucceeded PoolProvisioningState = "Succeeded"
)

// PossiblePoolProvisioningStateValues returns an array of possible values for the PoolProvisioningState const type.
func PossiblePoolProvisioningStateValues() []PoolProvisioningState {
	return []PoolProvisioningState{PoolProvisioningStateDeleting, PoolProvisioningStateSucceeded}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCancelled ...
	ProvisioningStateCancelled ProvisioningState = "Cancelled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInvalid ...
	ProvisioningStateInvalid ProvisioningState = "Invalid"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCancelled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateInvalid, ProvisioningStateSucceeded}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// PremiumLRS ...
	PremiumLRS StorageAccountType = "Premium_LRS"
	// StandardLRS ...
	StandardLRS StorageAccountType = "Standard_LRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{PremiumLRS, StandardLRS}
}
