#ifndef __GM_TEXT_SCROLLER_H__
#define __GM_TEXT_SCROLLER_H__

#include <glib-object.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_TEXT_SCROLLER				(gm_text_scroller_get_type())
#define GM_TEXT_SCROLLER(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_TEXT_SCROLLER, GmTextScroller))
#define GM_TEXT_SCROLLER_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_TEXT_SCROLLER, GmTextScroller const))
#define GM_TEXT_SCROLLER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GM_TYPE_TEXT_SCROLLER, GmTextScrollerClass))
#define GM_IS_TEXT_SCROLLER(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), GM_TYPE_TEXT_SCROLLER))
#define GM_IS_TEXT_SCROLLER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GM_TYPE_TEXT_SCROLLER))
#define GM_TEXT_SCROLLER_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GM_TYPE_TEXT_SCROLLER, GmTextScrollerClass))

/* Private structure type */
typedef struct _GmTextScrollerPrivate GmTextScrollerPrivate;

/*
 * Main object structure
 */
typedef struct _GmTextScroller GmTextScroller;
 
struct _GmTextScroller {
	GObject parent;
	
	/*< private > */
	GmTextScrollerPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmTextScrollerClass 	GmTextScrollerClass;

struct _GmTextScrollerClass {
	GObjectClass parent_class;

	/* Signals
	void (* proto) (GmTextScroller *obj); */
};

GType gm_text_scroller_get_type(void) G_GNUC_CONST;
GmTextScroller *gm_text_scroller_new(GtkTextView *text_view);
void gm_text_scroller_scroll_end(GmTextScroller *scroller);
void gm_text_scroller_scroll_begin(GmTextScroller *scroller);
void gm_text_scroller_scroll_page(GmTextScroller *scroller, gint direction);

G_END_DECLS
#endif /* __GM_TEXT_SCROLLER_H__ */
