#ifndef __GM_DEBUG_H__
#define __GM_DEBUG_H__ 1

typedef enum _GmDebugLevel {
	DEBUG_ALWAYS = 1 << 1,
	DEBUG_DEFAULT = 1 << 2,
	DEBUG_MCP = 1 << 3,
	DEBUG_ALL = 0xFFFF
} GmDebugLevel;

#define GM_DEBUG(format, args...) gm_debug_msg(DEBUG_ALWAYS, format, ##args)

void gm_debug_msg(gint level, char *line, ...);
void gm_debug_set_level(gchar *level);

#endif /* __GM_DEBUG_H__ */
