/*
  gmod - derived from gmorgan: ryhthm station software

  main.c  -  Main file of gmod. 
  Bob Vogel. vogel at ct dot metrocast dot net.

  Adapted from gmorgan. 
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#include <locale.h>
#include <getopt.h>
#include <sched.h>
#include <sys/mman.h>
#include "GMorgan.h"
#include "NotGenerated.h"
#include <iostream>
#include <map>
#include <vector>
#include <string>
using namespace std;

#include "gmorgan.chord.cpp"
GMO gmo;
SPLASH splh;
GMORGAN *gmoUI = new GMORGAN(&gmo);
Fl_Box* BarBox[128];
int LastBar;
void pon_realtime()

{
    sched_param scprior;

    scprior.sched_priority=50;
    int prior=sched_setscheduler(0,SCHED_FIFO,&scprior);
    if (prior==0) printf("SCHED_FIFO\n");

};

int loadcount = 0;

CHORD zing;

int main(int argc, char *argv[])
{
  setlocale(LC_ALL, "");
  bindtextdomain("gmorgan", LOCALEDIR);
  textdomain("gmorgan");


  fprintf (stderr,
	   gettext("gmod v0.59 - Copyright (c) 2003-2004 Josep Andreu (Holborn) ... modifications by Robert Vogel 2011\n"));
  if (argc == 1)
    fprintf (stderr, gettext("Try 'gmorgan --help' for command-line options.\n"));


  struct option opts[] = {
    {"drump",2,NULL, 'd'}, 
    {"preset", 2,NULL, 'p'},
    {"load", 1, NULL, 'l'},
    {"bank", 1, NULL, 'b'},
    {"rhyt", 1, NULL, 'r'},
    {"help", 0, NULL, 'h'},
    {0, 0, 0, 0}
  };

  
  Pexitprogram = 0;

   opterr = 0;
  int option_index = 0, opt, exitwithhelp = 0;
  while (1)
    {
      opt = getopt_long (argc, argv, "d:p:l:b:r:h", opts, &option_index);
      char *optarguments = optarg;
      
      if (opt == -1)
	break;


      switch (opt)
	{
	case 'h':
	  exitwithhelp = 1;
	  break;
        case 'd':
           if (optarguments != NULL)
           {
              gmo.loaddrumset(optarguments);
              break; 
           }

        case 'p':
          if (optarguments != NULL)
           {
              gmo.loadpreset(optarguments);
              break; 
           }                                 
	case 'l':
	  if (optarguments != NULL)
	    {
              gmo.prime=1;
              gmo.ulti=100;
              gmo.loadstyl(optarguments);
	      break;
	    }
        case 'r' :
            if (optarguments != NULL)
            {
              gmo.prime=1;
              gmo.ulti=500;
              gmo.loadpatt (optarguments);
              break;
            }

	case 'b':
	  if (optarguments != NULL)
	    {
              gmo.prime=1;
              gmo.ulti=100;
	      gmo.loadfile(optarguments);
              break;
	    }


	};
    };

  if (exitwithhelp != 0)
    {
      fprintf (stderr, gettext("Usage: gmorgan [OPTION]\n\n"));
      fprintf (stderr, gettext("  -h       --help \t\t\t display command-line help and exit\n"));
      fprintf (stderr, gettext("  -d File, --drump=File \t\t loads the drum map file list\n"));
      fprintf (stderr, gettext("  -p File, --preset=File \t\t loads the preset file list\n"));
      fprintf (stderr, gettext("  -l File, --load=File \t\t\t loads the Styles\n"));
      fprintf (stderr, gettext("  -b File, --bank=File \t\t\t loads the Sound Bank\n"));
      fprintf (stderr, gettext("  -r File, --rhyt=File \t\t\t loads the Patterns\n"));

      fprintf (stderr, "\n\n");
      return (0);
    };

  SPLASH   *splhUI = new SPLASH();
  splhUI->splashwin->show();
// it was here.


mlockall(MCL_CURRENT | MCL_FUTURE);
pon_realtime();

std::string oldchordout = "";
// rlv instantiate the initial chord, c7.
  zing.CurrentKey = "C7";
zing.RinitChordtable = 1;
// zing.DumpChordTable();
// ***************************************************************************************
// main loop:
// ***************************************************************************************
  while (Pexitprogram == 0)
    {  
      Fl::wait();
      gmo.miramidi();
      gmo.organo();
      if (gmo.reproduccion) gmo.EPlay();

     if (splash == 1) 
     {
            splashcounter++;
     
            if ((clicksplash == 1 ) || (splashcounter > 500)) 
                {
                  splhUI->splashwin->hide();
                  splhUI->splashwin->clear();
                  splash = 0;
 		  gmoUI->gmorganwin->show();
                  delete splhUI;
 		  Fl::focus(gmoUI->StartStop);
                }
     }

 if (vumvum != vum) gmoUI->VUI1->value(vum);
 int moveit = 0;
  if ((gmo.stst) && (ulcount != count))
     {
      ulcount = count;
      S[1].pattern = (int)gmoUI->PtBro->value();
      int rvtempo = gmoUI->CTEMPO->value();
	if (gmo.bplay != 1)
	{
	gmo.TemT[1].tempo = rvtempo;
	TempoSong = rvtempo;
	}
	else
	{
	gmoUI->CTEMPO->value(TempoSong);
	}
      std::string chordout = zing.GetCurrentChordsym();
      if (chordout == oldchordout)
	 {moveit = 0;}
      else
	 {
	 oldchordout = chordout;
	 moveit = 1;
	 }		
      int nbar = gmo.ncompas;		
      ++nbar;	

      if (gmo.bplay == 1 && nbar ==1)
         {
	 LastBar = 1;
 	 gmoUI->LightIt(gmo.nb);
         }
	if (nbar > 127) nbar = 127;	
      switch(count)
      {
         case 1:
                gmoUI->N1->setonly();
                gmoUI->DispBlack->label(gmo.elbart);
                if (gmo.bplay == 1)
                 {
                 gmoUI->BDispBlack->label(gmo.elbart);
                 gmoUI->Dispnb->label(gmo.elnb);
                 gmoUI->LaBarra->value(gmo.nb);
                 }
		else
		{
		strcpy(S[nbar].ch1,chordout.c_str());
		}
                if (gmo.BPW) gmoUI->BPN1->setonly();
                 break;
         case 2:
                gmoUI->N2->setonly();
                if (gmo.BPW) gmoUI->BPN2->setonly();
                if (gmo.bplay != 1)
		{
		strcpy(S[nbar].ch2,chordout.c_str());
		}
                break;
         case 3:  
                gmoUI->N3->setonly();
                if (gmo.BPW) gmoUI->BPN3->setonly();
                if (gmo.bplay != 1)
		{
		strcpy(S[nbar].ch3,chordout.c_str());
		}
                break;
         case 4:
                gmoUI->N4->setonly();
                if (gmo.BPW) gmoUI->BPN4->setonly();       
// this is early, but it seems to work better. 
                if (gmo.bplay == 1)
                 {
	  	 gmoUI->LightIt(gmo.nb+1);
		 LastBar = gmo.nb+1;
                 }
		else
		{
		strcpy(S[nbar].ch4,chordout.c_str());
		}
                break;
       }
      }
// If at the end, wrap back to the beginning.
      if (actunex == 1)
       {
       gmoUI->ApagaNex();
       actunex = 0;
       }
// final ending.
      if (ponfin ==1)
       {
       gmoUI->ApagaSt();
       gmo.bplay = 0;
       ponfin=0;
       }
// Chord change.
      if (cambialo == 1) 
      {
       gmoUI->ACI->label(NombreAcorde);
       if (gmo.KeybON) gmo.GeneraChord();
       cambialo = 0;
      }

      if (programa != 0)
	{ 
      	  gmoUI->PutCombi (programa);
	  programa = 0;
	}

      if (ttnp != 0) gmoUI->prepsig();

      if (cambiapat !=0)
          {
           gmoUI->metemixerpat();
           cambiapat = 0;
          }
   
     if (tocadrum != 0)
  	{
 	    gmo.suenaev(9,tocadrum,127);
	     tocadrum = 0;
  	}

    if (paraplay) gmoUI->StopPlay();

    if ((gmo.bplay) && (gmo.cambiaacorde))
        {
         gmo.cambiaacorde = 0;
         gmoUI->NomElacorde->value(gmo.Delacorde);
        }

    if (cambiacasdr)
        {
         cambiacasdr = 0;
         gmoUI->PonColores(lastcasdr);
        }

    if (cambiacascr)
        {
         cambiacascr = 0;
         gmoUI->PonColores2(lastcascr);
        }

         
    }

  delete gmoUI;

};
void
GMO::loadsound(char *filename)
{
   FILE *fs;
   char temp[128];
   int i;
   int j;
   int k;
   bzero(temp,sizeof(temp));
  cout << " loadsound: " << filename << endl;
  if ((fs = fopen (filename, "r")) != NULL)
   {
      for(i=prime; i<=ulti; i++)
       {
         bzero(Prog[i].Nom,sizeof(Prog[i].Nom));
         bzero(temp,sizeof(temp));
         fgets(temp, sizeof temp, fs);
         for (k = 0; k <= (int) strlen(temp) - 2; k++) Prog[i].Nom[k] = temp[k];
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&Prog[i].style,&Prog[i].pattern,&Prog[i].bpm,&Prog[i].transpose);

         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v1lowVelocity,&v1highVelocity,&v1lowMidi,&v1highMidi);
         gmoUI->v1HighVel->value(v1highVelocity);  
         gmoUI->v1LowVelocity->value(v1lowVelocity);  
         gmoUI->v1HighMidi->value(v1highMidi);  
         gmoUI->v1LowMidi->value(v1lowMidi);  

         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v2lowVelocity,&v2highVelocity,&v2lowMidi,&v2highMidi);
         gmoUI->v2HighVel->value(v2highVelocity);  
         gmoUI->v2LowVelocity->value(v2lowVelocity);  
         gmoUI->v2HighMidi->value(v2highMidi);  
         gmoUI->v2LowMidi->value(v2lowMidi);  

         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v3lowVelocity,&v3highVelocity,&v3lowMidi,&v3highMidi);
         gmoUI->v3HighVel->value(v3highVelocity);  
         gmoUI->v3LowVelocity->value(v3lowVelocity);  
         gmoUI->v3HighMidi->value(v3highMidi);  
         gmoUI->v3LowMidi->value(v3lowMidi);  

         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&v4lowVelocity,&v4highVelocity,&v4lowMidi,&v4highMidi);
         gmoUI->v4HighVel->value(v4highVelocity);  
         gmoUI->v4LowVelocity->value(v4lowVelocity);  
         gmoUI->v4HighMidi->value(v4highMidi);  
         gmoUI->v4LowMidi->value(v4lowMidi);  

         for (j=1; j<=4; j++)
         {
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&Prog[i].progch[j],&Prog[i].volume[j],&Prog[i].BankLSB[j],&Prog[i].BankMSB[j]);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d,%d",&Prog[i].pan[j],&Prog[i].Pon[j],&Prog[i].reverb[j],&Prog[i].chorus[j]);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         sscanf(temp,"%d,%d,%d",&Prog[i].Ptime[j],&Prog[i].OnOff[j],&Prog[i].octa[j]);
         bzero(temp,sizeof(temp));
         fgets(temp,sizeof temp, fs);
         }
       }
    }
};	
