/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.io;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.io.ContentHandler;
import hypergraph.graphApi.io.SAXReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphXMLContentHandler
extends DefaultHandler
implements ContentHandler {
    private SAXReader reader;
    protected Graph graph;
    protected Element currentElement;
    protected StringBuffer currentText;

    public void setReader(SAXReader sAXReader) {
        this.reader = sAXReader;
    }

    public SAXReader getReader() {
        return this.reader;
    }

    public void endDocument() throws SAXException {
        this.reader.setGraph(this.graph);
    }

    protected void startElementGraph(Attributes attributes) {
        this.graph = this.reader.getGraphSystem().createGraph();
    }

    protected void endElementGraph() {
    }

    protected void startElementNode(Attributes attributes) {
        String string = null;
        Group group = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2;
            if (attributes.getQName(i).equals("name")) {
                string = attributes.getValue(i);
                continue;
            }
            if (!attributes.getQName(i).equals("class") || (string2 = attributes.getValue(i)) == null || string2.length() <= 0 || (group = (Group)this.graph.getElement(string2)) != null) continue;
            try {
                group = this.graph.createGroup(string2);
                continue;
            }
            catch (GraphException graphException) {
                graphException.printStackTrace();
            }
        }
        try {
            this.currentElement = this.graph.createNode(string);
            if (group != null) {
                this.currentElement.setGroup(group);
            }
        }
        catch (GraphException graphException) {
            graphException.printStackTrace();
        }
    }

    protected void endElementNode() {
        this.currentElement = null;
    }

    protected void startElementEdge(Attributes attributes) {
        String string = null;
        Group group = null;
        Node node = null;
        Node node2 = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2;
            if (attributes.getQName(i).equals("name")) {
                string = attributes.getValue(i);
                continue;
            }
            if (attributes.getQName(i).equals("class")) {
                string2 = attributes.getValue(i);
                if (string2 == null || string2.length() <= 0 || (group = (Group)this.graph.getElement(string2)) != null) continue;
                try {
                    group = this.graph.createGroup(string2);
                }
                catch (GraphException graphException) {
                    graphException.printStackTrace();
                }
                continue;
            }
            if (attributes.getQName(i).equals("source")) {
                string2 = attributes.getValue(i);
                node = (Node)this.graph.getElement(string2);
                if (node != null) continue;
                try {
                    node = this.graph.createNode(string2);
                }
                catch (GraphException graphException) {
                    graphException.printStackTrace();
                }
                continue;
            }
            if (!attributes.getQName(i).equals("target") || (node2 = (Node)this.graph.getElement(string2 = attributes.getValue(i))) != null) continue;
            try {
                node2 = this.graph.createNode(string2);
                continue;
            }
            catch (GraphException graphException) {
                graphException.printStackTrace();
            }
        }
        try {
            this.currentElement = this.graph.createEdge(string, node, node2);
            if (group != null) {
                this.currentElement.setGroup(group);
            }
        }
        catch (GraphException graphException) {
            graphException.printStackTrace();
        }
    }

    protected void endElementEdge() {
        this.currentElement = null;
    }

    protected void startElementLabel(Attributes attributes) {
        this.currentText = new StringBuffer();
    }

    protected void endElementLabel() {
        if (this.currentText != null && this.currentElement != null) {
            if (this.currentElement instanceof Node) {
                ((Node)this.currentElement).setLabel(this.currentText.toString());
            }
            if (this.currentElement instanceof Edge) {
                ((Edge)this.currentElement).setLabel(this.currentText.toString());
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("graph")) {
            this.startElementGraph(attributes);
            return;
        }
        if (string3.equals("node")) {
            this.startElementNode(attributes);
            return;
        }
        if (string3.equals("edge")) {
            this.startElementEdge(attributes);
            return;
        }
        if (string3.equals("label")) {
            this.startElementLabel(attributes);
            return;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("graph")) {
            this.endElementGraph();
            return;
        }
        if (string3.equals("node")) {
            this.endElementNode();
            return;
        }
        if (string3.equals("edge")) {
            this.endElementEdge();
            return;
        }
        if (string3.equals("label")) {
            this.endElementLabel();
            return;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.currentText == null) {
            this.currentText = new StringBuffer();
        }
        this.currentText.append(cArray, n, n2);
    }
}

