/*
 * Decompiled with CFR 0.152.
 */
package visad.aune;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.Delay;
import visad.util.VisADSlider;

public class ShallowFluid {
    RemoteServerImpl server_server;
    RemoteServer client_server;
    RealType xloc;
    RealType yloc;
    RealType u;
    RealType v;
    RealType h;
    RealType cc;
    RealType udiff;
    RealType vdiff;
    RealType hdiff;
    RealType ccdiff;
    RealType time;
    RealTupleType loc;
    FunctionType vol;
    FunctionType voldiff;
    Set linear59x49;
    DataReference sim_time_ref;
    DataReference new_state_ref;
    DataReference old_state_ref;
    DataReference oldest_state_ref;
    DataReference newold_diff_ref;
    DataReference iopt_ref;
    DataReference ibc_ref;
    DataReference gravity_ref;
    DataReference alat_ref;
    DataReference ubar1_ref;
    DataReference vbar1_ref;
    DataReference hprm11_ref;
    DataReference hprm12_ref;
    DataReference delt_ref;
    DataReference eps_ref;
    DataReference adiff_ref;
    DataReference tfilt_ref;
    DataReference anim_delay_ref;
    public static int WIDTH = 1200;
    public static int HEIGHT = 1000;
    public boolean initial = true;

    public static void main(String[] args) throws VisADException, RemoteException {
        ShallowFluid shallow = new ShallowFluid(args);
        if (shallow.client_server != null) {
            shallow.setupClient();
        } else if (shallow.server_server != null) {
            System.loadLibrary("ShallowFluid");
            shallow.setupServer();
        } else {
            System.loadLibrary("ShallowFluid");
            shallow.setupServer();
        }
    }

    public ShallowFluid(String[] args) throws VisADException, RemoteException {
        if (args.length > 0) {
            String domain = "//" + args[0] + "/ShallowFluid";
            try {
                this.client_server = (RemoteServer)Naming.lookup(domain);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
        } else {
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///ShallowFluid", this.server_server);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
        }
    }

    void setupServer() throws VisADException, RemoteException {
        RealTupleType generic2d = new RealTupleType(RealType.Generic, RealType.Generic);
        this.linear59x49 = new Linear2DSet((MathType)generic2d, 1.0, 59.0, 59, 1.0, 49.0, 49);
        this.xloc = RealType.getRealType("xloc");
        this.yloc = RealType.getRealType("yloc");
        this.u = RealType.getRealType("u");
        this.v = RealType.getRealType("v");
        this.h = RealType.getRealType("h");
        this.cc = RealType.getRealType("cc");
        this.udiff = RealType.getRealType("udiff");
        this.vdiff = RealType.getRealType("vdiff");
        this.hdiff = RealType.getRealType("hdiff");
        this.ccdiff = RealType.getRealType("ccdiff");
        this.time = RealType.getRealType("time");
        this.loc = new RealTupleType(this.xloc, this.yloc, null, this.linear59x49);
        this.vol = new FunctionType(this.loc, new RealTupleType(this.u, this.v, this.h, this.cc));
        this.voldiff = new FunctionType(this.loc, new RealTupleType(this.udiff, this.vdiff, this.hdiff, this.ccdiff));
        Real sim_time = new Real(this.time, 0.0);
        this.sim_time_ref = new DataReferenceImpl("sim_time");
        this.sim_time_ref.setData(sim_time);
        FlatField new_state = new FlatField(this.vol);
        this.new_state_ref = new DataReferenceImpl("new_state");
        this.new_state_ref.setData(new_state);
        FlatField old_state = new FlatField(this.vol);
        this.old_state_ref = new DataReferenceImpl("old_state");
        this.old_state_ref.setData(old_state);
        FlatField oldest_state = new FlatField(this.vol);
        this.oldest_state_ref = new DataReferenceImpl("oldest_state");
        this.oldest_state_ref.setData(oldest_state);
        FlatField newold_diff = new FlatField(this.voldiff);
        this.newold_diff_ref = new DataReferenceImpl("newold_diff");
        this.newold_diff_ref.setData(newold_diff);
        this.iopt_ref = new DataReferenceImpl("iopt");
        this.ibc_ref = new DataReferenceImpl("ibc");
        this.gravity_ref = new DataReferenceImpl("gravity");
        this.alat_ref = new DataReferenceImpl("alat");
        this.ubar1_ref = new DataReferenceImpl("ubar1");
        this.vbar1_ref = new DataReferenceImpl("vbar1");
        this.hprm11_ref = new DataReferenceImpl("hprm11");
        this.hprm12_ref = new DataReferenceImpl("hprm12");
        this.delt_ref = new DataReferenceImpl("delt");
        this.eps_ref = new DataReferenceImpl("eps");
        this.adiff_ref = new DataReferenceImpl("adiff");
        this.tfilt_ref = new DataReferenceImpl("tfilt");
        this.anim_delay_ref = new DataReferenceImpl("anim_delay");
        DisplayImpl[] displays = new DisplayImpl[2];
        this.setupDisplays(false, displays);
        this.setupUI(displays);
        this.initial = true;
        shalstepCell shalstep_cell = new shalstepCell("shalstep_cell");
        shalstep_cell.addReference(this.new_state_ref);
        initializeCell initialize_cell = new initializeCell();
        initialize_cell.addReference(this.iopt_ref);
        if (this.server_server != null) {
            RemoteDataReferenceImpl[] refs = new RemoteDataReferenceImpl[]{new RemoteDataReferenceImpl((DataReferenceImpl)this.new_state_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.iopt_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.ibc_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.gravity_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.alat_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.ubar1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.vbar1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.hprm11_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.hprm12_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.delt_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.eps_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.adiff_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.tfilt_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.anim_delay_ref)};
            this.server_server.setDataReferences(refs);
        }
    }

    void setupClient() throws VisADException, RemoteException {
        RemoteDataReference[] refs = this.client_server.getDataReferences();
        if (refs == null) {
            System.out.println("Cannot connect to server");
            System.exit(0);
        }
        this.new_state_ref = refs[0];
        this.iopt_ref = refs[1];
        this.ibc_ref = refs[2];
        this.gravity_ref = refs[3];
        this.alat_ref = refs[4];
        this.ubar1_ref = refs[5];
        this.vbar1_ref = refs[6];
        this.hprm11_ref = refs[7];
        this.hprm12_ref = refs[8];
        this.delt_ref = refs[9];
        this.eps_ref = refs[10];
        this.adiff_ref = refs[11];
        this.tfilt_ref = refs[12];
        this.anim_delay_ref = refs[13];
        this.vol = (FunctionType)this.new_state_ref.getType();
        this.loc = this.vol.getDomain();
        this.xloc = (RealType)this.loc.getComponent(0);
        this.yloc = (RealType)this.loc.getComponent(1);
        RealTupleType range = (RealTupleType)this.vol.getRange();
        this.u = (RealType)range.getComponent(0);
        this.v = (RealType)range.getComponent(1);
        this.h = (RealType)range.getComponent(2);
        this.cc = (RealType)range.getComponent(3);
        DisplayImpl[] displays = new DisplayImpl[2];
        this.setupDisplays(true, displays);
        this.setupUI(displays);
    }

    void setupDisplays(boolean client, DisplayImpl[] displays) throws VisADException, RemoteException {
        DisplayImplJ3D display1 = new DisplayImplJ3D("display1");
        display1.addMap(new ScalarMap(this.xloc, Display.XAxis));
        display1.addMap(new ScalarMap(this.yloc, Display.YAxis));
        ScalarMap map1h = new ScalarMap(this.h, Display.ZAxis);
        map1h.setRange(5450.0, 5700.0);
        display1.addMap(map1h);
        ScalarMap map1cc = new ScalarMap(this.cc, Display.Green);
        map1cc.setRange(-40.0, 40.0);
        display1.addMap(map1cc);
        ScalarMap map1u = new ScalarMap(this.u, Display.Flow1X);
        display1.addMap(map1u);
        display1.addMap(new ScalarMap(this.v, Display.Flow1Y));
        ((FlowControl)map1u.getControl()).setFlowScale(0.15f);
        display1.addMap(new ConstantMap(0.5, Display.Red));
        display1.addMap(new ConstantMap(0.5, Display.Blue));
        if (client) {
            RemoteDisplayImpl remote_display1 = new RemoteDisplayImpl(display1);
            remote_display1.addReference(this.new_state_ref);
        } else {
            display1.addReference(this.new_state_ref);
        }
        DisplayImplJ3D display2 = new DisplayImplJ3D("display2");
        display2.addMap(new ScalarMap(this.xloc, Display.XAxis));
        display2.addMap(new ScalarMap(this.yloc, Display.YAxis));
        ScalarMap map2h = new ScalarMap(this.h, Display.ZAxis);
        map2h.setRange(5450.0, 5700.0);
        display2.addMap(map2h);
        ScalarMap map2cc = new ScalarMap(this.cc, Display.Green);
        map2cc.setRange(-40.0, 40.0);
        display2.addMap(map2cc);
        GraphicsModeControl mode = display2.getGraphicsModeControl();
        mode.setTextureEnable(false);
        display2.addMap(new ConstantMap(0.5, Display.Red));
        display2.addMap(new ConstantMap(0.5, Display.Blue));
        if (client) {
            RemoteDisplayImpl remote_display2 = new RemoteDisplayImpl(display2);
            remote_display2.addReference(this.new_state_ref);
        } else {
            display2.addReference(this.new_state_ref);
        }
        displays[0] = display1;
        displays[1] = display2;
    }

    void setupUI(DisplayImpl[] displays) throws VisADException, RemoteException {
        JFrame frame = new JFrame("ShallowFluid");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        frame.setSize(WIDTH, HEIGHT);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        JPanel big_panel = new JPanel();
        big_panel.setLayout(new BoxLayout(big_panel, 1));
        big_panel.setAlignmentY(0.0f);
        big_panel.setAlignmentX(0.0f);
        frame.getContentPane().add(big_panel);
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.setAlignmentY(0.0f);
        top.setAlignmentX(0.0f);
        big_panel.add(top);
        JPanel text = new JPanel();
        text.setLayout(new BoxLayout(text, 1));
        text.setAlignmentY(0.0f);
        text.setAlignmentX(0.0f);
        top.add(text);
        text.add(new JLabel("Interactive 2-D shallow fluid model"));
        text.add(new JLabel("using VisAD  -  see:"));
        text.add(new JLabel("  "));
        text.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        text.add(new JLabel("  "));
        text.add(new JLabel("for more information about VisAD."));
        text.add(new JLabel("  "));
        text.add(new JLabel("Bill Hibbard and Bob Aune"));
        text.add(new JLabel("Space Science and Engineering Center"));
        text.add(new JLabel("University of Wisconsin - Madison"));
        text.add(new JLabel("  "));
        text.add(new JLabel("  "));
        text.add(new JLabel("Move initial configuration slider to restart model."));
        text.add(new JLabel("  "));
        text.add(new JLabel("Move animation delay slider to adjust model speed."));
        text.add(new JLabel("  "));
        text.add(new JLabel("Move other sliders to adjust model parameters."));
        text.add(new JLabel("  "));
        text.add(new JLabel("Rotate scenes with text mouse button."));
        text.add(new JLabel("  "));
        text.add(new JLabel("  "));
        JPanel sliders = new JPanel();
        sliders.setName("ShallowFluid Sliders");
        sliders.setFont(new Font("Dialog", 0, 12));
        sliders.setLayout(new BoxLayout(sliders, 1));
        sliders.setAlignmentY(0.0f);
        sliders.setAlignmentX(0.0f);
        top.add(sliders);
        sliders.add(new VisADSlider("initial configuration", 1, 5, 5, 1.0, this.iopt_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("boundary condition", 1, 3, 3, 1.0, this.ibc_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("gravity constant", 0, 9806, 9806, 0.001, this.gravity_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("latitude of south boundary", 0, 90, 10, 1.0, this.alat_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("mean u", -100, 100, 0, 1.0, this.ubar1_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("mean v", -100, 100, 0, 1.0, this.vbar1_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("hprm11", -100, 200, -100, 1.0, this.hprm11_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("hprm12", -100, 200, -66, 1.0, this.hprm12_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("simulated time step", 0, 1200, 325, 1.0, this.delt_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("spatial filter constant", 0, 200, 0, 0.01, this.eps_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("interior diffusion coefficient", 0, 1000000, 0, 1.0, this.adiff_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("temporal filter constant", 0, 100, 0, 0.01, this.tfilt_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("animation delay (ms)", 10, 2000, 2000, 1.0, this.anim_delay_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        JPanel display_panel = new JPanel();
        display_panel.setLayout(new BoxLayout(display_panel, 0));
        display_panel.setAlignmentY(0.0f);
        display_panel.setAlignmentX(0.0f);
        big_panel.add(display_panel);
        JPanel display_left = new JPanel();
        display_left.setLayout(new BoxLayout(display_left, 1));
        display_left.setAlignmentY(0.0f);
        display_left.setAlignmentX(0.0f);
        display_panel.add(display_left);
        JPanel display_right = new JPanel();
        display_right.setLayout(new BoxLayout(display_right, 1));
        display_right.setAlignmentY(0.0f);
        display_right.setAlignmentX(0.0f);
        display_panel.add(display_right);
        JPanel panel1 = (JPanel)displays[0].getComponent();
        JPanel panel2 = (JPanel)displays[1].getComponent();
        CompoundBorder etchedBorder10 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        panel1.setBorder(etchedBorder10);
        panel2.setBorder(etchedBorder10);
        JLabel display1_label = new JLabel("fluid flow vectors");
        JLabel display2_label = new JLabel("fluid height surface");
        display_left.add(panel1);
        display_left.add(display1_label);
        display_right.add(panel2);
        display_right.add(display2_label);
        frame.setVisible(true);
    }

    private native void shalstep_c(int var1, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6, float[] var7, float[] var8, float[] var9, float[] var10, float[] var11, float[] var12, float[] var13, int var14, int var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24, float var25);

    class initializeCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            ShallowFluid.this.initial = true;
        }
    }

    class shalstepCell
    extends CellImpl {
        public shalstepCell(String name) throws VisADException, RemoteException {
            super(name);
        }

        public void doAction() throws VisADException, RemoteException {
            float[][] oldest_x;
            float[][] old_x;
            float[][] new_x;
            int step = (int)((Real)ShallowFluid.this.sim_time_ref.getData()).getValue();
            int iopt = (int)((Real)ShallowFluid.this.iopt_ref.getData()).getValue();
            int ibc = (int)((Real)ShallowFluid.this.ibc_ref.getData()).getValue();
            float gravity = (float)((Real)ShallowFluid.this.gravity_ref.getData()).getValue();
            float alat = (float)((Real)ShallowFluid.this.alat_ref.getData()).getValue();
            float ubar1 = (float)((Real)ShallowFluid.this.ubar1_ref.getData()).getValue();
            float vbar1 = (float)((Real)ShallowFluid.this.vbar1_ref.getData()).getValue();
            float hprm11 = (float)((Real)ShallowFluid.this.hprm11_ref.getData()).getValue();
            float hprm12 = (float)((Real)ShallowFluid.this.hprm12_ref.getData()).getValue();
            float delt = (float)((Real)ShallowFluid.this.delt_ref.getData()).getValue();
            float eps = (float)((Real)ShallowFluid.this.eps_ref.getData()).getValue();
            float adiff = (float)((Real)ShallowFluid.this.adiff_ref.getData()).getValue();
            float tfilt = (float)((Real)ShallowFluid.this.tfilt_ref.getData()).getValue();
            int anim_delay = (int)((Real)ShallowFluid.this.anim_delay_ref.getData()).getValue();
            if (ShallowFluid.this.initial) {
                step = 0;
                delt = 0.0f;
                new_x = new float[4][2891];
                old_x = new float[4][2891];
                oldest_x = new float[4][2891];
            } else {
                new_x = Set.doubleToFloat(((FlatField)ShallowFluid.this.new_state_ref.getData()).getValues());
                old_x = Set.doubleToFloat(((FlatField)ShallowFluid.this.old_state_ref.getData()).getValues());
                oldest_x = Set.doubleToFloat(((FlatField)ShallowFluid.this.oldest_state_ref.getData()).getValues());
            }
            ShallowFluid.this.shalstep_c(step, oldest_x[0], oldest_x[1], oldest_x[2], oldest_x[3], old_x[0], old_x[1], old_x[2], old_x[3], new_x[0], new_x[1], new_x[2], new_x[3], iopt, ibc, gravity, alat, ubar1, vbar1, hprm11, hprm12, delt, eps, adiff, tfilt);
            ((FlatField)ShallowFluid.this.new_state_ref.getData()).setSamples(new_x);
            if (ShallowFluid.this.initial) {
                ShallowFluid.this.initial = false;
                ShallowFluid.this.old_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.new_state_ref.getData()).clone());
                ShallowFluid.this.oldest_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.new_state_ref.getData()).clone());
            } else {
                ShallowFluid.this.newold_diff_ref.setData(ShallowFluid.this.new_state_ref.getData().subtract(ShallowFluid.this.oldest_state_ref.getData()));
                ShallowFluid.this.oldest_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.old_state_ref.getData()).clone());
                ShallowFluid.this.old_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.new_state_ref.getData()).clone());
            }
            ShallowFluid.this.sim_time_ref.setData(new Real(ShallowFluid.this.time, (double)(++step)));
            new Delay(anim_delay);
        }
    }
}

