# Fenrir User Manual

Fenrir is a modern command line screen reader written in Python3. 
 
It has a modular structure, a flexible based driver model, is highly configurable and easy to customize and extend ([see Developer Manual](fenrir_development_manual)).
 
Please see the following pages for the [current](fenrir_current_version) and [Git](fenrir_git_version) version of Fenrir. 

 
# Support and Requirements

 
Fenrir requires several drivers to interact with the operating system.
 
## Speech Drivers

 
A speech driver is for communication with the text to speech system like [Speech-Dispatcher](#SpeechDispatcher) or [Espeak](http://espeak.sourceforge.net). \\
See section [Speech](#Speech) in ''settings.conf'' for more information.

 
### SpeechDispatcher

 
This driver is used by default.
It uses Speech-dispatcher as its backend. 
 
Dependencies:
 

*  Speech-dispatcher (installed and configured, [Documentation](https///devel.freebsoft.org/speechd#sec2))

*  Python-speechd

### Espeak

 
Uses Espeak via Python bindings.
 
Dependencies:

*  Espeak or Espeak-ng

*  [python-espeak](https///launchpad.net/python-espeak)
 
### Generic

 
This invokes speech via a sub-process. This is almost the same as using the commandline. The performance depends on the overhead of the speech synthesis application but it is really flexible.
 
Dependencies:

*  Espeak or Espeak-ng
 
The Requirements are flexible, they depend on the configuration in settings.conf. 
 
### Dummy

 
this is just for debugging, logs are output to the screen and logged as well.

## Sound Drivers

 
To play sound icons and similar.\\
See section [Sound](#Sound) in ''settings.conf'' for more information.
 
### Generic

 
This driver is used by default.
 
Dependencies:
 

*  [Sox](http://sox.sourceforge.net/) with opus support
The Requirements are flexible, they depend on the configuration in settings.conf. 
 
### Gstreamer

if you prefer to use Gstreamer for sound output.
 
Dependencies:

*  Gstreamer >= 1.x

*  Glibc
 
### Dummy

 
this is just for debugging, logs are output to the screen and logged as well.
 
## Input Drivers

 
Input drivers are to capture keyboard shortcuts issued to the screen reader \
See section [Keyboard](#Keyboard) in ''settings.conf'' for more information.
 
### Evdev

 
This driver is used by default.
 
Evdev is the low level input device framework for Linux.
 
Dependencies:
 

*  python-evdev >=0.6.3

*  pyudev

*  loaded uinput kernel module

*  exclusive access to the input devices
Read permission to the following files and services:

*  /dev/input

*  /dev/uinput
 
## Screen Drivers

 
The job of a screen driver is to get the information of current screen content.\\
See section [Screen](#Screen) in ''settings.conf'' for more information.
 
### VCSA

 
This driver is used by default.
For Linux VCSA devices. These exist on any current standard installation of Linux.
 
Dependencie
s:
 

*  python-dbus
Read permission to the following files and services (or run as root):

*  /sys/devices/virtual/tty/tty0/active

*  /dev/tty[1 - 64] 

*  /dev/vcsa[1 - 64] ([VCSA manpage](https///linux.die.net/man/4/vcsa))

*  read Logind DBUS
 
## Braille Drivers

This is for Braille support.
Braille is currently a work in progress and is planned for the Fenrir 2.0 release.\\
See section [Braille](#Braille) in ''settings.conf'' for more information.

 
### BRLTTY

 
This driver is used by default.
It uses [BrlTTY](brltty) to communicate with with a Braille device.
 
Dependencies:
 

*  BrlTTY (configured and running, [Documentation](http://mielke.cc/brltty/doc/Manual-BRLTTY/English/BRLTTY.html))

*  python-brlapi (configured, [Documentation](http://mielke.cc/brltty/doc/Manual-BrlAPI/English/BrlAPI.html))
## Currently supported platforms

 
Currently Fenrir  completely supports the following Platforms:

*  Linux TTY
Support for further Systems are planned.
 
# Installation

 
Fenrir can run without installation. It just requires the dependencies are installed first.
 
We recommend to try it out before installation to be sure everything works and prevent yourself from experiencing a non-talking environment.
 
## Try Out

Fenrir does not require installation. You can try it and make sure everything works before you decide to install. In this way you can be sure that your system doesnt break or stop talking.
for that you can just grab the code and run as root ''src/fenrir/fenrir'' (in foreground) or ''src/fenrir/fenrir-daemon'' (in background, used by systemd for autostart)

## Install it

###  Documented operating systems

 
### Arch Linux

 
For Arch there are PKGBUILDs in the AUR:

*  [fenrir](https///aur.archlinux.org/packages/fenrir/)

*  [fenrir-git](https///aur.archlinux.org/packages/fenrir-git/)
 
### Manual

 
 1.  Download the latest stable version from the [Fenrir-Project](https///linux-a11y.org/index.php?page=fenrir-screenreader) site.
 2.  Unpack the archive
 3.  Check the needed Dependencys by running [check-dependencys.py](https///github.com/chrys87/fenrir/blob/master/check-dependencies.py) script
 4.  install the missing dependencies an standard installation requires the following:

    * python3 >= 3.3 (and all the following is needed for python3 )
    * python3-speechd (screen)
    * python3-dbus (screen)
    * python3-evdev >= 0.6.4(input)
    * python3-daemonize (background service)
    * python3-brlapi (braille)
    * python3-pyenchant (spellchecker)
    * your language for aspell (aspell-`<lang>`) (spellchecker)
    * sox (sound)
    * For an individual installation see [Support and Requirements](#Support and Requirements) or consult the [Readme](https///github.com/chrys87/fenrir/blob/master/README.md))
 5.  run "install.sh" as root

this installs Fenrir as the following

    * Application:''/opt/fenrir''
    * Settings:''/etc/fenrir''
    * Sound Icons:''/usr/share/fenrir/''
 
to remove Fenrir just run uninstall.sh as root
 
### Git

 
if you want to get the latest code you can use git to get a development snapshot:
 
    git clone https://github.com/chrys87/fenrir.git
 
## Auto Start

 
To start Fenrir once:
    systemctl start fenrir
 
To enable auto start on system boot:
    systemctl enable fenrir
 
# First Steps

 
If you are using Fenrir for the first time you may want to take a look at these resources:

*  [Keybindings](#Keybindings)

*  [Tutorial Mode](#Tutorial Mode)
 
# Features

 
## Commands

 
### Keybindings

 
Normal commands can be invoked in two ways:
 1.  Using a Metakey ([FenrirKey](#Fenrir Key))
 2.  Shortcuts with a single key

See section [Keyboard](#Keyboard) in ''settings.conf'' for more information. 
#### Fenrir Key

The Fenrir Key is for invoking screen reader commands. Fenrir can utilize more than one FenrirKey at the same time.
By default the following keys are used:
 1.  Insert
 2.  KeyPad Insert
 3.  Meta (Super, Windows) 
 
#### Script Key

To invoke "Scripts" the Script Key is mandatory. The shortcut is encoded in the filename of the script. See [Scripting](#Scripting)
#### Desktop Layout

 | Shortcut                     | Command                                                                    | 
 | --------                     | -------                                                                    | 
 | FenrirKey + H                | [toggle tutorial mode](#Tutorial Mode)                                     | 
 | CTRL                         | [shut up (interrupts speech)](#shut up)                                    | 
 | FenrirKey + KeyPad 9         | [reviews bottom](#review bottom)                                           | 
 | FenrirKey + KeyPad 7         | [reviews top](#review top)                                                 | 
 | KeyPad 8                     | [reviews current line](#review current line)                               | 
 | KeyPad 7                     | [reviews previous line](#review previous line)                             | 
 | KeyPad 9                     | [reviews next line](#review next line)                                     | 
 | FenrirKey + KeyPad 4         | [reviews line beginning](#review line beginning)                           | 
 | FenrirKey + KeyPad 6         | [reviews line ending](#review line ending)                                 | 
 | FenrirKey + KeyPad 1         | [reviews line first character](#review line first character)               | 
 | FenrirKey + KeyPad 3         | [reviews line last character](#review line last character)                 | 
 | FenrirKey + Alt + 1          | [presents first line](#present first line)                                 | 
 | FenrirKey + Alt + 2          | [presents last line](#present last line)                                   | 
 | KeyPad 5                     | [reviews current word](#review current word)                               | 
 | KeyPad 4                     | [reviews previous word](#review previous word)                             | 
 | KeyPad 6                     | [reviews next word](#review next word)                                     | 
 | FenrirKey + Shift + KeyPad 5 | [reviews current word phonetic](#review current word phonetic)             | 
 | FenrirKey + Shift + KeyPad 4 | [reviews previous word phonetic](#review previous word phonetic)           | 
 | FenrirKey + Shift + KeyPad 6 | [reviews next word phonetic](#review next word phonetic)                   | 
 | KeyPad 2                     | [reviews current char](#review current character)                          | 
 | KeyPad 1                     | [reviews previous char](#review previous character)                        | 
 | KeyPad 3                     | [reviews next char](#review next character)                                | 
 | FenrirKey + Shift + KeyPad 2 | [reviews current character phonetic](#review current character phonetic)   | 
 | FenrirKey + Shift + KeyPad 1 | [reviews previous character phonetic](#review previous character phonetic) | 
 | FenrirKey + Shift + KeyPad 3 | [reviews next character phonetic](#review next character phonetic)         | 
 | FenrirKey + CTRL + KeyPad 8  | [reviews up](#review up)                                                   | 
 | FenrirKey + CTRL + KeyPad 2  | [reviews down](#review down)                                               | 
 | FenrirKey + KeyPad dot       | [exit review](#exit review)                                                | 
 | KeyPad dot                   | [cursor position](#cursor position)                                        | 
 | FenrirKey + I                | [indent curr line](#indent current line)                                   | 
 | FenrirKey + KeyPad 5         | [current screen](#current screen)                                          | 
 | FenrirKey + KeyPad 8         | [current screen before cursor](#current screen before cursor)              | 
 | FenrirKey + KeyPad 2         | [current screen after cursor](#current screen after cursor)                | 
 | `<Unbound>`                    | [cursor read to end of line](#cursor read to end of line)                  | 
 | `<Unbound>`                    | [cursor column](#cursor column)                                            | 
 | `<Unbound>`                    | [cursor line number](#cursor line number)                                  | 
 | `<Unbound>`                    | [Braille flush](#braille flush)                                            | 
 | `<Unbound>`                    | [Braille pan left](#braille pan left)                                      | 
 | `<Unbound>`                    | [Braille pan right](#braille pan right)                                    | 
 | `<Unbound>`                    | [Braille return to cursor](#braille return to cursor)                      | 
 | FenrirKey + CTRL + 1         | [clear bookmark 1](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 1        | [set bookmark 1](#set Bookmark X)                                          | 
 | FenrirKey + 1                | [bookmark 1](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 2         | [clear bookmark 2](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 2        | [set bookmark 2](#set Bookmark X)                                          | 
 | FenrirKey + 2                | [bookmark 2](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 3         | [clear bookmark 3](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 3        | [set bookmark 3](#set Bookmark X)                                          | 
 | FenrirKey + 3                | [bookmark 3](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 4         | [clear bookmark 4](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 4        | [set bookmark 4](#set Bookmark X)                                          | 
 | FenrirKey + 4                | [bookmark 4](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 5         | [clear bookmark 5](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 5        | [set bookmark 5](#set Bookmark X)                                          | 
 | FenrirKey + 5                | [bookmark 5](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 6         | [clear bookmark 6](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 6        | [set bookmark 6](#set Bookmark X)                                          | 
 | FenrirKey + 6                | [bookmark 6](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 7         | [clear bookmark 7](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 7        | [set bookmark 7](#set Bookmark X)                                          | 
 | FenrirKey + 7                | [bookmark 7](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 8         | [clear bookmark 8](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 8        | [set bookmark 8](#set Bookmark X)                                          | 
 | FenrirKey + 8                | [bookmark 8](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 9         | [clear bookmark 9](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 9        | [set bookmark 9](#set Bookmark X)                                          | 
 | FenrirKey + 9                | [bookmark 9](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 0         | [clear bookmark 10](#clear Bookmark X)                                     | 
 | FenrirKey + Shift + 0        | [set bookmark 10](#set Bookmark X)                                         | 
 | FenrirKey + 0                | [bookmark 10](#read Bookmark X)                                            | 
 | FenrirKey + KeyPad Slash     | [set window application](#Create Window)                                   | 
 | 2 * FenrirKey + KeyPad Slash | [clear window application](#Remove Window)                                 | 
 | KeyPad Plus                  | [read last incoming](#last incoming)                                       | 
 | FenrirKey + F2               | [toggles braille](#toggle braille)                                         | 
 | FenrirKey + F3               | [toggles sound](#toggle sound)                                             | 
 | FenrirKey + F4               | [toggles speech](#toggle speech)                                           | 
 | KeyPad Enter                 | [temporarily disables speech](#disable speech temporarily)                 | 
 | FenrirKey + CTRL + P         | [toggles punctuation level](#toggle punctuation level)                     | 
 | FenrirKey + RightBrace       | [toggle auto spell check](#toggle auto spell check)                        | 
 | FenrirKey + Backslash        | [toggles output](#toggle output)                                           | 
 | FenrirKey + CTRL + E         | [toggles emoticons](#toggle emoticons)                                     | 
 | FenrirKey + KeyPad Enter     | [toggles auto read](#toggle auto read)                                     | 
 | FenrirKey + CTRL + T         | [toggles auto time](#toggle auto time)                                     | 
 | FenrirKey + KeyPad ASTERISK  | [toggles highlight tracking](#toggle highlight tracking)                   | 
 | FenrirKey + Q                | [quits fenrir](#quit Fenrir)                                               | 
 | FenrirKey + T                | [Announce time](#Time)                                                     | 
 | 2 * FenrirKey + T            | [Announce date](#Date)                                                     | 
 | FenrirKey + S                | [spell check](#spell check)                                                | 
 | 2 * FenrirKey + S            | [add word to spell check](#add word to spell check)                        | 
 | FenrirKey + Shift + S        | [removes word from spell check](#removes word from spell check)            | 
 | FenrirKey + Backspace        | [forward keypress](#forward keypress)                                      | 
 | FenrirKey + Up               | [increase speech volume](#increase speech volume)                          | 
 | FenrirKey + Down             | [decrease speech volume](#decrease speech volume)                          | 
 | FenrirKey + Right            | [increase speech rate](#increase speech rate)                              | 
 | FenrirKey + Left             | [decrease speech rate](#decrease speech rate)                              | 
 | FenrirKey + Alt + Right      | [increase speech pitch](#increase speech pitch)                            | 
 | FenrirKey + Alt + Left       | [decrease speech pitch](#decrease speech pitch)                            | 
 | FenrirKey + Alt + Up         | [increase sound volume](#increase sound volume)                            | 
 | FenrirKey + Alt + Down       | [decrease sound volume](#decrease sound volume)                            | 
 | FenrirKey + CTRL + Shift + C | [clears clipboard](#clear clipboard)                                       | 
 | FenrirKey + Home             | [first clipboard](#first clipboard)                                        | 
 | FenrirKey + End              | [last clipboard](#last clipboard)                                          | 
 | FenrirKey + PageUp           | [previous clipboard](#previous clipboard)                                  | 
 | FenrirKey + PageDown         | [next clipboard](#next clipboard)                                          | 
 | FenrirKey + Shift + C        | [current clipboard](#read current clipboard)                               | 
 | FenrirKey + C                | [copy marked text to clipboard](#copy marked to clipboard)                 | 
 | FenrirKey + V                | [paste clipboard contents](#paste clipboard)                               | 
 | FenrirKey + P                | [import clipboard from file](#import clipboard from file)                  | 
 | FenrirKey + Alt + Shift +C   | [export clipboard to file](#export clipboard to file)                      | 
 | FenrirKey + CTRL + Shift + X | [remove marks](#Remove Marks)                                              | 
 | FenrirKey + X                | [set mark](#Set mark)                                                      | 
 | FenrirKey + Shift + X        | [announce marked text](#Get text between marks)                            | 
 | Linux specific               |                                                                           
 | `<Unbound>`                    | export clipboard to X                                                      | 
 | FenrirKey + CTRL + Up        | include Alsa volume                                                        | 
 | FenrirKey + CTRL + Down      | decrease Alsa volume                                                       | 

#### Laptop Layout

 | Shortcut                       | Command                                                                    | 
 | --------                       | -------                                                                    | 
 | FenrirKey + H                  | [toggle tutorial mode](#Tutorial Mode)                                     | 
 | CTRL                           | [shut up (interrupts speech)](#shut up)                                    | 
 | FenrirKey + Shift + O          | [reviews bottom](#review bottom)                                           | 
 | FenrirKey + Shift + U          | [reviews top](#review top)                                                 | 
 | FenrirKey + I                  | [reviews current line](#review current line)                               | 
 | FenrirKey + U                  | [reviews previous line](#review previous line)                             | 
 | FenrirKey + O                  | [reviews next line](#review next line)                                     | 
 | FenrirKey + Shift + J          | [reviews line beginning](#review line beginning)                           | 
 | FenrirKey + Shift + L          | [reviews line ending](#review line ending)                                 | 
 | FenrirKey + CTRL + J           | [reviews line first character](#review line first character)               | 
 | FenrirKey + CTRL + L           | [reviews line last character](#review line last character)                 | 
 | FenrirKey + Alt + 1            | [presents first line](#present first line)                                 | 
 | FenrirKey + Alt + 2            | [presents last line](#present last line)                                   | 
 | FenrirKey + K                  | [reviews current word](#review current word)                               | 
 | FenrirKey + J                  | [reviews previous word](#review previous word)                             | 
 | FenrirKey + L                  | [reviews next word](#review next word)                                     | 
 | FenrirKey + CTRL + ALT + K     | [reviews current word phonetic](#review current word phonetic)             | 
 | FenrirKey + CTRL + ALT + J     | [reviews previous word phonetic](#review previous word phonetic)           | 
 | FenrirKey + CTRL + ALT + L     | [reviews next word phonetic](#review next word phonetic)                   | 
 | FenrirKey + comma              | [reviews current character](#review current character)                     | 
 | FenrirKey + M                  | [reviews previous character](#review previous character)                   | 
 | FenrirKey + dot                | [reviews next character](#review next character)                           | 
 | FenrirKey + CTRL + ALT + comma | [reviews current character phonetic](#review current character phonetic)   | 
 | FenrirKey + CTRL + ALT + M     | [reviews previous character phonetic](#review previous character phonetic) | 
 | FenrirKey + CTRL + ALT + dot   | [reviews next character phonetic](#review next character phonetic)         | 
 | FenrirKey + CTRL + I           | [reviews up](#review up)                                                   | 
 | FenrirKey + CTRL + comma       | [reviews down](#review down)                                               | 
 | FenrirKey + Slash              | [exit review](#exit review)                                                | 
 | FenrirKey + Shift + dot        | [cursor position](#cursor position)                                        | 
 | 2 * FenrirKey + I              | [indent curr line](#indent current line)                                   | 
 | FenrirKey + Shift + K          | [current screen](#current screen)                                          | 
 | FenrirKey + Shift + I          | [current screen before cursor](#current screen before cursor)              | 
 | FenrirKey + Shift + comma      | [current screen after cursor](#current screen after cursor)                | 
 | `<Unbound>`                      | [cursor read to end of line](#cursor read to end of line)                  | 
 | `<Unbound>`                      | [cursor column](#cursor column)                                            | 
 | `<Unbound>`                      | [cursor line number](#cursor line number)                                  | 
 | `<Unbound>`                      | [Braille flush](#braille flush)                                            | 
 | `<Unbound>`                      | [Braille pan left](#braille pan left)                                      | 
 | `<Unbound>`                      | [Braille pan right](#braille pan right)                                    | 
 | `<Unbound>`                      | [Braille return to cursor](#braille return to cursor)                      | 
 | FenrirKey + CTRL + 1           | [clear bookmark 1](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 1          | [set bookmark 1](#set Bookmark X)                                          | 
 | FenrirKey + 1                  | [bookmark 1](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 2           | [clear bookmark 2](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 2          | [set bookmark 2](#set Bookmark X)                                          | 
 | FenrirKey + 2                  | [bookmark 2](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 3           | [clear bookmark 3](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 3          | [set bookmark 3](#set Bookmark X)                                          | 
 | FenrirKey + 3                  | [bookmark 3](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 4           | [clear bookmark 4](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 4          | [set bookmark 4](#set Bookmark X)                                          | 
 | FenrirKey + 4                  | [bookmark 4](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 5           | [clear bookmark 5](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 5          | [set bookmark 5](#set Bookmark X)                                          | 
 | FenrirKey + 5                  | [bookmark 5](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 6           | [clear bookmark 6](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 6          | [set bookmark 6](#set Bookmark X)                                          | 
 | FenrirKey + 6                  | [bookmark 6](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 7           | [clear bookmark 7](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 7          | [set bookmark 7](#set Bookmark X)                                          | 
 | FenrirKey + 7                  | [bookmark 7](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 8           | [clear bookmark 8](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 8          | [set bookmark 8](#set Bookmark X)                                          | 
 | FenrirKey + 8                  | [bookmark 8](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 9           | [clear bookmark 9](#clear Bookmark X)                                      | 
 | FenrirKey + Shift + 9          | [set bookmark 9](#set Bookmark X)                                          | 
 | FenrirKey + 9                  | [bookmark 9](#read Bookmark X)                                             | 
 | FenrirKey + CTRL + 0           | [clear bookmark 10](#clear Bookmark X)                                     | 
 | FenrirKey + Shift + 0          | [set bookmark 10](#set Bookmark X)                                         | 
 | FenrirKey + 0                  | [bookmark 10](#read Bookmark X)                                            | 
 | FenrirKey + CTRL + 8           | [set window application](#Create Window)                                   | 
 | 2 * FenrirKey + CTRL + 8       | [clear window application](#Remove Window)                                 | 
 | FenrirKey + Semicolon          | [read last incoming](#last incoming)                                       | 
 | FenrirKey + F2                 | [toggles braille](#toggle braille)                                         | 
 | FenrirKey + F3                 | [toggles sound](#toggle sound)                                             | 
 | FenrirKey + F4                 | [toggles speech](#toggle speech)                                           | 
 | FenrirKey + Enter              | [temporarily disables speech](#disable speech temporarily)                 | 
 | FenrirKey + Shift + CTRL + P   | [toggles punctuation level](#toggle punctuation level)                     | 
 | FenrirKey + RightBrace         | [toggle auto spell check](#toggle auto spell check)                        | 
 | FenrirKey + Shift + Enter      | [toggles output](#toggle output)                                           | 
 | FenrirKey + Shift + E          | [toggles emoticons](#toggle emoticons)                                     | 
 | FenrirKey + Enter              | [toggles auto read](#toggle auto read)                                     | 
 | FenrirKey + CTRL + T           | [toggles auto time](#toggle auto time)                                     | 
 | FenrirKey + Y                  | [toggles highlight tracking](#toggle highlight tracking)                   | 
 | FenrirKey + Q                  | [quits fenrir](#quit Fenrir)                                               | 
 | FenrirKey + T                  | [Announce time](#Time)                                                     | 
 | 2 * FenrirKey + T              | [Announce date](#Date)                                                     | 
 | FenrirKey + S                  | [spell check](#spell check)                                                | 
 | 2 * FenrirKey + S              | [add word to spell check](#add word to spell check)                        | 
 | FenrirKey + Shift + S          | [removes word from spell check](#removes word from spell check)            | 
 | FenrirKey + Backspace          | [forward keypress](#forward keypress)                                      | 
 | FenrirKey + Up                 | [increase speech volume](#increase speech volume)                          | 
 | FenrirKey + Down               | [decrease speech volume](#decrease speech volume)                          | 
 | FenrirKey + Right              | [increase speech rate](#increase speech rate)                              | 
 | FenrirKey + Left               | [decrease speech rate](#decrease speech rate)                              | 
 | FenrirKey + Alt + Right        | [increase speech pitch](#increase speech pitch)                            | 
 | FenrirKey + Alt + Left         | [decrease speech pitch](#decrease speech pitch)                            | 
 | FenrirKey + Alt + Up           | [increase sound volume](#increase sound volume)                            | 
 | FenrirKey + Alt + Down         | [decrease sound volume](#decrease sound volume)                            | 
 | FenrirKey + CTRL + Shift + C   | [clears clipboard](#clear clipboard)                                       | 
 | FenrirKey + Home               | [first clipboard](#first clipboard)                                        | 
 | FenrirKey + End                | [last clipboard](#last clipboard)                                          | 
 | FenrirKey + PageUp             | [previous clipboard](#previous clipboard)                                  | 
 | FenrirKey + PageDown           | [next clipboard](#next clipboard)                                          | 
 | FenrirKey + Shift + C          | [current clipboard](#read current clipboard)                               | 
 | FenrirKey + C                  | [copy marked text to clipboard](#copy marked to clipboard)                 | 
 | FenrirKey + V                  | [paste clipboard contents](#paste clipboard)                               | 
 | FenrirKey + F5                 | [import clipboard from file](#import clipboard from file)                  | 
 | FenrirKey + Alt + Shift +C     | [export clipboard to file](#export clipboard to file)                      | 
 | FenrirKey + CTRL + Shift + X   | [remove marks](#Remove Marks)                                              | 
 | FenrirKey + X                  | [set mark](#Set mark)                                                      | 
 | FenrirKey + Shift + X          | [announce marked text](#Get text between marks)                            | 
 | Linux specific                 |                                                                           
 | `<Unbound>`                      | export clipboard to X                                                      | 
 | FenrirKey + CTRL + Up          | increases Alsa volume                                                      | 
 | FenrirKey + CTRL + Down        | decreases Alsa volume                                                      | 
### General

#### quit Fenrir
Just stops fenrir.
#### shut up

Interrupt the current spoken.
### Review Modes

Fenrir provides a virtual cursor, with it you can navigate all over the screen without changing the text cursor. 
 
Using the review feature will open the review mode automatically. 
 
The review cursor always starts from the text cursor.  Attention: after using the review mode, the review cursor will stay open until you use the ''exit review'' shortcut. 
 
Think when using clipboard operations and similar. The review cursor is always prefered over the text cursor.

Fenrir sounds a bell sound if the used review command jumps to another line or end of screen.
#### exit review

You can leave the review mode by pressing the ''exit review'' shortcut.
#### review bottom

Set the review cursor to first column in the last line.
#### review top

Set the review cursor to the first column in the first line
#### review current line

Set the review cursor to the beginn of the the current line and review it.
#### review previous line

Set the review cursor to the previous line and review it.
#### review next line

Set the review cursor to the next line and review it.
#### review line beginning

Set the review cursor to the begin of the current line
#### review line ending

Set the review cursor to the end of the current line
#### review line first character

Set the review cursor the first char (that is not space) in the current line and review it.
#### review line last character

Set the review cursor the last char (that is not space) in the current line and review it.
#### review current word

Sets the review cursor to the beginning of the current word and review it.
#### review previous word

Sets the review cursor to the beginning of the previous word and review it.
#### review next word

Sets the review cursor to the beginning of the next word and review it.
#### review current word phonetic

Sets the review cursor to the beginning of the current word and spell it phonetic.
#### review previous word phonetic

Sets the review cursor to the beginning of the previous word and spell it phonetic.
#### review next word phonetic

Sets the review cursor to the beginning of the next word and spell it phonetic.
#### review current character

Does not change the review cursor. Just announce the current char.
#### review previous character

Sets review cursor to the previous column and review it
#### review next character

Sets review cursor to the next column and review it
#### review current character phonetic

Does not change the review cursor. Just announce the current char phonetic.
#### review previous character phonetic

Sets review cursor to the previous column and announce the char phonetic.
#### review next character phonetic

Sets review cursor to the next column and announce the char phonetic.
#### review up

Set the review cursor in the same column one line above the current one and review it.
#### review down

Set the review cursor in the same column one line below the current one and review it.
### Handling marking

A mark defines a point of origin or end to prepare to copy or paste a block of text.
\\
Examples where you need marks are:

*  copy to clipboard

*  set window application

*  set bookmark 1 - X
#### Set mark

How to set a mark:
 1.  navigate with review or textcursor to the position you want to set the mark. Attention: if a review cursor is set, that is the prefered. If you want to use text cursor, be sure that you are not in review mode.
 2.  press shortcut for ''set mark''
you can set two marks (begin and end). Some commands allow some simpler usecases just using the whole line if only one mark is set. you may want to try this out.
#### Get text between marks

To get the text that is currently between your marks press shortcut for ''marked text''.\\
#### Remove Marks

You can remove all current marks by pressing the shortcut for ''remove marks''.
Changing the screen also removes the marks.
### Screen Interaction

Fenrir provides several methods to interact with the current screen.
#### forward keypress

This just forwards the next shortcut to the screen Fenrir shortcut or not. This is useful if the currently pressed shortcut is also in use by Fenrir.
#### Clipboard

Fenrir provides a clipboard with multible items represented by a list. You navigate throught the list and paste the selected clipboard.
##### copy marked to clipboard

To copy something to the clipboard you need to set one or two marks. if you set one mark, the text between the mark and your current cursor is copied to clipboard. Setting two marks just copies the text between the marks into the clipboard. If you copy something it is always placed as the first item on your clipboard.
##### clear clipboard

You can remove all items from the current clipboard by ''clear clipboard'' functionality.
##### first clipboard

This moves quick to the first item of the clipboard.
##### last clipboard

This moves quick to the last item of the clipboard.
##### previous clipboard

Go to previous item in the clipboard.
##### next clipboard

Go to next item on the clipboard. 
##### read current clipboard

Read the content of the current item of the clipboard.
##### paste clipboard

Pass whatever item is currently selected by first, last, prev or next clipboard commands.
if no special clipboard is selected the (last copied) is used.
##### export clipboard to file

This allows you to export the current clipboard to a configurable filepath. This is useful to share the clipboard with a graphical desktop.
##### import clipboard from file

Import a clipboard from a configurable file. This is useful to share the clipboard with a graphical desktop.
### Quick Settings

Fenrir provides shortcuts to change settings temporarily and on the fly without the need to permanently change the ''settings.conf'' file.
#### toggle braille

Enables and disables Braille. This is not persistent stored in your ''settings.conf'' but during run time.
#### toggle sound

Enables and disables sound. This is not persistent stored in your ''settings.conf'' but during run time.
#### toggle speech

Enables and disables speech. This is not persistent stored in your ''settings.conf'' but during run time.
#### disable speech temporarily

Disables the speech until next key press. it might be useful if you want to listen to music or similar. As soon as a key is pressed it is going to be enabled again.
#### toggle punctuation level

Cycle between all available punctuation levels. This is not persistent stored in your ''settings.conf'' but during run time.
#### toggle auto spell check

Enables and disables automatic spellchecker (when typing). This is not persistent stored in your ''settings.conf'' but during run time.
#### toggle emoticons

Enables and disables emoticons. This is not persistent stored in your ''settings.conf'' but during runtime.
#### toggle output

Enables and disables all output at once (sound, Braille, speech). This is not persistent stored in your ''settings.conf'' but during run time.
#### toggle auto read

Enables and disables what is automatically spoken. This is not persistent stored in your ''settings.conf'' but during run time.
#### toggle auto time

Enables and disables auto time functionality. This is not persistent stored in your ''settings.conf'' but during run time.
#### toggle highlight tracking

Enables and disables highlight tracking. This is not persistent stored in your ''settings.conf'' but during run time.
#### increase speech volume

Increase the volume of the speech. This is not persistent stored in your ''settings.conf'' but during runtime.
#### decrease speech volume

Decrease the volume of the speech. This is not persistent stored in your ''settings.conf'' but during runtime.
#### increase speech rate

Increase the rate of the speech. This is not persistent stored in your ''settings.conf'' but during runtime.
#### decrease speech rate

Decrease the rate of the speech. This is not persistent stored in your ''settings.conf'' but during runtime.
#### increase speech pitch

Increase the pitch of the speech. This is not persistent stored in your ''settings.conf'' but during runtime.
#### decrease speech pitch

Decrease the pitch of the speech. This is not persistent stored in your ''settings.conf'' but during runtime.
#### increase sound volume

Increase the volume of the sound. This is not persistent stored in your ''settings.conf'' but during runtime.
#### decrease sound volume

Decrease the volume of the sound. This is not persistent stored in your ''settings.conf'' but during runtime.
### Window Mode

Fenrir supports window mode, a window is a partial area of the screen.
#### Create Window

To create a window you need to do the following:
 1.  set a beginning mark (as the start of the window)
 2.  set an end mark (where the window should end)
 3.  press ''set window application'' shortcut. 
Now Fenrir ignores anything outside of the window.\\
#### Remove Window

You can remove the window by pressing ''the clear window application'' shortcut.
Now Fenrir will read everything on the screen again.
### Tracking Modes

Different types of tracking are currently supported
See section [Focus](#Focus) in ''settings.conf'' for more information.
####  Cursor Tracking

This follows the text cursor. This is the typical way an application works. This is used by:

*  almost any shell such as (Bash, Zsh, sh)

*  vim

*  nano

*  emacs

*  mutt

*  tintin++
#### Highlight Tracking

In some applications there are no text cursors. In those applications cursor changes are represented by different colors or attributes (underlined or bold). This mode tracks and announces these changes for you. This is used by: 

    * wifi-menu
    * dialog
    * alpine
### Tutorial Mode

Fenrir provides a Tutorial mode. 
When you enter tutorial mode, screen reader commands are intercepted  and explained instead of executing them. ''Arrow up'' and ''Arrow Down'' let you navigate through a list of all available commands with shortcuts and description. Pressing escape leaves the tutorial mode. 

### Information

#### Time
Announces the current Time.
#### Date

Announces the current Date.
#### Bookmarks

Bookmarks provide quick access to part of the screen without the need to navigate to the area.
By default Fenrir provides 10 bookmarks. Those can be set and accessed via shortcut.
This is useful for status lines or other information where the position does not change.
##### set Bookmark X

You need to set the bookmark first. For that you have to set one or two lines for use.
 1.  Set marks (one or two)
 2.  press shortcut for ''set bookmark X''. X represents the number 1 - 10.
##### read Bookmark X

If a bookmark is set you can access the area just by pressing the ''bookmark X'' shortcut. X represents the number 1 - 10. Bookmarks are dynamic. That means the content changes with the screen. 
##### clear Bookmark X

to remove a bookmark just press the ''clear bookmark X'' shortcut.  X represents the number 1 - 10.
Afterward the bookmark is no longer available.
#### cursor position

You can get information about the current cursor and its position by using the "cursor position" functionality.
#### indent current line

Announce the current indent level of the current line. It represents the number of trailing spaces of the line.
#### current screen

Reads all the current screen from the beginning to the end.
#### current screen  before cursor

Reads current screen from the beginning of the screen to the current cursor position.
#### current screen after cursor

Read anything after current cursor position to the end.
#### cursor read to end of line

Read from the current cursor position to the end of the current line.
#### cursor column

Read the current X position of a cursor (column of the current line).
#### cursor line number

Read the current Y position of a cursor (line number).
#### present first line

Reads just the first line. this is maybe useful for status information.
#### present last line

Presets the last line. This is maybe useful for status information.
#### last incoming

Repeat the last automatically incoming text.
## Input

### Echo
Fenrir provides different methods of echoing content:

*  Word: Will speak each word after you push space

*  Character: speak any letter you type on the screen

*  Delete Character: speaks the character prior to the cursor when you push backspace
### Silence on Key press

### Spellchecker
Fenrir has a built-in spellchecker, it can invoke automatically while typing or be called by a shortcut.
Commands to add or remove the current word to the dictionary are included. 
As using the spellchecker is enhanced usage. You will need dictionary aspell-`<language>`.
See section [General](#General) in ''settings.conf'' for more information.
#### spell check

Invokes the spellcheck on the word that contains the Review or text cursor. 
#### add word to spell check

Adds the word under the Review or Text cursor to the dictionary.
#### removes word from spell check

Removes the word under the Review or Text cursor from the dictionary.
## Announcements

### Emoticons
If you want to replace ":)" emoticons with "smile" in speech you can use this feature.
It can be toggled on or off.
You can define emoticons in a dictionary, please see Emoticon Dictionary.
See section [General](#General) in ''settings.conf'' to see how to enable or disable this feature.

### Time

Announce the time at periodical increments, To track the time easily.
You can define 2 different ways of time announcements.
 1.  periodic
 2.  on fix minutes

Example periodic, every 20 minutes "delaySec=20":

    [time]
    enabled=True
    presentTime=True
    presentDate=True
    delaySec=20
    onMinutes=
    announce=True
    interrupt=False    

Example on fix minutes in an hour. example every quarter "delaySec=0" and "onMinutes=00,15,30,45":

    [time]
    enabled=True
    presentTime=True
    presentDate=True
    #delaySec is repected bevore onMinutes so it need to be set to 0
    delaySec=0 
    onMinutes=00,15,30,45
    announce=True
    interrupt=False      
### Promoted List

Promoted Lists are a nice feature if you are away from your computer or performing more longer tasks.
you can define a list of words which you want to hear a sound icon for after a period of inactivity.
Example if the word "Chrys" appears after 120 Seconds of inactivity:
    [promote]
    enabled=True  
    inactiveTimeoutSec=120
    list=Chrys
See section [Promote](#Promote) in ''settings.conf'' for more information.
### Punctuation

Fenrir handles punctuation levels and names for you with several provided dictionaries.

See levelDict
See punctuationDict
## Braille

Fenrir provides Braille support in Version >= 2.0.
See section [Braille](#Braille) in ''settings.conf'' for more information.
### braille flush

If a message appears on the Braille device you can flush it to get back to the review- or system cursor
### Braille pan left

If a line is longer than your Braille devices you can move the view (called panning) to the left.
So you can read stuff without the need to move the review- or system cursor.
### Braille pan right

If a line is longer than your Braille devices you can move the view (called panning) to the right.
So you can read stuff without the need to move the review- or system cursor.
### braille return to cursor

When you have finished reading the line on the Braille device using panning, the focus can be returned to the current used cursor by using "return to cursor" command.
## Dictionary

You can make use of different kinds of built-in dictionary's.
A dictionary has a name and list of keys and values separated by :===:
Example:
    [customDict]
    Chrys:===:Chrys is cool
    lollipop:===:lolli
that means that every instance "chrys" is displayed, speech will say Chrys is cool.
"lollipop" is spoken as "lolli".
Before making changes to a dictionary we recommend  making a backup of your current dictionary in case future updates overwrite your local changes.
### Punctuation

#### Level
The punctuation level dict contains lists with "what punctuation is spoken in what level".
the default one looks like this:
    [levelDict]
    none:===:
    some:===:.-$~+*-/\@
    most:===:.,:-$~+*-/\@!#%^&*()[]}{`<>`;
    all:===:!"#$%& \'()*+,-./:;`<=>`?@[\\]^_`{|}~
the level "none" has no values. so it should not speak any punctuation (sadly this is not respected by every TTS system)
if "some" is the current level the following are spoken: dot dash dollar tilde plus star slash backslash at.
same for most and all, you can add new levels. if you cycle punctuation levels they are recognized. the default punctuation level is set in settings.conf. The default is "some".
#### Punctuation

The punctuation dictionary "[punctDict]" contains how the punctuation is spoken. 
Example:
    [punctDict]
    _:===:line  
speaks an _ as "line".  
    [punctDict]
    _:===:underscore
speaks an _ as underscore.
for question mark an ? is appended to the word that the TTS system can announce the question correctly.    
### Custom

The dict "[customDict]" is just for your own use, it just replace the key with the value without any special functionality. This might be used to fix incorrectly spoken words, make words more common, shorter or just for fun. :)
### Emoticons

The Emoticons dictionary "[emoticonDict]" by default contains some emoticons. it can replace ":)" with "smile" or "XD" with "loool" Making chat more colorful.
A nice feature with this dictionary  is that you can toggle the substitution on or off during run time or in settings.conf. This is useful because while doing programming or other serious work you want to hear colons and perryns not smiles.
# Configuration

You can configure Fenrir in the following places (ordered by priority):
 1.  Commandline Parameters ''-o'' see [Set settings coption](#Set settings coption)
 2.  /etc/fenrir/settings/settings.conf see [Settigns](#Settings)
 3.  `<sourceTree>`/config/settings/settings.conf see [Settigns](#Settings)
 4.  hard coded defaults
## Commandline Arguments

### Set settings option
You can specify options that overwrite the setting.conf.
This is done with ''-o `<list of options>` parameter.
The list of options have the following syntax
    fenrir -o "section#setting=value;section#setting=value"

For example changing the sound driver to gstreamer and disabling Braille  
    fenrir -o "sound#driver=gstreamerDriver;braille#enabled=False=False"
or change the debug level to verbose
    fenrir -o "general#debugLevel=3"
You can find the available sections and variables here [#Settings](#Settings)
See Syntax [#settings.conf syntax](#settings.conf syntax)
### settings.conf syntax

the syntax of the [settings.conf](#Settings) is quite simple and similar to a "*.ini" file, there are 4 different elements. 
 1.  Sections
 2.  Settings
 3.  Values
 4.  Comments

A comment starts with a # and is ignored by Fenrir.
    # this is a comment
To group settings we have sections.
A section can look like this:
    [Section]
A setting looks like this:
    settingName=Value

Example:
    [sound]
    # Turn sound on or off:
    enabled=True
    # Select the driver used to play sounds, choices are genericDriver and gstreamerDriver.
    # Sox is default.
    driver=genericDriver
    
## Settings

### Sound
The sound is configured in section ''[sound]''. 

Turn sound on or off:
    enabled=True
Values: on=''True'', off=''False''

Select the driver used to play sounds.
The genericDriver using Sox is the default.

    driver=genericDriver

Available Drivers:

*  ''genericDriver'' using the generic driver, for Fenrir <1.5 just use ''generic''

*  ''gstreamerDriver'' using the gstreamer, for Fenrir <1.5 just use ''gstreamer''

These are the pack of sounds used for sound icons.
    theme=default
By default we ship two sound packs.
 1.  ''default'' opus encoded, for newer Sox versions
 2.  ''default-wav'' wav encoded, just for compatibility
Sound packs are located at /usr/share/sounds/fenrir/

Sound volume controls how loud the sounds for your selected sound pack are.
    volume=1.0
Values: ''0.0'' is quietest, ''1.0'' is loudest.

#### Generic Driver

The generic sound driver uses shell commands for play sound and frequencies.

''genericPlayFileCommand'' defines the command that is used to play a sound file.
    genericPlayFileCommand=`<your command for playing a file>`
''genericFrequencyCommand'' defines the command that is used playing frequencies.
    genericFrequencyCommand=`<your command for playing a frequence>`
 
The following variables are substituted in ''genericPlayFileCommand'' and ''genericFrequencyCommand'':

*  ''fenrirVolume'' = the current volume setting

*  ''fenrirSoundFile'' = the sound file for an sound icon

*  ''fenrirFrequence'' = the frequency to play

*  ''fenrirDuration'' = the duration of the frequency

Example genericPlayFileCommand (default)
    genericPlayFileCommand=play -q -v fenrirVolume fenrirSoundFile
Example genericFrequencyCommand (default)
    genericFrequencyCommand=play -q -v fenrirVolume -n -c1 synth fenrirDuration sine fenrirFrequence
### Speech

Speech is configured in section ''[speech]''.
Turn speech on or off:
    enabled=True
Values: on=''True'', off=''False''

# Select speech driver, options are speechdDriver (default), genericDriver or espeakDriver:

driver=speechdDriver
#driver=espeakDriver

#driver=genericDriver

Select the driver used to generate speech output.

    driver=speechdDriver

Available Drivers:

*  ''genericDriver'' using the generic driver, for Fenrir <1.5 this is not available

*  ''speechdDriver'' using speech-dispatcher, for Fenrir <1.5 just use ''speechd''

*  ''espeakDriver'' using the espeak directly, for Fenrir <1.5 just use ''espeak''

The rate selects how fast Fenrir will speak. 
    rate=0.65
Values: Range Minimum:''0.0'' is slowest, Maximum:''1.0'' is fastest.

Pitch controls the pitch of the voice.
   pitch=0.5
Values: Range Minimum:''0.0'' is lowest, Maximum:''1.0'' is highest.

A Pitch for capital letters can be set.
    capitalPitch=0.9
Values: Range Minimum:''0.0'' is lowest, Maximum:''1.0'' is highest.

The Volume controls the loudness of the voice.
    volume=1.0
Values: Range Minimum:''0.0'' is quietest, Maximum:''1.0'' is loudest.

Some speech drivers like speechdDriver can support various modules. these can be set here.
    module=espeak
Values: Text, Consult speech-dispatcher's configuration to see what modules are available.

Voice selects the varient you want to use, for example, f5 will use the female voice #5 in Espeak,
or if using the Espeak module in Speech-dispatcher. To find out which voices are available, consult the documentation provided with your selected synthesizer.
    voice=
Values: Text, see your TTS synths documentation what is available.

Select the language you want Fenrir to use.
    language=english-us
Values: Text, see your TTS synths documentation what is available.

Read new text as it occurs
autoReadIncoming=True
Values: on=''True'', off=''False''

#### Generic Driver

The generic speech driver uses shell commands for speech synthisus.

''genericSpeechCommand'' defines the command that is executed for creating speech
The following variables are substituted in ''genericSpeechCommand'':

*  ''FenrirText'' = is the text that should be spoken

*  ''fenrirModule'' = may be the speech module like used in speech-dispatcher, not every TTY needs this

*  ''fenrirLanguage'' = the language to speak in

*  ''fenrirVoice'' = is the current voice that should be used

*  ''fenrirVolume'' = is replaced with the current volume

*  ''fenrirPitch'' = is replaced with the current pitch

*  ''fenrirRate'' = is replaced with the current speed (speech rate)

Example genericSpeechCommand (default):
    genericSpeechCommand=espeak -a fenrirVolume -s fenrirRate -p fenrirPitch -v fenrirVoice "fenrirText"

These are the minimum and maximum values of the TTS system used in genericSpeechCommand. They are needed to calculate the abstract range in volume, rate and pitch 0.0 - 1.0.

    FenrirMinVolume=0
    fenrirMaxVolume=200
    fenrirMinPitch=0
    fenrirMaxPitch=99
    fenrirMinRate=80
    fenrirMaxRate=450

The current volume, pitch and rate is calculated like this
value = min + [volume,pitch,rate] * (min - max )
### Braille

Braille is a WIP and not ready yet.
Braille support can be configured in section ''[braille]''.

Turn braille on or off:
    enabled=False
Values: on=''True'', off=''False''

Select the driver used for communication with a braille device.
    driver=brlapiDriver
Values: Text, available Driver
Available Drivers:

*  ''brlttyDriver'' using brltty for braille communication, for Fenrir <1.5 just use ''brltty''

The Braille layout can be configured here
    layout=en
Values: Text, see braille driver for layouts.

What should the flush timeout relate to 
    flushMode=word
Values: Text, an flushMode
Existing flushModes:

*  ''word'' = flush after (number of words to display) * seconds

*  ''char'' = flush after (number of chars to display) * seconds

*  ''fix'' = flush after X seconds

*  ''none'' = no automatic flush (manual via shortcut)

Seconds to flush (see flushMode)
    flushTimeout=3
Values: Integer, in Seconds or ''-1'' = no automatic flush (manual via shortcut)
The total flush time calculates in relation to flushMode.

How should the Braille cursor focus be tracked?
    cursorFocusMode=page
Values: Text, an existing cursor focus mode
Available cursor focus modes:

*  ''page'' = if the cursor crosses the border move to next page and start at begin

*  ''fixCell'' = ajust the cursor on a special cell where it is always placed. the display scroll here more smooth.


Define the cell on the Braille device where Fenrir should scroll and keep the cursor
    fixCursorOnCell=-1
Values: Integer

*  ''0'' = first cell on device,

*  ''-1'' = last cell on device 

*  ''>0'' = fix cell number

What cursor should Fenrir show on the Braille device
    cursorFollowMode=review
Values: Text, an exsiting cursor following mode.
Existing cursor following mode:

*  ''none'' = no automatic toggle command used

*  ''review'' = priority to review

*  ''last'' = follow last used cursor

number of cells in panning (horizontal). How many cell should be panned on press the routing key?
    panSizeHorizontal=0
Values: Integer,

*  ''0'' = display size

*  ''>0'' number of cells
### Screen

The settings for screens, (TTY, PTY) are configured in the ''[screen]'' section.

The driver to get the information from the screen:
    driver=vcsaDriver
Available Drivers:

*  ''vcsaDriver'' using the VCSA driver (for TTYs), for Fenrir <1.5 just use ''vcsa''
The encoding of the screen
    encoding=cp850
Values:''cp850'' is used for Western languages like USA or Europe.

The driver updates Fenrir with changes on the screen.
    screenUpdateDelay=0.05
Values: in Seconds

If you want Fenrir to not be active on any screen for various reasons. Maybe an X server or Wayland is running on that screen. You can make Fenrir ignore it or multiple screens seperated by '','' with:
    suspendingScreen=
Values: Depends on driver:

*  VCSA: the number of the TTY. TTY6 is ''6''.
Example ignore TTY1 and TTY2:
    suspendingScreen=1,2

There is also the ability to let Fenrir auto detect screens that are running an X server. So Screens running an GUI can be ignored.
    autodetectSuspendingScreen=True
Values: on=''True'', off=''False''

### Keyboard

The settings for keyboard and input related configuration is located in the section ''[keyboard]'' of the ''settings.conf'' file.

Select the driver used for grabbing keybord input and for recieving shortcuts.
    driver=evdevDriver
Values: Text, available Driver
Available Drivers:

*  ''evdevDriver'' uses the evdev input system of linux, for Fenrir <1.5 just use ''evdev''
    
You can let Fenrir know about what input devices are to be used.
    device=ALL
Values: 

*  ''ALL'' use all devices with key capabilities.

*  ''NOMICE'' Exclude mices from handling.

*  `<Device Name>` just use the device with the given name.
    
Gives Fenrir exclusive access to the keyboard and lets it control keystrokes. This is needed to intercept Fenrir related shortcuts.
    grabDevices=True
Values: on=''True'', off=''False''

The following makes sense if you are using a second screenreader and want to have some hooked events. Fenrir ignores all shortcuts then. 
    ignoreShortcuts=False
Values: on=''True'', off=''False''

The current keyboard layout used for shortcuts.
    keyboardLayout=desktop
 Values: An absolute Path to a Keyboard definition file or a Filename without extension located in  ''/etc/fenrir/keyboard''
 
Announce characters while typing.
    charEcho=False
Values: on=''True'', off=''False''

Announce deleted characters
    charDeleteEcho=True
Values: on=''True'', off=''False''

Announce word after pressing space
    wordEcho=False
Values: on=''True'', off=''False''

Interrupt speech on any keypress
    interruptOnKeyPress=False
Values: on=''True'', off=''False''

You can filter the keys that speech should interrupt 
    interruptOnKeyPressFilter=
Values: (List) empty = all keys, otherwise interrupt with specified keys

The timeout that is used for double tap shortcuts
    doubleTapTimeout=0.2
Values: Seconds
### General

Overall settings can be configured from the section ''[general]''.

Set the current debug level:
    debugLevel=1
Values: off=0, error=1, warning=2, info=3

the current punctuation and dict file in use:
    punctuationProfile=default
Values: Text, see available profiles in ''/etc/fenrir/punctuation'' or in ''sourceTree/config/punctuation''

The current punctuation level in use:
    punctuationLevel=some
Values: Text, See available levels in the used punctuation file.  

Respect pause for punctuations:
    respectPunctuationPause=True
Values: on=''True'', off=''False''

Add a pause on Line break:
    newLinePause=True
Values: on=''True'', off=''False''

Specify the path where the clipboard should be exported to.
See [export clipboard to file](#export clipboard to file).
The variable ''$user'' is replaced by the current logged username.
    clipboardExportPath=/tmp/fenrirClipboard
Values: Text, Systemfilepath

The number of available clipboards:
    numberOfClipboards=10
Values: Integer, 1 - 999

Replace emoticons like :) or ;) with text insertions:
    emoticons=True
Values: on=''True'', off=''False''  

Define the current Fenrir keys:
    fenrirKeys=KEY_KP0,KEY_META,KEY_INSERT
Values, Text list, separated by comma.

Define the current script keys: 
    scriptKey=KEY_COMPOSE
Values, Text list, separated by comma.

The time format to be used for (time command) output:
    timeFormat=%H:%M:%P
Values: see python specification for [datetime.strftime](https///docs.python.org/3/library/datetime.html#strftime-and-strptime-behavior)

The date format to be used for (date command) output:
    dateFormat=%A, %B %d, %Y
Values: see python specification for [datetime.strftime](https///docs.python.org/3/library/datetime.html#strftime-and-strptime-behavior)

Enable or Disable spellcheck whilst typing:
    autoSpellCheck=True
Values: on=''True'', off=''False''  

The use of the dictionary with spellcheck:
    spellCheckLanguage=en_US
Values: Text, see aspell dictionary's.

Folder Path for your scripts "scriptKey" functionality: 
    scriptPath=/usr/share/fenrir/scripts
Values: Text, Existing path on file system.

Override commands or create new ones without changing the Fenrir defaults:
    commandPath=/usr/share/fenrir/commands
Values: Text, Existing path on file system.
Subfolders in commandPath are:

*  ''commands'' = to create shortcut commands

*  ''onInput'' = executed while typing

*  ''onScreenChange'' = executed on change the screen (change from TTY4 to TTY6)

*  ''onScreenUpdate'' = executed when the screen is captured
    
### Focus

The configuration for basic focus is in the section ''[focus]''.
Follow the text cursor:
    cursor=True
Values: on=''True'', off=''False''
    
Follow highlighted text changes (Highlight Tracking):
    highlight=False
Values: on=''True'', off=''False''
### Review

Configurations for the review mode are in the section ''[review]''.

If "next word/ char" or "prev word/char" create a linebreak, announce it:
    lineBreak=True
Values: on=''True'', off=''False''

If "next word/ char" or "prev word/char" cannot be performed because you reached the end of the screen, announce it:
    endOfScreen=True
Values: on=''True'', off=''False''
    
Leave the review mode when pressing a key:
    leaveReviewOnKeypress=False
Values: on=''True'', off=''False''

Leave the review mode when changing the screen (From TTY3 to TTY4):
    leaveReviewOnScreenChange=True
Values: on=''True'', off=''False''
### Promote

"Promoted Lists" are configured in the section ''[promote]''.
Turn Promoted Lists" on or off:
    enabled=True
Values: on=''True'', off=''False''

The minimum time interval of inactivity to activate promoting.
By default it promotes after 120 Seconds inactivity:
    inactiveTimeoutSec=120
Values: in Seconds  

Define a list of promoted words comma seperated:
    list=
Values: text (comma seperated)
Example to promote the word "nickname" or a bash prompt:
    list=nickname,$:,#:
    
### Time

The automated time announcement is configured in the section ''[time]''.
Time announcement is disabled by default.
Turn time announcement on or off:
    enabled=True
Values: on=''True'', off=''False''

Should the time be announced:
    presentTime=True
Values: on=''True'', off=''False''

Should the date be announced (just on date change):
    presentDate=True
Values: on=''True'', off=''False''

Announce after a given period of seconds:
    delaySec=0
Value: in Seconds, 0 = Deactivated  

Announce after fixed minutes in an hour. if delaySec is >0 onMinutes is ignored:
    onMinutes=00,30
Example every 15 minutes: 
    onMinutes=00,15,30,45

Just play a soundicon, (not interrupting):
    announce=True
Values: on=''True'', off=''False''  

Interrupt current speech for time announcement:
    interrupt=False
Values: on=''True'', off=''False''
# Customization

## Scripting
Scripts can be in any language, bash, python, sh or others. Place your scripts in the directory /usr/share/fenrir/scripts/ (the path is configurable in settings.conf).
The script key is the applications key. Usually this key can be found on the keyboard located just left of the right most control key.
When you name a script, the key name appears in the script seperated by the sequence __-__. So, for example, if you have a python weather script you want assigned to the script key plus the letter w you would name the script /usr/share/fenrir/scripts/weather__-__key_w.py
Then, to access the script, simply press the script key and the letter w.
Scripts must be executable. So, make sure to chmod 755 your script when you place it in the scripts directory.
The script gets some parameters from fenrir when it is executed. So that information is available in your script then.

### Parameterlist

 | Parameter | Content                                | 
 | --------- | -------                                | 
 | $1        | Username of the current logged in user | 

### Examples

Script that just speaks the current username when pressing ScriptKey + H.\\
File: ''/usr/share/fenrir/scripts/helloWorld__-__key_h.sh'':
    #!/bin/bash
    echo $1


## Commands

You can place your own commands in "/usr/share/fenrir/commands" (path is configurable in settings.conf).
Commands are python files with a special scheme. You can assign them to a shortcut using the filename without an extension or place them in a hook trigger like OnInput or OnScreenChange. For further information see developer guide.
Good Examples: ["date.py"](https///github.com/chrys87/fenrir/blob/master/src/fenrir/commands/commands/date.py) (announce the Date), ["shut_up.py"](https///github.com/chrys87/fenrir/blob/master/src/fenrir/commands/commands/shut_up.py) (interrupt output)
the basic scheme for a command is as follows:

    from core import debug
    
    class command():
      def __init__(self):
          pass
      def initialize(self, environment):
          self.env = environment
      def shutdown(self):
          pass
      def getDescription(self):
          return _('No description found')
      def run(self):
          pass
      def setCallback(self, callback):
          pass


*  [Template lives here](https///github.com/chrys87/fenrir/blob/master/src/fenrir/commands/command_template.py)

*  The class needs to have the name "command".

*  "initialize" is running once whilst loading the command.

*  "shutdown" is running on unload like the command (quit fenrir)

*  "getDescriptsion" just returns an string. That String is used in Tutorial Mode.

*  "run" is executed when the command is invoked. (shortcut is pressed, or trigger isn't running)

*  setCAllback is currently not used. and has no functionality yet.


# Troubleshooting

## Fenrir does not start
 1.  Have you installed all the dependencies [Support and Requirements](#Support and Requirements)
 2.  Try using master, a lot of changes take place there to make Fenrir compatible with more systems
## Fenrir does not utilize the shortcuts

 1.  Make sure you have python3-evdev installed
 2.  Use the latest Fenrir version
 3.  Make sure that Fenrir has permission to /dev/input/* and /dev/uinput (or run it as root)
## No sound at all

 1.  Run the script to configure Pulseaudio once as root and once as your user. This will setup Pulseaudio but require a restart of Pulseaudio. The script is located in ''tools/configure_pulse.sh''
 2.  Use ALSA
 3.  [Configure Pulse system wide](https///www.freedesktop.org/wiki/Software/PulseAudio/Documentation/User/SystemWide/) (Not recommended)
 4.  Use gstreamerDriver: change ''settings.conf'' in the section ''sound'' the line ''driver=genericDriver'' to ''driver=gstreamerDriver''
 5.  Use wave sound-icons: change ''settings.conf'' in the section ''sound'' the line ''theme=default'' to ''theme=default-wav''
 6.  Use most current version of [sox](http://sox.sourceforge.net/) with opus support
 7.  Try [apulse](https///github.com/i-rinat/apulse) (not tested by myself but might work). Please give me feedback if you try it out.
## You get sound-icons but no speech

 1.  If you are using speech-dispatcher run "spd-conf" once as user and as root.
 2.  You can test if speech-dispatcher works by invoking it as root\\  ''sudo spd-say "hello world"''
## Bugreports and feature requests

Please report Bugs and feature requests to:
[https://github.com/chrys87/fenrir/issues](https///github.com/chrys87/fenrir/issues)

for bugs please provide a [debug](#Howto create a debug file) file that shows the issue.
### How-to create a debug file

 1.  Delete old debug stuff\\  ''sudo rm /var/log/fenrir.log''
 2.  Start fenrir in debug mode\\ ''sudo fenrir -d''
 3.  Do your stuff to reproduce the problem
 4.  Stop fenrir (''fenrirKey + q'')
the debug file is located in ''/var/log/fenrir.log''

Please be as precise as possible to make it easy to solve the problem.

