# frozen_string_literal: true

describe Facts::Linux::Memory::System::Capacity do
  describe '#call_the_resolver' do
    subject(:fact) { Facts::Linux::Memory::System::Capacity.new }

    let(:value) { '5.3%' }

    before do
      allow(Facter::Resolvers::Linux::Memory).to \
        receive(:resolve).with(:capacity).and_return(value)
    end

    it 'returns system memory capacity fact' do
      expect(fact.call_the_resolver).to be_an_instance_of(Facter::ResolvedFact).and \
        have_attributes(name: 'memory.system.capacity', value: value)
    end
  end
end
