!! NOTES
!!  This file has been automatically generated by the config/scripts/autogen_tests.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten. See the template file in config/etsf/template.tests.

program tests_copy

  use etsf_io_low_level
  use etsf_io
  
  use tests
  
  implicit none

  call test_data_copy()
  call test_copy_geometry()
  call test_copy_electrons()
  call test_copy_kpoints()
  call test_copy_basisdata()
  call test_copy_gwdata()
  call test_copy_dielectric()
  call test_copy_main()

  
contains

  subroutine test_data_copy()
    type(etsf_dims) :: dims
    type(etsf_groups) :: grp
    integer :: ncid
    type(etsf_io_low_error) :: error
    type(etsf_io_low_var_double) :: var
    character(len = *), parameter :: me = "test_data_copy"
    logical :: lstat

    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."

call etsf_io_data_copy("Makefile", "pouet", dims, lstat, error)
call tests_status("source_file: wrong value (no file)", (.not. lstat), error)

call etsf_io_data_copy("Makefile", "Makefile", dims, lstat, error)
call tests_status("source_file: wrong value (text file)", (.not. lstat), error)

call etsf_io_data_copy("pouet", "test_write_geometry.nc", dims, lstat, error)
call tests_status("dest_file: wrong value (no file)", (.not. lstat), error)

call etsf_io_data_copy("Makefile", "test_write_geometry.nc", dims, lstat, error)
call tests_status("dest_file: wrong value (text file)", (.not. lstat), error)


    write(*,*)

  end subroutine test_data_copy

  subroutine test_copy_geometry()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_geometry), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_copy_geometry"
    integer :: ncid
  
    groups%geometry => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."
  
  call etsf_io_low_open_read(ncid, "test_write_geometry.nc", lstat, error_data = error_data)
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  call etsf_io_low_close(ncid, lstat, error_data)
  
    flags%geometry = etsf_geometry_all
    call etsf_io_data_init("test_copy_geometry.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_copy_geometry.nc", lstat, error_data)
    call etsf_io_data_copy("test_copy_geometry.nc", "test_write_geometry.nc", &
                          & dims, lstat, error_data)
    call tests_status("copy data to test_copy_geometry.nc", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_copy_geometry.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "space_group", "integer", lstat, error_data)
  call tests_check_variable(ncid, "primitive_vectors", "real double_precision", (/ &
    & dims%number_of_cartesian_directions, &
    & dims%number_of_vectors /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_symmetry_matrices", "integer", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_symmetry_operations /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_symmetry_translations", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_symmetry_operations /), lstat, error_data)
  call tests_check_variable(ncid, "atom_species", "integer", (/ &
    & dims%number_of_atoms /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_atom_positions", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_atoms /), lstat, error_data)
  call tests_check_variable(ncid, "valence_charges", "real double_precision", (/ &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "atomic_numbers", "real double_precision", (/ &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "atom_species_names", "string", (/ &
    & dims%character_string_length, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "chemical_symbols", "string", (/ &
    & dims%symbol_length, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "pseudopotential_types", "string", (/ &
    & dims%character_string_length, &
    & dims%number_of_atom_species /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
  
    write(*,*)
  end subroutine test_copy_geometry
  
    subroutine test_copy_electrons()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_electrons), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_copy_electrons"
    integer :: ncid
  
    groups%electrons => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."
  
  call etsf_io_low_open_read(ncid, "test_write_electrons.nc", lstat, error_data = error_data)
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  call etsf_io_low_close(ncid, lstat, error_data)
  
    flags%electrons = etsf_electrons_all
    call etsf_io_data_init("test_copy_electrons.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_copy_electrons.nc", lstat, error_data)
    call etsf_io_data_copy("test_copy_electrons.nc", "test_write_electrons.nc", &
                          & dims, lstat, error_data)
    call tests_status("copy data to test_copy_electrons.nc", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_copy_electrons.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "number_of_electrons", "integer", lstat, error_data)
  call tests_check_variable(ncid, "exchange_functional", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "correlation_functional", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "fermi_energy", "real double_precision", lstat, error_data)
  call tests_check_variable(ncid, "smearing_scheme", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "smearing_width", "real double_precision", lstat, error_data)
  call tests_check_variable(ncid, "number_of_states", "integer", (/ &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "eigenvalues", "real double_precision", (/ &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "occupations", "real double_precision", (/ &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
  
    write(*,*)
  end subroutine test_copy_electrons
  
    subroutine test_copy_kpoints()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_kpoints), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_copy_kpoints"
    integer :: ncid
  
    groups%kpoints => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."
  
  call etsf_io_low_open_read(ncid, "test_write_kpoints.nc", lstat, error_data = error_data)
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  call etsf_io_low_close(ncid, lstat, error_data)
  
    flags%kpoints = etsf_kpoints_all
    call etsf_io_data_init("test_copy_kpoints.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_copy_kpoints.nc", lstat, error_data)
    call etsf_io_data_copy("test_copy_kpoints.nc", "test_write_kpoints.nc", &
                          & dims, lstat, error_data)
    call tests_status("copy data to test_copy_kpoints.nc", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_copy_kpoints.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "kpoint_grid_shift", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions /), lstat, error_data)
  call tests_check_variable(ncid, "kpoint_grid_vectors", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_vectors /), lstat, error_data)
  call tests_check_variable(ncid, "monkhorst_pack_folding", "integer", (/ &
    & dims%number_of_vectors /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_coordinates_of_kpoints", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_kpoints /), lstat, error_data)
  call tests_check_variable(ncid, "kpoint_weights", "real double_precision", (/ &
    & dims%number_of_kpoints /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
  
    write(*,*)
  end subroutine test_copy_kpoints
  
    subroutine test_copy_basisdata()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_basisdata), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_copy_basisdata"
    integer :: ncid
  
    groups%basisdata => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."
  
  call etsf_io_low_open_read(ncid, "test_write_basisdata.nc", lstat, error_data = error_data)
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  call etsf_io_low_close(ncid, lstat, error_data)
  
    flags%basisdata = etsf_basisdata_all
    call etsf_io_data_init("test_copy_basisdata.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_copy_basisdata.nc", lstat, error_data)
    call etsf_io_data_copy("test_copy_basisdata.nc", "test_write_basisdata.nc", &
                          & dims, lstat, error_data)
    call tests_status("copy data to test_copy_basisdata.nc", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_copy_basisdata.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "basis_set", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "kinetic_energy_cutoff", "real double_precision", lstat, error_data)
  call tests_check_variable(ncid, "number_of_coefficients", "integer", (/ &
    & dims%number_of_kpoints /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_coordinates_of_plane_waves", "integer", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%max_number_of_coefficients, &
    & dims%number_of_kpoints /), lstat, error_data)
  call tests_check_variable(ncid, "coordinates_of_basis_grid_points", "integer", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%max_number_of_basis_grid_points, &
    & dims%number_of_localization_regions /), lstat, error_data)
  call tests_check_variable(ncid, "number_of_coefficients_per_grid_point", "integer", (/ &
    & dims%max_number_of_basis_grid_points, &
    & dims%number_of_localization_regions /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
  
    write(*,*)
  end subroutine test_copy_basisdata
  
    subroutine test_copy_gwdata()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_gwdata), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_copy_gwdata"
    integer :: ncid
  
    groups%gwdata => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."
  
  call etsf_io_low_open_read(ncid, "test_write_gwdata.nc", lstat, error_data = error_data)
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  call etsf_io_low_close(ncid, lstat, error_data)
  
    flags%gwdata = etsf_gwdata_all
    call etsf_io_data_init("test_copy_gwdata.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_copy_gwdata.nc", lstat, error_data)
    call etsf_io_data_copy("test_copy_gwdata.nc", "test_write_gwdata.nc", &
                          & dims, lstat, error_data)
    call tests_status("copy data to test_copy_gwdata.nc", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_copy_gwdata.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "gw_corrections", "real double_precision", (/ &
    & dims%real_or_complex_gw_corrections, &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "kb_formfactor_sign", "integer", (/ &
    & dims%max_number_of_projectors, &
    & dims%max_number_of_angular_momenta, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "kb_formfactors", "real double_precision", (/ &
    & dims%max_number_of_coefficients, &
    & dims%number_of_kpoints, &
    & dims%max_number_of_projectors, &
    & dims%max_number_of_angular_momenta, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "kb_formfactor_derivative", "real double_precision", (/ &
    & dims%max_number_of_coefficients, &
    & dims%number_of_kpoints, &
    & dims%max_number_of_projectors, &
    & dims%max_number_of_angular_momenta, &
    & dims%number_of_atom_species /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
  
    write(*,*)
  end subroutine test_copy_gwdata
  
    subroutine test_copy_dielectric()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_dielectric), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_copy_dielectric"
    integer :: ncid
  
    groups%dielectric => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."
  
  call etsf_io_low_open_read(ncid, "test_write_dielectric.nc", lstat, error_data = error_data)
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  call etsf_io_low_close(ncid, lstat, error_data)
  
    flags%dielectric = etsf_dielectric_all
    call etsf_io_data_init("test_copy_dielectric.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_copy_dielectric.nc", lstat, error_data)
    call etsf_io_data_copy("test_copy_dielectric.nc", "test_write_dielectric.nc", &
                          & dims, lstat, error_data)
    call tests_status("copy data to test_copy_dielectric.nc", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_copy_dielectric.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "frequencies_dielectric_function", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "qpoints_dielectric_function", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_qpoints_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "qpoints_gamma_limit", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_qpoints_gamma_limit /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
  
    write(*,*)
  end subroutine test_copy_dielectric
  
    subroutine test_copy_main()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_main), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_copy_main"
    integer :: ncid
  
    groups%main => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_copy()..."
  
  call etsf_io_low_open_read(ncid, "test_write_main.nc", lstat, error_data = error_data)
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  call etsf_io_low_close(ncid, lstat, error_data)
  
    flags%main = etsf_main_all
    call etsf_io_data_init("test_copy_main.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_copy_main.nc", lstat, error_data)
    call etsf_io_data_copy("test_copy_main.nc", "test_write_main.nc", &
                          & dims, lstat, error_data)
    call tests_status("copy data to test_copy_main.nc", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_copy_main.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "density", "real double_precision", (/ &
    & dims%real_or_complex_density, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "exchange_potential", "real double_precision", (/ &
    & dims%real_or_complex_potential, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "correlation_potential", "real double_precision", (/ &
    & dims%real_or_complex_potential, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "exchange_correlation_potential", "real double_precision", (/ &
    & dims%real_or_complex_potential, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "coefficients_of_wavefunctions", "real double_precision", (/ &
    & dims%real_or_complex_coefficients, &
    & dims%max_number_of_coefficients, &
    & dims%number_of_spinor_components, &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "real_space_wavefunctions", "real double_precision", (/ &
    & dims%real_or_complex_wavefunctions, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_spinor_components, &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
  
    write(*,*)
  end subroutine test_copy_main
  
  

end program tests_copy
