/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

class GraphFactory {
    private String title = "";
    private XYSeriesCollection dataset = new XYSeriesCollection();

    public GraphFactory(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    public void addDataSet(String name, double[][] chartData) {
        if (name == null) {
            name = "Default";
        }
        XYSeries serie = new XYSeries((Comparable)((Object)name));
        int i = 0;
        while (i < chartData.length) {
            serie.add(chartData[i][0], chartData[i][1]);
            ++i;
        }
        this.dataset.addSeries(serie);
    }

    public JPanel getGraph() {
        JFreeChart chart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        return chartPanel;
    }

    private JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createXYLineChart(this.title, "Wavelength", "Amplitude", this.dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(1, false);
        plot.setRenderer(renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }
}

