%define name eris
%define version 1.3.19
%define release 1
%define libsuffix -1.3

Summary: A WorldForge client library.
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Group: System Environment/Libraries
URL: http://www.worldforge.org/dev/eng/libraries/eris
Packager: Al Riddoch <alriddoch@googlemail.com>
Vendor: WorldForge
Distribution: Mason
Source: %{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: atlascpp-devel >= 0.5.98 wfmath-devel >= 0.3.2 skstream-devel >= 0.3.5
Obsoletes: eris-poll-glib

%description
Eris is designed to simplify client development (and avoid repeating the same
work several times), by providing a common system to deal with the back end
tasks.

%package devel
Summary: A WorldForge client library headers.
Group: Development/Libraries
Requires: %{name} = %{version} atlascpp-devel wfmath-devel skstream-devel

%description devel
Eris is designed to simplify client development (and avoid repeating the same
work several times), by providing a common system to deal with the back end
tasks.

%package static
Summary: A WorldForge client library static libs.
Group: Development/Libraries
Requires: %{name} = %{version} atlascpp-devel wfmath-devel skstream-devel

%description static
Eris is designed to simplify client development (and avoid repeating the same
work several times), by providing a common system to deal with the back end
tasks.

%package docs
Summary: A WorldForge client library documentation.
Group: Documentation

%description docs
Eris is designed to simplify client development (and avoid repeating the same
work several times), by providing a common system to deal with the back end
tasks.

%prep
%setup -q

%build
CXXFLAGS=$RPM_OPT_FLAGS %configure --enable-static
make
make doc

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
rm -f $RPM_BUILD_ROOT/%{_libdir}/lib*.la

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_libdir}/lib*.so.*
%doc AUTHORS COPYING NEWS README

%files devel
%defattr(-,root,root)
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/*
%{_includedir}/*

%files static
%defattr(-,root,root)
%{_libdir}/lib*.a

%files docs
%defattr(-,root,root)
%doc docs/html/*
