/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import com.stevesoft.pat.Regex;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import java.util.Hashtable;
import java.util.Vector;

public class DBRefUtils {
    public static Hashtable DasCoordinateSystemsLookup = null;
    public static Hashtable CanonicalSourceNameLookup = null;
    public static DbRefComp matchNonNullonA = new DbRefComp(){

        public boolean matches(DBRefEntry refa, DBRefEntry refb) {
            return !(refa.getSource() != null && !refb.getSource().equals(refa.getSource()) || refa.getVersion() != null && !refb.getVersion().equals(refa.getVersion()) || refa.getAccessionId() != null && !refb.getAccessionId().equals(refa.getAccessionId()) || refa.getMap() != null && (refb.getMap() == null || !refb.getMap().equals(refa.getMap())));
        }
    };
    public static DbRefComp matchEitherNonNull = new DbRefComp(){

        public boolean matches(DBRefEntry refa, DBRefEntry refb) {
            return !(refa.getSource() != null && refb.getSource() != null && !refb.getSource().equals(refa.getSource()) || refa.getVersion() != null && refb.getVersion() != null && !refb.getVersion().equals(refa.getVersion()) || refa.getAccessionId() != null && refb.getAccessionId() != null && !refb.getAccessionId().equals(refa.getAccessionId()) || refa.getMap() != null && refb.getMap() != null && (refb.getMap() == null || !refb.getMap().equals(refa.getMap())));
        }
    };
    public static DbRefComp matchDbAndIdAndEitherMap = new DbRefComp(){

        public boolean matches(DBRefEntry refa, DBRefEntry refb) {
            return refa.getSource() != null && refb.getSource() != null && refb.getSource().equals(refa.getSource()) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId())) && (refa.getMap() == null || refb.getMap() == null || refa.getMap() != null && refb.getMap() != null && refb.getMap().equals(refa.getMap()));
        }
    };
    public static DbRefComp matchDbAndIdAndComplementaryMapList = new DbRefComp(){

        public boolean matches(DBRefEntry refa, DBRefEntry refb) {
            return refa.getSource() != null && refb.getSource() != null && refb.getSource().equals(refa.getSource()) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId())) && (refa.getMap() == null && refb.getMap() == null || refa.getMap() != null && refb.getMap() != null) && (refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().getInverse().equals(refa.getMap().getMap()));
        }
    };
    public static DbRefComp matchDbAndIdAndEquivalentMapList = new DbRefComp(){

        public boolean matches(DBRefEntry refa, DBRefEntry refb) {
            if (refa.getSource() != null && refb.getSource() != null && refb.getSource().equals(refa.getSource()) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId()))) {
                if (refa.getMap() == null && refb.getMap() == null) {
                    return true;
                }
                if (refa.getMap() != null && refb.getMap() != null && (refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().equals(refa.getMap().getMap()))) {
                    return true;
                }
            }
            return false;
        }
    };
    public static DbRefComp matchDbAndIdAndEitherMapOrEquivalentMapList = new DbRefComp(){

        public boolean matches(DBRefEntry refa, DBRefEntry refb) {
            if (refa.getSource() != null && refb.getSource() != null && refb.getSource().equals(refa.getSource()) && refa.getAccessionId() != null && refb.getAccessionId() != null && refb.getAccessionId().equals(refa.getAccessionId())) {
                if (refa.getMap() == null || refb.getMap() == null) {
                    return true;
                }
                if (refa.getMap() != null && refb.getMap() != null && refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().equals(refa.getMap().getMap())) {
                    return true;
                }
            }
            return false;
        }
    };

    public static DBRefEntry[] selectRefs(DBRefEntry[] dbrefs, String[] sources) {
        int i;
        if (dbrefs == null) {
            return null;
        }
        if (sources == null) {
            return dbrefs;
        }
        Hashtable<String, Integer> srcs = new Hashtable<String, Integer>();
        Vector<DBRefEntry> res = new Vector<DBRefEntry>();
        for (i = 0; i < sources.length; ++i) {
            srcs.put(new String(sources[i]), new Integer(i));
        }
        int j = dbrefs.length;
        for (i = 0; i < j; ++i) {
            if (!srcs.containsKey(dbrefs[i].getSource())) continue;
            res.addElement(dbrefs[i]);
        }
        if (res.size() > 0) {
            DBRefEntry[] reply = new DBRefEntry[res.size()];
            for (int i2 = 0; i2 < res.size(); ++i2) {
                reply[i2] = (DBRefEntry)res.elementAt(i2);
            }
            return reply;
        }
        res = null;
        return null;
    }

    public static boolean isDasCoordinateSystem(String string, DBRefEntry dBRefEntry) {
        String coordsys;
        if (DasCoordinateSystemsLookup == null) {
            DasCoordinateSystemsLookup = new Hashtable();
            DasCoordinateSystemsLookup.put("pdbresnum", DBRefSource.PDB);
            DasCoordinateSystemsLookup.put("uniprot", DBRefSource.UNIPROT);
            DasCoordinateSystemsLookup.put("EMBL", DBRefSource.EMBL);
        }
        if ((coordsys = (String)DasCoordinateSystemsLookup.get(string.toLowerCase())) != null) {
            return coordsys.equals(dBRefEntry.getSource());
        }
        return false;
    }

    public static String getCanonicalName(String source) {
        String canonical;
        if (CanonicalSourceNameLookup == null) {
            CanonicalSourceNameLookup = new Hashtable();
            CanonicalSourceNameLookup.put("uniprotkb/swiss-prot", DBRefSource.UNIPROT);
            CanonicalSourceNameLookup.put("uniprotkb/trembl", DBRefSource.UNIPROT);
            CanonicalSourceNameLookup.put("pdb", DBRefSource.PDB);
        }
        if ((canonical = (String)CanonicalSourceNameLookup.get(source.toLowerCase())) == null) {
            return source;
        }
        return canonical;
    }

    public static DBRefEntry[] searchRefs(DBRefEntry[] ref, DBRefEntry entry) {
        return DBRefUtils.searchRefs(ref, entry, matchDbAndIdAndEitherMapOrEquivalentMapList);
    }

    public static DBRefEntry[] searchRefs(DBRefEntry[] ref, DBRefEntry entry, DbRefComp comparator) {
        if (ref == null || entry == null) {
            return null;
        }
        Vector<DBRefEntry> rfs = new Vector<DBRefEntry>();
        for (int i = 0; i < ref.length; ++i) {
            if (!comparator.matches(entry, ref[i])) continue;
            rfs.addElement(ref[i]);
        }
        if (rfs.size() > 0) {
            Object[] rf = new DBRefEntry[rfs.size()];
            rfs.copyInto(rf);
            return rf;
        }
        return null;
    }

    public static DBRefEntry parseToDbRef(SequenceI seq, String dbname, String version, String acn) {
        DBRefEntry ref = null;
        if (dbname != null) {
            String locsrc = DBRefUtils.getCanonicalName(dbname);
            if (locsrc.equals(DBRefSource.PDB)) {
                Regex r = new Regex("([0-9][0-9A-Za-z]{3})\\s*(.?)\\s*;([0-9]+)-([0-9]+)");
                if (r.search(acn.trim())) {
                    String pdbid = r.stringMatched(1);
                    String chaincode = r.stringMatched(2);
                    String mapstart = r.stringMatched(3);
                    String mapend = r.stringMatched(4);
                    if (chaincode.equals(" ")) {
                        chaincode = "_";
                    }
                    ref = new DBRefEntry(locsrc, version, pdbid + chaincode);
                    PDBEntry pdbr = new PDBEntry();
                    pdbr.setId(pdbid);
                    seq.addPDBId(pdbr);
                }
            } else {
                ref = new DBRefEntry(locsrc, version, acn);
            }
        }
        if (ref != null) {
            seq.addDBRef(ref);
        }
        return ref;
    }

    public static interface DbRefComp {
        public boolean matches(DBRefEntry var1, DBRefEntry var2);
    }
}

