/*
Copyright (C) 2002 Pedro Zorzenon Neto <pzn@vztech.com.br>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: memory.c,v 1.2 2003/06/30 17:20:25 pzn Exp $
*/
#include "common.h"
#include "memory.h"
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

memory_t * memory_init(unsigned long int size) {
  memory_t * self;
  int * data;
  self=malloc(sizeof(memory_t*));
  assert(self!=NULL);
  assert(size>0);
  data=malloc((sizeof(int))*size);
  assert(data!=NULL);
  self->size=size;
  self->data=data;
  return self;
}

void memory_destroy(memory_t* self) {
  if (self!=NULL) {
    if (self->data!=NULL) {
      free(self->data);
    }
    free(self);
  }
}

void memory_fill (memory_t* self, int value) {
  int i;
  for (i=0; i<self->size; i++) {
    self->data[i]=value;
  }
}


int memory_read(memory_t* self, unsigned int addr) {
  assert( self->size > addr );
  return self->data[addr];
}

void memory_write (memory_t* self, unsigned int addr, int value) {
  assert( self->size > addr );
  self->data[addr]=value;
}

int memory_compare (memory_t* mem1, memory_t* mem2) {
  unsigned int i;
  if (mem1->size != mem2->size)
    return 0;
  for (i=0; i<(mem1->size); i++) {
    if ( (mem1->data[i]) != (mem2->data[i]) ) {
      return 0;
    }
  }
  return 1;
}

#ifdef TEST
int main() {
  memory_t* mt;
  int i;
  mt=memory_init(16);
  memory_fill(mt, -34);
  memory_write (mt, 13, 1132);
  memory_write (mt, 12, 1122);
  memory_write (mt, 14, 1142);
  memory_write (mt, 11, 1112);
  for (i=0; i<16; i++) {
    printf("addr=%d value=%d\n",i,memory_read(mt, i));
  }
  memory_destroy(mt);
  return 0;
}
#endif
