function o = uplus(o)  % --*-- Unitary tests --*--

% Overloads the unary plus operator for dates objects. Shifts all the elements by one period.
%
% INPUTS
% - o [dates]
%
% OUTPUTS
% - o [dates]

% Copyright (C) 2013-2017 Dynare Team
%
% This code is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare dates submodule is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

o.time(:,2) = o.time(:,2)+1;
idx = find(o.time(:,2)>o.freq); % Happy new year!
o.time(idx,1) = o.time(idx,1)+1;
o.time(idx,2) = 1;

%@test:1
%$ % Define some dates
%$ date_1 = '1950Y';
%$ date_2 = '1950Q2';
%$ date_3 = '1950Q4';
%$ date_4 = '1950M2';
%$ date_5 = '1950M12';
%$
%$ % Call the tested routine.
%$ d1 = dates(date_1); +d1;
%$ d2 = dates(date_2); +d2;
%$ d3 = dates(date_3); +d3;
%$ d4 = dates(date_4); +d4;
%$ d5 = dates(date_5); +d5;
%$ i1 = (d1==dates('1951Y'));
%$ i2 = (d2==dates('1950Q3'));
%$ i3 = (d3==dates('1951Q1'));
%$ i4 = (d4==dates('1950M3'));
%$ i5 = (d5==dates('1951M1'));
%$
%$ % Check the results.
%$ t(1) = dassert(i1,true);
%$ t(2) = dassert(i2,true);
%$ t(3) = dassert(i3,true);
%$ t(4) = dassert(i4,true);
%$ t(5) = dassert(i5,true);
%$ T = all(t);
%@eof:1

%@test:2
%$ d1 = dates('1950Q1','1950Q2','1950Q3','1950Q4','1951Q1');
%$ d2 = dates('1950Q2','1950Q3','1950Q4','1951Q1','1951Q2');
%$ try
%$   +d1;
%$   t(1) = 1;
%$ catch
%$   t(1) = 0;
%$ end
%$
%$ if t(1)
%$   t(2) = dassert(all(d2==d1),true);
%$ end
%$
%$ T = all(t);
%@eof:2