/*
 * Copyright (C) 2007-2009 KenD00
 * 
 * This file is part of DumpHD.
 * 
 * DumpHD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package dumphd.gui;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
//import java.awt.event.ComponentAdapter;
//import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * Simple Dialog that provides a text box to enter data and the possibility to validate that data before accepting it.
 * 
 * @author KenD00
 */
public class ValidatedInputDialog {

   private JDialog dialog = null;
   private JTextField valueField = null;
   private String validateErrorMsg = null;
   private boolean dialogConfirmed = false;
   private Pattern validatePattern = null;


   public ValidatedInputDialog() {
      dialog = new JDialog();
      createDialog(null, null, null, null, 16, ".*", "", "OK", "Cancel");
   }

   public ValidatedInputDialog(JDialog owner, String title, String message, String valueName, String initialValue, int valueLength, String validatePattern, String validateErrorMsg, String confirmLabel, String cancelLabel) {
      dialog = new JDialog(owner);
      createDialog(title, message, valueName, initialValue, valueLength, validatePattern, validateErrorMsg, confirmLabel, cancelLabel);
   }

   public ValidatedInputDialog(JFrame owner, String title, String message, String valueName, String initialValue, int valueLength, String validatePattern, String validateErrorMsg, String confirmLabel, String cancelLabel) {
      dialog = new JDialog(owner);
      createDialog(title, message, valueName, initialValue, valueLength, validatePattern, validateErrorMsg, confirmLabel, cancelLabel);
   }

   private void createDialog(String title, String message, String valueName, String initialValue, int valueLength, String validatePattern, String validateErrorMsg, String confirmLabel, String cancelLabel) {
      this.validateErrorMsg = validateErrorMsg;
      this.validatePattern = Pattern.compile(validatePattern);

      dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
      dialog.setModal(true);
      dialog.setResizable(false);

      JPanel contentPane = new JPanel();
      contentPane.setOpaque(true);
      contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.PAGE_AXIS));
      contentPane.setBorder(Manager.createEmptyBorder());
      if (title != null) {
         dialog.setTitle(title);
      }
      if (message != null) {
         JLabel messageLabel = new JLabel(message);
         messageLabel.setAlignmentX(JComponent.CENTER_ALIGNMENT);
         contentPane.add(messageLabel);
         contentPane.add(Box.createRigidArea(Manager.BOX_VERTICAL_BIG_SPACING));
      }
      JPanel panel = new JPanel();
      panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
      panel.setAlignmentX(JComponent.CENTER_ALIGNMENT);
      if (valueName != null) {
         JLabel valueLabel = new JLabel(valueName);
         panel.add(valueLabel);
         panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_SMALL_SPACING));
      }
      if (initialValue != null) {
         valueField = new JTextField(initialValue, valueLength);
         valueField.selectAll();
      } else {
         valueField = new JTextField(valueLength);
      }
      panel.add(valueField);
      contentPane.add(panel);
      contentPane.add(Box.createRigidArea(Manager.BOX_VERTICAL_BIG_SPACING));
      panel = new JPanel();
      panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
      panel.setAlignmentX(JComponent.CENTER_ALIGNMENT);
      ButtonListener buttonListener = new ButtonListener();
      JButton confirmButton = new JButton(confirmLabel);
      confirmButton.setActionCommand("confirm");
      confirmButton.addActionListener(buttonListener);
      JButton cancelButton = new JButton(cancelLabel);
      cancelButton.setActionCommand("cancel");
      cancelButton.addActionListener(buttonListener);
      Manager.equalizeComponentSize(confirmButton, cancelButton);
      panel.add(confirmButton);
      panel.add(Box.createRigidArea(Manager.BOX_HORIZONTAL_SMALL_SPACING));
      panel.add(cancelButton);
      contentPane.add(panel);

      dialog.setContentPane(contentPane);
      dialog.getRootPane().setDefaultButton(confirmButton);
      //dialog.addComponentListener(new ComponentAdapter() {
      //    public void componentShown(ComponentEvent e) {
      //        valueField.requestFocusInWindow();
      //    }
      //});
      dialog.addWindowFocusListener(new WindowAdapter() {
         public void windowGainedFocus(WindowEvent e) {
            valueField.requestFocusInWindow();
         }
      });
      dialog.pack();
   }

   public boolean show() {
      dialog.setLocationRelativeTo(dialog.getParent());
      dialog.setVisible(true);
      return dialogConfirmed;
   }

   public String getText() {
      return valueField.getText().trim();
   }

   private class ButtonListener implements ActionListener {

      public void actionPerformed(ActionEvent e) {
         String command = e.getActionCommand();
         if (command.equals("confirm")) {
            Matcher validator = validatePattern.matcher(valueField.getText().trim());
            if (validator.matches()) {
               dialogConfirmed = true;
               dialog.dispose();
            } else {
               JOptionPane.showMessageDialog(dialog, validateErrorMsg, "Error", JOptionPane.ERROR_MESSAGE);
            }
         } else if (command.equals("cancel")) {
            dialog.dispose();
         }
      }
   }

}
