/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "textboard.h"
#include "dingl.h"
#include "font.h"
#include "basic_editor.h"

#include <iostream>
using namespace std;

void textboard::draw () {
  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glLoadIdentity ();
  extern viewport view;
  glOrtho (0, view.xmax, 0, view.ymax, -1, 1);
  for (int i = 0, j = texts.size(); i < j; ++i) {
    text& t = texts[i];

    glColor3f (0.2, 0.2, 0.2);
    if (t.type == text::vlabel) {
      glBegin (GL_LINES);
        glVertex2i (t.vx, 0);
        glVertex2i (t.vx, view.ymax);
      glEnd ();
    } else if (t.type == text::hlabel) {
      glBegin (GL_LINES);
        glVertex2i (0, t.vy);
        glVertex2i (view.xmax, t.vy);
      glEnd ();
    }

    glColor3f (t.r, t.g, t.b);
    draw_string (t.txt, t.vx, t.vy);
  }
  glPopMatrix ();
}

void textboard::clear () {
  unsigned int i = 0;
  while (i < texts.size ()) {
    text& ti = texts[i];
    if (ti.state == text::temporary) texts.erase (texts.begin() + i); else ++i;
  }
}

void textboard::erase (const string& s) {
  unsigned int i = 0;
  while (i < texts.size ()) {
    text& ti = texts[i];
    if (ti.txt == s) {
			texts.erase (texts.begin() + i); 
			break;
		} else ++i;
  }
}

void textboard::refresh (basic_editor* b) {
  for (int i = 0, j = texts.size (); i < j; ++i) {
    text& ti = texts[i];
    extern viewport view;
    float wx, wy; b->obj2win (ti.wx, ti.wy, wx, wy);
    win2view (wx, wy, ti.vx, ti.vy, b->win, view);
    if (ti.type == text::hlabel) {
      ti.vx = 3;
    } else if (ti.type == text::vlabel) {
      ti.vy = 3;
    }
  }
}

void textboard::load (ifstream& file) {

  string ignore, txt;
  float r, g, b, wx, wy;
  int type, ntexts;

  file >> ignore >> ntexts;
  for (int i = 0; i < ntexts; ++i) {
    file >> txt >> wx >> wy >> r >> g >> b >> type;
    add (text (txt, wx, wy, r, g, b, text::permanent, type));
  }

}

void textboard::save (ofstream& file) {

  static const char spc = ' ';

  int ntexts = texts.size ();
  file << "num_labels " << ntexts << endl;
  for (int i = 0, j = texts.size (); i < j; ++i) {
    text& ti = texts[i];
    if (ti.type != text::none) {
      file << ti.txt << spc << ti.wx << spc << ti.wy << spc << ti.r << spc << ti.g << spc << ti.b << spc << ti.type << endl;
    }
  }

}
