;;;Cut Selection as Sketch
;cuts the selection and places it as a sketch in a separate movement of its own
(let ((timesig #f)(keysig #f)(clef #f)(timesiga #f)(keysiga #f)(clefa #f))
	(if (d-GoToSelectionStart)
		(begin
			(d-MoveCursorLeft)
			(d-PushPosition)
			(set! timesig (d-GetPrevailingTimesig))
			(set! keysig (d-GetPrevailingKeysigAsLilyPond))
			(set! clef (d-GetPrevailingClef))
			(d-GoToSelectionStart)
			(MoveToEndOfSelection)
			(set! timesiga (d-GetPrevailingTimesig))
			(set! keysiga (d-GetPrevailingKeysigAsLilyPond))
			(set! clefa (d-GetPrevailingClef))
			(d-Cut)
			(d-InsertMovementAfter)
			(d-InitialTimeSig timesig)
			(d-InitialClef clef)
			(d-InitialKey keysig)
			(d-Paste)
			(d-ToggleSketch)
			(d-PopPosition)
			(d-MoveToMeasureRight)

			(if (not (equal? timesiga timesig))
				(d-InsertTimeSig timesiga))
			(if (not (equal? keysiga keysig))
				(d-InsertKey keysiga))
			(if (not (equal? clefa clef))
				(d-InsertClef clefa)))
		(d-WarningDialog (_ "Cursor not in selection"))))