# Generated by Django 3.2.19 on 2024-04-09 13:04

import django.db.models.expressions
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('db', '0030_move_task_type'),
    ]

    operations = [
        migrations.AddField(
            model_name='workflowtemplate',
            name='priority',
            field=models.IntegerField(
                default=0,
                help_text='Base priority for work requests created from this template',
            ),
        ),
        migrations.AddField(
            model_name='workrequest',
            name='priority_adjustment',
            field=models.IntegerField(
                default=0,
                help_text='Administrator adjustment to the priority of this work request',
            ),
        ),
        migrations.AddField(
            model_name='workrequest',
            name='priority_base',
            field=models.IntegerField(
                default=0, help_text='Base priority of this work request'
            ),
        ),
        migrations.AddIndex(
            model_name='workrequest',
            index=models.Index(
                django.db.models.expressions.OrderBy(
                    django.db.models.expressions.CombinedExpression(
                        django.db.models.expressions.F('priority_base'),
                        '+',
                        django.db.models.expressions.F('priority_adjustment'),
                    ),
                    descending=True,
                ),
                django.db.models.expressions.F('created_at'),
                condition=models.Q(('status', 'pending')),
                name='db_workrequest_pending_idx',
            ),
        ),
        migrations.AddIndex(
            model_name='workrequest',
            index=models.Index(
                django.db.models.expressions.F('worker'),
                condition=models.Q(('status__in', ('pending', 'running'))),
                name='db_workrequest_worker_idx',
            ),
        ),
    ]
