# Find wrap library
#
# Released under BSD license
#
#  WRAP_INCLUDE_DIRS - where to find tcpd.h, etc
#  WRAP_LIBRARIES    - Lists of libraries when using libwrap
#  WRAP_FOUND        - True if wrap found

INCLUDE(FindPackageHandleStandardArgs)

# Look for the header file
FIND_PATH(WRAP_INCLUDE_DIR NAMES tcpd.h)
MARK_AS_ADVANCED(WRAP_INCLUDE_DIR)

# Look for the library
SET(WRAP_LIBS wrap)
FIND_LIBRARY(WRAP_LIBRARY NAMES ${WRAP_LIBS})
MARK_AS_ADVANCED(WRAP_LIBRARY)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(WRAP REQUIRED_VARS WRAP_LIBRARY WRAP_INCLUDE_DIR)

# Copy the result to output variables
IF(WRAP_FOUND)
  SET(WRAP_LIBRARIES ${WRAP_LIBRARY})
  SET(WRAP_INCLUDE_DIRS ${WRAP_INCLUDE_DIR})
ELSE(WRAP_FOUND)
  SET(WRAP_LIBS)
  SET(WRAP_LIBRARY)
  SET(WRAP_LIBRARIES)
  SET(WRAP_INCLUDE_DIR)
  SET(WRAP_INCLUDE_DIRS)
ENDIF(WRAP_FOUND)
