DACS_LIST_JURISDICTI(8)    DACS Web Services Manual    DACS_LIST_JURISDICTI(8)



[1mNAME[0m
       dacs_list_jurisdictions - display information about [1mDACS [22mjurisdictions

[1mSYNOPSIS[0m
       [1mdacs_list_jurisdictions [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This web service is part of the [1mDACS [22msuite.

       The [1mdacs_list_jurisdictions [22mweb service displays information, relative
       to the jurisdiction that receives the request, about its federation and
       other jurisdictions in that federation. Included are the federation's
       public encryption key and its unique instance identifier.

       The [4mFORMAT[24m argument (see [34m[1mdacs.services(8)[0m[1m[22m[2]) determines the type of
       output, with the default being HTML, using the style sheet
       [34m[1mdacs_list_jurisdictions.css[0m[1m[22m[3]. The various flavours of XML, a PHP
       format (see below), JSON, and plain text (TEXT) are supported.

       One application of [1mdacs_list_jurisdictions [22mis to assist middleware to
       generate a menu of jurisdictions for user authentication. If [4mFORMAT[24m is
       PHP, a list of each jurisdiction that provides an authentication
       service is emitted (as text/plain, one jurisdiction per line. Each line
       has the format:

           jurisdiction[]=[4mjname[24m&host[]=[4murl[24m&[4mjname[0m

       The string [4mjname[24m is the [1mDACS [22mjurisdiction name and [4murl[24m is the complete
       URL prefix for [1mDACS [22mweb services at the jurisdiction. For example,
       invoking this URL:

           https://example.com/infocards/cgi-bin/dacs/dacs_list_jurisdictions?FORMAT=PHP

       might return the following response:

           jurisdiction[]=INFOCARDS&host[]=https://example.com/infocards/cgi-bin/dacs&INFOCARDS
           jurisdiction[]=DEMO&host[]=https://example.com/demo/cgi-bin/dacs&DEMO
           jurisdiction[]=TEST&host[]=https://test.example.com/cgi-bin/dacs&TEST

       The [34m[1mhtml/examples/login.php[0m[1m[22m[4] template demonstrates this feature. If
       XML output is selected, a document conforming to
       [34m[1mdacs_list_jurisdictions.dtd[0m[1m[22m[5] is returned.

       When returned as an XML attribute, a public encryption key is a base-64
       encoding of the PEM formatted key.

           [1mNote[0m
           This program is also available as a [1mDACS [22mutility, [34m[1mdacslist(1)[0m[1m[22m[6].
           Because [34m[1mdacs_admin(8)[0m[1m[22m[7] provides the same functionality and more,
           [1mdacs_list_jurisdictions [22mmay be removed in a future release.

   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[8], [1mdacs_list_jurisdictions[0m
       understands the following CGI arguments:

       [4mJURISDICTION[0m
           Limit the output to the specified jurisdiction name. As a special
           case, if the argument does not specify a jurisdiction name, only
           federation-scoped information will be returned.

       [4mPUB_KEY_ONLY[0m
           If this argument is "yes" (case insensitive) only the federation's
           or a jurisdiction's public key (if known) will be returned. If
           [4mJURISDICTION[24m is given and is not the empty string, that
           jurisdiction name is selected; if [4mJURISDICTION[24m is given and is the
           empty string, the federation is selected; and if the argument is
           absent, the current jurisdiction is selected. This argument
           currently requires [4mFORMAT[24m to be TEXT. A PEM [[34m[1mRFC 1421[0m[1m[22m[9], [34m[1mRFC[0m
           [1m[34m1422[0m[1m[22m[10], [34m[1mRFC 1423[0m[1m[22m[11], [34m[1mRFC 1424[0m[1m[22m[12]] formatted key is returned.

           [1mNote[0m
           In the current implementation, a jurisdiction's public key can only
           be provided by one of the jurisdictions configured on the same
           host.

[1mFILES[0m
       [34m[1mdacs_list_jurisdictions.css[0m[1m[22m[3]

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs(1)[0m[1m[22m[13], [34m[1mdacskey(1)[0m[1m[22m[14], [34m[1mdacslist(1)[0m[1m[22m[6], [34m[1mdacs.groups(5)[0m[1m[22m[15]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[16])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[17] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.services(8)
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

        3. dacs_list_jurisdictions.css
           http://dacs.dss.ca/man//css/dacs_list_jurisdictions.css

        4. html/examples/login.php
           http://dacs.dss.ca/man/../examples/login.php

        5. dacs_list_jurisdictions.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_list_jurisdictions.dtd

        6. dacslist(1)
           http://dacs.dss.ca/man/dacslist.1.html

        7. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. RFC 1421
           http://www.rfc-editor.org/rfc/rfc1421.txt

       10. RFC 1422
           http://www.rfc-editor.org/rfc/rfc1422.txt

       11. RFC 1423
           http://www.rfc-editor.org/rfc/rfc1423.txt

       12. RFC 1424
           http://www.rfc-editor.org/rfc/rfc1424.txt

       13. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       14. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       15. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       16. www.dss.ca
           http://www.dss.ca

       17. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013           DACS_LIST_JURISDICTI(8)
