/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::aggressiveMiniscopeQuant__option_t::type& Options::operator[](
    options::aggressiveMiniscopeQuant__option_t) const
{
  return d_holder->aggressiveMiniscopeQuant;
}
template <> bool Options::wasSetByUser(options::aggressiveMiniscopeQuant__option_t) const
{
  return d_holder->aggressiveMiniscopeQuant__setByUser__;
}
template <> void Options::set(
    options::cbqi__option_t,
    const options::cbqi__option_t::type& x)
{
  d_holder->cbqi = x;
}
template <> const options::cbqi__option_t::type& Options::operator[](
    options::cbqi__option_t) const
{
  return d_holder->cbqi;
}
template <> bool Options::wasSetByUser(options::cbqi__option_t) const
{
  return d_holder->cbqi__setByUser__;
}
template <> void Options::set(
    options::cbqiAll__option_t,
    const options::cbqiAll__option_t::type& x)
{
  d_holder->cbqiAll = x;
}
template <> const options::cbqiAll__option_t::type& Options::operator[](
    options::cbqiAll__option_t) const
{
  return d_holder->cbqiAll;
}
template <> bool Options::wasSetByUser(options::cbqiAll__option_t) const
{
  return d_holder->cbqiAll__setByUser__;
}
template <> void Options::set(
    options::cbqiBv__option_t,
    const options::cbqiBv__option_t::type& x)
{
  d_holder->cbqiBv = x;
}
template <> const options::cbqiBv__option_t::type& Options::operator[](
    options::cbqiBv__option_t) const
{
  return d_holder->cbqiBv;
}
template <> bool Options::wasSetByUser(options::cbqiBv__option_t) const
{
  return d_holder->cbqiBv__setByUser__;
}
template <> void Options::set(
    options::cbqiBvConcInv__option_t,
    const options::cbqiBvConcInv__option_t::type& x)
{
  d_holder->cbqiBvConcInv = x;
}
template <> const options::cbqiBvConcInv__option_t::type& Options::operator[](
    options::cbqiBvConcInv__option_t) const
{
  return d_holder->cbqiBvConcInv;
}
template <> bool Options::wasSetByUser(options::cbqiBvConcInv__option_t) const
{
  return d_holder->cbqiBvConcInv__setByUser__;
}
template <> void Options::set(
    options::cbqiBvIneqMode__option_t,
    const options::cbqiBvIneqMode__option_t::type& x)
{
  d_holder->cbqiBvIneqMode = x;
}
template <> const options::cbqiBvIneqMode__option_t::type& Options::operator[](
    options::cbqiBvIneqMode__option_t) const
{
  return d_holder->cbqiBvIneqMode;
}
template <> bool Options::wasSetByUser(options::cbqiBvIneqMode__option_t) const
{
  return d_holder->cbqiBvIneqMode__setByUser__;
}
template <> void Options::set(
    options::cbqiBvInterleaveValue__option_t,
    const options::cbqiBvInterleaveValue__option_t::type& x)
{
  d_holder->cbqiBvInterleaveValue = x;
}
template <> const options::cbqiBvInterleaveValue__option_t::type& Options::operator[](
    options::cbqiBvInterleaveValue__option_t) const
{
  return d_holder->cbqiBvInterleaveValue;
}
template <> bool Options::wasSetByUser(options::cbqiBvInterleaveValue__option_t) const
{
  return d_holder->cbqiBvInterleaveValue__setByUser__;
}
template <> void Options::set(
    options::cbqiBvLinearize__option_t,
    const options::cbqiBvLinearize__option_t::type& x)
{
  d_holder->cbqiBvLinearize = x;
}
template <> const options::cbqiBvLinearize__option_t::type& Options::operator[](
    options::cbqiBvLinearize__option_t) const
{
  return d_holder->cbqiBvLinearize;
}
template <> bool Options::wasSetByUser(options::cbqiBvLinearize__option_t) const
{
  return d_holder->cbqiBvLinearize__setByUser__;
}
template <> void Options::set(
    options::cbqiBvRmExtract__option_t,
    const options::cbqiBvRmExtract__option_t::type& x)
{
  d_holder->cbqiBvRmExtract = x;
}
template <> const options::cbqiBvRmExtract__option_t::type& Options::operator[](
    options::cbqiBvRmExtract__option_t) const
{
  return d_holder->cbqiBvRmExtract;
}
template <> bool Options::wasSetByUser(options::cbqiBvRmExtract__option_t) const
{
  return d_holder->cbqiBvRmExtract__setByUser__;
}
template <> void Options::set(
    options::cbqiBvSolveNl__option_t,
    const options::cbqiBvSolveNl__option_t::type& x)
{
  d_holder->cbqiBvSolveNl = x;
}
template <> const options::cbqiBvSolveNl__option_t::type& Options::operator[](
    options::cbqiBvSolveNl__option_t) const
{
  return d_holder->cbqiBvSolveNl;
}
template <> bool Options::wasSetByUser(options::cbqiBvSolveNl__option_t) const
{
  return d_holder->cbqiBvSolveNl__setByUser__;
}
template <> void Options::set(
    options::cbqiFullEffort__option_t,
    const options::cbqiFullEffort__option_t::type& x)
{
  d_holder->cbqiFullEffort = x;
}
template <> const options::cbqiFullEffort__option_t::type& Options::operator[](
    options::cbqiFullEffort__option_t) const
{
  return d_holder->cbqiFullEffort;
}
template <> bool Options::wasSetByUser(options::cbqiFullEffort__option_t) const
{
  return d_holder->cbqiFullEffort__setByUser__;
}
template <> void Options::set(
    options::cbqiInnermost__option_t,
    const options::cbqiInnermost__option_t::type& x)
{
  d_holder->cbqiInnermost = x;
}
template <> const options::cbqiInnermost__option_t::type& Options::operator[](
    options::cbqiInnermost__option_t) const
{
  return d_holder->cbqiInnermost;
}
template <> bool Options::wasSetByUser(options::cbqiInnermost__option_t) const
{
  return d_holder->cbqiInnermost__setByUser__;
}
template <> const options::cbqiLitDepend__option_t::type& Options::operator[](
    options::cbqiLitDepend__option_t) const
{
  return d_holder->cbqiLitDepend;
}
template <> bool Options::wasSetByUser(options::cbqiLitDepend__option_t) const
{
  return d_holder->cbqiLitDepend__setByUser__;
}
template <> void Options::set(
    options::cbqiMidpoint__option_t,
    const options::cbqiMidpoint__option_t::type& x)
{
  d_holder->cbqiMidpoint = x;
}
template <> const options::cbqiMidpoint__option_t::type& Options::operator[](
    options::cbqiMidpoint__option_t) const
{
  return d_holder->cbqiMidpoint;
}
template <> bool Options::wasSetByUser(options::cbqiMidpoint__option_t) const
{
  return d_holder->cbqiMidpoint__setByUser__;
}
template <> const options::cbqiMinBounds__option_t::type& Options::operator[](
    options::cbqiMinBounds__option_t) const
{
  return d_holder->cbqiMinBounds;
}
template <> bool Options::wasSetByUser(options::cbqiMinBounds__option_t) const
{
  return d_holder->cbqiMinBounds__setByUser__;
}
template <> void Options::set(
    options::cbqiModel__option_t,
    const options::cbqiModel__option_t::type& x)
{
  d_holder->cbqiModel = x;
}
template <> const options::cbqiModel__option_t::type& Options::operator[](
    options::cbqiModel__option_t) const
{
  return d_holder->cbqiModel;
}
template <> bool Options::wasSetByUser(options::cbqiModel__option_t) const
{
  return d_holder->cbqiModel__setByUser__;
}
template <> void Options::set(
    options::cbqiMultiInst__option_t,
    const options::cbqiMultiInst__option_t::type& x)
{
  d_holder->cbqiMultiInst = x;
}
template <> const options::cbqiMultiInst__option_t::type& Options::operator[](
    options::cbqiMultiInst__option_t) const
{
  return d_holder->cbqiMultiInst;
}
template <> bool Options::wasSetByUser(options::cbqiMultiInst__option_t) const
{
  return d_holder->cbqiMultiInst__setByUser__;
}
template <> void Options::set(
    options::cbqiNestedQE__option_t,
    const options::cbqiNestedQE__option_t::type& x)
{
  d_holder->cbqiNestedQE = x;
}
template <> const options::cbqiNestedQE__option_t::type& Options::operator[](
    options::cbqiNestedQE__option_t) const
{
  return d_holder->cbqiNestedQE;
}
template <> bool Options::wasSetByUser(options::cbqiNestedQE__option_t) const
{
  return d_holder->cbqiNestedQE__setByUser__;
}
template <> const options::cbqiNopt__option_t::type& Options::operator[](
    options::cbqiNopt__option_t) const
{
  return d_holder->cbqiNopt;
}
template <> bool Options::wasSetByUser(options::cbqiNopt__option_t) const
{
  return d_holder->cbqiNopt__setByUser__;
}
template <> void Options::set(
    options::cbqiPreRegInst__option_t,
    const options::cbqiPreRegInst__option_t::type& x)
{
  d_holder->cbqiPreRegInst = x;
}
template <> const options::cbqiPreRegInst__option_t::type& Options::operator[](
    options::cbqiPreRegInst__option_t) const
{
  return d_holder->cbqiPreRegInst;
}
template <> bool Options::wasSetByUser(options::cbqiPreRegInst__option_t) const
{
  return d_holder->cbqiPreRegInst__setByUser__;
}
template <> const options::recurseCbqi__option_t::type& Options::operator[](
    options::recurseCbqi__option_t) const
{
  return d_holder->recurseCbqi;
}
template <> bool Options::wasSetByUser(options::recurseCbqi__option_t) const
{
  return d_holder->recurseCbqi__setByUser__;
}
template <> void Options::set(
    options::cbqiRepeatLit__option_t,
    const options::cbqiRepeatLit__option_t::type& x)
{
  d_holder->cbqiRepeatLit = x;
}
template <> const options::cbqiRepeatLit__option_t::type& Options::operator[](
    options::cbqiRepeatLit__option_t) const
{
  return d_holder->cbqiRepeatLit;
}
template <> bool Options::wasSetByUser(options::cbqiRepeatLit__option_t) const
{
  return d_holder->cbqiRepeatLit__setByUser__;
}
template <> const options::cbqiRoundUpLowerLia__option_t::type& Options::operator[](
    options::cbqiRoundUpLowerLia__option_t) const
{
  return d_holder->cbqiRoundUpLowerLia;
}
template <> bool Options::wasSetByUser(options::cbqiRoundUpLowerLia__option_t) const
{
  return d_holder->cbqiRoundUpLowerLia__setByUser__;
}
template <> void Options::set(
    options::cbqiSat__option_t,
    const options::cbqiSat__option_t::type& x)
{
  d_holder->cbqiSat = x;
}
template <> const options::cbqiSat__option_t::type& Options::operator[](
    options::cbqiSat__option_t) const
{
  return d_holder->cbqiSat;
}
template <> bool Options::wasSetByUser(options::cbqiSat__option_t) const
{
  return d_holder->cbqiSat__setByUser__;
}
template <> void Options::set(
    options::cbqiUseInfInt__option_t,
    const options::cbqiUseInfInt__option_t::type& x)
{
  d_holder->cbqiUseInfInt = x;
}
template <> const options::cbqiUseInfInt__option_t::type& Options::operator[](
    options::cbqiUseInfInt__option_t) const
{
  return d_holder->cbqiUseInfInt;
}
template <> bool Options::wasSetByUser(options::cbqiUseInfInt__option_t) const
{
  return d_holder->cbqiUseInfInt__setByUser__;
}
template <> void Options::set(
    options::cbqiUseInfReal__option_t,
    const options::cbqiUseInfReal__option_t::type& x)
{
  d_holder->cbqiUseInfReal = x;
}
template <> const options::cbqiUseInfReal__option_t::type& Options::operator[](
    options::cbqiUseInfReal__option_t) const
{
  return d_holder->cbqiUseInfReal;
}
template <> bool Options::wasSetByUser(options::cbqiUseInfReal__option_t) const
{
  return d_holder->cbqiUseInfReal__setByUser__;
}
template <> void Options::set(
    options::cegisSample__option_t,
    const options::cegisSample__option_t::type& x)
{
  d_holder->cegisSample = x;
}
template <> const options::cegisSample__option_t::type& Options::operator[](
    options::cegisSample__option_t) const
{
  return d_holder->cegisSample;
}
template <> bool Options::wasSetByUser(options::cegisSample__option_t) const
{
  return d_holder->cegisSample__setByUser__;
}
template <> void Options::set(
    options::ceGuidedInst__option_t,
    const options::ceGuidedInst__option_t::type& x)
{
  d_holder->ceGuidedInst = x;
}
template <> const options::ceGuidedInst__option_t::type& Options::operator[](
    options::ceGuidedInst__option_t) const
{
  return d_holder->ceGuidedInst;
}
template <> bool Options::wasSetByUser(options::ceGuidedInst__option_t) const
{
  return d_holder->ceGuidedInst__setByUser__;
}
template <> const options::cegqiSingleInvAbort__option_t::type& Options::operator[](
    options::cegqiSingleInvAbort__option_t) const
{
  return d_holder->cegqiSingleInvAbort;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvAbort__option_t) const
{
  return d_holder->cegqiSingleInvAbort__setByUser__;
}
template <> const options::cegqiSingleInvPartial__option_t::type& Options::operator[](
    options::cegqiSingleInvPartial__option_t) const
{
  return d_holder->cegqiSingleInvPartial;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvPartial__option_t) const
{
  return d_holder->cegqiSingleInvPartial__setByUser__;
}
template <> const options::cegqiSingleInvReconstruct__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstruct__option_t) const
{
  return d_holder->cegqiSingleInvReconstruct;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstruct__option_t) const
{
  return d_holder->cegqiSingleInvReconstruct__setByUser__;
}
template <> const options::cegqiSingleInvReconstructConst__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstructConst__option_t) const
{
  return d_holder->cegqiSingleInvReconstructConst;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstructConst__option_t) const
{
  return d_holder->cegqiSingleInvReconstructConst__setByUser__;
}
template <> const options::cegqiSolMinCore__option_t::type& Options::operator[](
    options::cegqiSolMinCore__option_t) const
{
  return d_holder->cegqiSolMinCore;
}
template <> bool Options::wasSetByUser(options::cegqiSolMinCore__option_t) const
{
  return d_holder->cegqiSolMinCore__setByUser__;
}
template <> const options::cegqiSolMinInst__option_t::type& Options::operator[](
    options::cegqiSolMinInst__option_t) const
{
  return d_holder->cegqiSolMinInst;
}
template <> bool Options::wasSetByUser(options::cegqiSolMinInst__option_t) const
{
  return d_holder->cegqiSolMinInst__setByUser__;
}
template <> void Options::set(
    options::cegqiSingleInvMode__option_t,
    const options::cegqiSingleInvMode__option_t::type& x)
{
  d_holder->cegqiSingleInvMode = x;
}
template <> const options::cegqiSingleInvMode__option_t::type& Options::operator[](
    options::cegqiSingleInvMode__option_t) const
{
  return d_holder->cegqiSingleInvMode;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvMode__option_t) const
{
  return d_holder->cegqiSingleInvMode__setByUser__;
}
template <> const options::condRewriteQuant__option_t::type& Options::operator[](
    options::condRewriteQuant__option_t) const
{
  return d_holder->condRewriteQuant;
}
template <> bool Options::wasSetByUser(options::condRewriteQuant__option_t) const
{
  return d_holder->condRewriteQuant__setByUser__;
}
template <> const options::condVarSplitQuantAgg__option_t::type& Options::operator[](
    options::condVarSplitQuantAgg__option_t) const
{
  return d_holder->condVarSplitQuantAgg;
}
template <> bool Options::wasSetByUser(options::condVarSplitQuantAgg__option_t) const
{
  return d_holder->condVarSplitQuantAgg__setByUser__;
}
template <> const options::condVarSplitQuant__option_t::type& Options::operator[](
    options::condVarSplitQuant__option_t) const
{
  return d_holder->condVarSplitQuant;
}
template <> bool Options::wasSetByUser(options::condVarSplitQuant__option_t) const
{
  return d_holder->condVarSplitQuant__setByUser__;
}
template <> void Options::set(
    options::conjectureFilterActiveTerms__option_t,
    const options::conjectureFilterActiveTerms__option_t::type& x)
{
  d_holder->conjectureFilterActiveTerms = x;
}
template <> const options::conjectureFilterActiveTerms__option_t::type& Options::operator[](
    options::conjectureFilterActiveTerms__option_t) const
{
  return d_holder->conjectureFilterActiveTerms;
}
template <> bool Options::wasSetByUser(options::conjectureFilterActiveTerms__option_t) const
{
  return d_holder->conjectureFilterActiveTerms__setByUser__;
}
template <> void Options::set(
    options::conjectureFilterCanonical__option_t,
    const options::conjectureFilterCanonical__option_t::type& x)
{
  d_holder->conjectureFilterCanonical = x;
}
template <> const options::conjectureFilterCanonical__option_t::type& Options::operator[](
    options::conjectureFilterCanonical__option_t) const
{
  return d_holder->conjectureFilterCanonical;
}
template <> bool Options::wasSetByUser(options::conjectureFilterCanonical__option_t) const
{
  return d_holder->conjectureFilterCanonical__setByUser__;
}
template <> void Options::set(
    options::conjectureFilterModel__option_t,
    const options::conjectureFilterModel__option_t::type& x)
{
  d_holder->conjectureFilterModel = x;
}
template <> const options::conjectureFilterModel__option_t::type& Options::operator[](
    options::conjectureFilterModel__option_t) const
{
  return d_holder->conjectureFilterModel;
}
template <> bool Options::wasSetByUser(options::conjectureFilterModel__option_t) const
{
  return d_holder->conjectureFilterModel__setByUser__;
}
template <> void Options::set(
    options::conjectureGen__option_t,
    const options::conjectureGen__option_t::type& x)
{
  d_holder->conjectureGen = x;
}
template <> const options::conjectureGen__option_t::type& Options::operator[](
    options::conjectureGen__option_t) const
{
  return d_holder->conjectureGen;
}
template <> bool Options::wasSetByUser(options::conjectureGen__option_t) const
{
  return d_holder->conjectureGen__setByUser__;
}
template <> const options::conjectureGenGtEnum__option_t::type& Options::operator[](
    options::conjectureGenGtEnum__option_t) const
{
  return d_holder->conjectureGenGtEnum;
}
template <> bool Options::wasSetByUser(options::conjectureGenGtEnum__option_t) const
{
  return d_holder->conjectureGenGtEnum__setByUser__;
}
template <> const options::conjectureGenMaxDepth__option_t::type& Options::operator[](
    options::conjectureGenMaxDepth__option_t) const
{
  return d_holder->conjectureGenMaxDepth;
}
template <> bool Options::wasSetByUser(options::conjectureGenMaxDepth__option_t) const
{
  return d_holder->conjectureGenMaxDepth__setByUser__;
}
template <> const options::conjectureGenPerRound__option_t::type& Options::operator[](
    options::conjectureGenPerRound__option_t) const
{
  return d_holder->conjectureGenPerRound;
}
template <> bool Options::wasSetByUser(options::conjectureGenPerRound__option_t) const
{
  return d_holder->conjectureGenPerRound__setByUser__;
}
template <> const options::conjectureUeeIntro__option_t::type& Options::operator[](
    options::conjectureUeeIntro__option_t) const
{
  return d_holder->conjectureUeeIntro;
}
template <> bool Options::wasSetByUser(options::conjectureUeeIntro__option_t) const
{
  return d_holder->conjectureUeeIntro__setByUser__;
}
template <> const options::conjectureNoFilter__option_t::type& Options::operator[](
    options::conjectureNoFilter__option_t) const
{
  return d_holder->conjectureNoFilter;
}
template <> bool Options::wasSetByUser(options::conjectureNoFilter__option_t) const
{
  return d_holder->conjectureNoFilter__setByUser__;
}
template <> void Options::set(
    options::dtStcInduction__option_t,
    const options::dtStcInduction__option_t::type& x)
{
  d_holder->dtStcInduction = x;
}
template <> const options::dtStcInduction__option_t::type& Options::operator[](
    options::dtStcInduction__option_t) const
{
  return d_holder->dtStcInduction;
}
template <> bool Options::wasSetByUser(options::dtStcInduction__option_t) const
{
  return d_holder->dtStcInduction__setByUser__;
}
template <> const options::dtVarExpandQuant__option_t::type& Options::operator[](
    options::dtVarExpandQuant__option_t) const
{
  return d_holder->dtVarExpandQuant;
}
template <> bool Options::wasSetByUser(options::dtVarExpandQuant__option_t) const
{
  return d_holder->dtVarExpandQuant__setByUser__;
}
template <> void Options::set(
    options::eMatching__option_t,
    const options::eMatching__option_t::type& x)
{
  d_holder->eMatching = x;
}
template <> const options::eMatching__option_t::type& Options::operator[](
    options::eMatching__option_t) const
{
  return d_holder->eMatching;
}
template <> bool Options::wasSetByUser(options::eMatching__option_t) const
{
  return d_holder->eMatching__setByUser__;
}
template <> void Options::set(
    options::elimExtArithQuant__option_t,
    const options::elimExtArithQuant__option_t::type& x)
{
  d_holder->elimExtArithQuant = x;
}
template <> const options::elimExtArithQuant__option_t::type& Options::operator[](
    options::elimExtArithQuant__option_t) const
{
  return d_holder->elimExtArithQuant;
}
template <> bool Options::wasSetByUser(options::elimExtArithQuant__option_t) const
{
  return d_holder->elimExtArithQuant__setByUser__;
}
template <> const options::elimTautQuant__option_t::type& Options::operator[](
    options::elimTautQuant__option_t) const
{
  return d_holder->elimTautQuant;
}
template <> bool Options::wasSetByUser(options::elimTautQuant__option_t) const
{
  return d_holder->elimTautQuant__setByUser__;
}
template <> void Options::set(
    options::finiteModelFind__option_t,
    const options::finiteModelFind__option_t::type& x)
{
  d_holder->finiteModelFind = x;
}
template <> const options::finiteModelFind__option_t::type& Options::operator[](
    options::finiteModelFind__option_t) const
{
  return d_holder->finiteModelFind;
}
template <> bool Options::wasSetByUser(options::finiteModelFind__option_t) const
{
  return d_holder->finiteModelFind__setByUser__;
}
template <> void Options::set(
    options::fmfBound__option_t,
    const options::fmfBound__option_t::type& x)
{
  d_holder->fmfBound = x;
}
template <> const options::fmfBound__option_t::type& Options::operator[](
    options::fmfBound__option_t) const
{
  return d_holder->fmfBound;
}
template <> bool Options::wasSetByUser(options::fmfBound__option_t) const
{
  return d_holder->fmfBound__setByUser__;
}
template <> void Options::set(
    options::fmfBoundInt__option_t,
    const options::fmfBoundInt__option_t::type& x)
{
  d_holder->fmfBoundInt = x;
}
template <> const options::fmfBoundInt__option_t::type& Options::operator[](
    options::fmfBoundInt__option_t) const
{
  return d_holder->fmfBoundInt;
}
template <> bool Options::wasSetByUser(options::fmfBoundInt__option_t) const
{
  return d_holder->fmfBoundInt__setByUser__;
}
template <> void Options::set(
    options::fmfBoundLazy__option_t,
    const options::fmfBoundLazy__option_t::type& x)
{
  d_holder->fmfBoundLazy = x;
}
template <> const options::fmfBoundLazy__option_t::type& Options::operator[](
    options::fmfBoundLazy__option_t) const
{
  return d_holder->fmfBoundLazy;
}
template <> bool Options::wasSetByUser(options::fmfBoundLazy__option_t) const
{
  return d_holder->fmfBoundLazy__setByUser__;
}
template <> const options::fmfBoundMinMode__option_t::type& Options::operator[](
    options::fmfBoundMinMode__option_t) const
{
  return d_holder->fmfBoundMinMode;
}
template <> bool Options::wasSetByUser(options::fmfBoundMinMode__option_t) const
{
  return d_holder->fmfBoundMinMode__setByUser__;
}
template <> const options::fmfEmptySorts__option_t::type& Options::operator[](
    options::fmfEmptySorts__option_t) const
{
  return d_holder->fmfEmptySorts;
}
template <> bool Options::wasSetByUser(options::fmfEmptySorts__option_t) const
{
  return d_holder->fmfEmptySorts__setByUser__;
}
template <> const options::fmfFmcSimple__option_t::type& Options::operator[](
    options::fmfFmcSimple__option_t) const
{
  return d_holder->fmfFmcSimple;
}
template <> bool Options::wasSetByUser(options::fmfFmcSimple__option_t) const
{
  return d_holder->fmfFmcSimple__setByUser__;
}
template <> const options::fmfFreshDistConst__option_t::type& Options::operator[](
    options::fmfFreshDistConst__option_t) const
{
  return d_holder->fmfFreshDistConst;
}
template <> bool Options::wasSetByUser(options::fmfFreshDistConst__option_t) const
{
  return d_holder->fmfFreshDistConst__setByUser__;
}
template <> void Options::set(
    options::fmfFunWellDefined__option_t,
    const options::fmfFunWellDefined__option_t::type& x)
{
  d_holder->fmfFunWellDefined = x;
}
template <> const options::fmfFunWellDefined__option_t::type& Options::operator[](
    options::fmfFunWellDefined__option_t) const
{
  return d_holder->fmfFunWellDefined;
}
template <> bool Options::wasSetByUser(options::fmfFunWellDefined__option_t) const
{
  return d_holder->fmfFunWellDefined__setByUser__;
}
template <> const options::fmfFunWellDefinedRelevant__option_t::type& Options::operator[](
    options::fmfFunWellDefinedRelevant__option_t) const
{
  return d_holder->fmfFunWellDefinedRelevant;
}
template <> bool Options::wasSetByUser(options::fmfFunWellDefinedRelevant__option_t) const
{
  return d_holder->fmfFunWellDefinedRelevant__setByUser__;
}
template <> void Options::set(
    options::fmfInstEngine__option_t,
    const options::fmfInstEngine__option_t::type& x)
{
  d_holder->fmfInstEngine = x;
}
template <> const options::fmfInstEngine__option_t::type& Options::operator[](
    options::fmfInstEngine__option_t) const
{
  return d_holder->fmfInstEngine;
}
template <> bool Options::wasSetByUser(options::fmfInstEngine__option_t) const
{
  return d_holder->fmfInstEngine__setByUser__;
}
template <> const options::fmfInstGen__option_t::type& Options::operator[](
    options::fmfInstGen__option_t) const
{
  return d_holder->fmfInstGen;
}
template <> bool Options::wasSetByUser(options::fmfInstGen__option_t) const
{
  return d_holder->fmfInstGen__setByUser__;
}
template <> const options::fmfInstGenOneQuantPerRound__option_t::type& Options::operator[](
    options::fmfInstGenOneQuantPerRound__option_t) const
{
  return d_holder->fmfInstGenOneQuantPerRound;
}
template <> bool Options::wasSetByUser(options::fmfInstGenOneQuantPerRound__option_t) const
{
  return d_holder->fmfInstGenOneQuantPerRound__setByUser__;
}
template <> const options::fullSaturateInterleave__option_t::type& Options::operator[](
    options::fullSaturateInterleave__option_t) const
{
  return d_holder->fullSaturateInterleave;
}
template <> bool Options::wasSetByUser(options::fullSaturateInterleave__option_t) const
{
  return d_holder->fullSaturateInterleave__setByUser__;
}
template <> void Options::set(
    options::fullSaturateQuant__option_t,
    const options::fullSaturateQuant__option_t::type& x)
{
  d_holder->fullSaturateQuant = x;
}
template <> const options::fullSaturateQuant__option_t::type& Options::operator[](
    options::fullSaturateQuant__option_t) const
{
  return d_holder->fullSaturateQuant;
}
template <> bool Options::wasSetByUser(options::fullSaturateQuant__option_t) const
{
  return d_holder->fullSaturateQuant__setByUser__;
}
template <> const options::fullSaturateQuantRd__option_t::type& Options::operator[](
    options::fullSaturateQuantRd__option_t) const
{
  return d_holder->fullSaturateQuantRd;
}
template <> bool Options::wasSetByUser(options::fullSaturateQuantRd__option_t) const
{
  return d_holder->fullSaturateQuantRd__setByUser__;
}
template <> void Options::set(
    options::globalNegate__option_t,
    const options::globalNegate__option_t::type& x)
{
  d_holder->globalNegate = x;
}
template <> const options::globalNegate__option_t::type& Options::operator[](
    options::globalNegate__option_t) const
{
  return d_holder->globalNegate;
}
template <> bool Options::wasSetByUser(options::globalNegate__option_t) const
{
  return d_holder->globalNegate__setByUser__;
}
template <> const options::hoMatching__option_t::type& Options::operator[](
    options::hoMatching__option_t) const
{
  return d_holder->hoMatching;
}
template <> bool Options::wasSetByUser(options::hoMatching__option_t) const
{
  return d_holder->hoMatching__setByUser__;
}
template <> const options::hoMatchingVarArgPriority__option_t::type& Options::operator[](
    options::hoMatchingVarArgPriority__option_t) const
{
  return d_holder->hoMatchingVarArgPriority;
}
template <> bool Options::wasSetByUser(options::hoMatchingVarArgPriority__option_t) const
{
  return d_holder->hoMatchingVarArgPriority__setByUser__;
}
template <> const options::hoMergeTermDb__option_t::type& Options::operator[](
    options::hoMergeTermDb__option_t) const
{
  return d_holder->hoMergeTermDb;
}
template <> bool Options::wasSetByUser(options::hoMergeTermDb__option_t) const
{
  return d_holder->hoMergeTermDb__setByUser__;
}
template <> const options::incrementTriggers__option_t::type& Options::operator[](
    options::incrementTriggers__option_t) const
{
  return d_holder->incrementTriggers;
}
template <> bool Options::wasSetByUser(options::incrementTriggers__option_t) const
{
  return d_holder->incrementTriggers__setByUser__;
}
template <> const options::inferArithTriggerEq__option_t::type& Options::operator[](
    options::inferArithTriggerEq__option_t) const
{
  return d_holder->inferArithTriggerEq;
}
template <> bool Options::wasSetByUser(options::inferArithTriggerEq__option_t) const
{
  return d_holder->inferArithTriggerEq__setByUser__;
}
template <> const options::inferArithTriggerEqExp__option_t::type& Options::operator[](
    options::inferArithTriggerEqExp__option_t) const
{
  return d_holder->inferArithTriggerEqExp;
}
template <> bool Options::wasSetByUser(options::inferArithTriggerEqExp__option_t) const
{
  return d_holder->inferArithTriggerEqExp__setByUser__;
}
template <> const options::instLevelInputOnly__option_t::type& Options::operator[](
    options::instLevelInputOnly__option_t) const
{
  return d_holder->instLevelInputOnly;
}
template <> bool Options::wasSetByUser(options::instLevelInputOnly__option_t) const
{
  return d_holder->instLevelInputOnly__setByUser__;
}
template <> void Options::set(
    options::instMaxLevel__option_t,
    const options::instMaxLevel__option_t::type& x)
{
  d_holder->instMaxLevel = x;
}
template <> const options::instMaxLevel__option_t::type& Options::operator[](
    options::instMaxLevel__option_t) const
{
  return d_holder->instMaxLevel;
}
template <> bool Options::wasSetByUser(options::instMaxLevel__option_t) const
{
  return d_holder->instMaxLevel__setByUser__;
}
template <> void Options::set(
    options::instNoEntail__option_t,
    const options::instNoEntail__option_t::type& x)
{
  d_holder->instNoEntail = x;
}
template <> const options::instNoEntail__option_t::type& Options::operator[](
    options::instNoEntail__option_t) const
{
  return d_holder->instNoEntail;
}
template <> bool Options::wasSetByUser(options::instNoEntail__option_t) const
{
  return d_holder->instNoEntail__setByUser__;
}
template <> void Options::set(
    options::instNoModelTrue__option_t,
    const options::instNoModelTrue__option_t::type& x)
{
  d_holder->instNoModelTrue = x;
}
template <> const options::instNoModelTrue__option_t::type& Options::operator[](
    options::instNoModelTrue__option_t) const
{
  return d_holder->instNoModelTrue;
}
template <> bool Options::wasSetByUser(options::instNoModelTrue__option_t) const
{
  return d_holder->instNoModelTrue__setByUser__;
}
template <> void Options::set(
    options::instPropagate__option_t,
    const options::instPropagate__option_t::type& x)
{
  d_holder->instPropagate = x;
}
template <> const options::instPropagate__option_t::type& Options::operator[](
    options::instPropagate__option_t) const
{
  return d_holder->instPropagate;
}
template <> bool Options::wasSetByUser(options::instPropagate__option_t) const
{
  return d_holder->instPropagate__setByUser__;
}
template <> void Options::set(
    options::instWhenPhase__option_t,
    const options::instWhenPhase__option_t::type& x)
{
  d_holder->instWhenPhase = x;
}
template <> const options::instWhenPhase__option_t::type& Options::operator[](
    options::instWhenPhase__option_t) const
{
  return d_holder->instWhenPhase;
}
template <> bool Options::wasSetByUser(options::instWhenPhase__option_t) const
{
  return d_holder->instWhenPhase__setByUser__;
}
template <> void Options::set(
    options::instWhenStrictInterleave__option_t,
    const options::instWhenStrictInterleave__option_t::type& x)
{
  d_holder->instWhenStrictInterleave = x;
}
template <> const options::instWhenStrictInterleave__option_t::type& Options::operator[](
    options::instWhenStrictInterleave__option_t) const
{
  return d_holder->instWhenStrictInterleave;
}
template <> bool Options::wasSetByUser(options::instWhenStrictInterleave__option_t) const
{
  return d_holder->instWhenStrictInterleave__setByUser__;
}
template <> void Options::set(
    options::instWhenTcFirst__option_t,
    const options::instWhenTcFirst__option_t::type& x)
{
  d_holder->instWhenTcFirst = x;
}
template <> const options::instWhenTcFirst__option_t::type& Options::operator[](
    options::instWhenTcFirst__option_t) const
{
  return d_holder->instWhenTcFirst;
}
template <> bool Options::wasSetByUser(options::instWhenTcFirst__option_t) const
{
  return d_holder->instWhenTcFirst__setByUser__;
}
template <> void Options::set(
    options::instWhenMode__option_t,
    const options::instWhenMode__option_t::type& x)
{
  d_holder->instWhenMode = x;
}
template <> const options::instWhenMode__option_t::type& Options::operator[](
    options::instWhenMode__option_t) const
{
  return d_holder->instWhenMode;
}
template <> bool Options::wasSetByUser(options::instWhenMode__option_t) const
{
  return d_holder->instWhenMode__setByUser__;
}
template <> void Options::set(
    options::intWfInduction__option_t,
    const options::intWfInduction__option_t::type& x)
{
  d_holder->intWfInduction = x;
}
template <> const options::intWfInduction__option_t::type& Options::operator[](
    options::intWfInduction__option_t) const
{
  return d_holder->intWfInduction;
}
template <> bool Options::wasSetByUser(options::intWfInduction__option_t) const
{
  return d_holder->intWfInduction__setByUser__;
}
template <> void Options::set(
    options::iteDtTesterSplitQuant__option_t,
    const options::iteDtTesterSplitQuant__option_t::type& x)
{
  d_holder->iteDtTesterSplitQuant = x;
}
template <> const options::iteDtTesterSplitQuant__option_t::type& Options::operator[](
    options::iteDtTesterSplitQuant__option_t) const
{
  return d_holder->iteDtTesterSplitQuant;
}
template <> bool Options::wasSetByUser(options::iteDtTesterSplitQuant__option_t) const
{
  return d_holder->iteDtTesterSplitQuant__setByUser__;
}
template <> void Options::set(
    options::iteLiftQuant__option_t,
    const options::iteLiftQuant__option_t::type& x)
{
  d_holder->iteLiftQuant = x;
}
template <> const options::iteLiftQuant__option_t::type& Options::operator[](
    options::iteLiftQuant__option_t) const
{
  return d_holder->iteLiftQuant;
}
template <> bool Options::wasSetByUser(options::iteLiftQuant__option_t) const
{
  return d_holder->iteLiftQuant__setByUser__;
}
template <> const options::literalMatchMode__option_t::type& Options::operator[](
    options::literalMatchMode__option_t) const
{
  return d_holder->literalMatchMode;
}
template <> bool Options::wasSetByUser(options::literalMatchMode__option_t) const
{
  return d_holder->literalMatchMode__setByUser__;
}
template <> const options::localTheoryExt__option_t::type& Options::operator[](
    options::localTheoryExt__option_t) const
{
  return d_holder->localTheoryExt;
}
template <> bool Options::wasSetByUser(options::localTheoryExt__option_t) const
{
  return d_holder->localTheoryExt__setByUser__;
}
template <> const options::ltePartialInst__option_t::type& Options::operator[](
    options::ltePartialInst__option_t) const
{
  return d_holder->ltePartialInst;
}
template <> bool Options::wasSetByUser(options::ltePartialInst__option_t) const
{
  return d_holder->ltePartialInst__setByUser__;
}
template <> const options::lteRestrictInstClosure__option_t::type& Options::operator[](
    options::lteRestrictInstClosure__option_t) const
{
  return d_holder->lteRestrictInstClosure;
}
template <> bool Options::wasSetByUser(options::lteRestrictInstClosure__option_t) const
{
  return d_holder->lteRestrictInstClosure__setByUser__;
}
template <> void Options::set(
    options::macrosQuant__option_t,
    const options::macrosQuant__option_t::type& x)
{
  d_holder->macrosQuant = x;
}
template <> const options::macrosQuant__option_t::type& Options::operator[](
    options::macrosQuant__option_t) const
{
  return d_holder->macrosQuant;
}
template <> bool Options::wasSetByUser(options::macrosQuant__option_t) const
{
  return d_holder->macrosQuant__setByUser__;
}
template <> const options::macrosQuantMode__option_t::type& Options::operator[](
    options::macrosQuantMode__option_t) const
{
  return d_holder->macrosQuantMode;
}
template <> bool Options::wasSetByUser(options::macrosQuantMode__option_t) const
{
  return d_holder->macrosQuantMode__setByUser__;
}
template <> const options::mbqiInterleave__option_t::type& Options::operator[](
    options::mbqiInterleave__option_t) const
{
  return d_holder->mbqiInterleave;
}
template <> bool Options::wasSetByUser(options::mbqiInterleave__option_t) const
{
  return d_holder->mbqiInterleave__setByUser__;
}
template <> void Options::set(
    options::fmfOneInstPerRound__option_t,
    const options::fmfOneInstPerRound__option_t::type& x)
{
  d_holder->fmfOneInstPerRound = x;
}
template <> const options::fmfOneInstPerRound__option_t::type& Options::operator[](
    options::fmfOneInstPerRound__option_t) const
{
  return d_holder->fmfOneInstPerRound;
}
template <> bool Options::wasSetByUser(options::fmfOneInstPerRound__option_t) const
{
  return d_holder->fmfOneInstPerRound__setByUser__;
}
template <> const options::fmfOneQuantPerRound__option_t::type& Options::operator[](
    options::fmfOneQuantPerRound__option_t) const
{
  return d_holder->fmfOneQuantPerRound;
}
template <> bool Options::wasSetByUser(options::fmfOneQuantPerRound__option_t) const
{
  return d_holder->fmfOneQuantPerRound__setByUser__;
}
template <> void Options::set(
    options::mbqiMode__option_t,
    const options::mbqiMode__option_t::type& x)
{
  d_holder->mbqiMode = x;
}
template <> const options::mbqiMode__option_t::type& Options::operator[](
    options::mbqiMode__option_t) const
{
  return d_holder->mbqiMode;
}
template <> bool Options::wasSetByUser(options::mbqiMode__option_t) const
{
  return d_holder->mbqiMode__setByUser__;
}
template <> void Options::set(
    options::miniscopeQuant__option_t,
    const options::miniscopeQuant__option_t::type& x)
{
  d_holder->miniscopeQuant = x;
}
template <> const options::miniscopeQuant__option_t::type& Options::operator[](
    options::miniscopeQuant__option_t) const
{
  return d_holder->miniscopeQuant;
}
template <> bool Options::wasSetByUser(options::miniscopeQuant__option_t) const
{
  return d_holder->miniscopeQuant__setByUser__;
}
template <> void Options::set(
    options::miniscopeQuantFreeVar__option_t,
    const options::miniscopeQuantFreeVar__option_t::type& x)
{
  d_holder->miniscopeQuantFreeVar = x;
}
template <> const options::miniscopeQuantFreeVar__option_t::type& Options::operator[](
    options::miniscopeQuantFreeVar__option_t) const
{
  return d_holder->miniscopeQuantFreeVar;
}
template <> bool Options::wasSetByUser(options::miniscopeQuantFreeVar__option_t) const
{
  return d_holder->miniscopeQuantFreeVar__setByUser__;
}
template <> const options::multiTriggerCache__option_t::type& Options::operator[](
    options::multiTriggerCache__option_t) const
{
  return d_holder->multiTriggerCache;
}
template <> bool Options::wasSetByUser(options::multiTriggerCache__option_t) const
{
  return d_holder->multiTriggerCache__setByUser__;
}
template <> const options::multiTriggerLinear__option_t::type& Options::operator[](
    options::multiTriggerLinear__option_t) const
{
  return d_holder->multiTriggerLinear;
}
template <> bool Options::wasSetByUser(options::multiTriggerLinear__option_t) const
{
  return d_holder->multiTriggerLinear__setByUser__;
}
template <> const options::multiTriggerPriority__option_t::type& Options::operator[](
    options::multiTriggerPriority__option_t) const
{
  return d_holder->multiTriggerPriority;
}
template <> bool Options::wasSetByUser(options::multiTriggerPriority__option_t) const
{
  return d_holder->multiTriggerPriority__setByUser__;
}
template <> const options::multiTriggerWhenSingle__option_t::type& Options::operator[](
    options::multiTriggerWhenSingle__option_t) const
{
  return d_holder->multiTriggerWhenSingle;
}
template <> bool Options::wasSetByUser(options::multiTriggerWhenSingle__option_t) const
{
  return d_holder->multiTriggerWhenSingle__setByUser__;
}
template <> void Options::set(
    options::partialTriggers__option_t,
    const options::partialTriggers__option_t::type& x)
{
  d_holder->partialTriggers = x;
}
template <> const options::partialTriggers__option_t::type& Options::operator[](
    options::partialTriggers__option_t) const
{
  return d_holder->partialTriggers;
}
template <> bool Options::wasSetByUser(options::partialTriggers__option_t) const
{
  return d_holder->partialTriggers__setByUser__;
}
template <> void Options::set(
    options::preSkolemQuant__option_t,
    const options::preSkolemQuant__option_t::type& x)
{
  d_holder->preSkolemQuant = x;
}
template <> const options::preSkolemQuant__option_t::type& Options::operator[](
    options::preSkolemQuant__option_t) const
{
  return d_holder->preSkolemQuant;
}
template <> bool Options::wasSetByUser(options::preSkolemQuant__option_t) const
{
  return d_holder->preSkolemQuant__setByUser__;
}
template <> void Options::set(
    options::preSkolemQuantAgg__option_t,
    const options::preSkolemQuantAgg__option_t::type& x)
{
  d_holder->preSkolemQuantAgg = x;
}
template <> const options::preSkolemQuantAgg__option_t::type& Options::operator[](
    options::preSkolemQuantAgg__option_t) const
{
  return d_holder->preSkolemQuantAgg;
}
template <> bool Options::wasSetByUser(options::preSkolemQuantAgg__option_t) const
{
  return d_holder->preSkolemQuantAgg__setByUser__;
}
template <> void Options::set(
    options::preSkolemQuantNested__option_t,
    const options::preSkolemQuantNested__option_t::type& x)
{
  d_holder->preSkolemQuantNested = x;
}
template <> const options::preSkolemQuantNested__option_t::type& Options::operator[](
    options::preSkolemQuantNested__option_t) const
{
  return d_holder->preSkolemQuantNested;
}
template <> bool Options::wasSetByUser(options::preSkolemQuantNested__option_t) const
{
  return d_holder->preSkolemQuantNested__setByUser__;
}
template <> void Options::set(
    options::prenexQuantUser__option_t,
    const options::prenexQuantUser__option_t::type& x)
{
  d_holder->prenexQuantUser = x;
}
template <> const options::prenexQuantUser__option_t::type& Options::operator[](
    options::prenexQuantUser__option_t) const
{
  return d_holder->prenexQuantUser;
}
template <> bool Options::wasSetByUser(options::prenexQuantUser__option_t) const
{
  return d_holder->prenexQuantUser__setByUser__;
}
template <> void Options::set(
    options::prenexQuant__option_t,
    const options::prenexQuant__option_t::type& x)
{
  d_holder->prenexQuant = x;
}
template <> const options::prenexQuant__option_t::type& Options::operator[](
    options::prenexQuant__option_t) const
{
  return d_holder->prenexQuant;
}
template <> bool Options::wasSetByUser(options::prenexQuant__option_t) const
{
  return d_holder->prenexQuant__setByUser__;
}
template <> void Options::set(
    options::pureThTriggers__option_t,
    const options::pureThTriggers__option_t::type& x)
{
  d_holder->pureThTriggers = x;
}
template <> const options::pureThTriggers__option_t::type& Options::operator[](
    options::pureThTriggers__option_t) const
{
  return d_holder->pureThTriggers;
}
template <> bool Options::wasSetByUser(options::pureThTriggers__option_t) const
{
  return d_holder->pureThTriggers__setByUser__;
}
template <> void Options::set(
    options::purifyDtTriggers__option_t,
    const options::purifyDtTriggers__option_t::type& x)
{
  d_holder->purifyDtTriggers = x;
}
template <> const options::purifyDtTriggers__option_t::type& Options::operator[](
    options::purifyDtTriggers__option_t) const
{
  return d_holder->purifyDtTriggers;
}
template <> bool Options::wasSetByUser(options::purifyDtTriggers__option_t) const
{
  return d_holder->purifyDtTriggers__setByUser__;
}
template <> void Options::set(
    options::purifyTriggers__option_t,
    const options::purifyTriggers__option_t::type& x)
{
  d_holder->purifyTriggers = x;
}
template <> const options::purifyTriggers__option_t::type& Options::operator[](
    options::purifyTriggers__option_t) const
{
  return d_holder->purifyTriggers;
}
template <> bool Options::wasSetByUser(options::purifyTriggers__option_t) const
{
  return d_holder->purifyTriggers__setByUser__;
}
template <> void Options::set(
    options::qcfAllConflict__option_t,
    const options::qcfAllConflict__option_t::type& x)
{
  d_holder->qcfAllConflict = x;
}
template <> const options::qcfAllConflict__option_t::type& Options::operator[](
    options::qcfAllConflict__option_t) const
{
  return d_holder->qcfAllConflict;
}
template <> bool Options::wasSetByUser(options::qcfAllConflict__option_t) const
{
  return d_holder->qcfAllConflict__setByUser__;
}
template <> const options::qcfEagerCheckRd__option_t::type& Options::operator[](
    options::qcfEagerCheckRd__option_t) const
{
  return d_holder->qcfEagerCheckRd;
}
template <> bool Options::wasSetByUser(options::qcfEagerCheckRd__option_t) const
{
  return d_holder->qcfEagerCheckRd__setByUser__;
}
template <> const options::qcfEagerTest__option_t::type& Options::operator[](
    options::qcfEagerTest__option_t) const
{
  return d_holder->qcfEagerTest;
}
template <> bool Options::wasSetByUser(options::qcfEagerTest__option_t) const
{
  return d_holder->qcfEagerTest__setByUser__;
}
template <> const options::qcfNestedConflict__option_t::type& Options::operator[](
    options::qcfNestedConflict__option_t) const
{
  return d_holder->qcfNestedConflict;
}
template <> bool Options::wasSetByUser(options::qcfNestedConflict__option_t) const
{
  return d_holder->qcfNestedConflict__setByUser__;
}
template <> const options::qcfSkipRd__option_t::type& Options::operator[](
    options::qcfSkipRd__option_t) const
{
  return d_holder->qcfSkipRd;
}
template <> bool Options::wasSetByUser(options::qcfSkipRd__option_t) const
{
  return d_holder->qcfSkipRd__setByUser__;
}
template <> void Options::set(
    options::qcfTConstraint__option_t,
    const options::qcfTConstraint__option_t::type& x)
{
  d_holder->qcfTConstraint = x;
}
template <> const options::qcfTConstraint__option_t::type& Options::operator[](
    options::qcfTConstraint__option_t) const
{
  return d_holder->qcfTConstraint;
}
template <> bool Options::wasSetByUser(options::qcfTConstraint__option_t) const
{
  return d_holder->qcfTConstraint__setByUser__;
}
template <> const options::qcfVoExp__option_t::type& Options::operator[](
    options::qcfVoExp__option_t) const
{
  return d_holder->qcfVoExp;
}
template <> bool Options::wasSetByUser(options::qcfVoExp__option_t) const
{
  return d_holder->qcfVoExp__setByUser__;
}
template <> const options::quantAlphaEquiv__option_t::type& Options::operator[](
    options::quantAlphaEquiv__option_t) const
{
  return d_holder->quantAlphaEquiv;
}
template <> bool Options::wasSetByUser(options::quantAlphaEquiv__option_t) const
{
  return d_holder->quantAlphaEquiv__setByUser__;
}
template <> void Options::set(
    options::quantAntiSkolem__option_t,
    const options::quantAntiSkolem__option_t::type& x)
{
  d_holder->quantAntiSkolem = x;
}
template <> const options::quantAntiSkolem__option_t::type& Options::operator[](
    options::quantAntiSkolem__option_t) const
{
  return d_holder->quantAntiSkolem;
}
template <> bool Options::wasSetByUser(options::quantAntiSkolem__option_t) const
{
  return d_holder->quantAntiSkolem__setByUser__;
}
template <> void Options::set(
    options::quantConflictFind__option_t,
    const options::quantConflictFind__option_t::type& x)
{
  d_holder->quantConflictFind = x;
}
template <> const options::quantConflictFind__option_t::type& Options::operator[](
    options::quantConflictFind__option_t) const
{
  return d_holder->quantConflictFind;
}
template <> bool Options::wasSetByUser(options::quantConflictFind__option_t) const
{
  return d_holder->quantConflictFind__setByUser__;
}
template <> const options::qcfMode__option_t::type& Options::operator[](
    options::qcfMode__option_t) const
{
  return d_holder->qcfMode;
}
template <> bool Options::wasSetByUser(options::qcfMode__option_t) const
{
  return d_holder->qcfMode__setByUser__;
}
template <> const options::qcfWhenMode__option_t::type& Options::operator[](
    options::qcfWhenMode__option_t) const
{
  return d_holder->qcfWhenMode;
}
template <> bool Options::wasSetByUser(options::qcfWhenMode__option_t) const
{
  return d_holder->qcfWhenMode__setByUser__;
}
template <> void Options::set(
    options::quantDynamicSplit__option_t,
    const options::quantDynamicSplit__option_t::type& x)
{
  d_holder->quantDynamicSplit = x;
}
template <> const options::quantDynamicSplit__option_t::type& Options::operator[](
    options::quantDynamicSplit__option_t) const
{
  return d_holder->quantDynamicSplit;
}
template <> bool Options::wasSetByUser(options::quantDynamicSplit__option_t) const
{
  return d_holder->quantDynamicSplit__setByUser__;
}
template <> void Options::set(
    options::quantEpr__option_t,
    const options::quantEpr__option_t::type& x)
{
  d_holder->quantEpr = x;
}
template <> const options::quantEpr__option_t::type& Options::operator[](
    options::quantEpr__option_t) const
{
  return d_holder->quantEpr;
}
template <> bool Options::wasSetByUser(options::quantEpr__option_t) const
{
  return d_holder->quantEpr__setByUser__;
}
template <> const options::quantEprMatching__option_t::type& Options::operator[](
    options::quantEprMatching__option_t) const
{
  return d_holder->quantEprMatching;
}
template <> bool Options::wasSetByUser(options::quantEprMatching__option_t) const
{
  return d_holder->quantEprMatching__setByUser__;
}
template <> const options::quantFunWellDefined__option_t::type& Options::operator[](
    options::quantFunWellDefined__option_t) const
{
  return d_holder->quantFunWellDefined;
}
template <> bool Options::wasSetByUser(options::quantFunWellDefined__option_t) const
{
  return d_holder->quantFunWellDefined__setByUser__;
}
template <> const options::quantInduction__option_t::type& Options::operator[](
    options::quantInduction__option_t) const
{
  return d_holder->quantInduction;
}
template <> bool Options::wasSetByUser(options::quantInduction__option_t) const
{
  return d_holder->quantInduction__setByUser__;
}
template <> const options::quantModelEe__option_t::type& Options::operator[](
    options::quantModelEe__option_t) const
{
  return d_holder->quantModelEe;
}
template <> bool Options::wasSetByUser(options::quantModelEe__option_t) const
{
  return d_holder->quantModelEe__setByUser__;
}
template <> void Options::set(
    options::quantRepMode__option_t,
    const options::quantRepMode__option_t::type& x)
{
  d_holder->quantRepMode = x;
}
template <> const options::quantRepMode__option_t::type& Options::operator[](
    options::quantRepMode__option_t) const
{
  return d_holder->quantRepMode;
}
template <> bool Options::wasSetByUser(options::quantRepMode__option_t) const
{
  return d_holder->quantRepMode__setByUser__;
}
template <> void Options::set(
    options::quantSplit__option_t,
    const options::quantSplit__option_t::type& x)
{
  d_holder->quantSplit = x;
}
template <> const options::quantSplit__option_t::type& Options::operator[](
    options::quantSplit__option_t) const
{
  return d_holder->quantSplit;
}
template <> bool Options::wasSetByUser(options::quantSplit__option_t) const
{
  return d_holder->quantSplit__setByUser__;
}
template <> const options::registerQuantBodyTerms__option_t::type& Options::operator[](
    options::registerQuantBodyTerms__option_t) const
{
  return d_holder->registerQuantBodyTerms;
}
template <> bool Options::wasSetByUser(options::registerQuantBodyTerms__option_t) const
{
  return d_holder->registerQuantBodyTerms__setByUser__;
}
template <> const options::relationalTriggers__option_t::type& Options::operator[](
    options::relationalTriggers__option_t) const
{
  return d_holder->relationalTriggers;
}
template <> bool Options::wasSetByUser(options::relationalTriggers__option_t) const
{
  return d_holder->relationalTriggers__setByUser__;
}
template <> const options::relevantTriggers__option_t::type& Options::operator[](
    options::relevantTriggers__option_t) const
{
  return d_holder->relevantTriggers;
}
template <> bool Options::wasSetByUser(options::relevantTriggers__option_t) const
{
  return d_holder->relevantTriggers__setByUser__;
}
template <> const options::quantRewriteRules__option_t::type& Options::operator[](
    options::quantRewriteRules__option_t) const
{
  return d_holder->quantRewriteRules;
}
template <> bool Options::wasSetByUser(options::quantRewriteRules__option_t) const
{
  return d_holder->quantRewriteRules__setByUser__;
}
template <> const options::rrOneInstPerRound__option_t::type& Options::operator[](
    options::rrOneInstPerRound__option_t) const
{
  return d_holder->rrOneInstPerRound;
}
template <> bool Options::wasSetByUser(options::rrOneInstPerRound__option_t) const
{
  return d_holder->rrOneInstPerRound__setByUser__;
}
template <> const options::strictTriggers__option_t::type& Options::operator[](
    options::strictTriggers__option_t) const
{
  return d_holder->strictTriggers;
}
template <> bool Options::wasSetByUser(options::strictTriggers__option_t) const
{
  return d_holder->strictTriggers__setByUser__;
}
template <> const options::sygusAddConstGrammar__option_t::type& Options::operator[](
    options::sygusAddConstGrammar__option_t) const
{
  return d_holder->sygusAddConstGrammar;
}
template <> bool Options::wasSetByUser(options::sygusAddConstGrammar__option_t) const
{
  return d_holder->sygusAddConstGrammar__setByUser__;
}
template <> const options::sygusInvAutoUnfold__option_t::type& Options::operator[](
    options::sygusInvAutoUnfold__option_t) const
{
  return d_holder->sygusInvAutoUnfold;
}
template <> bool Options::wasSetByUser(options::sygusInvAutoUnfold__option_t) const
{
  return d_holder->sygusInvAutoUnfold__setByUser__;
}
template <> void Options::set(
    options::sygusBoolIteReturnConst__option_t,
    const options::sygusBoolIteReturnConst__option_t::type& x)
{
  d_holder->sygusBoolIteReturnConst = x;
}
template <> const options::sygusBoolIteReturnConst__option_t::type& Options::operator[](
    options::sygusBoolIteReturnConst__option_t) const
{
  return d_holder->sygusBoolIteReturnConst;
}
template <> bool Options::wasSetByUser(options::sygusBoolIteReturnConst__option_t) const
{
  return d_holder->sygusBoolIteReturnConst__setByUser__;
}
template <> const options::sygusEvalUnfold__option_t::type& Options::operator[](
    options::sygusEvalUnfold__option_t) const
{
  return d_holder->sygusEvalUnfold;
}
template <> bool Options::wasSetByUser(options::sygusEvalUnfold__option_t) const
{
  return d_holder->sygusEvalUnfold__setByUser__;
}
template <> const options::sygusEvalUnfoldBool__option_t::type& Options::operator[](
    options::sygusEvalUnfoldBool__option_t) const
{
  return d_holder->sygusEvalUnfoldBool;
}
template <> bool Options::wasSetByUser(options::sygusEvalUnfoldBool__option_t) const
{
  return d_holder->sygusEvalUnfoldBool__setByUser__;
}
template <> void Options::set(
    options::sygusExtRew__option_t,
    const options::sygusExtRew__option_t::type& x)
{
  d_holder->sygusExtRew = x;
}
template <> const options::sygusExtRew__option_t::type& Options::operator[](
    options::sygusExtRew__option_t) const
{
  return d_holder->sygusExtRew;
}
template <> bool Options::wasSetByUser(options::sygusExtRew__option_t) const
{
  return d_holder->sygusExtRew__setByUser__;
}
template <> const options::sygusGrammarNorm__option_t::type& Options::operator[](
    options::sygusGrammarNorm__option_t) const
{
  return d_holder->sygusGrammarNorm;
}
template <> bool Options::wasSetByUser(options::sygusGrammarNorm__option_t) const
{
  return d_holder->sygusGrammarNorm__setByUser__;
}
template <> void Options::set(
    options::sygusInference__option_t,
    const options::sygusInference__option_t::type& x)
{
  d_holder->sygusInference = x;
}
template <> const options::sygusInference__option_t::type& Options::operator[](
    options::sygusInference__option_t) const
{
  return d_holder->sygusInference;
}
template <> bool Options::wasSetByUser(options::sygusInference__option_t) const
{
  return d_holder->sygusInference__setByUser__;
}
template <> void Options::set(
    options::sygusInvTemplWhenSyntax__option_t,
    const options::sygusInvTemplWhenSyntax__option_t::type& x)
{
  d_holder->sygusInvTemplWhenSyntax = x;
}
template <> const options::sygusInvTemplWhenSyntax__option_t::type& Options::operator[](
    options::sygusInvTemplWhenSyntax__option_t) const
{
  return d_holder->sygusInvTemplWhenSyntax;
}
template <> bool Options::wasSetByUser(options::sygusInvTemplWhenSyntax__option_t) const
{
  return d_holder->sygusInvTemplWhenSyntax__setByUser__;
}
template <> const options::sygusInvTemplMode__option_t::type& Options::operator[](
    options::sygusInvTemplMode__option_t) const
{
  return d_holder->sygusInvTemplMode;
}
template <> bool Options::wasSetByUser(options::sygusInvTemplMode__option_t) const
{
  return d_holder->sygusInvTemplMode__setByUser__;
}
template <> const options::sygusMinGrammar__option_t::type& Options::operator[](
    options::sygusMinGrammar__option_t) const
{
  return d_holder->sygusMinGrammar;
}
template <> bool Options::wasSetByUser(options::sygusMinGrammar__option_t) const
{
  return d_holder->sygusMinGrammar__setByUser__;
}
template <> void Options::set(
    options::sygusUnifPbe__option_t,
    const options::sygusUnifPbe__option_t::type& x)
{
  d_holder->sygusUnifPbe = x;
}
template <> const options::sygusUnifPbe__option_t::type& Options::operator[](
    options::sygusUnifPbe__option_t) const
{
  return d_holder->sygusUnifPbe;
}
template <> bool Options::wasSetByUser(options::sygusUnifPbe__option_t) const
{
  return d_holder->sygusUnifPbe__setByUser__;
}
template <> const options::sygusQePreproc__option_t::type& Options::operator[](
    options::sygusQePreproc__option_t) const
{
  return d_holder->sygusQePreproc;
}
template <> bool Options::wasSetByUser(options::sygusQePreproc__option_t) const
{
  return d_holder->sygusQePreproc__setByUser__;
}
template <> const options::sygusRefEval__option_t::type& Options::operator[](
    options::sygusRefEval__option_t) const
{
  return d_holder->sygusRefEval;
}
template <> bool Options::wasSetByUser(options::sygusRefEval__option_t) const
{
  return d_holder->sygusRefEval__setByUser__;
}
template <> void Options::set(
    options::sygusRepairConst__option_t,
    const options::sygusRepairConst__option_t::type& x)
{
  d_holder->sygusRepairConst = x;
}
template <> const options::sygusRepairConst__option_t::type& Options::operator[](
    options::sygusRepairConst__option_t) const
{
  return d_holder->sygusRepairConst;
}
template <> bool Options::wasSetByUser(options::sygusRepairConst__option_t) const
{
  return d_holder->sygusRepairConst__setByUser__;
}
template <> const options::sygusRew__option_t::type& Options::operator[](
    options::sygusRew__option_t) const
{
  return d_holder->sygusRew;
}
template <> bool Options::wasSetByUser(options::sygusRew__option_t) const
{
  return d_holder->sygusRew__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynth__option_t,
    const options::sygusRewSynth__option_t::type& x)
{
  d_holder->sygusRewSynth = x;
}
template <> const options::sygusRewSynth__option_t::type& Options::operator[](
    options::sygusRewSynth__option_t) const
{
  return d_holder->sygusRewSynth;
}
template <> bool Options::wasSetByUser(options::sygusRewSynth__option_t) const
{
  return d_holder->sygusRewSynth__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthAccel__option_t,
    const options::sygusRewSynthAccel__option_t::type& x)
{
  d_holder->sygusRewSynthAccel = x;
}
template <> const options::sygusRewSynthAccel__option_t::type& Options::operator[](
    options::sygusRewSynthAccel__option_t) const
{
  return d_holder->sygusRewSynthAccel;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthAccel__option_t) const
{
  return d_holder->sygusRewSynthAccel__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthCheck__option_t,
    const options::sygusRewSynthCheck__option_t::type& x)
{
  d_holder->sygusRewSynthCheck = x;
}
template <> const options::sygusRewSynthCheck__option_t::type& Options::operator[](
    options::sygusRewSynthCheck__option_t) const
{
  return d_holder->sygusRewSynthCheck;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthCheck__option_t) const
{
  return d_holder->sygusRewSynthCheck__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthFilterCong__option_t,
    const options::sygusRewSynthFilterCong__option_t::type& x)
{
  d_holder->sygusRewSynthFilterCong = x;
}
template <> const options::sygusRewSynthFilterCong__option_t::type& Options::operator[](
    options::sygusRewSynthFilterCong__option_t) const
{
  return d_holder->sygusRewSynthFilterCong;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterCong__option_t) const
{
  return d_holder->sygusRewSynthFilterCong__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthFilterMatch__option_t,
    const options::sygusRewSynthFilterMatch__option_t::type& x)
{
  d_holder->sygusRewSynthFilterMatch = x;
}
template <> const options::sygusRewSynthFilterMatch__option_t::type& Options::operator[](
    options::sygusRewSynthFilterMatch__option_t) const
{
  return d_holder->sygusRewSynthFilterMatch;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterMatch__option_t) const
{
  return d_holder->sygusRewSynthFilterMatch__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthFilterOrder__option_t,
    const options::sygusRewSynthFilterOrder__option_t::type& x)
{
  d_holder->sygusRewSynthFilterOrder = x;
}
template <> const options::sygusRewSynthFilterOrder__option_t::type& Options::operator[](
    options::sygusRewSynthFilterOrder__option_t) const
{
  return d_holder->sygusRewSynthFilterOrder;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterOrder__option_t) const
{
  return d_holder->sygusRewSynthFilterOrder__setByUser__;
}
template <> void Options::set(
    options::sygusRewVerify__option_t,
    const options::sygusRewVerify__option_t::type& x)
{
  d_holder->sygusRewVerify = x;
}
template <> const options::sygusRewVerify__option_t::type& Options::operator[](
    options::sygusRewVerify__option_t) const
{
  return d_holder->sygusRewVerify;
}
template <> bool Options::wasSetByUser(options::sygusRewVerify__option_t) const
{
  return d_holder->sygusRewVerify__setByUser__;
}
template <> void Options::set(
    options::sygusRewVerifyAbort__option_t,
    const options::sygusRewVerifyAbort__option_t::type& x)
{
  d_holder->sygusRewVerifyAbort = x;
}
template <> const options::sygusRewVerifyAbort__option_t::type& Options::operator[](
    options::sygusRewVerifyAbort__option_t) const
{
  return d_holder->sygusRewVerifyAbort;
}
template <> bool Options::wasSetByUser(options::sygusRewVerifyAbort__option_t) const
{
  return d_holder->sygusRewVerifyAbort__setByUser__;
}
template <> const options::sygusSampleGrammar__option_t::type& Options::operator[](
    options::sygusSampleGrammar__option_t) const
{
  return d_holder->sygusSampleGrammar;
}
template <> bool Options::wasSetByUser(options::sygusSampleGrammar__option_t) const
{
  return d_holder->sygusSampleGrammar__setByUser__;
}
template <> void Options::set(
    options::sygusSamples__option_t,
    const options::sygusSamples__option_t::type& x)
{
  d_holder->sygusSamples = x;
}
template <> const options::sygusSamples__option_t::type& Options::operator[](
    options::sygusSamples__option_t) const
{
  return d_holder->sygusSamples;
}
template <> bool Options::wasSetByUser(options::sygusSamples__option_t) const
{
  return d_holder->sygusSamples__setByUser__;
}
template <> void Options::set(
    options::sygusStream__option_t,
    const options::sygusStream__option_t::type& x)
{
  d_holder->sygusStream = x;
}
template <> const options::sygusStream__option_t::type& Options::operator[](
    options::sygusStream__option_t) const
{
  return d_holder->sygusStream;
}
template <> bool Options::wasSetByUser(options::sygusStream__option_t) const
{
  return d_holder->sygusStream__setByUser__;
}
template <> const options::sygusTemplEmbedGrammar__option_t::type& Options::operator[](
    options::sygusTemplEmbedGrammar__option_t) const
{
  return d_holder->sygusTemplEmbedGrammar;
}
template <> bool Options::wasSetByUser(options::sygusTemplEmbedGrammar__option_t) const
{
  return d_holder->sygusTemplEmbedGrammar__setByUser__;
}
template <> void Options::set(
    options::sygusUnif__option_t,
    const options::sygusUnif__option_t::type& x)
{
  d_holder->sygusUnif = x;
}
template <> const options::sygusUnif__option_t::type& Options::operator[](
    options::sygusUnif__option_t) const
{
  return d_holder->sygusUnif;
}
template <> bool Options::wasSetByUser(options::sygusUnif__option_t) const
{
  return d_holder->sygusUnif__setByUser__;
}
template <> void Options::set(
    options::termDbMode__option_t,
    const options::termDbMode__option_t::type& x)
{
  d_holder->termDbMode = x;
}
template <> const options::termDbMode__option_t::type& Options::operator[](
    options::termDbMode__option_t) const
{
  return d_holder->termDbMode;
}
template <> bool Options::wasSetByUser(options::termDbMode__option_t) const
{
  return d_holder->termDbMode__setByUser__;
}
template <> void Options::set(
    options::trackInstLemmas__option_t,
    const options::trackInstLemmas__option_t::type& x)
{
  d_holder->trackInstLemmas = x;
}
template <> const options::trackInstLemmas__option_t::type& Options::operator[](
    options::trackInstLemmas__option_t) const
{
  return d_holder->trackInstLemmas;
}
template <> bool Options::wasSetByUser(options::trackInstLemmas__option_t) const
{
  return d_holder->trackInstLemmas__setByUser__;
}
template <> void Options::set(
    options::triggerActiveSelMode__option_t,
    const options::triggerActiveSelMode__option_t::type& x)
{
  d_holder->triggerActiveSelMode = x;
}
template <> const options::triggerActiveSelMode__option_t::type& Options::operator[](
    options::triggerActiveSelMode__option_t) const
{
  return d_holder->triggerActiveSelMode;
}
template <> bool Options::wasSetByUser(options::triggerActiveSelMode__option_t) const
{
  return d_holder->triggerActiveSelMode__setByUser__;
}
template <> void Options::set(
    options::triggerSelMode__option_t,
    const options::triggerSelMode__option_t::type& x)
{
  d_holder->triggerSelMode = x;
}
template <> const options::triggerSelMode__option_t::type& Options::operator[](
    options::triggerSelMode__option_t) const
{
  return d_holder->triggerSelMode;
}
template <> bool Options::wasSetByUser(options::triggerSelMode__option_t) const
{
  return d_holder->triggerSelMode__setByUser__;
}
template <> void Options::set(
    options::userPatternsQuant__option_t,
    const options::userPatternsQuant__option_t::type& x)
{
  d_holder->userPatternsQuant = x;
}
template <> const options::userPatternsQuant__option_t::type& Options::operator[](
    options::userPatternsQuant__option_t) const
{
  return d_holder->userPatternsQuant;
}
template <> bool Options::wasSetByUser(options::userPatternsQuant__option_t) const
{
  return d_holder->userPatternsQuant__setByUser__;
}
template <> const options::varElimQuant__option_t::type& Options::operator[](
    options::varElimQuant__option_t) const
{
  return d_holder->varElimQuant;
}
template <> bool Options::wasSetByUser(options::varElimQuant__option_t) const
{
  return d_holder->varElimQuant__setByUser__;
}
template <> const options::varIneqElimQuant__option_t::type& Options::operator[](
    options::varIneqElimQuant__option_t) const
{
  return d_holder->varIneqElimQuant;
}
template <> bool Options::wasSetByUser(options::varIneqElimQuant__option_t) const
{
  return d_holder->varIneqElimQuant__setByUser__;
}


namespace options {

struct aggressiveMiniscopeQuant__option_t aggressiveMiniscopeQuant;
struct cbqi__option_t cbqi;
struct cbqiAll__option_t cbqiAll;
struct cbqiBv__option_t cbqiBv;
struct cbqiBvConcInv__option_t cbqiBvConcInv;
struct cbqiBvIneqMode__option_t cbqiBvIneqMode;
struct cbqiBvInterleaveValue__option_t cbqiBvInterleaveValue;
struct cbqiBvLinearize__option_t cbqiBvLinearize;
struct cbqiBvRmExtract__option_t cbqiBvRmExtract;
struct cbqiBvSolveNl__option_t cbqiBvSolveNl;
struct cbqiFullEffort__option_t cbqiFullEffort;
struct cbqiInnermost__option_t cbqiInnermost;
struct cbqiLitDepend__option_t cbqiLitDepend;
struct cbqiMidpoint__option_t cbqiMidpoint;
struct cbqiMinBounds__option_t cbqiMinBounds;
struct cbqiModel__option_t cbqiModel;
struct cbqiMultiInst__option_t cbqiMultiInst;
struct cbqiNestedQE__option_t cbqiNestedQE;
struct cbqiNopt__option_t cbqiNopt;
struct cbqiPreRegInst__option_t cbqiPreRegInst;
struct recurseCbqi__option_t recurseCbqi;
struct cbqiRepeatLit__option_t cbqiRepeatLit;
struct cbqiRoundUpLowerLia__option_t cbqiRoundUpLowerLia;
struct cbqiSat__option_t cbqiSat;
struct cbqiUseInfInt__option_t cbqiUseInfInt;
struct cbqiUseInfReal__option_t cbqiUseInfReal;
struct cegisSample__option_t cegisSample;
struct ceGuidedInst__option_t ceGuidedInst;
struct cegqiSingleInvAbort__option_t cegqiSingleInvAbort;
struct cegqiSingleInvPartial__option_t cegqiSingleInvPartial;
struct cegqiSingleInvReconstruct__option_t cegqiSingleInvReconstruct;
struct cegqiSingleInvReconstructConst__option_t cegqiSingleInvReconstructConst;
struct cegqiSolMinCore__option_t cegqiSolMinCore;
struct cegqiSolMinInst__option_t cegqiSolMinInst;
struct cegqiSingleInvMode__option_t cegqiSingleInvMode;
struct condRewriteQuant__option_t condRewriteQuant;
struct condVarSplitQuantAgg__option_t condVarSplitQuantAgg;
struct condVarSplitQuant__option_t condVarSplitQuant;
struct conjectureFilterActiveTerms__option_t conjectureFilterActiveTerms;
struct conjectureFilterCanonical__option_t conjectureFilterCanonical;
struct conjectureFilterModel__option_t conjectureFilterModel;
struct conjectureGen__option_t conjectureGen;
struct conjectureGenGtEnum__option_t conjectureGenGtEnum;
struct conjectureGenMaxDepth__option_t conjectureGenMaxDepth;
struct conjectureGenPerRound__option_t conjectureGenPerRound;
struct conjectureUeeIntro__option_t conjectureUeeIntro;
struct conjectureNoFilter__option_t conjectureNoFilter;
struct dtStcInduction__option_t dtStcInduction;
struct dtVarExpandQuant__option_t dtVarExpandQuant;
struct eMatching__option_t eMatching;
struct elimExtArithQuant__option_t elimExtArithQuant;
struct elimTautQuant__option_t elimTautQuant;
struct finiteModelFind__option_t finiteModelFind;
struct fmfBound__option_t fmfBound;
struct fmfBoundInt__option_t fmfBoundInt;
struct fmfBoundLazy__option_t fmfBoundLazy;
struct fmfBoundMinMode__option_t fmfBoundMinMode;
struct fmfEmptySorts__option_t fmfEmptySorts;
struct fmfFmcSimple__option_t fmfFmcSimple;
struct fmfFreshDistConst__option_t fmfFreshDistConst;
struct fmfFunWellDefined__option_t fmfFunWellDefined;
struct fmfFunWellDefinedRelevant__option_t fmfFunWellDefinedRelevant;
struct fmfInstEngine__option_t fmfInstEngine;
struct fmfInstGen__option_t fmfInstGen;
struct fmfInstGenOneQuantPerRound__option_t fmfInstGenOneQuantPerRound;
struct fullSaturateInterleave__option_t fullSaturateInterleave;
struct fullSaturateQuant__option_t fullSaturateQuant;
struct fullSaturateQuantRd__option_t fullSaturateQuantRd;
struct globalNegate__option_t globalNegate;
struct hoMatching__option_t hoMatching;
struct hoMatchingVarArgPriority__option_t hoMatchingVarArgPriority;
struct hoMergeTermDb__option_t hoMergeTermDb;
struct incrementTriggers__option_t incrementTriggers;
struct inferArithTriggerEq__option_t inferArithTriggerEq;
struct inferArithTriggerEqExp__option_t inferArithTriggerEqExp;
struct instLevelInputOnly__option_t instLevelInputOnly;
struct instMaxLevel__option_t instMaxLevel;
struct instNoEntail__option_t instNoEntail;
struct instNoModelTrue__option_t instNoModelTrue;
struct instPropagate__option_t instPropagate;
struct instWhenPhase__option_t instWhenPhase;
struct instWhenStrictInterleave__option_t instWhenStrictInterleave;
struct instWhenTcFirst__option_t instWhenTcFirst;
struct instWhenMode__option_t instWhenMode;
struct intWfInduction__option_t intWfInduction;
struct iteDtTesterSplitQuant__option_t iteDtTesterSplitQuant;
struct iteLiftQuant__option_t iteLiftQuant;
struct literalMatchMode__option_t literalMatchMode;
struct localTheoryExt__option_t localTheoryExt;
struct ltePartialInst__option_t ltePartialInst;
struct lteRestrictInstClosure__option_t lteRestrictInstClosure;
struct macrosQuant__option_t macrosQuant;
struct macrosQuantMode__option_t macrosQuantMode;
struct mbqiInterleave__option_t mbqiInterleave;
struct fmfOneInstPerRound__option_t fmfOneInstPerRound;
struct fmfOneQuantPerRound__option_t fmfOneQuantPerRound;
struct mbqiMode__option_t mbqiMode;
struct miniscopeQuant__option_t miniscopeQuant;
struct miniscopeQuantFreeVar__option_t miniscopeQuantFreeVar;
struct multiTriggerCache__option_t multiTriggerCache;
struct multiTriggerLinear__option_t multiTriggerLinear;
struct multiTriggerPriority__option_t multiTriggerPriority;
struct multiTriggerWhenSingle__option_t multiTriggerWhenSingle;
struct partialTriggers__option_t partialTriggers;
struct preSkolemQuant__option_t preSkolemQuant;
struct preSkolemQuantAgg__option_t preSkolemQuantAgg;
struct preSkolemQuantNested__option_t preSkolemQuantNested;
struct prenexQuantUser__option_t prenexQuantUser;
struct prenexQuant__option_t prenexQuant;
struct pureThTriggers__option_t pureThTriggers;
struct purifyDtTriggers__option_t purifyDtTriggers;
struct purifyTriggers__option_t purifyTriggers;
struct qcfAllConflict__option_t qcfAllConflict;
struct qcfEagerCheckRd__option_t qcfEagerCheckRd;
struct qcfEagerTest__option_t qcfEagerTest;
struct qcfNestedConflict__option_t qcfNestedConflict;
struct qcfSkipRd__option_t qcfSkipRd;
struct qcfTConstraint__option_t qcfTConstraint;
struct qcfVoExp__option_t qcfVoExp;
struct quantAlphaEquiv__option_t quantAlphaEquiv;
struct quantAntiSkolem__option_t quantAntiSkolem;
struct quantConflictFind__option_t quantConflictFind;
struct qcfMode__option_t qcfMode;
struct qcfWhenMode__option_t qcfWhenMode;
struct quantDynamicSplit__option_t quantDynamicSplit;
struct quantEpr__option_t quantEpr;
struct quantEprMatching__option_t quantEprMatching;
struct quantFunWellDefined__option_t quantFunWellDefined;
struct quantInduction__option_t quantInduction;
struct quantModelEe__option_t quantModelEe;
struct quantRepMode__option_t quantRepMode;
struct quantSplit__option_t quantSplit;
struct registerQuantBodyTerms__option_t registerQuantBodyTerms;
struct relationalTriggers__option_t relationalTriggers;
struct relevantTriggers__option_t relevantTriggers;
struct quantRewriteRules__option_t quantRewriteRules;
struct rrOneInstPerRound__option_t rrOneInstPerRound;
struct strictTriggers__option_t strictTriggers;
struct sygusAddConstGrammar__option_t sygusAddConstGrammar;
struct sygusInvAutoUnfold__option_t sygusInvAutoUnfold;
struct sygusBoolIteReturnConst__option_t sygusBoolIteReturnConst;
struct sygusEvalUnfold__option_t sygusEvalUnfold;
struct sygusEvalUnfoldBool__option_t sygusEvalUnfoldBool;
struct sygusExtRew__option_t sygusExtRew;
struct sygusGrammarNorm__option_t sygusGrammarNorm;
struct sygusInference__option_t sygusInference;
struct sygusInvTemplWhenSyntax__option_t sygusInvTemplWhenSyntax;
struct sygusInvTemplMode__option_t sygusInvTemplMode;
struct sygusMinGrammar__option_t sygusMinGrammar;
struct sygusUnifPbe__option_t sygusUnifPbe;
struct sygusQePreproc__option_t sygusQePreproc;
struct sygusRefEval__option_t sygusRefEval;
struct sygusRepairConst__option_t sygusRepairConst;
struct sygusRew__option_t sygusRew;
struct sygusRewSynth__option_t sygusRewSynth;
struct sygusRewSynthAccel__option_t sygusRewSynthAccel;
struct sygusRewSynthCheck__option_t sygusRewSynthCheck;
struct sygusRewSynthFilterCong__option_t sygusRewSynthFilterCong;
struct sygusRewSynthFilterMatch__option_t sygusRewSynthFilterMatch;
struct sygusRewSynthFilterOrder__option_t sygusRewSynthFilterOrder;
struct sygusRewVerify__option_t sygusRewVerify;
struct sygusRewVerifyAbort__option_t sygusRewVerifyAbort;
struct sygusSampleGrammar__option_t sygusSampleGrammar;
struct sygusSamples__option_t sygusSamples;
struct sygusStream__option_t sygusStream;
struct sygusTemplEmbedGrammar__option_t sygusTemplEmbedGrammar;
struct sygusUnif__option_t sygusUnif;
struct termDbMode__option_t termDbMode;
struct trackInstLemmas__option_t trackInstLemmas;
struct triggerActiveSelMode__option_t triggerActiveSelMode;
struct triggerSelMode__option_t triggerSelMode;
struct userPatternsQuant__option_t userPatternsQuant;
struct varElimQuant__option_t varElimQuant;
struct varIneqElimQuant__option_t varIneqElimQuant;


}  // namespace options
}  // namespace CVC4
