if not modules then modules = { } end modules ['mult-mes'] = {
    version   = 1.001,
    comment   = "companion to mult-ini.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files",
    dataonly  = true,
}

-- floatsblocks -> floats
-- bodyfont     -> fonts
-- verbatims    -> buffers

-- check all interfaces.showmessage
-- replace all writestatus (tricky as %'s in names, but we can support --)

return {
    formats = {
        ["adapted: preamble %a, state %a, order %a"] = {
            nl = "aangepast: preamble %a, status %a, volgorde %a",
        },
        ["already loaded: %a"] = {
            nl = "al geladen: %a",
        },
        ["check:1"] = {
            cs = "postradam '=' po %a na radku %a",
            de = "Fehlendes '=' nach %a in Zeile %a",
            en = "missing or ungrouped '=' after %a in line %a",
            fr = "manquant ou dégroupé '=' après %a à la ligne %a",
            it = "'=' mancante o non raggruppato dopo %a alla riga %a",
            nl = "'=' ontbreekt of zonder {} na %a in regel %a",
            no = "manglende '=' etter %a i linje %a",
            ro = "lipseste '=' dupa %a in linia %a",
        },
        ["check:2"] = {
            cs = "ocekavam %a argument(y) na radku %a",
            de = "%a Argument(e) in Zeile %a erwartet",
            en = "%a argument(s) expected in line %a",
            fr = "%a argument(s) attendu(s) à la ligne %a",
            it = "%a argomento/i attesi alla riga %a",
            nl = "%a argument(en) verwacht in regel %a",
            no = "%a argument forventet i linje %a",
            ro = "argumentul(ele) %a sunt asteptate in linia  %a",
        },
        ["check:3"] = {
            cs = "%a %a nahrazuje makro, uzijte VERZALKY!",
            de = "%a %a ersetzt ein Makro, verwende VERSALIEN!",
            en = "%a %a replaces a macro, use CAPITALS!",
            fr = "%a %a remplace une macro, utilisez des MAJUSCULES !",
            it = "%a %a sostituisce una macro, usare le MAIUSCOLE!",
            nl = "%a %a vervangt een macro, gebruik HOOFDLETTERS!",
            no = "%a %a overskygger en makro, bruk STORE BOKSTAVER!",
            ro = "%a %a inlocuieste un macro, folositi MAJUSCULE!",
        },
        ["checking file: %a"] = {
            nl = "controleren file: %a",
        },
        ["checking url: %a"] = {
            nl = "controleren url: %a",
        },
        ["colors:1"] = {
            cs = "system %a je globalne aktivovana",
            de = "system %a ist global aktiviert",
            en = "system %a is global activated",
            fr = "le système %a est globalement activé",
            it = "sistema %a attivato globalmente",
            nl = "systeem %a is globaal actief",
            no = "system %a er aktivert globalt",
            ro = "sistem %a este activata global",
        },
        ["colors:10"] = {
            cs = "%a prostor barev je podporovan",
            de = "%a Farbraum wird unterstuetzt",
            en = "%a color space is supported",
            fr = "%a l'espace de couleur est supporté",
            it = "spazio dei colori %a supportato",
            nl = "%a kleurruimte wordt ondersteund",
            no = "%a fargerom er støttet",
            ro = "spatiul de culoare %a este suportat",
        },
        ["colors:11"] = {
            cs = "barva je prevedena na sed",
            de = "Farbe wird in Grau umgewandelt",
            en = "color is converted to gray",
            fr = "la couleur est convertie en niveau de gris",
            it = "il colore ø convertito in grigio",
            nl = "kleur wordt vertaald in grijs",
            no = "fargen vil bli vist som grø",
            ro = "culoarea este convertita la gri",
        },
        ["colors:12"] = {
            cs = "%a is registered",
            de = "%a is registered",
            en = "%a is registered",
            fr = "%a est enregistré",
            it = "%a is registered",
            nl = "%a is geregistreerd",
            no = "%a is registered",
            ro = "%a is registered",
        },
        ["colors:2"] = {
            cs = "system %a je lokalne activovana",
            de = "system %a ist lokal aktiviert",
            en = "system %a is local activated",
            fr = "le système %a est localement activé",
            it = "sistema %a attivato localmente",
            nl = "systeem %a is lokaal actief",
            no = "system %a er aktivert lokalt",
            ro = "sistem %a este activata local",
        },
        ["colors:3"] = {
            cs = "%a neni definovana %a",
            de = "%a ist undefiniert %a",
            en = "%a is not defined %a",
            fr = "%a n'est pas défini %a",
            it = "%a non definito %a",
            nl = "%a is niet gedefinieerd %a",
            no = "%a er udefinert %a",
            ro = "%a nu este definita %a",
        },
        ["colors:4"] = {
            cs = "system %a je nacten",
            de = "system %a ist geladen",
            en = "system %a is loaded",
            fr = "le système %a est chargé",
            it = "sistema %a caricato",
            nl = "systeem %a wordt geladen",
            no = "system %a er lest inn",
            ro = "sistem %a este incarcata",
        },
        ["colors:5"] = {
            cs = "neznamy system %a",
            de = "unbekanntes System %a",
            en = "unknown system %a",
            fr = "système %a inconnu",
            it = "sistema %a sconosciuto",
            nl = "onbekend systeem %a",
            no = "ukjent system %a",
            ro = "sistem %a necunoscuta",
        },
        ["colors:6"] = {
            cs = "palette %a je k dispozici",
            de = "palette %a ist verfuegbar",
            en = "palette %a is available",
            fr = "la palette %a est disponible",
            it = "tavolozza %a resa disponibile",
            nl = "palet %a is beschikbaar",
            no = "palett %a er tilgjengelig",
            ro = "paleta %a este disponibila",
        },
        ["colors:7"] = {
            cs = "palette %a neni k dispozici",
            de = "palette %a ist nicht verfuegbar",
            en = "palette %a is not available",
            fr = "le palette %a n'est pas disponible",
            it = "tavolozza %a non disponibile",
            nl = "palet %a is niet beschikbaar",
            no = "palett %a er ikke tilgjengelig",
            ro = "palette %a nu este disponibila",
        },
        ["colors:8"] = {
            cs = "specifikace %a v barve %a bude cerna",
            de = "Spezifikation %a bei Farbe %a wird schwarz",
            en = "specification %a at color %a becomes black",
            fr = "la spécification %a de la couleur %a devient noire",
            it = "specifica %a del colore %a convertita in nero",
            nl = "specificatie %a bij %a wordt zwart",
            no = "spesifikasjon %a for farge %a gir kun svart",
            ro = "specificatia %a la culoarea %a devine neagra",
        },
        ["colors:9"] = {
            cs = "%a prostor barev neni podporovan",
            de = "%a Farbraum wird nicht unterstuetzt",
            en = "%a color space is not supported",
            fr = "l'espace de couleur %a n'est pas supporté",
            it = "spazio dei colori %a non supportato",
            nl = "%a kleurruimte wordt niet ondersteund",
            no = "%a fargerom er ikke støttet",
            ro = "spatiul de culoare %a nu este suportat",
        },
        ["columns:1"] = {
            cs = "je mozno pouze %a sloupcu",
            de = "nur %a Spalten moeglich",
            en = "only %a columns possible",
            fr = "seules %a colonnes possibles",
            it = "solo %a colonne possibili",
            nl = "maximaal %a kolommen",
            no = "maksimalt %a kolonner",
            ro = "este posibil numai %a coloane",
        },
        ["columns:10"] = {
            cs = "zbyl (mene nez) 1 radek",
            de = "(weniger als) 1 Zeile uebrig",
            en = "(less than) 1 line left",
            fr = "(moins de) 1 ligne restante",
            it = "(meno di) una riga rimasta",
            nl = "(minder dan) 1 regel over",
            no = "(mindre enn) 1 linje igjen",
            ro = "a mai ramas (mai putin de) 1 linie",
        },
        ["columns:11"] = {
            cs = "plovouci objekt je pro sloupec prilis siroky",
            de = "Gleitobjekt zu breit fuer Spalte",
            en = "float too wide for column",
            fr = "flottant mis à la largeur de la colonne",
            it = "oggetto mobile troppo ampio per la colonna",
            nl = "plaatsblok te breed voor kolom",
            no = "flytblokk for bredt for kolonna",
            ro = "blocul este prea lat pentru coloana",
        },
        ["columns:12"] = {
            cs = "plovouci objekt je presunut do nasledujiciho sloupce / %a",
            de = "Gleitobjekt in naechste Zeile verschoben / %a",
            en = "float moved to next column / %a",
            fr = "flottant déplacé à la colonne suivante / %a",
            it = "oggetto mobile spostata alla colonna successiva / %a",
            nl = "plaatsblok verplaatst naar volgende kolom / %a",
            no = "flytblokk forskjøvet til neste kolonne / %a",
            ro = "blocul este mutat pe urmatoarea coloana / %a",
        },
        ["columns:13"] = {
            cs = "siroky plovouci objekt je presunut nad sloupce",
            de = "breites Gleitobjekt an den Anfang der Spalten verschoben",
            en = "wide float moved to top of columns",
            fr = "flottant large déplacé dans la partie supérieure de la colonne",
            it = "oggetto mobile ampio spostato sopra le colonne",
            nl = "breed figuur geplaatst boven kolommen",
            no = "bred flytblokk forksjøvet til toppen av kolonnene",
            ro = "blocul lat este mutat in partea de sus a coloanelor",
        },
        ["columns:2"] = {
            cs = "pouzijte \\string\\filbreak\\space jako alternativu",
            de = "benutzte \\string\\filbreak\\space als Alternative",
            en = "use \\string\\filbreak\\space as alternative",
            fr = "utilisez \\string\\filbreak\\space en tant qu'alternative",
            it = "in alternativa, usare \\string\\filbreak",
            nl = "gebruik eventueel \\string\\filbreak",
            no = "bruk \\string\\filbreak\\space som et alternativ",
            ro = "folositi \\string\\filbreak\\space ca alternativa",
        },
        ["columns:3"] = {
            cs = "problem, vypina se vyvazovani",
            de = "Problem, verwende [ausgleich=nein]",
            en = "problems, disable balancing",
            fr = "problèmes, désactive l'équilibrage",
            it = "problemi, disabilitare il bilanciamento",
            nl = "probleempje, probeer [balanceren=nee]",
            no = "problemer, slår av balansering",
            ro = "probleme, se dezactiveaza alinierea",
        },
        ["columns:4"] = {
            cs = "horni plovouci objekt jeste neni podporovan",
            de = "Gleitobjekt oben ncoh nicht unterstuetzt",
            en = "top float not yet supported",
            fr = "flottant en partie supérieure pas encore supporté",
            it = "float in cima non ancora supportato",
            nl = "plaatsblok boven nog niet mogelijk",
            no = "flytblokker øverst er ikke støttet enda",
            ro = "cadrele top (top float) nu sunt inca suportate",
        },
        ["columns:5"] = {
            cs = "spodni plovouci objekt jeste neni podporovan",
            de = "Gleitobjekt unten ncoh nicht unterstuetzt",
            en = "bottom float not yet supported",
            fr = "flottant en partie inférieure pas encore supporté",
            it = "float in fondo non ancora supportato",
            nl = "plaatsblok onder nog niet mogelijk",
            no = "flytblokker nedert er ikke støttet enda",
            ro = "cadrele bottom (bottom float) nu sunt inca suportate",
        },
        ["columns:6"] = {
            cs = "%a plovouci objekt(y) odlozeny",
            de = "%a Gleitobjekt(e) verschoben",
            en = "%a float(s) postponed",
            fr = "%a flottant(s) reporté(s)",
            it = "%a float(s) posticipate",
            nl = "%a plaatsblok(en) opgeschort",
            no = "%a flytblokk forskjøvet",
            ro = "%a blocurile sunt amanate",
        },
        ["columns:7"] = {
            cs = "vyvazovani ukonceno po 100 krocich",
            de = "ausgleich nach 100 Schritten abgebrocheb",
            en = "balancing aborted after 100 steps",
            fr = "équilibrage abandonné après 100 pas",
            it = "bilanciamento annullato dopo 100 passi",
            nl = "balanceren afgebroken na 100 stappen",
            no = "balansering avbrutt etter 100 iterasjoner",
            ro = "alinierea este oprita dupa 100 de incercari",
        },
        ["columns:8"] = {
            cs = "vyvazeno v %a krocich",
            de = "ausgeglichen nach  %a Schritt(en)",
            en = "balanced in %a step(s)",
            fr = "équilibré en %a pas",
            it = "bilanciamento in %a passo/i",
            nl = "gebalanceerd in %a stap(pen)",
            no = "balansert etter %a iterasjoner",
            ro = "aliniat in  %a pas(i)",
        },
        ["columns:9"] = {
            cs = "kontrola nerovnost",
            de = "Ausrichtung ueberpruefen",
            en = "check raggedness",
            fr = "vérification des irrégularités",
            it = "controllare seghettamento",
            nl = "uitlijnen controleren!",
            no = "kontroller tekstlayout!",
            ro = "verificat alinierea",
        },
        ["databases:1"] = {
            cs = "%a",
            de = "%a",
            en = "%a",
            fr = "%a",
            it = "%a",
            nl = "%a",
            no = "%a",
            ro = "%a",
        },
        ["databases:2"] = {
            cs = "local file %a",
            de = "lokale Datei %a",
            en = "local file %a",
            fr = "fichier local %a",
            it = "file locale %a",
            nl = "lokaal bestand %a",
            no = "lokal fil %a",
            ro = "fisier local %a",
        },
        ["databases:3"] = {
            cs = "global file %a",
            de = "globale Datei %a",
            en = "global file %a",
            fr = "fichier global %a",
            it = "file globale %a",
            nl = "globaal bestand %a",
            no = "global fil %a",
            ro = "fisier global %a",
        },
        ["databases:4"] = {
            cs = "unknown file %a",
            de = "unbekannte Datei %a",
            en = "unknown file %a",
            fr = "fichier inconnu %a",
            it = "file sconosciuto %a",
            nl = "onbekend bestand %a",
            no = "ukjent fil %a",
            ro = "fisier necunoscut %a",
        },
        ["extended: preamble %a, state %a, order %a"] = {
            nl = "uitgebreid: preamble %a, status %a, volgorde %a",
        },
        ["figures:1"] = {
            cs = "obraz %a nelze nalezt",
            de = "Abbildung %a kann nicht gefunden werden",
            en = "figure %a can not be found",
            fr = "la figure %a ne peut être trouvée",
            it = "figura %a non trovata",
            nl = "figuur %a is niet te vinden",
            ro = "figura %a nu poate fi gasita",
        },
        ["figures:2"] = {
            cs = "obraz %a nepritomen",
            de = "Abbildung %a wird nicht erstellt",
            en = "figure %a is not preset",
            fr = "la figure %a n'est pas pré-sélectionnée",
            it = "la figura %a non è preimpostata",
            nl = "figuur %a wordt niet preset",
            ro = "figura %a nu este presetata",
        },
        ["figures:3"] = {
            cs = "dimensions of %a are determined externally",
            de = "dimensions of %a are determined externally",
            en = "dimensions of %a are determined externally",
            fr = "dimensions of %a are determined externally",
            it = "dimensions of %a are determined externally",
            nl = "maten van %a worden extern vastgesteld",
            ro = "dimensions of %a are determined externally",
        },
        ["figures:4"] = {
            cs = "dimenze obrazu %a nacteny primo z jeho souboru",
            de = "Dimensionen von %a geladen aus der Abbildungsdatei selbst",
            en = "dimensions of %a loaded from figurefile itself",
            fr = "les dimensions de %a chargées implicitement à partir du fichier de figure",
            it = "dimensioni di %a caricate dal file di immagini stesso",
            nl = "maten van %a geladen uit figuurfile zelf",
            ro = "dimensiunea figurii %a se incarca din fisierul insusi",
        },
        ["figures:5"] = {
            cs = "dimensions of %a are unknown",
            de = "Dimensions of %a are unknown",
            en = "dimensions of %a are unknown",
            fr = "dimensions of %a are unknown",
            it = "dimensions of %a are unknown",
            nl = "maten van %a zijn onbekend",
            ro = "dimensions of %a are unknown",
        },
        ["figures:6"] = {
            cs = "dimenze obrazu %a spocteny programem rlxtools",
            de = "Dimensionen von %a ausgerechnet durch rlxtools",
            en = "dimensions of %a calculated by rlxtools",
            fr = "les dimensions de %a calculées par rlxtools",
            it = "dimensioni di %a calcolate da rlxtools",
            nl = "maten van %a berekend door rlxtools",
            ro = "dimensiunea figurii %a este calculata de rlxtools",
        },
        ["figures:8"] = {
            cs = "obrazovy objekt %a je znovu pouzit",
            de = "Abbildungobjekt %a wurde wiederverwandt",
            en = "figureobject %a is reused",
            fr = "figureobject %a est réutilisé",
            it = "oggetto-figura %a riutilizzato",
            nl = "figuurobject %a wordt opnieuw gebruikt",
            ro = "obiectul figura %a este refolosit",
        },
        ["files:1"] = {
            cs = "synonymum souboru %a je jiz pouzito pro %a",
            de = "Dateisynonym %a wird bereits fuer %a benutzt",
            en = "file synonym %a is already used for %a",
            fr = "le synonyme de fichier %a est déjà utilisé pour %a",
            it = "sinonimo file %a già in uso per %a",
            nl = "file synoniem %a is al in gebruik voor %a",
            no = "filesynonym %a er allerede brukt for %a",
            ro = "sinonimul fisierelor %a este folosit deja pentru %a",
        },
        ["filters:1"] = {
            cs = "filter %a is loaded",
            de = "filter %a ist geladen",
            en = "filter %a is loaded",
            fr = "le filtre %a est chargé",
            it = "filtro %a caricato",
            nl = "filter %a wordt geladen",
        },
        ["filters:2"] = {
            cs = "unknown filter %a",
            de = "unknown filter %a",
            en = "unknown filter %a",
            fr = "filtre %a inconnu",
            it = "filtro sconosciuto %a",
            nl = "onbekend filter %a",
        },
        ["floatblocks:1"] = {
            cs = "%a precislovano / %a => %a",
            de = "%a neu nummeriert / %a => %a",
            en = "%a renumbered / %a => %a",
            fr = "%a renuméroté / %a => %a",
            it = "%a rinumerato / %a => %a",
            nl = "%a hernummerd / %a => %a",
            no = "%a renummerert / %a => %a",
            ro = "%a renumerotat / %a => %a",
        },
        ["floatblocks:10"] = {
            cs = "%a omezeno",
            de = "%a begrenzt",
            en = "%a limited",
            fr = "%a limité",
            it = "%a limitato",
            nl = "%a begrensd",
            no = "%a begrenset",
            ro = "%a limitat",
        },
        ["floatblocks:11"] = {
            cs = "nedan zadny blok",
            de = "kein Block gegeben",
            en = "no block given",
            fr = "pas de bloc donné",
            it = "nessun oggetto specificato",
            nl = "geen blok opgegeven",
            no = "ingen blokk oppgitt",
            ro = "nu este dat nici un bloc",
        },
        ["floatblocks:12"] = {
            cs = "nedefinovano",
            de = "undefiniert",
            en = "undefined",
            fr = "indéfini",
            it = "non definito",
            nl = "niet gedefinieerd",
            no = "udefinert",
            ro = "nedefinit",
        },
        ["floatblocks:13"] = {
            cs = "there is nothing to split",
            de = "there is nothing to split",
            en = "there is nothing to split",
            fr = "there is nothing to split",
            it = "there is nothing to split",
            nl = "er is niets te splitsen",
            no = "there is nothing to split",
            ro = "there is nothing to split",
        },
        ["floatblocks:14"] = {
            en = "float locations will be forced to %a due to exporting",
            nl = "blok plaatsing is altijd %a vanwege export",
        },
        ["floatblocks:15"] = {
            en = "location %a changed to %a due to exporting",
            nl = "plaatsing %a vervangen door %a vanwege export",
        },
        ["floatblocks:16"] = {
            en = "anchor=orange, shift=red, box=green, dummy=blue, line=cyan, depth=magenta, prev=orange",
        },
        ["floatblocks:1"] = {
            en = "%a is empty",
        },
        ["floatblocks:2"] = {
            cs = "%a ulozeno",
            de = "%a gespeichert",
            en = "%a saved",
            fr = "%a sauvegardé",
            it = "%a salvato",
            nl = "%a bewaard",
            no = "%a lagret",
            ro = "%a salvat",
        },
        ["floatblocks:3"] = {
            cs = "%a presunuto",
            de = "%a verschoben",
            en = "%a moved",
            fr = "%a déplacé",
            it = "%a mosso",
            nl = "%a verplaatst",
            no = "%a flyttet",
            ro = "%a mutat",
        },
        ["floatblocks:4"] = {
            cs = "%a umisteno (%s)",
            de = "%a plaziert (%s)",
            en = "%a placed (%s)",
            fr = "%a placé (%s)",
            it = "%a sistemato (%s)",
            nl = "%a geplaatst (%s)",
            no = "%a plassert (%s)",
            ro = "%a plasat (%s)",
        },
        ["floatblocks:5"] = {
            cs = "poradi prizpusobeno",
            de = "Reihenfolge angepasst",
            en = "order adapted",
            fr = "ordre adapté",
            it = "ordine aggiustato",
            nl = "volgorde aangepast",
            no = "rekkefølge tilpasset",
            ro = "ordinea adaptata",
        },
        ["floatblocks:6"] = {
            cs = "pocet hornich plovoucich objektu je omezen na %a",
            de = "Anz. der oberen Gleitobjekte beschraengt auf %a",
            en = "n of top floats limited to %a",
            fr = "n flottants de haut de page limité à %a",
            it = "n di top floats limitato a %a",
            nl = "maximaal %a boven",
            no = "maksimalt %a flytblokker øverst",
            ro = "nr. cadrelor de sus limitat la  %a",
        },
        ["floatblocks:7"] = {
            cs = "pocet spodnich plovoucich objektu je omezen na %a",
            de = "Anz. der unteren Gleitobjekte beschraengt auf  %a",
            en = "n of bottom floats limited to %a",
            fr = "n flottants de bas de page limité à %a",
            it = "n di bottom floats limitato a %a",
            nl = "maximaal %a onder",
            no = "maksimalt %a flytblokker nederst",
            ro = "nr. blocurilor de jos limitat la %a",
        },
        ["floatblocks:8"] = {
            cs = "radku je mene nez %a",
            de = "weniger als %a zeilen",
            en = "less than %a lines",
            fr = "moins de %a lignes",
            it = "meno di %a righe",
            nl = "minder dan %a regels",
            no = "mindre enn %a linjer",
            ro = "mai putin de %a linii",
        },
        ["floatblocks:9"] = {
            cs = "poradi naruseno",
            de = "Reigenfolge gestoert",
            en = "order disturbed",
            fr = "ordre perturbé",
            it = "ordine disturbato",
            nl = "volgorde verstoord",
            no = "rekkefølge endret",
            ro = "ordinea deranjata",
        },
        ["flushed: preamble %a"] = {
            nl = "weggeschreven: preamble %a",
        },
        ["fonts:1"] = {
            cs = "kodovani %a",
            de = "Kodierung %a",
            en = "coding %a",
            fr = "encodage %a",
            it = "codifica %a",
            nl = "codering %a",
            no = "koding %a",
            ro = "codificarea %a",
        },
        ["fonts:10"] = {
            cs = "neznamy font %a",
            de = "unbekanntes Font %a",
            en = "unknown font file %a",
            fr = "fichier de police %a inconnu",
            it = "file di font sconosciuto %a",
            nl = "onbekende font file %a",
            no = "ukjent fontfil %a",
            ro = "fisier font necunoscut %a",
        },
        ["fonts:14"] = {
            cs = "bodyfont %a is defined (can better be done global)",
            de = "Fliesstext %a wurde definiert (besser waere globale Definition)",
            en = "bodyfont %a is defined (can better be done global)",
            fr = "policecorps %a est défini (une définition globale pourrait être plus adéquat)",
            it = "corpo del testo %a definito (sarebbe meglio globale)",
            nl = "korps %a is gedefinieerd (kan beter globaal plaatsvinden)",
            no = "bodyfont %a is defined (can better be done global)",
            ro = "bodyfont %a is defined (can better be done global)",
        },
        ["fonts:2"] = {
            cs = "varianta %a je nactena",
            de = "Variante %a ist geladen",
            en = "variant %a is loaded",
            fr = "la variante %a est chargée",
            it = "variante %a caricata",
            nl = "variant %a wordt geladen",
            no = "variant %a er lest inn",
            ro = "varianta %a este incarcata",
        },
        ["fonts:3"] = {
            cs = "neznama varianta %a",
            de = "Unbekannte Variante %a",
            en = "unknown variant %a",
            fr = "variante %a inconnue",
            it = "variante sconosciuta %a",
            nl = "onbekende variant %a",
            no = "ukjent variant %a",
            ro = "varianta necunoscuta %a",
        },
        ["fonts:4"] = {
            cs = "zakladni font %a neni definovan",
            de = "Fliesstext %a ist nicht definiert",
            en = "bodyfont %a is not defined",
            fr = "policecorps %a n'est pas définie",
            it = "corpo del testo %a non definito",
            nl = "korps %a is niet gedefinieerd",
            no = "hovedfont %a er ikke definert",
            ro = "corpul de litere %a nu este definit",
        },
        ["fonts:5"] = {
            cs = "styl %a neni definovan",
            de = "Stil %a ist nicht definiert",
            en = "style %a is not defined",
            fr = "le style %a n'est pas défini",
            it = "stile %a non definito",
            nl = "stijl %a is niet gedefinieerd",
            no = "stil %a er ikke definert",
            ro = "stilul %a nu este definit",
        },
        ["fonts:6"] = {
            cs = "%a je nacten",
            de = "%a ist geladen",
            en = "%a is loaded",
            fr = "%a est chargé",
            it = "%a caricato",
            nl = "%a wordt geladen",
            no = "%a er lest inn",
            ro = "%a este incarcat",
        },
        ["fonts:7"] = {
            cs = "neznamy format %a",
            de = "unbekanntes Format %a",
            en = "unknown format %a",
            fr = "format %a inconnu",
            it = "formato sconosciuto %a",
            nl = "onbekend formaat %a",
            no = "ukjent format %a",
            ro = "format necunoscut %a",
        },
        ["fonts:8"] = {
            cs = "styl %a definovan",
            de = "Stil %a definiert",
            en = "style %a defined",
            fr = "style %a défini",
            it = "stile %a definito",
            nl = "stijl %a gedefinieerd",
            no = "stil %a definert",
            ro = "stilul %a definit",
        },
        ["interactions:1"] = {
            cs = "pomer %a x %a (s x v)",
            de = "Seitenverhaeltnis %a x %a (B x H)",
            en = "aspect ratio %a x %a (b x h)",
            fr = "ratio d'aspect %a x %a (b x h)",
            it = "rapporto %a x %a (b x a)",
            nl = "aspect ratio %a x %a (b x h)",
            no = "forholdstall %a x %a (b x h)",
            ro = "aspectul %a x %a (b x h)",
        },
        ["interactions:2"] = {
            cs = "aktivni",
            de = "aktiv",
            en = "active",
            fr = "actif",
            it = "attiva",
            nl = "actief",
            no = "aktiv",
            ro = "activ",
        },
        ["interactions:21"] = {
            cs = "%a kod vlozen",
            de = "%a Code eingefuegt",
            en = "%a code inserted",
            fr = "%a code inseré",
            it = "codice %a inserito",
            nl = "%a code tussengevoegd",
            no = "%a kode satt inn / tilføyd",
            ro = "%a cod inserat",
        },
        ["interactions:3"] = {
            cs = "neaktivni",
            de = "inaktiv",
            en = "inactive",
            fr = "inactif",
            it = "inattiva",
            nl = "niet actief",
            no = "inaktiv",
            ro = "inactiv",
        },
        ["interactions:4"] = {
            cs = "zadna strankova synchronizace (%a) v hmode",
            de = "keine Seitensynchronisation (%a) im hmode",
            en = "no pagesynchronisation (%a) in hmode",
            fr = "pas de synchronisation de page (%a) dans le hmode",
            it = "sincronizzazione di pagina (%a) non disponibile in hmode",
            nl = "geen paginasynchronisatie (%a) in hmode",
            no = "ingen sidesynkronisering (%a) i hmode",
            ro = "nu exista sincronizare pt. pagini (%a) in hmode",
        },
        ["interactions:5"] = {
            cs = "unknown attachment %a",
            de = "unknown attachment %a",
            en = "unknown attachment %a",
            fr = "le fichier joint %a est inconnu",
            it = "unknown attachment %a",
            nl = "onbekend attachment %a",
            no = "unknown attachment %a",
            ro = "unknown attachment %a",
        },
        ["interactions:6"] = {
            cs = "attachment file %a does not exist",
            de = "attachment file %a does not exist",
            en = "attachment file %a does not exist",
            fr = "le fichier joint %a n'existe pas",
            it = "attachment file %a does not exist",
            nl = "attachment file %a bestaat niet",
            no = "attachment file %a does not exist",
            ro = "attachment file %a does not exist",
        },
        ["languages:1"] = {
            cs = "vzory %a pro %a nacteny (n=%a,e=%a,m=%a)",
            de = "Trennmuster %a fuer %a geladen (n=%a,e=%a,m=%a)",
            en = "patterns %a for %a loaded (n=%a,e=%a,m=%a)",
            fr = "les motifs %a pour %a sont chargés (n=%a,e=%a,m=%a)",
            it = "schemi %a per %a caricati (n=%a,e=%a,m=%a)",
            nl = "afbreekpatronen %a voor %a geladen (n=%a,e=%a,m=%a)",
            no = "orddelingsmønster %a for %a er lest inn (n=%a,e=%a,m=%a)",
            ro = "sablonul %a pentru %a s-a incarcat (n=%a,e=%a,m=%a)",
        },
        ["languages:10"] = {
            cs = "vzory %a nacteny",
            de = "Trennmuster %a geladen",
            en = "patterns %a loaded",
            fr = "motifs %a chargés",
            it = "schemi %a caricati",
            nl = "patronen %ageladen",
            no = "orddelingsmønster %a er lest inn",
            ro = "sabloanele %a incarcate",
        },
        ["languages:2"] = {
            cs = "zadne vzory %a pro %a (n=%a,e=%a,m=%a) (%a,%a)",
            de = "Keine Trennmuster %a fuer %a (n=%a,e=%a,m=%a) (%a,%a)",
            en = "no patterns %a for %a (n=%a,e=%a,m=%a) (%a,%a)",
            fr = "pas de motifs %a pour %a (n=%a,e=%a,m=%a) (%a,%a)",
            it = "niente schemi %a per %a (n=%a,e=%a,m=%a) (%a,%a)",
            nl = "geen afbreekpatronen %a voor %a (n=%a,e=%a,m=%a) (%a,%a)",
            no = "ingen orddelingsmønster %a for %a (n=%a,e=%a,m=%a) (%a,%a)",
            ro = "nu exista sabloane %a pentru %a (n=%a,e=%a,m=%a) (%a,%a)",
        },
        ["languages:3"] = {
            cs = "deleni slov %a pro %a nacteno (n=%a,e=%a,m=%a)",
            de = "Trenndefinitionen %a fuer %a geladen (n=%a,e=%a,m=%a)",
            en = "hyphenations %a for %a loaded (n=%a,e=%a,m=%a)",
            fr = "hyphenations %a pour %a chargés (n=%a,e=%a,m=%a)",
            it = "sillabazione %a per %a caricata (n=%a,e=%a,m=%a)",
            nl = "afbreekdefinities %a voor %a geladen (n=%a,e=%a,m=%a)",
            no = "orddelingsdefinisjon %a for %a er lest inn (n=%a,e=%a,m=%a)",
            ro = "despartirea in silabe %a pentru %a s-a incarcat (n=%a,e=%a,m=%a)",
        },
        ["languages:4"] = {
            cs = "zadne deleni slov %a pro %a (n=%a,e=%a,m=%a)",
            de = "Keine Trenndefinitionen %a fuer %a (n=%a,e=%a,m=%a)",
            en = "no hyphenations %a for %a (n=%a,e=%a,m=%a)",
            fr = "pas d'hyphenations %a pour %a (n=%a,e=%a,m=%a)",
            it = "niente sillabazione %a per %a (n=%a,e=%a,m=%a)",
            nl = "geen afbreekdefinities %a voor %a (n=%a,e=%a,m=%a)",
            no = "ingen orddelingsdefinisjon %a for %a (n=%a,e=%a,m=%a)",
            ro = "nu exista despartire in silabe %a pentru %a (n=%a,e=%a,m=%a)",
        },
        ["languages:5"] = {
            cs = "vzory pro %a nenacteny",
            de = "Trennmuster fuer %a nicht geladen",
            en = "patterns for %a not loaded",
            fr = "les motifs pour %a ne sont pas chargés",
            it = "schemi per %a non caricati",
            nl = "afbreekpatronen voor %a niet geladen",
            no = "orddelingsmønster for %a er ikke lest inn",
            ro = "sabloanele pentru %a nu sunt incarcate",
        },
        ["languages:6"] = {
            cs = "jazyk %a neni definovan",
            de = "Sprache %a ist undefiniert",
            en = "language %a is undefined",
            fr = "langue %a non définie",
            it = "lingua %a non definita",
            nl = "taal %a is niet gedefinieerd",
            no = "spràk %a er udefinert",
            ro = "limba %a nu este definita",
        },
        ["languages:7"] = {
            cs = "specificke volby jazyka [%a] zavadeji %a (zavlecenou) mezeru",
            de = "Sprachenspezifische Option [%a] fuegt eine Luecke von %a ein",
            en = "language specific options [%a] introduce a %a skip",
            fr = "les options spécifiques de langue [%a] introduisent un %a saut",
            it = "opzioni specifiche per la lingua [%a] introducono un salto %a",
            nl = "taal specifieke opties [%a] introduceren een skip van %a",
            no = "spràk spesifikk opsjon [%a] introduserer et %a hopp",
            ro = "optiunile specifice ale limbii [%a] introduc un spatiu %a",
        },
        ["languages:8"] = {
            cs = "specificke volby jazyka [%a] bez mezer pripojeny",
            de = "Sprachenspezifische Option [%a] nahtlos hinzugefuegt",
            en = "language specific options [%a] seamless appended",
            fr = "les options spécifiques de langue [%a] sont ajoutés en douceur",
            it = "opzioni specifiche per la lingua [%a] aggiunte trasparentemente",
            nl = "taal specifieke opties [%a] naadloos toegevoegd",
            no = "spràk spesifikk opsjon [%a] problemfritt tilføyd",
            ro = "optiunile specifice ale limbii [%a] adaugate",
        },
        ["languages:9"] = {
            cs = "language %a is active",
            de = "Sprache %a ist aktiv",
            en = "language %a is active",
            fr = "la langue %a est active",
            it = "lingua %a attiva",
            nl = "taal %a is actief",
            no = "spràk %a er aktivt",
            ro = "limba %a este activa",
        },
        ["layouts:1"] = {
            cs = "vyska textu prizpusobena s %a na strane %a",
            de = "Texthoehe angepasst mit %a auf Seite %a",
            en = "textheight adapted with %a at page %a",
            fr = "hauteurtexte adaptée avec %a à la page %a",
            it = "altezza del testo adattata con %a a pagina %a",
            nl = "teksthoogte aangepast met %a op pagina %a",
            no = "teksthøyde tilpasset med %a på side %a",
            ro = "textheight adaptat cu %a la pagina %a",
        },
        ["layouts:10"] = {
            cs = "%a a %a nedava dohromady 1.0",
            de = "%a und %a ergeben zusammen nicht 1.0",
            en = "%a and %a don't add up to 1.0",
            fr = "%a et %a ne sont pas ajoutés à 1.0",
            it = "%a e %a non sommano a 1.0",
            nl = "%a en %a tellen niet op tot 1.0",
            no = "%a og %a er ikke 1.0 til sammen",
            ro = "%a si %a nu se adauga pana la 1.0",
        },
        ["layouts:11"] = {
            cs = "svisla mezera %a neni povolena v pevnem radkovem rejstriku",
            de = "Zwischenraum %a nicht im Grittermoduserlau",
            en = "spacing %a not permitted in gridmode",
            fr = "espacement %a non permis en modegrille",
            it = "spaziatura %a non permessa in modo griglia",
            nl = "interlinie %a niet toegestaan in gridmode",
            no = "mellomrom %a ikke tillatt i gridmodus",
            ro = "spatierea %a nu este permisa in gridmode",
        },
        ["layouts:2"] = {
            cs = "%a krat odlozeny text umisten",
            de = "%a mal verschobener Text plaziert",
            en = "%a times postponed text placed",
            fr = "%a times postponed text placed",
            it = "posizionato testo posticipato %a volte",
            nl = "%a maal uitgestelde tekst tussengevoegd",
            no = "%a ganger forskjøvet tekst plassert",
            ro = "textul amanat de %a ori a fost plasat",
        },
        ["layouts:3"] = {
            cs = "%a krat text odlozen",
            de = "%a mal Text verschoben",
            en = "%a times text postponed",
            fr = "%a times text postponed",
            it = "testo posticipato %a volte",
            nl = "%a maal tekst plaatsen uitstellen",
            no = "%a ganger tekst forskjøvet",
            ro = "textul amanat de %a ori",
        },
        ["layouts:4"] = {
            cs = "okrajove bloky aktivni",
            de = "marginalbloecke aktiv",
            en = "marginblocks active",
            fr = "blocsmarge actifs",
            it = "blocchi in margine attivi",
            nl = "margeblokken actief",
            no = "margblokker aktive",
            ro = "blocuri marginale active",
        },
        ["layouts:5"] = {
            cs = "okrajove bloky neaktivni",
            de = "marginalbloecke inaktiv",
            en = "marginblocks inactive",
            fr = "blocsmarge inactifs",
            it = "blocchi in margine inattivi",
            nl = "margeblokken inactief",
            no = "margblokker inaktive",
            ro = "blocuri marginale inactive",
        },
        ["layouts:6"] = {
            cs = "sada stran %a zpracovana (velikost %a)",
            de = "Unterseitenfolge %a verarbeitet (Groesse %a)",
            en = "subpage set %a processed (size %a)",
            fr = "jeu de souspage %a traité (taille %a)",
            it = "gruppo di sottopagine %a elaborato (dimensione %a)",
            nl = "subpagina reeks %a verwerkt (aantal %a)",
            no = "delside sett %a behandlet (størrelse %a)",
            ro = "setul %a de subpagini procesat (dimensiunea %a)",
        },
        ["layouts:7"] = {
            cs = "pocita se misto pro logo",
            de = "berechne Platzbedarf des Logos",
            en = "calculating logospace",
            fr = "calcul de l'espace pour le logo",
            it = "calcolo dello spazio per logo",
            nl = "beeldmerken berekenen",
            no = "beregner plass for logo",
            ro = "se calculeaza spatiul pentru logo",
        },
        ["layouts:8"] = {
            cs = "pocita se pozadi",
            de = "berechne Hintergrund",
            en = "calculating backgrounds",
            fr = "calcul des arrières-plans",
            it = "calcolo dello sfondo",
            nl = "achtergronden berekenen",
            no = "beregner bakgrunn",
            ro = "se calculeaza fundalurile",
        },
        ["layouts:9"] = {
            cs = "aktualne ne vice nez %a urovne/urovni vyctu",
            de = "z.Z. nicht mehr als %a Ebenen in Aufzaehlungen",
            en = "currently no more than %a levels in itemizations",
            fr = "pas plus de %a niveaux pour l'instant dans les élémentarisations",
            it = "attualmente non più di %a livelli di elencazione",
            nl = "momenteel maximaal %a niveaus in opsommingen",
            no = "for øyeblikket maksimalt %a nivåer i opplisting",
            ro = "acum nu se supota mai mult de %a nivele de adancime la iteratii",
        },
        ["loaded: %a"] = {
            nl = "geladen: %a",
        },
        ["loaded: library %a"] = {
            nl = "geladen: bibliotheek %a",
        },
        ["loading: %a"] = {
            nl = "laden: %a",
        },
        ["locating: %a"] = {
            nl = "zoeken: %a",
        },
        ["not found: %a"] = {
            nl = "niet gevonden: %a",
        },
        ["number 1: %a, number 2: %a"] = {
            en = "number 1: (%a), number 2: (%a)",
            nl = "nummer 1: (%a), nummer 2: (%a)",
        },
        ["popping level: %a"] = {
            nl = "niveau omlaag: %a",
        },
        ["publications:1"] = {
            en = "file %a not found, unknown style ignored",
        },
        ["publications:2"] = {
            en = "file %a not found, waiting for bibtex",
        },
        ["publications:3"] = {
            en = "wrote a new auxiliary file %a",
        },
        ["publications:4"] = {
            en = "loading database from %a",
        },
        ["publications:5"] = {
            en = "warning: unknown cite argument %a on line %a",
        },
        ["publications:6"] = {
            en = "loading formatting style from %a",
        },
        ["publications:7"] = {
            en = "placing all entries, use 'text' to be more selective",
        },
        ["publications:10"] = {
            en = "unknown command %a, using built-in context variant %a",
        },
        ["publications:11"] = {
            en = "unknown command %a",
        },
        ["publications:12"] = {
            en = "missing setup: %s",
        },
        ["publications:13"] = {
            en = "no field %a for tag %a in dataset %a",
        },
        ["publications:14"] = {
            en = "unknown rendering alternative %a",
        },
        ["pushing level: %a"] = {
            nl = "niveau omhoog: %a",
        },
        ["references:1"] = {
            cs = "neznama reference %a",
            de = "unbekannte Referenz %a",
            en = "unknown reference %a",
            fr = "réference %a inconnue",
            it = "riferimento sconosciuto %a",
            nl = "onbekende verwijzing %a",
            no = "ukjent referanse %a",
            ro = "referinta necunoscuta %a",
        },
        ["references:2"] = {
            cs = "duplicitni reference %a na strane %a",
            de = "doppelte Referenz %a auf Seite %a",
            en = "duplicate reference %a on page %a",
            fr = "réference %a dupliquée à la page %a",
            it = "riferimento duplicato %a a pagina %a",
            nl = "dubbele verwijzing %a op pagina %a",
            no = "duplikat referanse %a pø side %a",
            ro = "referinta duplicat %a la pagina %a",
        },
        ["references:21"] = {
            cs = "dokument %a nacten",
            de = "Dokument %a geladen",
            en = "document %a loaded",
            fr = "document %a chargé",
            it = "documento %a caricato",
            nl = "document %a geladen",
            no = "dokument %a er lest inn",
            ro = "documentul %a este incarcat",
        },
        ["references:22"] = {
            cs = "dokument %a neni interaktivni",
            de = "Dokument %a ist nicht aktiv",
            en = "document %a is not interactive",
            fr = "le document %a n'est pas interactif",
            it = "il documento %a non ø interattivo",
            nl = "document %a is niet interactief",
            no = "dokument %a er ikke interaktivt",
            ro = "documentul %a nu este interactiv",
        },
        ["references:23"] = {
            cs = "obskurni (nejasna) reference %a (prefix=%a)",
            de = "Obskure Referenz %a (Prefix=%a)",
            en = "obscure reference %a (prefix=%a)",
            fr = "reference %a indéterminé (préfixe=%a)",
            it = "riferimento ambiguo %a (prefisso=%a)",
            nl = "onduidelijke verwijzing %a (prefix=%a)",
            no = "obskur referanse %a (Prefix=%a)",
            ro = "referinta obscura %a (prefix=%a)",
        },
        ["references:24"] = {
            en = "references from document %a are not exported",
        },
        ["references:25"] = {
            en = "references from document %a are not imported (export again)",
        },
        ["references:26"] = {
            en = "references from document %a are imported",
        },
        ["references:3"] = {
            cs = "neznamy typ reference %a",
            de = "unbekannte Referenz Typ %a",
            en = "unknown reference type %a",
            fr = "type %a de réference inconnu",
            it = "riferimento di tipo sconosciuto %a",
            nl = "type verwijzing %a onbekend",
            no = "ukjent referansetype %a",
            ro = "tip necunoscut de referinta %a",
        },
        ["references:30"] = {
            cs = "neznamy objekt %a",
            de = "unbekanntes Object %a",
            en = "unknown object %a",
            fr = "objet %a inconnu",
            it = "oggetto sconosciuto %a",
            nl = "onbekend object %a",
            no = "ukjent objekt %a",
            ro = "obiect necunoscut %a",
        },
        ["references:31"] = {
            cs = "duplicitni object %a",
            de = "doppeltes Object %a",
            en = "duplicate object %a",
            fr = "objet %a dupliqué",
            it = "oggetto duplicato %a",
            nl = "dubbel object %a",
            no = "duplikat objekt %a",
            ro = "obiect duplicat %a",
        },
        ["references:4"] = {
            cs = "nedovolena reference %a",
            de = "illegale Referenz %a",
            en = "illegal reference %a",
            fr = "réference %a inconnue",
            it = "riferimento illecito %a",
            nl = "verboden verwijzing %a",
            no = "ulovlig referanse %a",
            ro = "referinta eronata %a",
        },
     -- ["number of unknown references: %a"] = {
     -- },
        ["references:6"] = {
            en = "number of illegal references: %a",
        },
        ["start: %a"] = {
        },
        ["stop: %a"] = {
        },
        ["stored: preamble %a, state %a, order %a"] = {
            nl = "opgeslagen: preamble %a, status %a, volgorde %a",
        },
        ["structures:1"] = {
            cs = "zacatek oddilu (sekce) %a",
            de = "Begin des Abschnittsblocks %a",
            en = "begin of sectionblock %a",
            fr = "début de blocsection %a",
            it = "inizio del blocco (sezione) %a",
            nl = "begin van sectieblok %a",
            no = "starten av blokk %a (seksjon)",
            ro = "inceput de bloc sectiune %a",
        },
        ["structures:2"] = {
            cs = "konec oddilu (sekce) %a",
            de = "Ende des Abschnittsblocks %a",
            en = "end of sectionblock %a",
            fr = "fin de blocsection %a",
            it = "fine del blocco (sezione) %a",
            nl = "eind van sectieblok %a",
            no = "slutten av blokk %a (seksjon)",
            ro = "sfarsit de bloc sectiune %a",
        },
        ["symbols:1"] = {
            cs = "nacita se soubor symbolu %a",
            de = "Lade Symboldatei %a",
            en = "loading symbolset %a",
            fr = "chargement du jeu de symbole %a",
            it = "caricamento gruppo di simboli %a",
            nl = "symboolset %a wordt geladen",
            no = "leser inn symbolsett %a",
            ro = "se incarca setul de simboluri %a",
        },
        ["system:1"] = {
            cs = "nacteni pomocneho souboru odlozeno (typemode)",
            de = "Laden der Hilfsdatei aufgeschoben (Eingabe-Modus)",
            en = "loading utility-file postponed (typemode)",
            fr = "chargement de fichier utilitaire reporté (typemode)",
            it = "caricamento dei file supplementari posticipato (typemode)",
            nl = "laden hulpfile uitgesteld (typemode)",
            no = "innlesning av hjelpefila utsatt (typemode)",
            ro = "se incarca utilitarul-fisierul este amanat (typemode)",
        },
        ["system:10"] = {
            cs = "nepouzivejte em v %a",
            de = "Benutzte kein em in %a",
            en = "don't use em in %a",
            fr = "n'utilisez pas em dans %a",
            it = "non usare em in %a",
            nl = "gebruik geen em in %a",
            no = "ikke bruk em i %a",
            ro = "nu folositi em in %a",
        },
        ["system:11"] = {
            cs = "vytvarim jednoduchy pomocny soubor",
            de = "Erstelle einfache Hilfdatei",
            en = "building simple util",
            fr = "construction util simple",
            it = "costruzione di un semplice supplemento",
            nl = "aanmaken basale hulpfile",
            no = "lager enkel hjelpefil",
            ro = "se creeaza un utilitar simplu",
        },
        ["system:12"] = {
            cs = "pomosny soubor neni setriden, pouzijte texutil",
            de = "Die Hilfdatei ist nicht sortiert, verwende texutil",
            en = "the utility-file is not sorted, use texutil",
            fr = "le fichier utilitaire n'est pas trié, utilise texutil",
            it = "file di supplemento non ordinato, usare texutil",
            nl = "de hulpfile is niet gesorteerd, gebruik texutil",
            no = "hjelpefila er ikke sortert, bruk texutil",
            ro = "fisierul utilitar nu este sortat, folositi texutil",
        },
        ["system:13"] = {
            cs = "znacka %a definovana %a",
            de = "Beschriftung %a definiert %a",
            en = "mark %a defined %a",
            fr = "marquage %a defini %a",
            it = "marcatura %a definita %a",
            nl = "markering %a gedefinieerd %a",
            no = "markering %a definert %a",
            ro = "marcajul %a definit %a",
        },
        ["system:14"] = {
            cs = "vynucena nova stranka v seznamu na %a",
            de = "Erzwungendes Seitenumbruch in Liste bei %a",
            en = "forced newpage in list at %a",
            fr = "nouvellepage forcée dans la liste à %a",
            it = "nuova pagina obbligata in lista a %a",
            nl = "geforceerde paginaovergang in lijst voor %a",
            no = "tvunget sideskift i liste ved %a",
            ro = "s-a fortat trecere pa pagina noua in lista la %a",
        },
        ["system:15"] = {
            cs = "uklada se buffer %a",
            de = "Speichere Buffer %a",
            en = "saving buffer %a",
            fr = "sauvegarde du tampon (buffer) %a",
            it = "salvataggio del buffer %a",
            nl = "wegschrijven buffer %a",
            no = "lagrer Buffer %a",
            ro = "buffer salvat %a",
        },
        ["system:16"] = {
            cs = "sazi se buffer %a",
            de = "Setzte Buffer %a",
            en = "typesetting buffer %a",
            fr = "composition du tampon (buffer) %a",
            it = "composizione del buffer %a",
            nl = "inlezen buffer %a",
            no = "tegnsetter buffer %a",
            ro = "buffer-ul %a s-a cules",
        },
        ["system:17"] = {
            cs = "sazi se doslovny (verbatim) buffer %a",
            de = "Setzte tippen-Buffer %a",
            en = "typesetting verbatim buffer %a",
            fr = "composition textuelle du tampon (buffer) %a",
            it = "composizione verbatim del buffer %a",
            nl = "verbatim inlezen buffer %a",
            no = "tegnsetter verbatim-buffer %a",
            ro = "se culege buffer-ul verbatim %a",
        },
        ["system:18"] = {
            cs = "synonymum %a %a neexistuje",
            de = "Synonym %a %a existiert nicht",
            en = "synonym %a %a does not exist",
            fr = "le synonyme %a %a n'existe pas",
            it = "sinonimo %a %a non esistente",
            nl = "synoniem %a %a bestaat niet",
            no = "synonym %a %a eksisterer ikke",
            ro = "sinonimul %a %a nu exista",
        },
        ["system:19"] = {
            cs = "vyznam (synonyma) %a nacten",
            de = "Bedeutung (synonyme) von %a geladen",
            en = "meaning (synonyms) of %a loaded",
            fr = "signification (synonymes) de %a chargée",
            it = "significato (sinonimi) di %a caricato",
            nl = "betekenissen (synoniemen) van %a geladen",
            no = "betydning (synonymer) av %a er lest inn",
            ro = "intelesul (sinonimele) pentru %a incarcat",
        },
        ["system:2"] = {
            cs = "%a nacteno",
            de = "%a geladen",
            en = "%a loaded",
            fr = "%a chargé",
            it = "%a caricato",
            nl = "%a geladen",
            no = "%a er lest inn",
            ro = "%a s-a incarcat",
        },
        ["system:20"] = {
            cs = "vyznam (trideni) %a nacten",
            de = "Bedeutung (sortieren) von %a geladen",
            en = "meaning (sorts) of %a loaded",
            fr = "signification (tris) de %a chargée",
            it = "significato (specie) di %a caricato",
            nl = "betekenissen (sorteren) van %a geladen",
            no = "betydning (sorterer) av %a er lest inn",
            ro = "intelesul (ordinea) pentru %a incarcat",
        },
        ["system:21"] = {
            cs = "pomocny soubor necten",
            de = "Die Hilfsdatei ist nicht geladen",
            en = "no utility data is loaded",
            fr = "pas de données utilitaires chargées",
            it = "nessuna informazione supplementare caricata",
            nl = "de hulpfile is niet geladen",
            no = "hjelpefila er ikke lest inn",
            ro = "nici o data utilitara nu este incarcata",
        },
        ["system:22"] = {
            cs = "pouzijte platny pomocny soubor",
            de = "Benoetige gueltige Hilfsdateie",
            en = "use a valid utilityfile",
            fr = "utilise un fichier utilitaire valide",
            it = "usare un file supplementare valido",
            nl = "gebruik een goede hulpfile",
            no = "bruk en gyldig hjelpefil",
            ro = "folositi un fisier utilitar valid",
        },
        ["system:23"] = {
            cs = "%a upraveno na %a",
            de = "%a angeordnet auf %a",
            en = "%a arranged at %a",
            fr = "%a arrangé à %a",
            it = "%a sistemato a %a",
            nl = "%a gearrangeerd op %a",
            no = "%a arrangert på %a",
            ro = "%a aranjat la %a",
        },
        ["system:24"] = {
            cs = "plovouci bloky",
            de = "Fliessbloecke",
            en = "Floatblocks",
            fr = "blocsflottants",
            it = "Oggetti mobili",
            nl = "Plaatsblokken",
            no = "Flytblokker",
            ro = "Blocuri",
        },
        ["system:25"] = {
            cs = "reference",
            de = "Referenzen",
            en = "References",
            fr = "Réferences",
            it = "Riferimenti",
            nl = "Verwijzingen",
            no = "Referanser",
            ro = "Referinte",
        },
        ["system:26"] = {
            cs = "registry",
            de = "Register",
            en = "Registers",
            fr = "Registres",
            it = "Registri",
            nl = "Registers",
            no = "Registere",
            ro = "Registri",
        },
        ["system:27"] = {
            cs = "verze",
            de = "Version",
            en = "Version",
            fr = "Version",
            it = "Versione",
            nl = "Versie",
            no = "Versjon",
            ro = "Versiune",
        },
        ["system:4"] = {
            cs = "prikaz %a je jiz definovan",
            de = "Befehl %a ist bereits definiert",
            en = "command %a is already defined",
            fr = "la commande %a est déjà définie",
            it = "comando %a già definito",
            nl = "commando %a is al gedefinieerd",
            no = "kommando %a er allerede definert",
            ro = "comanda %a este deja definita",
        },
        ["system:41"] = {
            cs = "externi soubor %a ve skupine %a neexistuje",
            de = "Externe Datei %a in Gruppe %a existiert nicht",
            en = "external file %a in group %a does not exist",
            fr = "le fichier externe %a du groupe %a n'existe pas",
            it = "il file esterno %a del gruppo %a non esiste",
            nl = "externe file %a in groep %a bestaat niet",
            no = "ekstern fil %a i gruppe %a eksisterer ikke",
            ro = "fisierul extern %a din grupul %a nu exista",
        },
        ["system:5"] = {
            cs = "makra z %a nactena",
            de = "Modul %a geladen",
            en = "module %a loaded",
            fr = "module %a chargé",
            it = "macro del modulo %a caricate",
            nl = "module %a geladen",
            no = "makroene i modul  %a er lest inn",
            ro = "macro-urile din modulul %a s-au incarcat",
        },
        ["system:6"] = {
            cs = "zadna makra v %a nenalezena",
            de = "Modul %a gefunden",
            en = "module %a not found",
            fr = "module %a non trouvé",
            it = "nessuna macro trovata nel modulo %a",
            nl = "geen module %a gevonden",
            no = "ingen makroer funnet i modul %a-",
            ro = "nu s-au gasit macro-uri in modulul %a",
        },
        ["system:7"] = {
            cs = "makra z %a jsou jiz nactena",
            de = "Modul %a bereits geladen",
            en = "module %a already loaded",
            fr = "module %a déjà chargé",
            it = "macro del modulo %a già caricate",
            nl = "module %a reeds geladen",
            no = "makroene i modul %a er allerede lest inn",
            ro = "macro-urile din modulul %a s-au incarcat deja",
        },
        ["system:8"] = {
            cs = "nova verze pomocneho souboru, je treba druheho behu",
            de = "Neue Version der Hilfsdatei, zweiter Durchlauf benoetigt",
            en = "new version of utility file, second pass needed",
            fr = "nouvelle version de fichier utilitaire, seconde passe nécessaire",
            it = "nuova versione del file supplementare, seconda passata necessaria",
            nl = "nieuwe versie hulpfile, tweede run nodig",
            no = "ny versjon av hjelpefil, andre gjennomkjøring nødvendig",
            ro = "o noua versiune de fisier utilitar, este necesara o noua trecere",
        },
        ["system:9"] = {
            cs = "%a nenalezeno/nezpracovano",
            de = "%a nicht gefunden/verarbeitet",
            en = "%a not found/processed",
            fr = "%a non trouvé/traité",
            it = "%a non trovato/elaborato",
            nl = "%a niet gevonden/geplaatst",
            no = "%a ikke funnet/behandlet",
            ro = "%a nu este gasit/procesat",
        },
        ["system:91"] = {
            en = "papertray %a",
            nl = "papierlade %a",
        },
        ["textblocks:1"] = {
            cs = "nova verze, je treba druhy beh",
            de = "neue Version, zweiter Durchlauf benoetigt",
            en = "new version, second pass needed",
            fr = "nouvelle version, une seconde passe est nécessaire",
            it = "nuova versione, seconda passata necessaria",
            nl = "nieuwe versie, tweede run nodig",
            no = "ny versjon, andre gjennomkjøring nødvendig",
            ro = "o noua versiune, este nevoie de inca o trecere",
        },
        ["textblocks:10"] = {
            cs = "%a nacteno a zpracovano",
            de = "%a geladen und verarbeitet",
            en = "%a loaded and processed",
            fr = "%a chargé et traité",
            it = "%a caricato ed elaborato",
            nl = "%a geladen en verwerkt",
            no = "%a lest inn og behandlet",
            ro = "%a incarcat si procesat",
        },
        ["textblocks:11"] = {
            cs = "%a nacteno a vysazeno",
            de = "%a geladen und gesetzt",
            en = "%a loaded and typeset",
            fr = "%a chargé et composé",
            it = "%a caricato e composto",
            nl = "%a geladen en geplaatst",
            no = "%a lest inn og tegnsatt",
            ro = "%a incarcat si cules",
        },
        ["textblocks:12"] = {
            cs = "%a preskoceno",
            de = "%a ausgelassen",
            en = "%a skipped",
            fr = "%a sauté",
            it = "%a saltato",
            nl = "%a overgeslagen",
            no = "%a utelatt",
            ro = "%a sarit peste",
        },
        ["textblocks:2"] = {
            cs = "zapisuji bloky do %a",
            de = "schreibe Bloecke zu %a",
            en = "writing blocks to %a",
            fr = "ecriture des blocs vers %a",
            it = "scrittura dei blocchi su %a",
            nl = "wegschrijven blokken naar %a",
            no = "skriver blokker til %a",
            ro = "se scriu blocurile in %a",
        },
        ["textblocks:3"] = {
            cs = "ctu bloky z %a",
            de = "lese Bloecke von %a",
            en = "reading blocks from %a",
            fr = "lecture des blocs en provenance de %a",
            it = "lettura dei blocchi da %a",
            nl = "inlezen blokken uit %a",
            no = "leser blokker fra %a",
            ro = "se citesc blocurile din %a",
        },
        ["textblocks:4"] = {
            cs = "je treba druhy beh",
            de = "zweiter Durchlauf benoetigt",
            en = "second pass needed",
            fr = "seconde passe nécessaire",
            it = "seconda passata necessaria",
            nl = "er is een tweede run nodig",
            no = "andre gjennomkjøring nødvendig",
            ro = "este nevoie de inca o trecere",
        },
        ["textblocks:5"] = {
            cs = "%a neni skryto",
            de = "%a nicht verborgen",
            en = "%a not hidden",
            fr = "%a non caché",
            it = "%a non nascosto",
            nl = "%a niet verborgen",
            no = "%a ikke skjult",
            ro = "%a nu este ascuns",
        },
        ["textblocks:6"] = {
            cs = "%a skryto a zpracovano",
            de = "%a verborgen und verarbeitet",
            en = "%a hidden and processed",
            fr = "%a caché et traité",
            it = "%a nascosto ed elaborato",
            nl = "%a verborgen en verwerkt",
            no = "%a skjult og behandlet",
            ro = "%a ascuns si procesat",
        },
        ["textblocks:7"] = {
            cs = "%a skryto",
            de = "%a verborgen",
            en = "%a hidden",
            fr = "%a caché",
            it = "%a nascosto",
            nl = "%a verborgen",
            no = "%a skjult",
            ro = "%a ascuns",
        },
        ["textblocks:8"] = {
            cs = "%a vysazeno",
            de = "%a gesetzt",
            en = "%a typeset",
            fr = "%a composé",
            it = "%a composto",
            nl = "%a gehandhaafd",
            no = "%a tegnsatt",
            ro = "%a cules",
        },
        ["textblocks:9"] = {
            cs = "%a nevysazeno",
            de = "%a nicht gesetzt",
            en = "%a not typeset",
            fr = "%a non composé",
            it = "%a non composto",
            nl = "%a niet gehandhaafd",
            no = "%a ikke tegnsatt",
            ro = "%a nu este cules",
        },
        ["unknown: library %a"] = {
            nl = "onbekend: bibliotheek %a",
        },
        ["used: code %a"] = {
            nl = "gebruikt: code %a",
        },
        ["used: code %a, preamble %a"] = {
            nl = "gebruikt: code %a, preamble %a",
        },
        ["used: function %a"] = {
            nl = "gebruikt: functie %a",
        },
        ["used: preamble %a, state %a, order %a"] = {
            nl = "gebruikt: preamble %a, status %a, volgorde %a",
        },
        ["vector %a is loaded"] = {
            nl = "vector %a is geladen",
        },
        ["vector %a is unknown"] = {
            nl = "onbekende vector %a",
        },
        ["verbatims:1"] = {
            cs = "soubor %a neexistuje",
            de = "Datei %a existiert nicht",
            en = "file %a does not exist",
            fr = "le fichier %a n'existe pas",
            it = "il file %a non esiste",
            nl = "file %a bestaat niet",
            no = "fil %a eksisterer ikke",
            ro = "fisierul %a nu exista",
        },
    },
    translations = {
        check = {
            cs = "kontrola",
            de = "check",
            en = "check",
            fr = "vérification",
            it = "controllo",
            nl = "controle",
            no = "kontroll",
            ro = "verificari",
        },
        colors = {
            cs = "barva",
            de = "farbe",
            en = "colors",
            fr = "couleurs",
            it = "colore",
            nl = "kleuren",
            no = "farge",
            ro = "culori",
        },
        columns = {
            cs = "sloupce",
            de = "Spalten",
            en = "columns",
            fr = "colonnes",
            it = "colonne",
            nl = "kolommen",
            no = "kolonner",
            ro = "coloane",
        },
        databases = {
            cs = "databases",
            de = "Datenbank",
            en = "databases",
            fr = "bases de données",
            it = "database",
            nl = "database",
            no = "databaser",
            ro = "baze de date",
        },
        figures = {
            cs = "obrazy",
            de = "Abbildungen",
            en = "figures",
            fr = "figures",
            it = "figure",
            nl = "figuren",
            ro = "figuri",
        },
        files = {
            cs = "soubory",
            de = "files",
            en = "files",
            fr = "fichiers",
            it = "file",
            nl = "files",
            no = "filer",
            ro = "fisiere",
        },
        filters = {
            cs = "filters",
            de = "filters",
            en = "filters",
            fr = "filtre",
            it = "filtri",
            nl = "filters",
        },
        floatblocks = {
            cs = "plovouciobjekty",
            de = "Gleitobjektbloecke",
            en = "floatblocks",
            fr = "blocs de flottants",
            it = "oggetti mobili",
            nl = "plaatsblokken",
            no = "flytblokker",
            ro = "Blocuri",
        },
        fonts = {
            cs = "zakladnifont",
            de = "Fliesstext",
            en = "bodyfont",
            fr = "corps de texte",
            it = "font del corpo",
            nl = "korps",
            no = "hovedfont",
            ro = "corp de litere",
        },
        interactions = {
            cs = "interakce",
            de = "Interaktions",
            en = "interactions",
            fr = "interactions",
            it = "interazione",
            nl = "interacties",
            no = "interaksjon",
            ro = "interactiuni",
        },
        languages = {
            cs = "jazyky",
            de = "Sprache",
            en = "languages",
            fr = "langue",
            it = "lingua",
            nl = "talen",
            no = "sprøk",
            ro = "limbi",
        },
        layouts = {
            cs = "layouts",
            de = "Layouts",
            en = "layouts",
            fr = "calque",
            it = "layouts",
            nl = "layouts",
            no = "layouts",
            ro = "aranjamente",
        },
        numbers = {
            nl = "nummers",
        },
        publications = {
            en = "publications",
        },
        references = {
            cs = "reference",
            de = "referenzen",
            en = "references",
            fr = "réferences",
            it = "riferimenti",
            nl = "verwijzingen",
            no = "referanser",
            ro = "referinte",
        },
        regimes = {
            de = "Kodierungen",
            fr = "encodages",
            nl = "regimes",
        },
        structures = {
            cs = "struktury",
            de = "strukture",
            en = "structures",
            fr = "structures",
            it = "struttura",
            nl = "structuren",
            no = "struktur",
            ro = "structuri",
        },
        symbols = {
            cs = "symboly",
            de = "Symbole",
            en = "symbols",
            fr = "symboles",
            it = "simboli",
            nl = "symbolen",
            no = "symboler",
            ro = "simboluri",
        },
        system = {
            cs = "system",
            de = "system",
            en = "system",
            fr = "système",
            it = "sistema",
            nl = "systeem",
            no = "system",
            ro = "sistem",
        },
        textblocks = {
            cs = "textovyblok",
            de = "textblock",
            en = "textblocks",
            fr = "blocs de texte",
            it = "blocchi di testo",
            nl = "tekstblokken",
            no = "tekstblokker",
            ro = "blocuri de text",
        },
        verbatims = {
            cs = "verbatim",
            de = "verbatim",
            en = "verbatim",
            fr = "verbatim",
            it = "verbatim",
            nl = "typen",
            no = "verbatim",
            ro = "verbatim",
        },
    },
}
