#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Tags/Manage.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2021-07-30 19:52:52 +0300 (Fri, 30 Jul 2021) $ 
#$Revision: 8840 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v3.4.0/tests/shtests/has_unknown_value_003.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Tags::Manage::has_unknown_value() subroutine.
#* Tests the way the subroutine behaves when the 'types' hash entry for
#* the data item is undefined.
#**
use strict;
use warnings;

use COD::CIF::Tags::Manage;
use COD::Serialise qw( serialiseRef );

my $data_block =
{
  'tags'   => [ '_value' ],
  'loops'  => [ ],
  'inloop' => {},
  'values' => { '_value' => [ '?' ] },
  'precisions' => {},
  'types' => {},
};

my $data_name   = '_value';

my $unknown = COD::CIF::Tags::Manage::has_unknown_value(
                $data_block,
                $data_name,
                0 );

print "Value is " .($unknown ? 'unknown' : 'known') . ".\n";

END_SCRIPT
