/****************************************************************************
 *    lib/c/Types.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef TYPES_H
#define TYPES_H

#include <string>
#include <vector>
#include <stdexcept>
#include <algorithm>

#include "Type.h"
#include "Constraint.h"

namespace C {


class Types
{
public:
	Types();
	Types(Type*);
	Types(Constraint*);
	
	virtual ~Types ( );
	
	set<Variable*>* getVariables();
	void addType(Type*);
	void addType(Constraint*);

	string getAsString(Printer*, set<Variable*>*, int);
	void print(Printer* p, set<Variable*>* vars, int line);
	bool printTypes(Printer*, set<Variable*>*, vector<Type*>*);
	void printConstraints(Printer*, set<Variable*>*, vector<Constraint*>*, bool);
	void check(set<Variable*>* vars, int line);

private:
	vector<Type*> types_;
	vector<Constraint*> constraints_;
	
};
}; // end of package namespace

#endif // TYPES_H
