package charactermanaj.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class CustomLayerOrder {

	public static final String CATEGORY = "category";

	public static final String LAYER = "layer";

	public static final String LAYER_ORDER = "layerOrder";

	private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

	private PartsCategory category;

	private Layer layer;

	private float layerOrder;

	public static CustomLayerOrder valueOf(PartsCategory category, Layer layer, float layerOrder) {
		CustomLayerOrder inst = new CustomLayerOrder();
		inst.setCategory(category);
		inst.setLayer(layer);
		inst.setLayerOrder(layerOrder);
		return inst;
	}

	public CustomLayerOrder copy() {
		CustomLayerOrder inst = new CustomLayerOrder();
		inst.setCategory(category);
		inst.setLayer(layer);
		inst.setLayerOrder(layerOrder);
		return inst;
	}

	public PartsCategory getCategory() {
		return category;
	}

	public void setCategory(PartsCategory category) {
		PartsCategory old = this.category;
		if (old == null ? category != null : !old.equals(category)) {
			this.category = category;
			propChangeSupport.firePropertyChange(CATEGORY, old, category);
		}
	}

	public Layer getLayer() {
		return layer;
	}

	public void setLayer(Layer layer) {
		Layer old = this.layer;
		this.layer = layer;
		if (old == null ? layer != null : !old.equals(layer)) {
			this.layer = layer;
			propChangeSupport.firePropertyChange(LAYER, old, layer);
		}
	}

	public float getLayerOrder() {
		return layerOrder;
	}

	public void setLayerOrder(float layerOrder) {
		float old = this.layerOrder;
		if (old != layerOrder) {
			this.layerOrder = layerOrder;
			propChangeSupport.firePropertyChange(LAYER_ORDER, old, layerOrder);
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((category == null) ? 0 : category.hashCode());
		result = prime * result + ((layer == null) ? 0 : layer.hashCode());
		result = prime * result + Float.floatToIntBits(layerOrder);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CustomLayerOrder other = (CustomLayerOrder) obj;
		if (category == null) {
			if (other.category != null)
				return false;
		} else if (!category.equals(other.category))
			return false;
		if (layer == null) {
			if (other.layer != null)
				return false;
		} else if (!layer.equals(other.layer))
			return false;
		if (Float.floatToIntBits(layerOrder) != Float.floatToIntBits(other.layerOrder))
			return false;
		return true;
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propChangeSupport.addPropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propChangeSupport.removePropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	@Override
	public String toString() {
		return "CustomLayerOrder [category=" + category + ", layer=" + layer + ", layerOrder=" + layerOrder + "]";
	}
}