// Copyright (c) 2009, 2017  INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
//
// $URL: https://github.com/CGAL/cgal/blob/v6.0.1/Periodic_3_triangulation_3/include/CGAL/Periodic_3_triangulation_3/internal/Periodic_3_regular_triangulation_dummy_288.h $
// $Id: include/CGAL/Periodic_3_triangulation_3/internal/Periodic_3_regular_triangulation_dummy_288.h 50cfbde3b84 $
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s)     : Manuel Caroli <Manuel.Caroli@sophia.inria.fr>

#include <CGAL/license/Periodic_3_triangulation_3.h>

#ifdef CGAL_INCLUDE_FROM_PERIODIC_3_REGULAR_TRIANGULATION_3_H

std::vector<Weighted_point> dummy_points()
{
  std::vector<Weighted_point> dummy_points;
  dummy_points.reserve(6*6*8);

  FT domain_x(domain().xmax() - domain().xmin());
  FT domain_y(domain().ymax() - domain().ymin());
  FT domain_z(domain().zmax() - domain().zmin());

  for (unsigned i = 0; i < 6; ++i)
  {
    for (unsigned j = 0; j < 6; ++j)
    {
      for (unsigned k = 0; k < 8; ++k)
      {
        FT x = (FT(i) * domain_x / FT(6)) + domain().xmin();
        if (k % 2)
          x += FT(1) * domain_x / FT(12);

        FT y = (FT(j) * domain_y / FT(6)) + domain().ymin();
        if (k % 2)
          y += FT(1) * domain_y / FT(12);

        FT z = (FT(k) * domain_z / FT(8)) + domain().zmin();

        dummy_points.emplace_back(Bare_point(x, y, z), 0);
      }
    }
  }

  return dummy_points;
}

std::vector<Vertex_handle> insert_dummy_points ()
{

static const unsigned N[1728][4] = {
  { 1220, 495, 1015, 1489 },
  { 1402, 567, 123, 295 },
  { 499, 428, 1261, 195 },
  { 221, 7, 298, 424 },
  { 959, 1337, 47, 873 },
  { 447, 341, 288, 18 },
  { 478, 498, 549, 193 },
  { 210, 658, 3, 498 },
  { 266, 171, 62, 103 },
  { 912, 185, 945, 803 },
  { 295, 27, 188, 963 },
  { 179, 298, 239, 144 },
  { 175, 1425, 574, 62 },
  { 112, 314, 66, 230 },
  { 821, 156, 696, 820 },
  { 424, 249, 185, 221 },
  { 994, 254, 571, 1314 },
  { 96, 679, 263, 431 },
  { 1494, 5, 79, 189 },
  { 272, 766, 618, 738 },
  { 742, 379, 397, 517 },
  { 314, 66, 487, 341 },
  { 300, 488, 258, 481 },
  { 487, 371, 657, 627 },
  { 1037, 869, 785, 1075 },
  { 967, 138, 1027, 1217 },
  { 464, 359, 1583, 404 },
  { 10, 609, 1353, 363 },
  { 39, 75, 106, 1006 },
  { 739, 690, 224, 182 },
  { 242, 1550, 520, 186 },
  { 337, 120, 1457, 331 },
  { 432, 63, 484, 470 },
  { 287, 213, 195, 87 },
  { 1502, 1509, 1481, 301 },
  { 1190, 558, 443, 168 },
  { 263, 270, 338, 232 },
  { 852, 1190, 976, 168 },
  { 684, 401, 251, 508 },
  { 28, 166, 1507, 190 },
  { 514, 697, 482, 515 },
  { 143, 1004, 493, 523 },
  { 337, 206, 120, 149 },
  { 951, 1112, 955, 678 },
  { 1006, 749, 1510, 145 },
  { 488, 193, 317, 258 },
  { 292, 452, 380, 201 },
  { 4, 1039, 646, 1186 },
  { 1149, 1501, 811, 1229 },
  { 320, 166, 190, 583 },
  { 349, 597, 788, 812 },
  { 281, 706, 247, 382 },
  { 477, 1606, 102, 564 },
  { 72, 190, 1449, 328 },
  { 823, 147, 872, 187 },
  { 414, 808, 578, 218 },
  { 970, 984, 845, 772 },
  { 59, 833, 703, 441 },
  { 1193, 1354, 1172, 1710 },
  { 1030, 1258, 57, 1281 },
  { 465, 290, 556, 601 },
  { 247, 113, 274, 296 },
  { 8, 321, 1417, 12 },
  { 32, 397, 240, 82 },
  { 210, 791, 658, 894 },
  { 245, 1173, 1414, 1125 },
  { 13, 21, 189, 114 },
  { 861, 1129, 674, 1072 },
  { 814, 781, 566, 388 },
  { 919, 810, 837, 1313 },
  { 378, 123, 567, 787 },
  { 561, 528, 279, 452 },
  { 1423, 306, 53, 374 },
  { 557, 1151, 969, 951 },
  { 520, 948, 465, 449 },
  { 28, 263, 202, 232 },
  { 1295, 1060, 1302, 1047 },
  { 1213, 558, 151, 1182 },
  { 381, 98, 591, 1017 },
  { 18, 288, 1528, 278 },
  { 545, 89, 458, 624 },
  { 833, 1301, 233, 1062 },
  { 470, 469, 63, 429 },
  { 1563, 1691, 930, 1659 },
  { 226, 1696, 1694, 1002 },
  { 1178, 1655, 1187, 1330 },
  { 271, 480, 481, 339 },
  { 1553, 33, 297, 170 },
  { 654, 737, 1038, 813 },
  { 365, 418, 633, 80 },
  { 486, 466, 358, 242 },
  { 712, 982, 459, 953 },
  { 1610, 437, 499, 287 },
  { 235, 363, 1615, 550 },
  { 792, 766, 115, 618 },
  { 1243, 1465, 964, 1024 },
  { 451, 429, 17, 681 },
  { 604, 584, 335, 131 },
  { 764, 617, 1065, 78 },
  { 339, 1574, 220, 107 },
  { 1191, 961, 1179, 1034 },
  { 1505, 199, 385, 336 },
  { 303, 1183, 560, 52 },
  { 234, 426, 612, 8 },
  { 434, 481, 1251, 271 },
  { 179, 221, 803, 120 },
  { 185, 202, 912, 28 },
  { 439, 99, 502, 1527 },
  { 597, 276, 599, 574 },
  { 462, 828, 590, 389 },
  { 1469, 1305, 1465, 1484 },
  { 584, 858, 604, 350 },
  { 385, 13, 1304, 188 },
  { 61, 149, 206, 192 },
  { 66, 371, 171, 611 },
  { 521, 764, 778, 94 },
  { 926, 1383, 390, 332 },
  { 1141, 1161, 1204, 1268 },
  { 313, 303, 497, 293 },
  { 502, 368, 527, 1629 },
  { 42, 223, 105, 31 },
  { 209, 314, 150, 330 },
  { 135, 341, 148, 447 },
  { 70, 1, 584, 289 },
  { 1257, 1576, 1468, 1379 },
  { 1407, 1642, 1487, 1648 },
  { 1383, 238, 862, 768 },
  { 1585, 1536, 1586, 891 },
  { 217, 1251, 1571, 1298 },
  { 513, 632, 524, 568 },
  { 1192, 153, 720, 1099 },
  { 412, 97, 336, 166 },
  { 150, 638, 330, 838 },
  { 925, 269, 327, 1392 },
  { 1143, 1498, 1221, 1444 },
  { 169, 141, 122, 453 },
  { 1571, 1464, 1251, 1209 },
  { 1450, 1205, 1141, 1222 },
  { 25, 176, 960, 1273 },
  { 954, 444, 792, 992 },
  { 850, 822, 848, 1106 },
  { 209, 314, 135, 184 },
  { 311, 880, 218, 407 },
  { 538, 41, 302, 524 },
  { 11, 433, 271, 1567 },
  { 44, 1558, 1378, 1556 },
  { 641, 1111, 151, 1240 },
  { 376, 413, 54, 696 },
  { 169, 122, 294, 355 },
  { 650, 599, 42, 113 },
  { 637, 121, 200, 132 },
  { 146, 77, 692, 643 },
  { 329, 211, 156, 820 },
  { 843, 704, 907, 130 },
  { 469, 478, 549, 286 },
  { 1302, 993, 870, 1345 },
  { 152, 519, 536, 14 },
  { 1446, 1315, 1320, 1605 },
  { 208, 1008, 746, 1027 },
  { 1106, 780, 822, 1076 },
  { 1439, 562, 539, 402 },
  { 815, 652, 381, 856 },
  { 592, 492, 372, 823 },
  { 562, 546, 550, 539 },
  { 691, 692, 182, 971 },
  { 248, 959, 444, 1049 },
  { 177, 131, 39, 49 },
  { 563, 211, 525, 349 },
  { 37, 35, 1244, 1199 },
  { 725, 135, 148, 203 },
  { 1554, 270, 87, 199 },
  { 189, 114, 321, 8 },
  { 1290, 1349, 1338, 1057 },
  { 1249, 1441, 1291, 769 },
  { 531, 758, 273, 782 },
  { 426, 581, 255, 12 },
  { 940, 1226, 1542, 138 },
  { 412, 166, 263, 431 },
  { 406, 367, 1580, 288 },
  { 105, 11, 319, 183 },
  { 213, 569, 456, 724 },
  { 258, 549, 619, 480 },
  { 164, 1041, 29, 268 },
  { 179, 1566, 1253, 803 },
  { 199, 141, 453, 385 },
  { 15, 306, 106, 9 },
  { 285, 30, 482, 1565 },
  { 696, 473, 448, 54 },
  { 335, 230, 112, 10 },
  { 1495, 66, 18, 171 },
  { 306, 49, 39, 53 },
  { 647, 268, 642, 1018 },
  { 296, 113, 278, 207 },
  { 45, 479, 700, 6 },
  { 244, 1165, 986, 1109 },
  { 33, 203, 2, 297 },
  { 785, 759, 710, 869 },
  { 1026, 1485, 1466, 1056 },
  { 399, 378, 560, 789 },
  { 170, 420, 184, 101 },
  { 604, 576, 150, 230 },
  { 722, 488, 46, 367 },
  { 106, 423, 75, 451 },
  { 724, 169, 428, 195 },
  { 629, 677, 284, 722 },
  { 515, 283, 458, 624 },
  { 42, 1532, 319, 113 },
  { 411, 192, 321, 600 },
  { 783, 250, 158, 811 },
  { 215, 121, 726, 141 },
  { 635, 64, 7, 630 },
  { 167, 152, 493, 416 },
  { 950, 450, 679, 304 },
  { 466, 454, 180, 33 },
  { 421, 1121, 1564, 1558 },
  { 420, 395, 509, 209 },
  { 1273, 1312, 994, 1087 },
  { 1188, 128, 522, 1023 },
  { 55, 850, 596, 142 },
  { 555, 1219, 573, 581 },
  { 99, 503, 458, 502 },
  { 3, 15, 105, 223 },
  { 1411, 875, 1528, 1224 },
  { 372, 221, 120, 592 },
  { 29, 844, 580, 268 },
  { 717, 430, 629, 354 },
  { 1617, 1679, 84, 1455 },
  { 683, 842, 510, 509 },
  { 305, 738, 735, 684 },
  { 301, 975, 1496, 1684 },
  { 188, 200, 13, 610 },
  { 748, 618, 353, 504 },
  { 75, 36, 361, 1555 },
  { 81, 870, 917, 1322 },
  { 1353, 103, 266, 1724 },
  { 1686, 567, 93, 507 },
  { 1425, 276, 966, 1207 },
  { 1364, 324, 1283, 1711 },
  { 126, 1427, 1429, 1706 },
  { 11, 434, 274, 319 },
  { 63, 353, 486, 257 },
  { 898, 585, 941, 767 },
  { 485, 90, 30, 1612 },
  { 488, 274, 434, 367 },
  { 1071, 1357, 194, 1116 },
  { 1138, 1171, 1115, 65 },
  { 256, 1071, 540, 1060 },
  { 51, 438, 479, 61 },
  { 1008, 1289, 165, 979 },
  { 448, 473, 306, 15 },
  { 1179, 1010, 208, 1236 },
  { 577, 38, 387, 495 },
  { 1418, 1650, 1452, 1694 },
  { 932, 702, 740, 670 },
  { 1320, 1360, 1358, 16 },
  { 574, 532, 175, 881 },
  { 918, 1311, 246, 1338 },
  { 240, 450, 338, 679 },
  { 22, 45, 375, 181 },
  { 870, 1345, 261, 962 },
  { 483, 320, 431, 312 },
  { 259, 925, 1095, 1122 },
  { 1284, 522, 1381, 1365 },
  { 177, 36, 17, 75 },
  { 1025, 1202, 779, 1533 },
  { 443, 1255, 1258, 1243 },
  { 708, 234, 8, 1239 },
  { 538, 1424, 1666, 1705 },
  { 182, 980, 224, 191 },
  { 133, 1201, 1362, 1200 },
  { 36, 420, 454, 170 },
  { 144, 86, 104, 1467 },
  { 729, 949, 19, 456 },
  { 425, 174, 806, 745 },
  { 479, 61, 239, 243 },
  { 1474, 315, 555, 553 },
  { 236, 476, 108, 337 },
  { 1315, 1598, 1646, 1174 },
  { 79, 192, 1529, 321 },
  { 442, 518, 359, 71 },
  { 1009, 1242, 1380, 1513 },
  { 639, 51, 676, 427 },
  { 649, 469, 429, 501 },
  { 480, 432, 205, 339 },
  { 739, 639, 547, 204 },
  { 432, 484, 186, 1515 },
  { 802, 154, 742, 663 },
  { 1611, 466, 92, 33 },
  { 5, 383, 178, 79 },
  { 399, 328, 123, 583 },
  { 794, 560, 303, 60 },
  { 1232, 1679, 1697, 1689 },
  { 723, 722, 640, 46 },
  { 329, 388, 118, 566 },
  { 148, 629, 430, 723 },
  { 10, 1, 1101, 335 },
  { 676, 61, 383, 192 },
  { 87, 195, 939, 453 },
  { 3, 433, 498, 11 },
  { 381, 357, 815, 765 },
  { 452, 22, 528, 439 },
  { 34, 229, 1432, 1683 },
  { 800, 493, 143, 537 },
  { 449, 102, 290, 118 },
  { 366, 683, 212, 352 },
  { 467, 505, 228, 437 },
  { 249, 72, 190, 185 },
  { 1171, 1200, 1418, 1368 },
  { 751, 642, 761, 647 },
  { 952, 1012, 976, 1376 },
  { 482, 497, 514, 1660 },
  { 142, 777, 462, 496 },
  { 681, 511, 260, 448 },
  { 1139, 477, 118, 329 },
  { 121, 13, 21, 141 },
  { 275, 1671, 500, 552 },
  { 671, 816, 685, 1120 },
  { 700, 547, 45, 752 },
  { 433, 470, 423, 451 },
  { 206, 239, 1279, 179 },
  { 260, 631, 49, 448 },
  { 171, 207, 278, 62 },
  { 346, 1719, 1472, 1181 },
  { 972, 1401, 325, 1434 },
  { 237, 1623, 1701, 1709 },
  { 973, 419, 1155, 323 },
  { 1374, 1362, 1201, 1625 },
  { 1114, 1325, 1184, 133 },
  { 564, 1317, 289, 53 },
  { 493, 152, 313, 293 },
  { 121, 698, 699, 132 },
  { 525, 890, 563, 31 },
  { 1135, 1113, 707, 116 },
  { 366, 457, 626, 754 },
  { 405, 355, 380, 396 },
  { 336, 97, 188, 295 },
  { 1506, 131, 101, 335 },
  { 966, 42, 31, 276 },
  { 36, 257, 486, 454 },
  { 86, 283, 99, 1195 },
  { 835, 829, 376, 820 },
  { 122, 21, 373, 5 },
  { 1509, 1562, 1422, 1502 },
  { 1669, 1630, 1522, 1712 },
  { 1415, 1100, 1617, 1693 },
  { 909, 613, 1355, 1436 },
  { 911, 1581, 322, 1583 },
  { 1163, 1627, 1363, 1427 },
  { 921, 1168, 1165, 419 },
  { 167, 50, 492, 416 },
  { 787, 111, 839, 857 },
  { 605, 849, 675, 881 },
  { 588, 483, 431, 304 },
  { 397, 231, 616, 240 },
  { 702, 225, 739, 690 },
  { 356, 148, 723, 334 },
  { 428, 355, 393, 405 },
  { 299, 617, 1073, 425 },
  { 505, 90, 377, 616 },
  { 551, 279, 553, 26 },
  { 767, 750, 1036, 762 },
  { 232, 485, 370, 559 },
  { 544, 723, 755, 640 },
  { 567, 27, 93, 608 },
  { 968, 905, 1282, 1048 },
  { 545, 472, 579, 89 },
  { 304, 557, 333, 950 },
  { 201, 243, 178, 383 },
  { 119, 538, 524, 1193 },
  { 416, 800, 871, 743 },
  { 423, 484, 1569, 361 },
  { 114, 23, 411, 669 },
  { 658, 162, 223, 650 },
  { 341, 487, 629, 677 },
  { 1228, 536, 519, 72 },
  { 666, 410, 619, 258 },
  { 340, 1126, 836, 147 },
  { 358, 520, 465, 491 },
  { 403, 198, 70, 765 },
  { 20, 494, 644, 474 },
  { 334, 46, 404, 406 },
  { 299, 78, 789, 161 },
  { 51, 734, 438, 887 },
  { 677, 367, 288, 296 },
  { 1021, 582, 500, 530 },
  { 101, 184, 587, 112 },
  { 480, 549, 470, 433 },
  { 251, 435, 578, 552 },
  { 68, 776, 293, 794 },
  { 109, 1105, 880, 834 },
  { 1104, 116, 1146, 707 },
  { 1549, 1252, 1048, 1520 },
  { 1593, 1261, 1395, 405 },
  { 401, 356, 544, 435 },
  { 659, 617, 764, 774 },
  { 412, 215, 637, 588 },
  { 974, 334, 406, 447 },
  { 644, 20, 353, 63 },
  { 739, 691, 639, 740 },
  { 289, 198, 564, 821 },
  { 933, 655, 796, 799 },
  { 732, 428, 393, 38 },
  { 1412, 467, 160, 437 },
  { 560, 378, 507, 534 },
  { 26, 452, 1584, 380 },
  { 392, 356, 464, 334 },
  { 396, 380, 1535, 178 },
  { 142, 573, 555, 496 },
  { 521, 1051, 1065, 634 },
  { 898, 585, 702, 670 },
  { 752, 721, 375, 693 },
  { 371, 627, 207, 668 },
  { 177, 131, 395, 420 },
  { 688, 147, 1081, 1126 },
  { 440, 807, 55, 777 },
  { 793, 748, 504, 512 },
  { 211, 369, 349, 835 },
  { 747, 852, 471, 1146 },
  { 572, 801, 89, 548 },
  { 348, 1164, 325, 972 },
  { 270, 412, 215, 199 },
  { 749, 1518, 1520, 214 },
  { 1077, 1076, 780, 847 },
  { 202, 1568, 370, 318 },
  { 3, 681, 451, 15 },
  { 765, 357, 273, 773 },
  { 582, 175, 605, 103 },
  { 831, 281, 627, 888 },
  { 401, 203, 356, 2 },
  { 82, 282, 679, 96 },
  { 225, 682, 294, 716 },
  { 352, 260, 177, 17 },
  { 283, 515, 285, 32 },
  { 298, 318, 386, 144 },
  { 104, 1573, 243, 239 },
  { 387, 393, 440, 551 },
  { 767, 762, 678, 680 },
  { 402, 305, 508, 92 },
  { 382, 650, 658, 247 },
  { 300, 481, 107, 1464 },
  { 435, 544, 414, 442 },
  { 1281, 905, 57, 968 },
  { 440, 561, 777, 279 },
  { 265, 460, 1470, 35 },
  { 139, 165, 634, 1044 },
  { 685, 965, 815, 853 },
  { 755, 728, 544, 759 },
  { 1525, 122, 396, 5 },
  { 312, 187, 320, 249 },
  { 74, 1438, 303, 497 },
  { 504, 510, 257, 212 },
  { 318, 96, 202, 424 },
  { 71, 300, 404, 46 },
  { 297, 135, 1235, 184 },
  { 338, 270, 569, 213 },
  { 1079, 941, 893, 1221 },
  { 730, 272, 180, 738 },
  { 333, 557, 1091, 719 },
  { 205, 220, 565, 80 },
  { 984, 796, 928, 91 },
  { 558, 1225, 1294, 443 },
  { 754, 922, 1136, 704 },
  { 109, 799, 795, 311 },
  { 844, 785, 933, 1042 },
  { 1395, 551, 26, 405 },
  { 377, 74, 467, 60 },
  { 90, 213, 505, 287 },
  { 465, 305, 556, 402 },
  { 1493, 1538, 1350, 1483 },
  { 282, 154, 82, 742 },
  { 386, 82, 32, 318 },
  { 734, 705, 720, 417 },
  { 796, 795, 365, 928 },
  { 187, 519, 249, 592 },
  { 379, 548, 594, 924 },
  { 698, 682, 680, 726 },
  { 575, 525, 597, 276 },
  { 931, 52, 313, 536 },
  { 154, 630, 6, 756 },
  { 193, 247, 498, 274 },
  { 386, 283, 181, 86 },
  { 22, 104, 86, 439 },
  { 186, 520, 40, 310 },
  { 352, 860, 260, 626 },
  { 32, 370, 485, 285 },
  { 361, 486, 484, 242 },
  { 338, 90, 240, 485 },
  { 21, 23, 699, 373 },
  { 201, 243, 45, 22 },
  { 838, 892, 1120, 638 },
  { 825, 1107, 1325, 1123 },
  { 697, 778, 377, 616 },
  { 349, 788, 162, 827 },
  { 211, 329, 41, 302 },
  { 548, 663, 379, 624 },
  { 539, 251, 0, 508 },
  { 407, 311, 568, 518 },
  { 310, 449, 118, 1618 },
  { 6, 7, 298, 479 },
  { 92, 508, 1413, 2 },
  { 384, 555, 315, 596 },
  { 541, 282, 950, 622 },
  { 107, 220, 526, 119 },
  { 220, 1424, 565, 538 },
  { 415, 729, 231, 450 },
  { 358, 466, 738, 305 },
  { 585, 750, 690, 1031 },
  { 1653, 403, 235, 562 },
  { 437, 38, 495, 499 },
  { 569, 726, 215, 227 },
  { 227, 729, 450, 569 },
  { 312, 595, 872, 635 },
  { 969, 746, 415, 955 },
  { 573, 598, 535, 129 },
  { 565, 566, 310, 40 },
  { 205, 644, 40, 432 },
  { 990, 713, 617, 1073 },
  { 790, 20, 748, 841 },
  { 496, 527, 553, 279 },
  { 156, 374, 473, 563 },
  { 30, 74, 377, 482 },
  { 792, 854, 115, 408 },
  { 1344, 891, 262, 217 },
  { 575, 1364, 41, 525 },
  { 535, 143, 368, 129 },
  { 476, 523, 167, 331 },
  { 527, 545, 502, 528 },
  { 518, 568, 119, 526 },
  { 71, 666, 526, 300 },
  { 1373, 1152, 916, 1178 },
  { 554, 596, 606, 384 },
  { 848, 174, 806, 672 },
  { 255, 598, 573, 667 },
  { 682, 716, 762, 731 },
  { 403, 773, 562, 556 },
  { 1354, 575, 524, 513 },
  { 477, 564, 156, 374 },
  { 565, 302, 566, 633 },
  { 503, 267, 143, 368 },
  { 160, 163, 1220, 495 },
  { 982, 246, 589, 953 },
  { 754, 649, 501, 704 },
  { 853, 1043, 1084, 965 },
  { 834, 625, 884, 812 },
  { 393, 362, 446, 440 },
  { 526, 365, 80, 666 },
  { 163, 577, 745, 554 },
  { 580, 284, 317, 722 },
  { 845, 474, 418, 494 },
  { 154, 6, 386, 181 },
  { 93, 554, 1595, 163 },
  { 359, 552, 435, 464 },
  { 315, 1015, 387, 551 },
  { 275, 518, 1246, 359 },
  { 550, 546, 607, 530 },
  { 275, 219, 407, 500 },
  { 60, 774, 534, 467 },
  { 366, 906, 457, 73 },
  { 460, 35, 692, 77 },
  { 361, 1613, 1560, 1555 },
  { 198, 403, 102, 290 },
  { 442, 640, 655, 71 },
  { 507, 534, 163, 160 },
  { 167, 331, 519, 592 },
  { 536, 52, 399, 328 },
  { 458, 503, 514, 537 },
  { 537, 68, 293, 514 },
  { 235, 1, 363, 70 },
  { 496, 579, 129, 527 },
  { 454, 180, 509, 510 },
  { 1560, 1385, 1059, 1613 },
  { 1044, 16, 713, 990 },
  { 845, 928, 418, 660 },
  { 532, 513, 219, 407 },
  { 255, 12, 108, 600 },
  { 1471, 523, 535, 476 },
  { 200, 899, 610, 839 },
  { 546, 251, 661, 578 },
  { 577, 387, 55, 596 },
  { 365, 795, 568, 632 },
  { 224, 547, 752, 603 },
  { 582, 1628, 219, 175 },
  { 1488, 581, 384, 426 },
  { 631, 289, 584, 49 },
  { 111, 123, 97, 583 },
  { 409, 241, 506, 1111 },
  { 1439, 628, 1651, 1653 },
  { 385, 1304, 1491, 1266 },
  { 395, 683, 636, 352 },
  { 540, 1071, 1070, 846 },
  { 1070, 1105, 109, 846 },
  { 789, 794, 776, 78 },
  { 162, 563, 473, 223 },
  { 906, 842, 683, 797 },
  { 474, 781, 814, 854 },
  { 626, 754, 824, 511 },
  { 530, 578, 218, 500 },
  { 598, 108, 476, 50 },
  { 513, 532, 597, 812 },
  { 651, 108, 149, 600 },
  { 668, 574, 599, 207 },
  { 794, 764, 60, 778 },
  { 719, 1414, 1408, 1091 },
  { 844, 580, 655, 640 },
  { 97, 111, 637, 200 },
  { 606, 351, 612, 426 },
  { 530, 849, 607, 605 },
  { 608, 806, 606, 554 },
  { 363, 727, 609, 607 },
  { 27, 608, 610, 612 },
  { 609, 576, 230, 611 },
  { 610, 669, 114, 612 },
  { 609, 605, 611, 103 },
  { 1259, 1394, 345, 1437 },
  { 797, 686, 1130, 906 },
  { 690, 716, 1013, 750 },
  { 491, 618, 358, 353 },
  { 98, 394, 516, 357 },
  { 94, 19, 616, 231 },
  { 375, 181, 663, 624 },
  { 836, 621, 1096, 1061 },
  { 620, 1068, 1123, 896 },
  { 501, 790, 793, 770 },
  { 1003, 1480, 1627, 1635 },
  { 80, 619, 494, 205 },
  { 543, 828, 927, 871 },
  { 483, 333, 915, 595 },
  { 23, 427, 676, 411 },
  { 1438, 1183, 1689, 586 },
  { 294, 373, 225, 204 },
  { 649, 210, 478, 907 },
  { 583, 855, 320, 859 },
  { 579, 871, 129, 800 },
  { 800, 801, 537, 89 },
  { 444, 959, 408, 1092 },
  { 681, 649, 511, 210 },
  { 637, 674, 861, 588 },
  { 395, 150, 604, 636 },
  { 674, 489, 908, 132 },
  { 398, 281, 706, 284 },
  { 362, 292, 603, 561 },
  { 670, 146, 643, 1215 },
  { 308, 752, 693, 191 },
  { 641, 151, 942, 1216 },
  { 515, 379, 697, 397 },
  { 770, 715, 790, 1001 },
  { 47, 1092, 1043, 946 },
  { 971, 191, 308, 1014 },
  { 791, 1135, 894, 786 },
  { 635, 630, 282, 541 },
  { 438, 651, 372, 149 },
  { 788, 599, 650, 886 },
  { 161, 656, 688, 878 },
  { 1061, 817, 1098, 1126 },
  { 728, 759, 1019, 88 },
  { 400, 603, 721, 561 },
  { 652, 1017, 1127, 946 },
  { 699, 932, 23, 903 },
  { 64, 372, 7, 438 },
  { 766, 733, 394, 735 },
  { 572, 711, 1069, 1063 },
  { 745, 737, 577, 813 },
  { 744, 987, 991, 949 },
  { 970, 286, 494, 619 },
  { 1526, 1631, 1624, 1045 },
  { 947, 1242, 1513, 1237 },
  { 528, 721, 545, 375 },
  { 880, 834, 881, 532 },
  { 798, 885, 411, 600 },
  { 611, 900, 371, 675 },
  { 409, 641, 253, 1157 },
  { 672, 316, 839, 899 },
  { 531, 816, 671, 902 },
  { 1586, 1276, 1116, 1303 },
  { 636, 67, 797, 638 },
  { 351, 901, 669, 798 },
  { 677, 281, 296, 627 },
  { 373, 676, 204, 383 },
  { 43, 436, 956, 842 },
  { 429, 212, 257, 17 },
  { 475, 867, 842, 436 },
  { 424, 635, 96, 312 },
  { 475, 430, 533, 725 },
  { 588, 593, 304, 227 },
  { 228, 732, 813, 38 },
  { 316, 445, 857, 1072 },
  { 614, 1079, 893, 914 },
  { 804, 826, 924, 1055 },
  { 856, 413, 1124, 652 },
  { 1038, 977, 990, 1035 },
  { 354, 615, 29, 506 },
  { 164, 747, 398, 942 },
  { 1041, 558, 164, 151 },
  { 642, 410, 970, 984 },
  { 986, 1165, 935, 934 },
  { 1113, 884, 825, 1123 },
  { 855, 14, 187, 147 },
  { 40, 814, 491, 644 },
  { 330, 717, 867, 475 },
  { 330, 717, 487, 657 },
  { 706, 317, 193, 751 },
  { 955, 1217, 746, 744 },
  { 253, 717, 354, 409 },
  { 715, 57, 772, 1001 },
  { 541, 961, 461, 153 },
  { 471, 706, 751, 747 },
  { 51, 639, 700, 705 },
  { 332, 887, 734, 390 },
  { 266, 1263, 944, 1495 },
  { 1636, 1643, 1297, 1675 },
  { 196, 807, 736, 780 },
  { 1064, 928, 993, 660 },
  { 1018, 91, 984, 983 },
  { 571, 1043, 1092, 516 },
  { 1362, 1664, 1184, 1665 },
  { 866, 703, 802, 645 },
  { 430, 533, 755, 615 },
  { 699, 698, 225, 702 },
  { 1142, 1143, 1079, 1361 },
  { 457, 1150, 602, 922 },
  { 471, 130, 907, 894 },
  { 410, 655, 666, 796 },
  { 292, 204, 547, 201 },
  { 355, 294, 362, 292 },
  { 180, 725, 730, 203 },
  { 724, 169, 726, 682 },
  { 509, 725, 209, 475 },
  { 787, 839, 608, 806 },
  { 731, 446, 654, 732 },
  { 510, 956, 504, 272 },
  { 732, 731, 724, 456 },
  { 533, 728, 978, 730 },
  { 401, 728, 730, 684 },
  { 1038, 991, 659, 990 },
  { 382, 471, 894, 707 },
  { 774, 659, 813, 228 },
  { 933, 710, 799, 1070 },
  { 88, 808, 758, 661 },
  { 228, 19, 456, 505 },
  { 398, 354, 284, 29 },
  { 253, 942, 398, 831 },
  { 1036, 809, 1269, 987 },
  { 469, 286, 20, 790 },
  { 835, 763, 369, 1068 },
  { 701, 1087, 992, 662 },
  { 773, 273, 546, 661 },
  { 512, 158, 954, 701 },
  { 691, 971, 705, 417 },
  { 415, 517, 231, 818 },
  { 44, 912, 1277, 421 },
  { 506, 360, 615, 1037 },
  { 705, 700, 756, 308 },
  { 317, 580, 410, 642 },
  { 1085, 851, 981, 1359 },
  { 595, 541, 333, 461 },
  { 716, 446, 362, 1013 },
  { 907, 751, 478, 761 },
  { 1118, 1156, 938, 895 },
  { 822, 737, 174, 1035 },
  { 446, 654, 807, 196 },
  { 1083, 996, 920, 1164 },
  { 756, 308, 802, 866 },
  { 360, 533, 978, 436 },
  { 801, 819, 1069, 743 },
  { 98, 394, 601, 115 },
  { 378, 299, 787, 425 },
  { 19, 991, 94, 659 },
  { 241, 360, 1214, 436 },
  { 126, 1196, 1133, 1327 },
  { 1300, 173, 1485, 1722 },
  { 961, 645, 622, 1179 },
  { 1384, 1332, 1039, 817 },
  { 703, 833, 56, 826 },
  { 534, 425, 745, 774 },
  { 556, 394, 773, 735 },
  { 1010, 804, 1008, 1289 },
  { 591, 820, 829, 388 },
  { 414, 442, 799, 311 },
  { 814, 115, 601, 491 },
  { 1308, 1296, 1591, 264 },
  { 1070, 710, 159, 422 },
  { 594, 801, 68, 819 },
  { 174, 1035, 1073, 1074 },
  { 1151, 1179, 969, 208 },
  { 1280, 1331, 1252, 1520 },
  { 1013, 196, 463, 24 },
  { 648, 1134, 1099, 1137 },
  { 70, 350, 727, 765 },
  { 492, 50, 651, 883 },
  { 198, 591, 821, 381 },
  { 622, 742, 517, 645 },
  { 823, 648, 64, 872 },
  { 818, 521, 94, 139 },
  { 950, 622, 415, 969 },
  { 601, 591, 388, 290 },
  { 472, 462, 579, 828 },
  { 721, 400, 472, 459 },
  { 614, 908, 593, 674 },
  { 675, 879, 668, 881 },
  { 736, 400, 462, 777 },
  { 633, 369, 632, 302 },
  { 763, 781, 633, 418 },
  { 761, 970, 286, 715 },
  { 183, 9, 1468, 105 },
  { 1001, 687, 841, 775 },
  { 935, 934, 1046, 882 },
  { 727, 531, 607, 273 },
  { 759, 808, 414, 710 },
  { 807, 737, 55, 822 },
  { 741, 869, 1078, 1019 },
  { 1306, 69, 1310, 989 },
  { 48, 1500, 208, 1027 },
  { 50, 598, 543, 871 },
  { 735, 88, 661, 684 },
  { 697, 594, 68, 778 },
  { 299, 445, 161, 857 },
  { 672, 1074, 316, 904 },
  { 653, 1097, 771, 1127 },
  { 748, 841, 792, 954 },
  { 763, 781, 1050, 829 },
  { 14, 152, 340, 776 },
  { 399, 14, 855, 789 },
  { 140, 808, 758, 159 },
  { 162, 827, 791, 54 },
  { 1081, 872, 595, 1137 },
  { 934, 490, 926, 695 },
  { 772, 917, 845, 687 },
  { 836, 1096, 492, 823 },
  { 109, 795, 1064, 625 },
  { 340, 819, 999, 776 },
  { 1114, 1163, 1427, 1184 },
  { 932, 740, 427, 937 },
  { 1336, 1284, 1062, 1365 },
  { 57, 983, 772, 81 },
  { 389, 882, 667, 543 },
  { 340, 743, 416, 836 },
  { 376, 620, 835, 827 },
  { 69, 989, 1604, 1085 },
  { 899, 489, 132, 903 },
  { 350, 576, 727, 671 },
  { 922, 1136, 1420, 1115 },
  { 517, 924, 818, 804 },
  { 680, 593, 227, 678 },
  { 153, 1029, 866, 961 },
  { 224, 1013, 603, 463 },
  { 56, 572, 548, 826 },
  { 589, 986, 590, 1016 },
  { 1310, 422, 1071, 1357 },
  { 849, 140, 531, 902 },
  { 606, 850, 848, 351 },
  { 849, 218, 140, 880 },
  { 1351, 753, 1356, 1297 },
  { 417, 37, 1192, 862 },
  { 878, 542, 1090, 445 },
  { 924, 594, 521, 1051 },
  { 821, 696, 631, 856 },
  { 161, 688, 855, 859 },
  { 815, 685, 858, 350 },
  { 859, 857, 861, 111 },
  { 631, 856, 860, 858 },
  { 859, 915, 483, 861 },
  { 860, 67, 636, 858 },
  { 852, 1146, 1429, 126 },
  { 1109, 1166, 1168, 1375 },
  { 1376, 1002, 1227, 1420 },
  { 1294, 1250, 985, 1255 },
  { 843, 1030, 761, 715 },
  { 898, 698, 680, 908 },
  { 908, 893, 898, 1033 },
  { 24, 809, 196, 1077 },
  { 233, 155, 1063, 259 },
  { 369, 812, 625, 632 },
  { 791, 824, 511, 54 },
  { 1307, 1131, 4, 1186 },
  { 1389, 1565, 1660, 1524 },
  { 1025, 1494, 222, 1234 },
  { 1500, 1285, 1288, 1562 },
  { 1090, 1173, 878, 1125 },
  { 853, 946, 652, 877 },
  { 1046, 885, 798, 882 },
  { 142, 389, 850, 667 },
  { 351, 667, 798, 255 },
  { 805, 879, 834, 884 },
  { 884, 1113, 886, 788 },
  { 543, 695, 882, 883 },
  { 879, 886, 888, 668 },
  { 883, 651, 887, 885 },
  { 707, 886, 382, 888 },
  { 937, 887, 427, 885 },
  { 1185, 1187, 1655, 1416 },
  { 331, 1228, 1457, 1456 },
  { 522, 127, 1381, 1633 },
  { 489, 1153, 1033, 1158 },
  { 686, 455, 868, 909 },
  { 734, 720, 64, 648 },
  { 757, 1145, 937, 1046 },
  { 1061, 1095, 621, 925 },
  { 1098, 1392, 1061, 1134 },
  { 867, 241, 409, 868 },
  { 576, 671, 838, 900 },
  { 899, 901, 903, 669 },
  { 675, 1118, 902, 900 },
  { 901, 1082, 848, 672 },
  { 838, 938, 657, 900 },
  { 920, 998, 816, 1154 },
  { 441, 1336, 1062, 364 },
  { 593, 951, 614, 557 },
  { 756, 153, 630, 720 },
  { 868, 867, 797, 638 },
  { 1033, 345, 1259, 893 },
  { 1318, 1492, 1610, 1657 },
  { 1390, 1589, 1479, 346 },
  { 106, 9, 749, 1518 },
  { 1084, 1396, 1347, 1398 },
  { 686, 1409, 1053, 1130 },
  { 860, 1124, 626, 1089 },
  { 529, 1440, 1372, 1654 },
  { 826, 233, 1063, 1055 },
  { 985, 1075, 1042, 256 },
  { 1204, 69, 1545, 1312 },
  { 1082, 760, 904, 1155 },
  { 1067, 1163, 348, 1167 },
  { 719, 1191, 840, 461 },
  { 1055, 1054, 1051, 1080 },
  { 841, 474, 854, 687 },
  { 133, 261, 896, 1325 },
  { 825, 1114, 1067, 116 },
  { 625, 1064, 1123, 1068 },
  { 459, 472, 572, 711 },
  { 1453, 1523, 1379, 1283 },
  { 83, 1692, 1330, 1656 },
  { 1139, 477, 1445, 1699 },
  { 657, 253, 831, 938 },
  { 463, 736, 400, 982 },
  { 694, 1067, 805, 825 },
  { 1105, 694, 1083, 805 },
  { 1245, 1093, 1643, 1715 },
  { 895, 1104, 831, 888 },
  { 903, 1158, 932, 757 },
  { 1233, 297, 1590, 1235 },
  { 1210, 1508, 1543, 176 },
  { 1214, 241, 455, 1222 },
  { 643, 691, 740, 1147 },
  { 1386, 1366, 962, 1374 },
  { 1291, 708, 1234, 1239 },
  { 1007, 9, 1423, 1468 },
  { 878, 646, 656, 1039 },
  { 665, 1236, 1500, 1285 },
  { 74, 1412, 1438, 1659 },
  { 978, 956, 272, 662 },
  { 366, 501, 212, 793 },
  { 906, 1102, 73, 43 },
  { 309, 1244, 1377, 1458 },
  { 91, 540, 993, 1302 },
  { 746, 1008, 818, 139 },
  { 43, 701, 512, 956 },
  { 955, 949, 729, 678 },
  { 1676, 1247, 1180, 1725 },
  { 1564, 1575, 1334, 1622 },
  { 165, 1080, 634, 4 },
  { 1027, 1288, 979, 138 },
  { 704, 843, 770, 100 },
  { 1272, 943, 259, 1122 },
  { 10, 1353, 1263, 1442 },
  { 95, 1319, 1241, 1284 },
  { 1074, 1073, 445, 542 },
  { 1531, 236, 337, 1175 },
  { 1229, 1210, 25, 997 },
  { 1236, 441, 1010, 364 },
  { 73, 783, 793, 512 },
  { 802, 693, 663, 56 },
  { 747, 164, 647, 1190 },
  { 1297, 323, 419, 1675 },
  { 1167, 325, 1156, 1431 },
  { 1202, 1593, 396, 1525 },
  { 1503, 1101, 1442, 229 },
  { 37, 309, 1029, 1192 },
  { 1078, 1032, 1314, 689 },
  { 731, 762, 949, 987 },
  { 960, 1517, 248, 1049 },
  { 268, 985, 1042, 1018 },
  { 753, 1297, 995, 1393 },
  { 1042, 540, 933, 91 },
  { 1254, 712, 833, 1301 },
  { 693, 459, 56, 712 },
  { 1040, 918, 980, 865 },
  { 694, 846, 194, 1107 },
  { 741, 1019, 662, 978 },
  { 1347, 1396, 1416, 1407 },
  { 810, 837, 1351, 1592 },
  { 733, 571, 516, 689 },
  { 992, 733, 766, 662 },
  { 744, 1044, 139, 991 },
  { 953, 1016, 711, 155 },
  { 1274, 16, 1044, 216 },
  { 1170, 1299, 1410, 981 },
  { 760, 1076, 1117, 1356 },
  { 967, 1267, 1217, 1112 },
  { 904, 1117, 1074, 1352 },
  { 829, 1050, 1127, 1017 },
  { 1150, 1149, 1371, 1454 },
  { 645, 703, 804, 1010 },
  { 864, 1700, 1132, 84 },
  { 1463, 1661, 623, 1707 },
  { 1666, 1139, 41, 1364 },
  { 1200, 1459, 1196, 1418 },
  { 28, 1556, 44, 1507 },
  { 1277, 945, 1223, 1519 },
  { 158, 775, 954, 248 },
  { 280, 1223, 1511, 1619 },
  { 250, 1001, 775, 968 },
  { 1012, 1159, 1281, 1237 },
  { 1011, 1034, 1029, 309 },
  { 615, 755, 844, 785 },
  { 1190, 647, 1030, 1258 },
  { 1671, 0, 552, 1238 },
  { 993, 846, 1064, 1107 },
  { 999, 1065, 656, 78 },
  { 191, 980, 712, 1254 },
  { 809, 654, 1038, 987 },
  { 1257, 1576, 1024, 1252 },
  { 1488, 1595, 384, 1727 },
  { 1486, 1634, 1478, 1473 },
  { 1280, 217, 1331, 1298 },
  { 1066, 95, 1336, 1020 },
  { 875, 1537, 1308, 264 },
  { 1212, 197, 1265, 1669 },
  { 811, 960, 158, 25 },
  { 1213, 1240, 1300, 1486 },
  { 1030, 1012, 843, 976 },
  { 1029, 1014, 866, 59 },
  { 1111, 506, 1041, 1264 },
  { 977, 1076, 1117, 1035 },
  { 892, 909, 868, 1157 },
  { 1237, 1012, 1227, 100 },
  { 689, 1032, 782, 758 },
  { 360, 1037, 1268, 741 },
  { 750, 1036, 24, 1160 },
  { 88, 1019, 733, 689 },
  { 1185, 47, 946, 771 },
  { 1041, 1264, 985, 1294 },
  { 692, 1031, 182, 1040 },
  { 980, 918, 463, 982 },
  { 646, 713, 1358, 542 },
  { 992, 994, 444, 571 },
  { 664, 1632, 1382, 1574 },
  { 1118, 805, 895, 879 },
  { 76, 1103, 1339, 1381 },
  { 1285, 391, 364, 1516 },
  { 979, 1307, 165, 1274 },
  { 819, 1051, 1054, 999 },
  { 1050, 854, 923, 408 },
  { 1642, 1678, 1681, 1443 },
  { 1259, 1406, 1086, 914 },
  { 923, 1094, 1050, 1097 },
  { 687, 917, 923, 1286 },
  { 1197, 1669, 197, 1340 },
  { 172, 1591, 1586, 1585 },
  { 1195, 1370, 1526, 1467 },
  { 570, 1367, 1514, 1608 },
  { 1338, 1103, 246, 76 },
  { 653, 896, 620, 897 },
  { 905, 832, 81, 1322 },
  { 917, 870, 660, 1094 },
  { 828, 711, 1016, 927 },
  { 408, 1017, 98, 1092 },
  { 1159, 1243, 1281, 1024 },
  { 921, 1145, 934, 926 },
  { 927, 1069, 621, 743 },
  { 660, 1068, 763, 1094 },
  { 736, 780, 590, 589 },
  { 246, 847, 589, 244 },
  { 1120, 1128, 685, 67 },
  { 782, 516, 357, 965 },
  { 816, 782, 965, 998 },
  { 1160, 24, 918, 1311 },
  { 422, 1032, 159, 996 },
  { 869, 1078, 422, 1310 },
  { 809, 1077, 1313, 977 },
  { 1102, 455, 686, 718 },
  { 1286, 923, 959, 1337 },
  { 1124, 413, 824, 1138 },
  { 902, 1083, 920, 1118 },
  { 1082, 1106, 760, 935 },
  { 1352, 913, 1358, 542 },
  { 837, 753, 1605, 1360 },
  { 1397, 1347, 1128, 1053 },
  { 1217, 216, 744, 1269 },
  { 1355, 1486, 1240, 1436 },
  { 915, 1125, 1091, 1129 },
  { 853, 1347, 877, 1128 },
  { 1089, 602, 457, 1130 },
  { 634, 646, 1065, 713 },
  { 1477, 936, 1292, 1299 },
  { 1063, 1095, 1069, 1054 },
  { 261, 1094, 1097, 896 },
  { 827, 1113, 1135, 620 },
  { 1095, 1054, 1332, 817 },
  { 653, 1171, 897, 1138 },
  { 786, 1133, 130, 1136 },
  { 344, 1655, 1650, 1692 },
  { 1447, 1402, 295, 975 },
  { 951, 1112, 1079, 1142 },
  { 1060, 1586, 1116, 1047 },
  { 1145, 390, 1147, 937 },
  { 389, 590, 1106, 935 },
  { 1105, 159, 140, 1083 },
  { 986, 1016, 1342, 490 },
  { 1504, 1291, 1441, 1534 },
  { 1116, 863, 194, 1343 },
  { 1517, 1335, 1369, 1559 },
  { 146, 585, 1031, 1189 },
  { 1102, 997, 43, 1214 },
  { 1096, 883, 332, 695 },
  { 926, 327, 830, 1383 },
  { 245, 1419, 840, 1414 },
  { 1103, 673, 244, 1109 },
  { 996, 1032, 998, 1359 },
  { 901, 1082, 757, 1046 },
  { 1673, 1166, 1168, 1675 },
  { 316, 1153, 1072, 489 },
  { 214, 1569, 1176, 1560 },
  { 962, 1201, 261, 1333 },
  { 621, 695, 490, 927 },
  { 688, 1081, 915, 1125 },
  { 877, 65, 1124, 1089 },
  { 413, 376, 653, 1127 },
  { 656, 1126, 817, 999 },
  { 1090, 1086, 1129, 1072 },
  { 1089, 1128, 1130, 67 },
  { 1091, 914, 614, 1129 },
  { 1369, 1373, 873, 1178 },
  { 1513, 1227, 1002, 1454 },
  { 1192, 768, 1421, 1099 },
  { 897, 1327, 1135, 786 },
  { 1096, 332, 648, 1134 },
  { 1099, 840, 461, 1137 },
  { 786, 1138, 1136, 824 },
  { 1098, 245, 1137, 1081 },
  { 1341, 313, 1004, 931 },
  { 1460, 1670, 1664, 1638 },
  { 137, 117, 1451, 1267 },
  { 1149, 1229, 1102, 718 },
  { 718, 1432, 134, 1443 },
  { 1533, 1202, 1390, 1535 },
  { 1167, 1104, 895, 1067 },
  { 1147, 862, 417, 390 },
  { 1216, 1146, 942, 1104 },
  { 1208, 1635, 1668, 1478 },
  { 1151, 1142, 1000, 48 },
  { 1151, 1000, 719, 1191 },
  { 73, 1149, 1150, 783 },
  { 1622, 1440, 529, 1620 },
  { 1154, 1397, 1120, 892 },
  { 904, 1309, 1153, 1155 },
  { 1156, 325, 920, 1154 },
  { 757, 973, 1155, 1158 },
  { 1033, 1215, 670, 1158 },
  { 892, 1156, 1157, 938 },
  { 1011, 1066, 1256, 1377 },
  { 1264, 1037, 1075, 1161 },
  { 1260, 117, 1160, 1203 },
  { 1400, 1208, 1634, 1726 },
  { 830, 1168, 921, 347 },
  { 1356, 760, 1165, 419 },
  { 194, 1164, 694, 348 },
  { 1303, 1119, 863, 1670 },
  { 1145, 921, 973, 1430 },
  { 1163, 863, 348, 1119 },
  { 1266, 1491, 1316, 1582 },
  { 1605, 1348, 1315, 995 },
  { 1098, 1384, 307, 245 },
  { 1474, 58, 1219, 1672 },
  { 1185, 1416, 65, 877 },
  { 1321, 277, 1187, 1396 },
  { 1484, 966, 1379, 1523 },
  { 1121, 1370, 1622, 1620 },
  { 1305, 1224, 1530, 1466 },
  { 1131, 529, 85, 1367 },
  { 100, 770, 783, 250 },
  { 957, 1541, 1405, 1594 },
  { 1246, 1583, 1230, 322 },
  { 77, 1206, 1199, 1428 },
  { 628, 102, 1606, 1653 },
  { 327, 830, 714, 1375 },
  { 1039, 889, 1384, 1173 },
  { 873, 1187, 47, 1321 },
  { 1174, 1186, 889, 85 },
  { 1293, 1572, 1344, 217 },
  { 1111, 1222, 1205, 1240 },
  { 37, 971, 1014, 35 },
  { 922, 100, 1150, 1227 },
  { 852, 976, 130, 1133 },
  { 1629, 368, 58, 1198 },
  { 1459, 1362, 1665, 1703 },
  { 339, 1515, 1574, 1058 },
  { 768, 1462, 1421, 1005 },
  { 1628, 1207, 1425, 1056 },
  { 1616, 1193, 1710, 1705 },
  { 1182, 1426, 168, 1429 },
  { 1392, 269, 1005, 307 },
  { 1372, 1122, 269, 326 },
  { 264, 974, 1388, 1144 },
  { 1161, 1204, 1306, 1350 },
  { 117, 1203, 1546, 919 },
  { 1260, 137, 1249, 1189 },
  { 1182, 1478, 1213, 1668 },
  { 1197, 1471, 236, 1630 },
  { 1340, 1672, 1148, 1162 },
  { 1390, 136, 1535, 1584 },
  { 1481, 940, 967, 1451 },
  { 1225, 1493, 1294, 1483 },
  { 1225, 1300, 1026, 1213 },
  { 77, 1028, 1212, 1206 },
  { 941, 1267, 1112, 767 },
  { 641, 1157, 1436, 1431 },
  { 643, 1430, 1428, 1147 },
  { 25, 1087, 701, 997 },
  { 1226, 1601, 1599, 1446 },
  { 1172, 1354, 219, 1628 },
  { 1541, 539, 1594, 0 },
  { 134, 1222, 455, 1355 },
  { 137, 1189, 941, 1221 },
  { 1007, 1423, 1387, 1009 },
  { 1482, 1234, 222, 1177 },
  { 460, 1211, 1265, 1212 },
  { 176, 1218, 1273, 1545 },
  { 1132, 1034, 864, 1191 },
  { 890, 374, 1423, 1445 },
  { 48, 1481, 967, 1142 },
  { 1181, 1527, 1629, 1639 },
  { 1606, 1317, 1540, 1685 },
  { 1606, 1540, 1699, 291 },
  { 1316, 939, 1324, 1248 },
  { 1538, 875, 1224, 944 },
  { 1491, 453, 939, 1525 },
  { 1237, 968, 250, 947 },
  { 665, 1011, 1034, 1236 },
  { 1245, 1489, 1015, 1395 },
  { 944, 266, 1466, 1485 },
  { 146, 1189, 1028, 1088 },
  { 1255, 1250, 1295, 964 },
  { 1519, 1256, 280, 665 },
  { 1470, 265, 1066, 95 },
  { 952, 168, 1521, 1426 },
  { 1581, 1238, 936, 1716 },
  { 553, 1181, 1629, 1474 },
  { 1597, 1714, 1292, 957 },
  { 1233, 1590, 1547, 1637 },
  { 1205, 173, 1493, 1300 },
  { 865, 1290, 1338, 1241 },
  { 1573, 136, 128, 104 },
  { 1020, 784, 1336, 391 },
  { 1280, 1293, 183, 1576 },
  { 1258, 1018, 983, 1255 },
  { 265, 865, 1254, 1241 },
  { 1159, 1257, 1242, 1453 },
  { 1256, 1020, 1519, 124 },
  { 1014, 1254, 59, 265 },
  { 1397, 613, 1053, 909 },
  { 1205, 1161, 1264, 1493 },
  { 1590, 2, 1413, 392 },
  { 1526, 1624, 1575, 1622 },
  { 963, 1304, 1534, 708 },
  { 1031, 1160, 1040, 1260 },
  { 1225, 1305, 1469, 1026 },
  { 1278, 587, 1169, 1548 },
  { 1141, 1268, 997, 1214 },
  { 117, 1036, 1269, 1267 },
  { 1268, 1312, 1087, 741 },
  { 1274, 1446, 1307, 1320 },
  { 1552, 1316, 1324, 1599 },
  { 1322, 1386, 962, 1275 },
  { 138, 1226, 1274, 216 },
  { 1273, 1270, 1049, 994 },
  { 1287, 1272, 1326, 1334 },
  { 1592, 1351, 673, 1636 },
  { 1510, 749, 1007, 1549 },
  { 1505, 1266, 1552, 1544 },
  { 1572, 1532, 319, 1293 },
  { 1253, 1023, 784, 1566 },
  { 1011, 1066, 59, 441 },
  { 364, 1287, 1289, 1516 },
  { 1456, 1663, 929, 237 },
  { 964, 1295, 832, 262 },
  { 947, 1549, 1048, 876 },
  { 1289, 1055, 1080, 1287 },
  { 1282, 1322, 1286, 1275 },
  { 876, 1517, 960, 1561 },
  { 775, 1286, 248, 1282 },
  { 1483, 172, 1250, 1588 },
  { 173, 1108, 1538, 944 },
  { 1596, 1247, 1093, 1607 },
  { 1188, 1279, 1253, 1577 },
  { 460, 1211, 1040, 865 },
  { 1241, 76, 1301, 1284 },
  { 779, 1603, 1592, 1391 },
  { 851, 981, 972, 709 },
  { 1023, 128, 1526, 1467 },
  { 1348, 1643, 1093, 995 },
  { 1249, 769, 1212, 1028 },
  { 983, 1302, 81, 1295 },
  { 1301, 953, 155, 76 },
  { 673, 1636, 1166, 1479 },
  { 1263, 112, 587, 1495 },
  { 1265, 1482, 110, 1177 },
  { 1203, 810, 1311, 1349 },
  { 1049, 1369, 873, 1270 },
  { 1025, 1582, 1490, 779 },
  { 1398, 1401, 1397, 1154 },
  { 1311, 1077, 847, 810 },
  { 1075, 1310, 256, 1306 },
  { 919, 1313, 216, 1269 },
  { 69, 1078, 1314, 1312 },
  { 1313, 1360, 16, 977 },
  { 157, 1170, 1647, 277 },
  { 1169, 1233, 1271, 1602 },
  { 1449, 1402, 1231, 328 },
  { 1609, 1547, 910, 1647 },
  { 1465, 1588, 964, 1344 },
  { 1270, 157, 1321, 254 },
  { 1320, 1174, 1186, 1358 },
  { 1062, 1272, 233, 1287 },
  { 1414, 1617, 1408, 1415 },
  { 1271, 1233, 1553, 1609 },
  { 327, 1342, 925, 490 },
  { 1275, 1333, 1337, 1373 },
  { 1383, 1392, 768, 1134 },
  { 1680, 1618, 1698, 1690 },
  { 1689, 1679, 1693, 1652 },
  { 1367, 930, 85, 1646 },
  { 784, 1023, 1365, 1575 },
  { 1333, 1337, 771, 1097 },
  { 1326, 1122, 1332, 1372 },
  { 1335, 958, 1275, 1373 },
  { 1516, 1564, 1334, 1110 },
  { 1024, 832, 905, 1252 },
  { 1326, 1080, 4, 1332 },
  { 1250, 172, 256, 1060 },
  { 1047, 1343, 1345, 1366 },
  { 1628, 1208, 1056, 1400 },
  { 1618, 1139, 1666, 1698 },
  { 1343, 1345, 1325, 1107 },
  { 1339, 1109, 1342, 1375 },
  { 1188, 1587, 1319, 522 },
  { 1339, 155, 259, 1342 },
  { 1657, 1607, 1645, 1433 },
  { 913, 988, 1090, 1086 },
  { 1637, 1299, 1547, 1170 },
  { 1350, 1306, 172, 1591 },
  { 468, 1490, 1203, 1349 },
  { 989, 851, 1357, 1276 },
  { 998, 1398, 1359, 1084 },
  { 27, 234, 963, 1713 },
  { 58, 535, 1219, 1471 },
  { 345, 1444, 1221, 1088 },
  { 1357, 996, 1164, 851 },
  { 847, 1356, 244, 1351 },
  { 1321, 1084, 1043, 254 },
  { 753, 1117, 1352, 1360 },
  { 1085, 1359, 254, 1314 },
  { 1371, 1443, 718, 1409 },
  { 269, 326, 714, 1194 },
  { 1430, 1641, 1428, 347 },
  { 523, 1004, 1456, 237 },
  { 832, 262, 1386, 1331 },
  { 1381, 1339, 943, 1461 },
  { 1059, 1385, 1178, 1330 },
  { 1384, 307, 1654, 1372 },
  { 1110, 1131, 1307, 1514 },
  { 1058, 1515, 1176, 1569 },
  { 1000, 1455, 1361, 1408 },
  { 1333, 1201, 1368, 916 },
  { 1334, 1326, 1131, 529 },
  { 943, 1461, 326, 1624 },
  { 1343, 863, 1184, 1664 },
  { 309, 1458, 864, 1421 },
  { 1159, 1521, 1453, 952 },
  { 145, 1559, 1561, 1551 },
  { 124, 1175, 1457, 929 },
  { 1663, 1619, 280, 1700 },
  { 262, 891, 1047, 1366 },
  { 1045, 1704, 1626, 1389 },
  { 116, 1114, 126, 1327 },
  { 1171, 771, 1368, 1185 },
  { 570, 1620, 1367, 1563 },
  { 1365, 943, 1272, 1575 },
  { 1422, 1223, 1449, 1511 },
  { 1202, 1593, 1391, 1589 },
  { 1424, 1574, 874, 1382 },
  { 1144, 911, 1536, 1209 },
  { 1388, 1637, 1296, 1644 },
  { 133, 1200, 1327, 897 },
  { 1398, 981, 1410, 1401 },
  { 1642, 613, 1597, 1678 },
  { 1581, 1238, 464, 392 },
  { 913, 1174, 988, 1598 },
  { 1153, 1309, 1086, 1259 },
  { 1352, 1393, 913, 1309 },
  { 1640, 1634, 1722, 1486 },
  { 1162, 1488, 1723, 1340 },
  { 1309, 1393, 1437, 323 },
  { 1101, 1, 1685, 1317 },
  { 1502, 1511, 1404, 1512 },
  { 1499, 1540, 1403, 1683 },
  { 1676, 1180, 1688, 1677 },
  { 1053, 1642, 1407, 1409 },
  { 1406, 125, 988, 1415 },
  { 1371, 1323, 1409, 602 },
  { 1408, 1406, 1361, 914 },
  { 1598, 1393, 995, 1596 },
  { 222, 1533, 1587, 1579 },
  { 948, 402, 1439, 1658 },
  { 1492, 499, 1489, 1261 },
  { 1115, 1323, 602, 65 },
  { 1416, 344, 1323, 1407 },
  { 1173, 889, 1415, 988 },
  { 1425, 62, 1466, 1530 },
  { 1419, 307, 1005, 252 },
  { 1115, 1418, 1420, 1694 },
  { 1421, 1419, 864, 840 },
  { 1376, 1196, 1420, 1133 },
  { 1448, 1510, 1387, 342 },
  { 945, 1228, 72, 1223 },
  { 503, 1389, 1660, 267 },
  { 12, 236, 1417, 1197 },
  { 1199, 1712, 1244, 1475 },
  { 238, 830, 347, 1463 },
  { 1182, 1363, 1429, 1216 },
  { 1428, 238, 1199, 862 },
  { 1167, 1363, 1431, 1216 },
  { 1430, 1435, 973, 1215 },
  { 301, 1498, 1481, 1143 },
  { 1487, 1346, 1656, 1648 },
  { 1674, 323, 1435, 1437 },
  { 1473, 1434, 1431, 1436 },
  { 345, 1435, 1088, 1215 },
  { 613, 1597, 1434, 1401 },
  { 449, 628, 1690, 948 },
  { 1412, 586, 1645, 160 },
  { 1152, 1625, 916, 1578 },
  { 1108, 173, 1450, 1497 },
  { 1534, 975, 963, 1496 },
  { 1361, 1682, 1143, 1052 },
  { 1678, 1640, 134, 1355 },
  { 1456, 931, 1228, 1619 },
  { 1218, 157, 1600, 1270 },
  { 1503, 1506, 1101, 1448 },
  { 1422, 1447, 1449, 1507 },
  { 1387, 1448, 1317, 53 },
  { 1451, 1441, 137, 1498 },
  { 1450, 1508, 1210, 1141 },
  { 252, 1649, 1702, 1695 },
  { 1377, 929, 1256, 1663 },
  { 1512, 1132, 1455, 1000 },
  { 1371, 226, 1454, 1499 },
  { 1364, 1445, 890, 1283 },
  { 1379, 1468, 890, 31 },
  { 1376, 1570, 952, 1662 },
  { 1005, 1194, 1462, 1702 },
  { 1633, 1140, 1461, 1631 },
  { 1366, 1460, 1664, 1374 },
  { 1196, 1459, 1706, 1570 },
  { 1427, 1665, 1003, 1706 },
  { 1527, 439, 136, 1584 },
  { 110, 1319, 95, 1577 },
  { 1177, 1239, 1417, 197 },
  { 271, 1058, 1298, 1567 },
  { 124, 945, 1457, 803 },
  { 1470, 1265, 110, 1522 },
  { 443, 1469, 1243, 1521 },
  { 1354, 575, 1207, 1711 },
  { 322, 1480, 1670, 1638 },
  { 1022, 1674, 1641, 1435 },
  { 275, 1246, 1172, 1718 },
  { 1570, 1708, 1706, 1426 },
  { 1673, 1675, 1674, 1715 },
  { 1492, 1489, 1607, 1093 },
  { 1206, 1148, 1641, 1022 },
  { 1536, 911, 1303, 1670 },
  { 623, 1472, 1673, 1719 },
  { 34, 1210, 1229, 1432 },
  { 1305, 1224, 1483, 1588 },
  { 1211, 468, 1290, 1482 },
  { 110, 1531, 1577, 1175 },
  { 769, 1239, 197, 1723 },
  { 1088, 1399, 1028, 1022 },
  { 125, 1596, 1598, 1433 },
  { 1400, 1724, 582, 1021 },
  { 1477, 0, 1238, 1413 },
  { 1538, 1539, 1350, 1308 },
  { 587, 1235, 1169, 1537 },
  { 1547, 1413, 910, 1477 },
  { 1249, 1260, 1211, 468 },
  { 1537, 1495, 18, 875 },
  { 708, 1304, 1494, 189 },
  { 1497, 229, 1442, 1721 },
  { 1496, 1441, 1498, 1720 },
  { 1432, 1497, 1450, 134 },
  { 1455, 1679, 1404, 1682 },
  { 1501, 947, 811, 876 },
  { 1502, 1500, 1512, 48 },
  { 34, 342, 1403, 1501 },
  { 1447, 1544, 1509, 975 },
  { 1108, 1539, 1548, 1508 },
  { 101, 1506, 1278, 1557 },
  { 1505, 336, 1447, 1507 },
  { 1006, 1506, 1448, 39 },
  { 1451, 1504, 940, 1546 },
  { 342, 1543, 34, 1503 },
  { 44, 1277, 1422, 1562 },
  { 1403, 1009, 1387, 1540 },
  { 1403, 1513, 1454, 1501 },
  { 1512, 280, 1132, 665 },
  { 1559, 1059, 1369, 1600 },
  { 1195, 285, 1565, 1370 },
  { 1048, 1282, 1517, 1335 },
  { 1288, 1516, 979, 1110 },
  { 1566, 1568, 421, 912 },
  { 1549, 1257, 1007, 1242 },
  { 421, 784, 391, 1564 },
  { 1470, 1522, 1377, 1244 },
  { 1521, 1469, 1523, 343 },
  { 1522, 1175, 929, 1630 },
  { 1621, 874, 1578, 1680 },
  { 1537, 1235, 974, 447 },
  { 1298, 664, 1262, 1058 },
  { 1464, 107, 1230, 1632 },
  { 222, 1579, 1529, 79 },
  { 1530, 278, 1528, 1532 },
  { 1417, 1529, 1177, 1531 },
  { 966, 1530, 1484, 1532 },
  { 1531, 1529, 1279, 206 },
  { 1411, 264, 1585, 1144 },
  { 1548, 1263, 1108, 1442 },
  { 1144, 1209, 1580, 406 },
  { 1390, 1479, 127, 1633 },
  { 1494, 1491, 1025, 1525 },
  { 1291, 1490, 468, 1234 },
  { 1504, 1490, 1582, 1546 },
  { 1231, 1511, 1232, 1404 },
  { 1607, 1220, 1645, 1180 },
  { 1543, 1551, 1561, 176 },
  { 1509, 1544, 1542, 940 },
  { 1278, 1548, 1543, 1503 },
  { 1546, 1601, 1226, 919 },
  { 1508, 1539, 1545, 1204 },
  { 1248, 1492, 1318, 1348 },
  { 1544, 1266, 1504, 1534 },
  { 1519, 391, 1285, 1277 },
  { 30, 1659, 1563, 1612 },
  { 1552, 1599, 1378, 1542 },
  { 1278, 1271, 1557, 1551 },
  { 1554, 1614, 1324, 87 },
  { 1555, 170, 1553, 1557 },
  { 232, 1554, 559, 1556 },
  { 1555, 1557, 145, 1006 },
  { 1556, 1554, 1552, 1505 },
  { 145, 214, 1559, 1560 },
  { 1378, 1558, 1110, 1514 },
  { 1558, 1121, 570, 559 },
  { 1562, 1378, 1288, 1542 },
  { 342, 1510, 876, 1561 },
  { 1385, 1621, 83, 1550 },
  { 1520, 958, 1335, 214 },
  { 1515, 186, 874, 1621 },
  { 1567, 1518, 1280, 183 },
  { 144, 1568, 1467, 1566 },
  { 1567, 423, 1569, 1518 },
  { 1568, 1370, 1121, 370 },
  { 1462, 1701, 1475, 1458 },
  { 128, 136, 1633, 1631 },
  { 1188, 1573, 1279, 1579 },
  { 1251, 434, 1572, 1580 },
  { 99, 1195, 1389, 1045 },
  { 1331, 1262, 1386, 958 },
  { 1020, 1577, 1253, 124 },
  { 1465, 1293, 1576, 1484 },
  { 1524, 1626, 1440, 1649 },
  { 1411, 1572, 1528, 1580 },
  { 1535, 1573, 1579, 178 },
  { 1589, 1395, 1245, 346 },
  { 1169, 1308, 1602, 1539 },
  { 26, 1584, 1181, 346 },
  { 1583, 1464, 1209, 404 },
  { 1587, 1533, 1057, 127 },
  { 1057, 673, 1103, 127 },
  { 1411, 1585, 1588, 1344 },
  { 1482, 1587, 1290, 1319 },
  { 1388, 1581, 1644, 911 },
  { 939, 1261, 1248, 1593 },
  { 1349, 779, 1592, 1057 },
  { 1591, 1296, 989, 1276 },
  { 974, 1590, 1388, 392 },
  { 1180, 1595, 1727, 1220 },
  { 1615, 550, 1021, 1594 },
  { 1597, 1292, 1410, 1487 },
  { 1437, 1247, 1596, 1394 },
  { 1396, 1410, 277, 1487 },
  { 1551, 1271, 1600, 1218 },
  { 1599, 1608, 1514, 1446 },
  { 1545, 1602, 1218, 1604 },
  { 1582, 1603, 1316, 1601 },
  { 1602, 1296, 1637, 1604 },
  { 1601, 1603, 1605, 837 },
  { 1604, 1170, 157, 1085 },
  { 52, 1231, 1232, 1183 },
  { 1477, 1541, 1346, 1292 },
  { 1609, 1647, 1059, 1600 },
  { 1324, 1318, 1614, 1608 },
  { 1611, 1658, 910, 92 },
  { 1612, 287, 1610, 1614 },
  { 242, 1611, 1550, 1613 },
  { 1612, 1614, 570, 559 },
  { 1613, 1611, 1609, 1553 },
  { 93, 1713, 1677, 1595 },
  { 1639, 1198, 1661, 1704 },
  { 1323, 344, 1694, 226 },
  { 1660, 497, 1341, 1328 },
  { 1380, 1445, 1009, 1699 },
  { 1176, 1621, 1152, 1385 },
  { 1620, 1565, 1524, 1563 },
  { 1176, 1262, 958, 1152 },
  { 324, 1666, 1667, 1705 },
  { 1262, 664, 1374, 1625 },
  { 1624, 1626, 326, 1440 },
  { 1382, 1703, 1625, 1578 },
  { 623, 1673, 347, 1641 },
  { 581, 1219, 1197, 1340 },
  { 1246, 1230, 119, 1193 },
  { 343, 1207, 1523, 1711 },
  { 1571, 1632, 1460, 664 },
  { 1631, 1527, 1639, 1045 },
  { 1571, 1536, 891, 1460 },
  { 1399, 1162, 1022, 1725 },
  { 1672, 1707, 1148, 623 },
  { 1276, 1644, 709, 1303 },
  { 1248, 1391, 1348, 1603 },
  { 1639, 1472, 1140, 1661 },
  { 1632, 1230, 1638, 1616 },
  { 1444, 1676, 1720, 1399 },
  { 1478, 1627, 1363, 1473 },
  { 1406, 1394, 125, 1052 },
  { 1644, 1299, 709, 936 },
  { 1391, 1643, 1636, 1589 },
  { 1346, 1541, 1439, 1651 },
  { 1647, 1656, 1330, 277 },
  { 1608, 1318, 1646, 1315 },
  { 125, 1652, 1433, 1693 },
  { 1650, 1578, 1452, 1680 },
  { 252, 1654, 1649, 1100 },
  { 1652, 586, 1688, 1645 },
  { 1681, 1329, 1651, 1648 },
  { 586, 1183, 1686, 507 },
  { 1655, 916, 1368, 1650 },
  { 889, 85, 1654, 1100 },
  { 1657, 1433, 930, 1646 },
  { 910, 1346, 1658, 1656 },
  { 1659, 1412, 1657, 1610 },
  { 948, 1658, 83, 1550 },
  { 1424, 874, 310, 1618 },
  { 1665, 1638, 1003, 1616 },
  { 1458, 1701, 1663, 1700 },
  { 1662, 1283, 1453, 1380 },
  { 1461, 1140, 1375, 714 },
  { 1463, 714, 1661, 1194 },
  { 267, 1341, 1004, 1623 },
  { 1623, 1695, 1701, 1702 },
  { 1206, 1148, 1669, 1712 },
  { 1668, 1056, 1026, 343 },
  { 1479, 1472, 1166, 1140 },
  { 1717, 1727, 315, 1015 },
  { 1208, 1172, 1635, 1718 },
  { 1480, 1119, 1627, 1476 },
  { 1473, 1476, 1434, 1714 },
  { 1476, 709, 1119, 972 },
  { 1678, 957, 1405, 1640 },
  { 1405, 1687, 1721, 1615 },
  { 1052, 1394, 1676, 1444 },
  { 291, 1499, 226, 1329 },
  { 1524, 1328, 1649, 1691 },
  { 1052, 1682, 1688, 1652 },
  { 1499, 1681, 1683, 1443 },
  { 1404, 1684, 301, 1682 },
  { 1683, 1685, 229, 1687 },
  { 1231, 1402, 1684, 1686 },
  { 1653, 1685, 1687, 235 },
  { 1688, 1686, 1684, 1677 },
  { 1681, 1687, 1405, 1651 },
  { 291, 1329, 1690, 628 },
  { 1691, 1328, 1689, 1438 },
  { 83, 1680, 1692, 1690 },
  { 1100, 930, 1691, 1693 },
  { 344, 1692, 1329, 1648 },
  { 1617, 252, 1419, 84 },
  { 1696, 1698, 1452, 1667 },
  { 84, 1697, 1695, 1700 },
  { 1696, 291, 1698, 1699 },
  { 1695, 1697, 1328, 1341 },
  { 1697, 931, 1619, 1232 },
  { 1662, 1696, 1380, 1002 },
  { 324, 1667, 1662, 1570 },
  { 1459, 1703, 1667, 1452 },
  { 1194, 1626, 1704, 1702 },
  { 1382, 1616, 1703, 1705 },
  { 1704, 1198, 1623, 267 },
  { 1462, 1463, 238, 1475 },
  { 1708, 1710, 1003, 1635 },
  { 1475, 1709, 1707, 1712 },
  { 1708, 324, 1710, 1711 },
  { 1707, 1709, 1198, 58 },
  { 1709, 1471, 1630, 237 },
  { 1668, 1708, 343, 1426 },
  { 1615, 1353, 1721, 1724 },
  { 1725, 1715, 1674, 1247 },
  { 1716, 936, 1476, 1714 },
  { 1245, 1717, 1715, 1719 },
  { 1716, 1671, 1726, 1718 },
  { 1719, 1717, 1672, 1474 },
  { 322, 1716, 1480, 1718 },
  { 1640, 1721, 1497, 1722 },
  { 1720, 1677, 1496, 1713 },
  { 1720, 1723, 769, 1399 },
  { 1722, 1724, 1485, 1400 },
  { 1723, 234, 1488, 1713 },
  { 957, 1726, 1634, 1714 },
  { 1727, 1162, 1725, 1717 },
  { 1726, 1594, 1021, 1671 }
};

static const unsigned V[1728][4] = {
  { 31, 279, 32, 39 },
  { 48, 1, 0, 41 },
  { 23, 24, 72, 31 },
  { 59, 11, 51, 60 },
  { 226, 169, 218, 178 },
  { 62, 22, 15, 70 },
  { 68, 116, 108, 59 },
  { 60, 59, 108, 51 },
  { 54, 6, 7, 14 },
  { 3, 251, 11, 10 },
  { 7, 8, 0, 48 },
  { 68, 20, 11, 60 },
  { 5, 54, 6, 45 },
  { 55, 7, 56, 15 },
  { 91, 138, 90, 50 },
  { 3, 11, 51, 58 },
  { 176, 168, 216, 169 },
  { 57, 58, 106, 66 },
  { 62, 14, 15, 22 },
  { 73, 65, 120, 113 },
  { 122, 114, 115, 67 },
  { 62, 63, 15, 55 },
  { 68, 76, 21, 69 },
  { 102, 110, 62, 55 },
  { 174, 166, 167, 119 },
  { 161, 153, 208, 201 },
  { 29, 30, 78, 38 },
  { 47, 0, 48, 7 },
  { 18, 10, 9, 58 },
  { 166, 109, 158, 118 },
  { 34, 74, 26, 25 },
  { 3, 4, 52, 12 },
  { 66, 19, 67, 74 },
  { 64, 24, 17, 72 },
  { 248, 193, 241, 201 },
  { 197, 204, 149, 157 },
  { 17, 66, 9, 57 },
  { 204, 196, 149, 156 },
  { 31, 80, 72, 79 },
  { 1, 10, 58, 9 },
  { 74, 27, 75, 82 },
  { 43, 92, 44, 35 },
  { 60, 52, 5, 12 },
  { 160, 105, 152, 153 },
  { 258, 249, 18, 10 },
  { 116, 69, 68, 61 },
  { 21, 70, 69, 78 },
  { 177, 169, 226, 178 },
  { 201, 153, 193, 202 },
  { 1, 50, 49, 58 },
  { 93, 140, 92, 52 },
  { 108, 53, 101, 61 },
  { 41, 90, 2, 42 },
  { 1, 2, 50, 10 },
  { 98, 51, 91, 139 },
  { 87, 86, 134, 79 },
  { 172, 115, 164, 124 },
  { 163, 155, 212, 164 },
  { 285, 277, 44, 37 },
  { 212, 155, 204, 164 },
  { 81, 73, 82, 33 },
  { 13, 61, 53, 60 },
  { 5, 6, 54, 14 },
  { 114, 66, 67, 74 },
  { 100, 108, 99, 51 },
  { 185, 146, 186, 234 },
  { 62, 7, 55, 15 },
  { 144, 96, 137, 97 },
  { 83, 82, 130, 75 },
  { 175, 216, 167, 215 },
  { 48, 88, 89, 41 },
  { 29, 78, 69, 77 },
  { 50, 2, 3, 10 },
  { 153, 105, 145, 154 },
  { 33, 82, 34, 25 },
  { 66, 18, 9, 58 },
  { 173, 220, 213, 165 },
  { 149, 198, 197, 206 },
  { 130, 138, 129, 81 },
  { 13, 14, 62, 22 },
  { 75, 76, 124, 84 },
  { 220, 163, 212, 172 },
  { 114, 66, 59, 67 },
  { 273, 265, 34, 274 },
  { 235, 194, 242, 282 },
  { 225, 217, 274, 226 },
  { 76, 28, 19, 68 },
  { 64, 16, 17, 24 },
  { 128, 120, 79, 127 },
  { 75, 84, 124, 132 },
  { 25, 74, 17, 65 },
  { 125, 172, 165, 117 },
  { 72, 24, 25, 32 },
  { 47, 40, 88, 0 },
  { 73, 122, 113, 121 },
  { 260, 212, 252, 205 },
  { 106, 58, 59, 66 },
  { 1, 56, 49, 48 },
  { 129, 130, 81, 121 },
  { 36, 76, 28, 27 },
  { 155, 202, 147, 154 },
  { 56, 8, 9, 16 },
  { 41, 90, 42, 33 },
  { 54, 7, 6, 47 },
  { 28, 20, 68, 21 },
  { 3, 12, 60, 11 },
  { 18, 10, 58, 11 },
  { 36, 29, 28, 76 },
  { 5, 93, 45, 52 },
  { 133, 134, 85, 125 },
  { 253, 252, 245, 205 },
  { 96, 48, 89, 49 },
  { 7, 8, 56, 15 },
  { 5, 13, 53, 60 },
  { 54, 7, 55, 62 },
  { 73, 122, 121, 130 },
  { 148, 141, 188, 189 },
  { 167, 208, 159, 207 },
  { 82, 35, 90, 42 },
  { 37, 29, 36, 84 },
  { 3, 12, 52, 60 },
  { 55, 104, 63, 56 },
  { 70, 23, 15, 63 },
  { 1, 89, 41, 48 },
  { 12, 243, 252, 251 },
  { 280, 225, 233, 232 },
  { 196, 148, 236, 189 },
  { 221, 213, 261, 270 },
  { 28, 268, 20, 261 },
  { 84, 37, 85, 92 },
  { 99, 148, 147, 156 },
  { 1, 9, 49, 56 },
  { 103, 55, 96, 104 },
  { 236, 188, 179, 228 },
  { 199, 192, 240, 200 },
  { 15, 23, 64, 63 },
  { 21, 261, 269, 28 },
  { 159, 200, 199, 207 },
  { 209, 161, 208, 201 },
  { 121, 113, 161, 170 },
  { 135, 142, 134, 87 },
  { 15, 64, 56, 63 },
  { 94, 86, 85, 134 },
  { 92, 84, 44, 35 },
  { 19, 20, 11, 68 },
  { 257, 249, 18, 258 },
  { 206, 198, 151, 158 },
  { 98, 91, 138, 139 },
  { 70, 71, 23, 63 },
  { 5, 60, 53, 52 },
  { 55, 96, 104, 56 },
  { 149, 158, 198, 206 },
  { 91, 90, 83, 43 },
  { 99, 156, 147, 107 },
  { 116, 67, 107, 59 },
  { 180, 220, 173, 172 },
  { 50, 90, 91, 43 },
  { 224, 216, 264, 217 },
  { 161, 153, 210, 162 },
  { 127, 135, 182, 134 },
  { 80, 32, 33, 40 },
  { 138, 89, 137, 129 },
  { 100, 51, 91, 52 },
  { 39, 40, 80, 88 },
  { 157, 109, 149, 158 },
  { 169, 161, 218, 170 },
  { 1, 58, 49, 9 },
  { 92, 52, 91, 43 },
  { 197, 196, 149, 204 },
  { 23, 71, 64, 63 },
  { 64, 16, 9, 17 },
  { 54, 14, 7, 62 },
  { 222, 213, 262, 214 },
  { 247, 254, 199, 207 },
  { 128, 136, 135, 87 },
  { 45, 54, 6, 94 },
  { 209, 201, 208, 256 },
  { 58, 57, 49, 9 },
  { 13, 22, 70, 21 },
  { 20, 12, 11, 60 },
  { 112, 72, 64, 65 },
  { 67, 76, 68, 116 },
  { 166, 109, 157, 158 },
  { 251, 12, 11, 20 },
  { 15, 16, 56, 64 },
  { 10, 11, 3, 58 },
  { 34, 27, 26, 74 },
  { 51, 98, 91, 50 },
  { 7, 8, 48, 56 },
  { 62, 14, 7, 15 },
  { 1, 10, 50, 58 },
  { 117, 164, 157, 109 },
  { 5, 62, 53, 13 },
  { 108, 116, 68, 61 },
  { 181, 173, 230, 182 },
  { 23, 24, 64, 72 },
  { 127, 174, 119, 126 },
  { 6, 245, 246, 254 },
  { 81, 90, 89, 41 },
  { 56, 16, 9, 64 },
  { 55, 56, 48, 96 },
  { 21, 70, 61, 69 },
  { 66, 58, 11, 18 },
  { 23, 72, 64, 71 },
  { 61, 118, 70, 110 },
  { 76, 75, 67, 27 },
  { 13, 60, 5, 12 },
  { 5, 54, 53, 62 },
  { 210, 153, 202, 162 },
  { 63, 64, 56, 104 },
  { 108, 59, 99, 51 },
  { 83, 92, 91, 43 },
  { 57, 106, 105, 114 },
  { 64, 72, 17, 65 },
  { 266, 258, 18, 259 },
  { 104, 64, 56, 57 },
  { 168, 161, 208, 216 },
  { 268, 260, 20, 261 },
  { 94, 86, 134, 87 },
  { 45, 94, 46, 37 },
  { 84, 76, 36, 27 },
  { 3, 60, 51, 11 },
  { 14, 253, 262, 22 },
  { 3, 52, 51, 60 },
  { 117, 109, 166, 118 },
  { 118, 110, 111, 63 },
  { 242, 194, 233, 282 },
  { 112, 57, 104, 105 },
  { 120, 80, 72, 73 },
  { 0, 240, 241, 248 },
  { 55, 7, 48, 56 },
  { 65, 114, 113, 122 },
  { 17, 18, 9, 66 },
  { 171, 163, 220, 172 },
  { 6, 247, 47, 7 },
  { 88, 40, 41, 0 },
  { 4, 245, 45, 5 },
  { 244, 4, 44, 283 },
  { 237, 196, 236, 189 },
  { 13, 60, 20, 68 },
  { 65, 66, 114, 74 },
  { 159, 152, 111, 151 },
  { 25, 26, 17, 74 },
  { 13, 21, 61, 68 },
  { 230, 173, 222, 182 },
  { 234, 146, 186, 187 },
  { 173, 165, 222, 174 },
  { 60, 61, 53, 108 },
  { 218, 161, 210, 170 },
  { 3, 58, 51, 50 },
  { 210, 202, 155, 162 },
  { 31, 39, 80, 79 },
  { 282, 235, 234, 227 },
  { 158, 150, 103, 110 },
  { 176, 169, 216, 224 },
  { 94, 54, 93, 45 },
  { 222, 165, 214, 174 },
  { 57, 66, 114, 65 },
  { 116, 76, 68, 69 },
  { 228, 171, 220, 180 },
  { 58, 106, 98, 49 },
  { 179, 171, 228, 180 },
  { 268, 220, 260, 213 },
  { 66, 58, 9, 57 },
  { 270, 262, 22, 263 },
  { 212, 204, 205, 157 },
  { 6, 14, 247, 7 },
  { 275, 44, 36, 35 },
  { 117, 109, 157, 166 },
  { 227, 236, 179, 228 },
  { 64, 17, 9, 57 },
  { 28, 20, 19, 68 },
  { 120, 65, 112, 113 },
  { 87, 88, 128, 136 },
  { 13, 68, 61, 60 },
  { 86, 37, 38, 46 },
  { 52, 5, 4, 45 },
  { 225, 217, 224, 272 },
  { 5, 14, 62, 13 },
  { 29, 78, 77, 86 },
  { 195, 242, 250, 243 },
  { 53, 110, 101, 61 },
  { 114, 106, 107, 59 },
  { 27, 76, 19, 67 },
  { 61, 118, 110, 109 },
  { 26, 27, 19, 74 },
  { 67, 115, 116, 107 },
  { 72, 24, 17, 25 },
  { 13, 22, 62, 70 },
  { 1, 89, 50, 41 },
  { 33, 82, 81, 90 },
  { 282, 42, 281, 242 },
  { 69, 78, 70, 118 },
  { 82, 35, 83, 90 },
  { 118, 71, 70, 63 },
  { 1, 8, 48, 0 },
  { 13, 62, 53, 61 },
  { 23, 16, 64, 24 },
  { 68, 60, 11, 59 },
  { 136, 89, 81, 129 },
  { 76, 29, 21, 69 },
  { 240, 193, 241, 248 },
  { 35, 84, 83, 92 },
  { 90, 82, 42, 33 },
  { 57, 106, 97, 105 },
  { 72, 80, 25, 73 },
  { 10, 58, 3, 50 },
  { 227, 234, 179, 187 },
  { 164, 156, 109, 116 },
  { 147, 196, 195, 204 },
  { 35, 27, 34, 82 },
  { 77, 85, 86, 134 },
  { 98, 58, 51, 106 },
  { 90, 35, 43, 42 },
  { 15, 63, 56, 55 },
  { 39, 86, 38, 46 },
  { 184, 96, 143, 136 },
  { 69, 116, 109, 61 },
  { 66, 11, 59, 19 },
  { 20, 12, 60, 13 },
  { 50, 58, 98, 49 },
  { 5, 14, 54, 62 },
  { 277, 269, 38, 278 },
  { 191, 238, 231, 183 },
  { 284, 244, 44, 283 },
  { 183, 191, 238, 190 },
  { 227, 219, 276, 228 },
  { 228, 236, 188, 181 },
  { 1, 50, 2, 41 },
  { 90, 35, 83, 43 },
  { 103, 55, 104, 63 },
  { 3, 52, 4, 43 },
  { 141, 148, 188, 100 },
  { 146, 106, 154, 97 },
  { 70, 30, 23, 78 },
  { 48, 8, 1, 56 },
  { 56, 8, 1, 9 },
  { 52, 4, 5, 12 },
  { 65, 17, 57, 66 },
  { 27, 28, 19, 76 },
  { 138, 91, 83, 131 },
  { 62, 70, 15, 63 },
  { 250, 241, 201, 249 },
  { 244, 197, 285, 245 },
  { 282, 233, 225, 234 },
  { 239, 151, 191, 192 },
  { 38, 269, 30, 278 },
  { 237, 189, 229, 238 },
  { 230, 190, 238, 181 },
  { 140, 91, 92, 52 },
  { 96, 136, 89, 48 },
  { 142, 54, 94, 95 },
  { 106, 57, 97, 49 },
  { 65, 74, 114, 122 },
  { 118, 158, 111, 110 },
  { 70, 78, 23, 71 },
  { 78, 31, 23, 71 },
  { 128, 136, 81, 129 },
  { 74, 73, 65, 25 },
  { 29, 38, 78, 86 },
  { 119, 160, 111, 159 },
  { 26, 18, 17, 66 },
  { 118, 126, 78, 71 },
  { 47, 88, 48, 0 },
  { 211, 210, 203, 163 },
  { 132, 84, 124, 77 },
  { 154, 106, 105, 97 },
  { 13, 70, 61, 21 },
  { 44, 37, 36, 84 },
  { 132, 140, 83, 92 },
  { 26, 18, 66, 19 },
  { 102, 54, 55, 62 },
  { 52, 60, 100, 51 },
  { 110, 70, 62, 63 },
  { 50, 3, 2, 43 },
  { 116, 76, 69, 124 },
  { 139, 91, 138, 131 },
  { 82, 73, 74, 25 },
  { 89, 88, 81, 41 },
  { 75, 122, 115, 67 },
  { 21, 30, 70, 78 },
  { 138, 89, 129, 81 },
  { 100, 53, 101, 108 },
  { 13, 62, 61, 70 },
  { 94, 39, 47, 46 },
  { 15, 8, 56, 16 },
  { 59, 19, 68, 67 },
  { 86, 39, 31, 79 },
  { 90, 82, 130, 83 },
  { 142, 85, 133, 134 },
  { 148, 101, 141, 189 },
  { 211, 258, 251, 203 },
  { 31, 30, 23, 271 },
  { 78, 79, 31, 71 },
  { 81, 73, 128, 121 },
  { 104, 49, 57, 56 },
  { 70, 22, 23, 30 },
  { 114, 74, 67, 122 },
  { 101, 110, 158, 109 },
  { 90, 50, 89, 41 },
  { 77, 125, 126, 117 },
  { 31, 79, 72, 71 },
  { 80, 32, 25, 33 },
  { 88, 33, 81, 41 },
  { 21, 30, 78, 29 },
  { 78, 30, 23, 31 },
  { 21, 22, 70, 30 },
  { 37, 86, 85, 94 },
  { 178, 121, 170, 130 },
  { 158, 103, 151, 111 },
  { 124, 116, 117, 69 },
  { 53, 54, 102, 62 },
  { 56, 57, 9, 49 },
  { 139, 186, 138, 98 },
  { 134, 86, 126, 79 },
  { 113, 105, 162, 114 },
  { 140, 91, 83, 92 },
  { 148, 101, 149, 156 },
  { 75, 124, 123, 132 },
  { 183, 238, 230, 190 },
  { 56, 64, 9, 57 },
  { 259, 258, 18, 251 },
  { 182, 174, 175, 127 },
  { 19, 66, 11, 18 },
  { 58, 11, 51, 59 },
  { 128, 88, 81, 136 },
  { 54, 47, 6, 94 },
  { 53, 102, 101, 110 },
  { 23, 31, 72, 71 },
  { 106, 66, 59, 114 },
  { 71, 118, 111, 63 },
  { 58, 57, 106, 49 },
  { 74, 19, 67, 27 },
  { 19, 68, 11, 59 },
  { 13, 68, 20, 21 },
  { 78, 86, 31, 79 },
  { 112, 152, 111, 160 },
  { 72, 32, 25, 80 },
  { 60, 108, 53, 100 },
  { 28, 29, 21, 76 },
  { 126, 86, 78, 79 },
  { 163, 155, 203, 212 },
  { 77, 86, 78, 126 },
  { 197, 204, 157, 205 },
  { 169, 121, 161, 170 },
  { 129, 137, 184, 136 },
  { 79, 126, 119, 71 },
  { 70, 22, 15, 23 },
  { 50, 58, 51, 98 },
  { 42, 82, 34, 33 },
  { 57, 114, 105, 65 },
  { 58, 11, 59, 66 },
  { 21, 78, 69, 29 },
  { 15, 16, 64, 23 },
  { 64, 65, 17, 57 },
  { 151, 192, 200, 152 },
  { 65, 72, 120, 112 },
  { 145, 146, 154, 97 },
  { 84, 75, 76, 27 },
  { 125, 172, 117, 124 },
  { 205, 157, 197, 206 },
  { 147, 99, 154, 146 },
  { 77, 85, 134, 125 },
  { 174, 117, 166, 126 },
  { 78, 30, 31, 38 },
  { 33, 73, 82, 25 },
  { 72, 25, 17, 65 },
  { 80, 33, 25, 73 },
  { 262, 214, 254, 207 },
  { 67, 114, 107, 59 },
  { 66, 19, 59, 67 },
  { 156, 148, 101, 108 },
  { 132, 124, 125, 77 },
  { 3, 51, 91, 50 },
  { 123, 122, 115, 75 },
  { 112, 104, 63, 111 },
  { 52, 45, 4, 92 },
  { 90, 43, 2, 42 },
  { 108, 116, 107, 59 },
  { 60, 68, 61, 108 },
  { 76, 68, 19, 67 },
  { 28, 76, 21, 68 },
  { 82, 27, 34, 74 },
  { 98, 106, 97, 49 },
  { 26, 74, 19, 66 },
  { 74, 26, 17, 66 },
  { 74, 66, 17, 65 },
  { 110, 63, 62, 55 },
  { 68, 69, 21, 61 },
  { 144, 96, 103, 143 },
  { 180, 188, 133, 181 },
  { 73, 74, 122, 82 },
  { 100, 91, 140, 52 },
  { 35, 92, 83, 43 },
  { 67, 75, 124, 115 },
  { 31, 32, 80, 39 },
  { 77, 37, 86, 85 },
  { 42, 35, 34, 82 },
  { 60, 68, 108, 59 },
  { 31, 24, 72, 32 },
  { 86, 39, 94, 46 },
  { 114, 154, 107, 106 },
  { 84, 29, 36, 76 },
  { 35, 84, 36, 27 },
  { 65, 114, 105, 113 },
  { 72, 73, 25, 65 },
  { 166, 158, 159, 111 },
  { 88, 40, 33, 41 },
  { 31, 32, 72, 80 },
  { 104, 57, 112, 64 },
  { 65, 57, 112, 105 },
  { 99, 51, 106, 98 },
  { 113, 105, 153, 162 },
  { 92, 37, 85, 45 },
  { 82, 27, 75, 35 },
  { 74, 27, 67, 75 },
  { 129, 128, 176, 121 },
  { 122, 162, 115, 114 },
  { 29, 86, 77, 37 },
  { 3, 91, 43, 50 },
  { 82, 74, 34, 25 },
  { 130, 121, 170, 122 },
  { 268, 260, 261, 213 },
  { 43, 92, 4, 44 },
  { 84, 37, 92, 44 },
  { 43, 52, 4, 92 },
  { 76, 29, 77, 84 },
  { 84, 29, 77, 37 },
  { 76, 29, 69, 77 },
  { 274, 226, 266, 219 },
  { 94, 47, 39, 87 },
  { 136, 95, 135, 87 },
  { 85, 94, 93, 45 },
  { 119, 112, 71, 111 },
  { 80, 33, 81, 88 },
  { 92, 37, 45, 44 },
  { 50, 43, 2, 90 },
  { 83, 75, 84, 35 },
  { 44, 84, 36, 35 },
  { 39, 32, 80, 40 },
  { 173, 125, 165, 174 },
  { 107, 154, 99, 106 },
  { 176, 184, 129, 177 },
  { 140, 93, 85, 133 },
  { 126, 79, 78, 71 },
  { 124, 76, 77, 84 },
  { 87, 88, 39, 80 },
  { 61, 69, 118, 109 },
  { 75, 124, 115, 123 },
  { 68, 67, 116, 59 },
  { 39, 40, 88, 47 },
  { 31, 78, 38, 86 },
  { 31, 86, 38, 39 },
  { 29, 38, 86, 37 },
  { 87, 47, 39, 88 },
  { 94, 86, 46, 37 },
  { 80, 33, 73, 81 },
  { 145, 154, 105, 97 },
  { 149, 206, 197, 157 },
  { 257, 18, 17, 26 },
  { 33, 90, 81, 41 },
  { 69, 77, 78, 126 },
  { 80, 40, 33, 88 },
  { 3, 91, 52, 43 },
  { 41, 50, 2, 90 },
  { 35, 75, 84, 27 },
  { 82, 35, 75, 83 },
  { 48, 88, 41, 0 },
  { 84, 37, 77, 85 },
  { 112, 57, 65, 64 },
  { 265, 257, 26, 266 },
  { 176, 121, 168, 169 },
  { 132, 123, 172, 124 },
  { 37, 94, 85, 45 },
  { 5, 93, 54, 45 },
  { 92, 45, 4, 44 },
  { 95, 48, 96, 55 },
  { 79, 87, 39, 80 },
  { 86, 87, 39, 79 },
  { 85, 84, 132, 77 },
  { 69, 117, 118, 109 },
  { 45, 94, 6, 46 },
  { 94, 47, 6, 46 },
  { 1, 49, 50, 89 },
  { 1, 49, 89, 48 },
  { 159, 158, 151, 111 },
  { 281, 40, 33, 273 },
  { 255, 16, 8, 15 },
  { 97, 49, 57, 104 },
  { 182, 125, 173, 174 },
  { 133, 125, 182, 134 },
  { 130, 138, 81, 90 },
  { 3, 51, 52, 91 },
  { 104, 97, 152, 105 },
  { 130, 122, 123, 75 },
  { 99, 98, 106, 146 },
  { 86, 94, 39, 87 },
  { 52, 92, 93, 45 },
  { 93, 92, 85, 45 },
  { 5, 53, 93, 52 },
  { 5, 53, 54, 93 },
  { 73, 82, 130, 81 },
  { 185, 145, 146, 194 },
  { 69, 126, 118, 117 },
  { 96, 56, 48, 49 },
  { 54, 47, 94, 95 },
  { 95, 47, 94, 87 },
  { 87, 47, 88, 95 },
  { 95, 47, 88, 48 },
  { 95, 7, 47, 48 },
  { 55, 7, 95, 48 },
  { 54, 7, 95, 55 },
  { 54, 7, 47, 95 },
  { 239, 191, 232, 192 },
  { 145, 97, 152, 144 },
  { 119, 166, 111, 118 },
  { 65, 74, 122, 73 },
  { 128, 129, 81, 121 },
  { 65, 122, 113, 73 },
  { 67, 124, 76, 116 },
  { 188, 139, 131, 140 },
  { 180, 188, 131, 140 },
  { 162, 154, 107, 114 },
  { 286, 237, 277, 229 },
  { 67, 75, 76, 124 },
  { 132, 140, 85, 133 },
  { 146, 98, 106, 97 },
  { 53, 62, 102, 110 },
  { 281, 273, 33, 42 },
  { 110, 118, 70, 63 },
  { 108, 107, 99, 59 },
  { 98, 49, 89, 50 },
  { 92, 84, 132, 85 },
  { 75, 84, 132, 83 },
  { 178, 121, 169, 170 },
  { 99, 51, 59, 106 },
  { 97, 49, 104, 96 },
  { 96, 49, 104, 56 },
  { 103, 104, 96, 144 },
  { 61, 109, 110, 101 },
  { 69, 126, 78, 118 },
  { 198, 150, 151, 158 },
  { 117, 164, 109, 116 },
  { 149, 150, 198, 158 },
  { 122, 74, 67, 75 },
  { 115, 162, 155, 107 },
  { 129, 177, 178, 169 },
  { 164, 156, 157, 109 },
  { 148, 99, 139, 100 },
  { 107, 106, 99, 59 },
  { 52, 60, 53, 100 },
  { 53, 100, 93, 52 },
  { 186, 137, 129, 138 },
  { 186, 139, 131, 179 },
  { 127, 120, 79, 119 },
  { 69, 77, 126, 117 },
  { 178, 186, 129, 138 },
  { 102, 55, 103, 110 },
  { 60, 108, 100, 51 },
  { 128, 73, 120, 121 },
  { 180, 123, 172, 132 },
  { 79, 80, 128, 87 },
  { 120, 113, 160, 168 },
  { 67, 124, 116, 115 },
  { 276, 267, 28, 268 },
  { 195, 202, 203, 250 },
  { 124, 76, 69, 77 },
  { 93, 94, 85, 142 },
  { 53, 54, 93, 102 },
  { 102, 54, 95, 55 },
  { 150, 103, 151, 158 },
  { 96, 95, 143, 136 },
  { 143, 95, 135, 136 },
  { 230, 221, 270, 222 },
  { 144, 104, 96, 97 },
  { 102, 54, 142, 95 },
  { 53, 62, 110, 61 },
  { 61, 70, 62, 110 },
  { 112, 105, 152, 160 },
  { 57, 66, 106, 114 },
  { 152, 112, 111, 104 },
  { 106, 58, 51, 59 },
  { 71, 112, 63, 111 },
  { 105, 57, 104, 97 },
  { 79, 80, 72, 120 },
  { 137, 96, 184, 136 },
  { 192, 144, 145, 152 },
  { 123, 170, 163, 115 },
  { 186, 137, 138, 98 },
  { 176, 128, 127, 168 },
  { 166, 158, 111, 118 },
  { 101, 158, 149, 109 },
  { 149, 158, 206, 157 },
  { 124, 164, 117, 116 },
  { 190, 133, 181, 182 },
  { 133, 188, 140, 141 },
  { 91, 98, 138, 50 },
  { 122, 74, 75, 82 },
  { 111, 104, 63, 103 },
  { 110, 55, 103, 63 },
  { 116, 108, 109, 61 },
  { 161, 113, 160, 153 },
  { 111, 158, 103, 110 },
  { 163, 115, 155, 164 },
  { 147, 99, 107, 154 },
  { 109, 156, 101, 108 },
  { 109, 108, 101, 61 },
  { 101, 148, 141, 100 },
  { 255, 14, 7, 247 },
  { 231, 230, 278, 223 },
  { 134, 174, 127, 126 },
  { 172, 180, 132, 125 },
  { 172, 164, 165, 117 },
  { 129, 121, 176, 169 },
  { 229, 236, 276, 228 },
  { 115, 107, 155, 164 },
  { 119, 118, 111, 71 },
  { 111, 110, 103, 63 },
  { 192, 145, 193, 200 },
  { 194, 146, 154, 145 },
  { 99, 108, 148, 156 },
  { 77, 124, 117, 69 },
  { 61, 69, 70, 118 },
  { 118, 78, 70, 71 },
  { 71, 72, 64, 112 },
  { 63, 112, 71, 64 },
  { 63, 104, 112, 64 },
  { 95, 88, 136, 48 },
  { 79, 120, 71, 119 },
  { 113, 65, 112, 105 },
  { 112, 72, 120, 71 },
  { 120, 112, 71, 119 },
  { 120, 72, 79, 71 },
  { 121, 128, 168, 120 },
  { 148, 100, 101, 108 },
  { 120, 80, 73, 128 },
  { 134, 125, 174, 126 },
  { 87, 128, 79, 127 },
  { 65, 72, 73, 120 },
  { 118, 109, 158, 110 },
  { 101, 110, 150, 158 },
  { 168, 160, 119, 167 },
  { 115, 114, 107, 67 },
  { 132, 140, 131, 83 },
  { 168, 113, 160, 161 },
  { 87, 80, 128, 88 },
  { 161, 113, 153, 162 },
  { 156, 101, 149, 109 },
  { 122, 113, 162, 114 },
  { 251, 258, 18, 10 },
  { 119, 166, 159, 111 },
  { 116, 156, 109, 108 },
  { 117, 116, 109, 69 },
  { 183, 224, 175, 223 },
  { 154, 146, 99, 106 },
  { 126, 118, 119, 71 },
  { 116, 107, 156, 108 },
  { 150, 102, 190, 143 },
  { 128, 135, 127, 87 },
  { 127, 126, 119, 79 },
  { 183, 190, 182, 135 },
  { 164, 107, 156, 116 },
  { 112, 160, 111, 119 },
  { 131, 132, 83, 123 },
  { 73, 130, 121, 81 },
  { 136, 88, 81, 89 },
  { 121, 73, 120, 113 },
  { 160, 152, 111, 159 },
  { 187, 148, 236, 196 },
  { 247, 246, 199, 254 },
  { 162, 154, 155, 107 },
  { 178, 186, 179, 226 },
  { 172, 115, 163, 164 },
  { 128, 80, 81, 88 },
  { 128, 80, 73, 81 },
  { 170, 210, 163, 162 },
  { 83, 130, 90, 138 },
  { 77, 134, 86, 126 },
  { 73, 82, 122, 130 },
  { 270, 262, 263, 215 },
  { 127, 182, 174, 134 },
  { 83, 130, 123, 75 },
  { 176, 136, 135, 128 },
  { 162, 153, 202, 154 },
  { 211, 251, 259, 260 },
  { 174, 166, 119, 126 },
  { 187, 99, 139, 148 },
  { 136, 88, 89, 48 },
  { 93, 100, 140, 52 },
  { 138, 89, 81, 90 },
  { 115, 162, 107, 114 },
  { 99, 51, 139, 100 },
  { 121, 113, 170, 122 },
  { 162, 105, 154, 114 },
  { 90, 82, 81, 130 },
  { 85, 132, 125, 77 },
  { 125, 124, 117, 77 },
  { 104, 97, 144, 152 },
  { 93, 54, 142, 102 },
  { 77, 134, 126, 125 },
  { 92, 84, 83, 132 },
  { 75, 132, 123, 83 },
  { 115, 107, 164, 116 },
  { 3, 12, 11, 251 },
  { 170, 162, 163, 115 },
  { 141, 142, 133, 190 },
  { 87, 88, 136, 95 },
  { 134, 126, 127, 79 },
  { 87, 134, 127, 79 },
  { 127, 168, 119, 167 },
  { 175, 222, 215, 167 },
  { 210, 153, 201, 202 },
  { 85, 140, 92, 93 },
  { 79, 80, 120, 128 },
  { 130, 82, 122, 75 },
  { 137, 89, 136, 129 },
  { 184, 143, 135, 136 },
  { 178, 186, 131, 179 },
  { 170, 113, 162, 122 },
  { 130, 131, 83, 123 },
  { 83, 138, 90, 91 },
  { 138, 89, 90, 50 },
  { 127, 135, 134, 87 },
  { 139, 51, 91, 100 },
  { 99, 146, 139, 98 },
  { 188, 141, 133, 181 },
  { 123, 115, 163, 172 },
  { 100, 91, 139, 140 },
  { 132, 133, 85, 125 },
  { 130, 138, 83, 131 },
  { 229, 236, 181, 189 },
  { 101, 102, 150, 110 },
  { 220, 211, 260, 212 },
  { 172, 163, 212, 164 },
  { 93, 85, 133, 142 },
  { 140, 91, 131, 83 },
  { 140, 91, 139, 131 },
  { 223, 216, 175, 215 },
  { 103, 55, 143, 96 },
  { 95, 136, 96, 48 },
  { 187, 194, 146, 147 },
  { 170, 162, 115, 122 },
  { 105, 112, 152, 104 },
  { 155, 107, 147, 156 },
  { 126, 117, 166, 118 },
  { 123, 115, 172, 124 },
  { 133, 125, 173, 182 },
  { 182, 222, 175, 174 },
  { 135, 95, 142, 87 },
  { 142, 95, 94, 87 },
  { 134, 142, 94, 87 },
  { 183, 230, 223, 175 },
  { 196, 148, 149, 156 },
  { 184, 137, 129, 177 },
  { 130, 170, 123, 122 },
  { 98, 89, 138, 50 },
  { 98, 89, 137, 138 },
  { 96, 89, 136, 137 },
  { 96, 49, 89, 137 },
  { 137, 49, 89, 98 },
  { 97, 49, 137, 98 },
  { 96, 49, 137, 97 },
  { 189, 196, 148, 149 },
  { 229, 181, 221, 230 },
  { 194, 147, 235, 195 },
  { 165, 157, 205, 214 },
  { 164, 107, 155, 156 },
  { 104, 152, 103, 111 },
  { 151, 103, 144, 152 },
  { 127, 174, 167, 119 },
  { 180, 171, 220, 172 },
  { 85, 132, 92, 140 },
  { 98, 51, 139, 99 },
  { 226, 169, 217, 218 },
  { 34, 275, 267, 27 },
  { 14, 262, 255, 22 },
  { 258, 201, 250, 210 },
  { 186, 137, 185, 177 },
  { 186, 137, 177, 129 },
  { 93, 142, 141, 102 },
  { 142, 94, 85, 134 },
  { 93, 54, 94, 142 },
  { 93, 133, 141, 142 },
  { 100, 93, 140, 141 },
  { 141, 93, 140, 133 },
  { 53, 102, 93, 141 },
  { 53, 141, 93, 100 },
  { 53, 101, 141, 100 },
  { 53, 102, 141, 101 },
  { 225, 234, 177, 226 },
  { 243, 4, 43, 3 },
  { 221, 268, 261, 213 },
  { 191, 103, 143, 144 },
  { 151, 144, 192, 152 },
  { 99, 100, 148, 108 },
  { 141, 102, 190, 150 },
  { 180, 188, 179, 131 },
  { 188, 139, 187, 179 },
  { 151, 103, 152, 111 },
  { 143, 55, 95, 96 },
  { 102, 55, 95, 143 },
  { 143, 95, 102, 142 },
  { 135, 95, 143, 142 },
  { 102, 55, 143, 103 },
  { 184, 143, 183, 135 },
  { 211, 163, 203, 212 },
  { 145, 97, 105, 152 },
  { 99, 108, 156, 107 },
  { 104, 144, 103, 152 },
  { 192, 144, 151, 191 },
  { 32, 265, 272, 24 },
  { 278, 269, 30, 270 },
  { 251, 18, 11, 10 },
  { 232, 184, 224, 177 },
  { 185, 144, 145, 192 },
  { 146, 97, 137, 98 },
  { 227, 226, 274, 219 },
  { 171, 123, 163, 172 },
  { 174, 165, 214, 166 },
  { 216, 208, 167, 215 },
  { 183, 143, 190, 135 },
  { 238, 190, 189, 181 },
  { 147, 146, 154, 194 },
  { 178, 170, 171, 123 },
  { 123, 170, 115, 122 },
  { 180, 188, 228, 179 },
  { 189, 141, 188, 181 },
  { 180, 140, 132, 133 },
  { 132, 172, 125, 124 },
  { 4, 243, 244, 252 },
  { 225, 265, 273, 274 },
  { 2, 283, 42, 43 },
  { 150, 102, 103, 110 },
  { 125, 117, 174, 126 },
  { 141, 133, 181, 190 },
  { 190, 142, 133, 182 },
  { 231, 278, 279, 271 },
  { 101, 102, 141, 150 },
  { 150, 102, 143, 103 },
  { 23, 263, 16, 24 },
  { 256, 201, 208, 248 },
  { 151, 200, 159, 152 },
  { 101, 150, 149, 158 },
  { 228, 219, 268, 220 },
  { 14, 254, 247, 255 },
  { 3, 243, 251, 10 },
  { 178, 186, 177, 129 },
  { 210, 250, 203, 202 },
  { 273, 34, 25, 33 },
  { 113, 120, 160, 112 },
  { 114, 105, 154, 106 },
  { 153, 105, 152, 145 },
  { 244, 195, 196, 204 },
  { 173, 172, 165, 125 },
  { 170, 113, 161, 162 },
  { 113, 105, 160, 153 },
  { 112, 105, 160, 113 },
  { 279, 287, 239, 280 },
  { 219, 266, 259, 211 },
  { 178, 169, 218, 170 },
  { 209, 161, 201, 210 },
  { 155, 154, 147, 107 },
  { 228, 171, 219, 220 },
  { 247, 8, 0, 7 },
  { 213, 212, 260, 205 },
  { 129, 184, 176, 136 },
  { 4, 12, 245, 5 },
  { 208, 153, 200, 201 },
  { 163, 210, 203, 155 },
  { 162, 105, 153, 154 },
  { 124, 115, 164, 116 },
  { 157, 156, 149, 109 },
  { 238, 230, 231, 183 },
  { 191, 150, 238, 190 },
  { 23, 22, 263, 30 },
  { 0, 248, 241, 8 },
  { 147, 156, 196, 204 },
  { 176, 168, 127, 175 },
  { 160, 120, 119, 112 },
  { 218, 161, 209, 210 },
  { 165, 117, 157, 166 },
  { 231, 224, 183, 223 },
  { 125, 117, 165, 174 },
  { 172, 212, 165, 164 },
  { 172, 164, 117, 124 },
  { 165, 157, 214, 166 },
  { 173, 181, 133, 182 },
  { 120, 160, 119, 168 },
  { 225, 185, 232, 177 },
  { 223, 222, 215, 175 },
  { 176, 128, 168, 121 },
  { 120, 113, 168, 121 },
  { 121, 113, 168, 161 },
  { 180, 172, 173, 125 },
  { 168, 161, 216, 169 },
  { 231, 224, 223, 272 },
  { 175, 183, 182, 135 },
  { 160, 153, 200, 208 },
  { 176, 184, 183, 135 },
  { 178, 138, 130, 131 },
  { 193, 194, 202, 145 },
  { 163, 162, 155, 115 },
  { 242, 194, 235, 195 },
  { 277, 237, 284, 229 },
  { 43, 44, 283, 35 },
  { 235, 187, 227, 236 },
  { 249, 10, 9, 18 },
  { 243, 250, 251, 10 },
  { 170, 161, 210, 162 },
  { 2, 242, 243, 250 },
  { 163, 210, 155, 162 },
  { 203, 155, 195, 204 },
  { 147, 204, 195, 155 },
  { 126, 166, 119, 118 },
  { 164, 204, 157, 156 },
  { 31, 38, 279, 39 },
  { 133, 180, 173, 125 },
  { 129, 138, 130, 178 },
  { 165, 164, 157, 117 },
  { 120, 168, 119, 127 },
  { 260, 203, 251, 252 },
  { 39, 46, 287, 47 },
  { 286, 198, 239, 246 },
  { 268, 259, 20, 260 },
  { 260, 203, 252, 212 },
  { 263, 262, 22, 255 },
  { 245, 197, 246, 254 },
  { 161, 153, 201, 210 },
  { 199, 246, 198, 206 },
  { 147, 156, 204, 155 },
  { 164, 155, 204, 156 },
  { 166, 206, 159, 158 },
  { 135, 176, 127, 175 },
  { 151, 103, 191, 144 },
  { 147, 202, 155, 195 },
  { 135, 128, 127, 176 },
  { 167, 160, 119, 159 },
  { 167, 166, 159, 119 },
  { 168, 128, 127, 120 },
  { 178, 186, 226, 177 },
  { 214, 157, 206, 166 },
  { 166, 157, 206, 158 },
  { 174, 117, 165, 166 },
  { 176, 177, 129, 169 },
  { 169, 121, 168, 161 },
  { 36, 267, 28, 276 },
  { 141, 102, 142, 190 },
  { 221, 220, 213, 173 },
  { 211, 210, 258, 203 },
  { 169, 161, 209, 218 },
  { 178, 131, 130, 123 },
  { 170, 178, 130, 123 },
  { 240, 233, 192, 280 },
  { 185, 144, 192, 232 },
  { 131, 178, 171, 123 },
  { 171, 170, 163, 123 },
  { 246, 6, 285, 245 },
  { 270, 213, 262, 222 },
  { 259, 28, 19, 267 },
  { 217, 257, 265, 266 },
  { 173, 165, 213, 222 },
  { 188, 139, 179, 131 },
  { 220, 163, 211, 212 },
  { 180, 123, 171, 172 },
  { 180, 133, 132, 125 },
  { 129, 121, 178, 130 },
  { 212, 203, 252, 204 },
  { 141, 181, 189, 190 },
  { 131, 140, 132, 180 },
  { 131, 123, 180, 132 },
  { 182, 125, 174, 134 },
  { 182, 173, 222, 174 },
  { 137, 96, 144, 184 },
  { 129, 136, 176, 128 },
  { 176, 184, 135, 136 },
  { 174, 214, 167, 166 },
  { 135, 182, 175, 127 },
  { 175, 174, 167, 127 },
  { 175, 168, 127, 167 },
  { 192, 145, 200, 152 },
  { 178, 218, 171, 170 },
  { 139, 146, 186, 98 },
  { 190, 143, 142, 135 },
  { 182, 190, 142, 135 },
  { 177, 176, 184, 224 },
  { 224, 216, 175, 223 },
  { 185, 144, 232, 184 },
  { 168, 160, 208, 161 },
  { 198, 151, 239, 199 },
  { 185, 97, 137, 146 },
  { 185, 137, 184, 177 },
  { 145, 97, 185, 146 },
  { 129, 121, 169, 178 },
  { 231, 272, 271, 279 },
  { 131, 123, 171, 180 },
  { 131, 179, 180, 171 },
  { 188, 139, 140, 100 },
  { 178, 179, 131, 171 },
  { 187, 139, 186, 179 },
  { 147, 99, 187, 148 },
  { 274, 282, 225, 234 },
  { 0, 8, 241, 1 },
  { 200, 145, 153, 152 },
  { 221, 173, 213, 222 },
  { 101, 150, 141, 189 },
  { 182, 142, 133, 134 },
  { 135, 142, 182, 134 },
  { 180, 181, 133, 173 },
  { 247, 248, 255, 207 },
  { 181, 173, 221, 230 },
  { 266, 209, 258, 218 },
  { 159, 206, 151, 158 },
  { 160, 152, 200, 153 },
  { 141, 188, 140, 100 },
  { 236, 189, 188, 181 },
  { 194, 146, 234, 187 },
  { 230, 173, 221, 222 },
  { 176, 183, 175, 135 },
  { 190, 102, 142, 143 },
  { 230, 238, 278, 229 },
  { 144, 96, 143, 184 },
  { 26, 266, 18, 259 },
  { 179, 171, 219, 228 },
  { 133, 180, 140, 188 },
  { 146, 137, 186, 98 },
  { 146, 137, 185, 186 },
  { 131, 186, 138, 139 },
  { 131, 178, 138, 186 },
  { 144, 137, 184, 185 },
  { 144, 97, 137, 185 },
  { 144, 97, 185, 145 },
  { 226, 217, 266, 218 },
  { 194, 242, 202, 195 },
  { 187, 147, 148, 196 },
  { 148, 139, 187, 188 },
  { 148, 139, 188, 100 },
  { 146, 99, 187, 147 },
  { 146, 99, 139, 187 },
  { 146, 139, 186, 187 },
  { 43, 283, 42, 35 },
  { 229, 276, 269, 221 },
  { 208, 200, 159, 207 },
  { 200, 145, 193, 153 },
  { 240, 192, 193, 200 },
  { 30, 261, 22, 270 },
  { 141, 190, 189, 150 },
  { 148, 101, 189, 149 },
  { 101, 150, 189, 149 },
  { 237, 246, 286, 285 },
  { 193, 202, 153, 145 },
  { 194, 154, 202, 145 },
  { 202, 154, 153, 145 },
  { 274, 266, 267, 219 },
  { 144, 143, 191, 184 },
  { 191, 143, 183, 184 },
  { 183, 143, 191, 190 },
  { 191, 143, 150, 190 },
  { 150, 103, 191, 151 },
  { 150, 103, 143, 191 },
  { 252, 195, 204, 203 },
  { 167, 214, 159, 166 },
  { 167, 214, 207, 159 },
  { 286, 287, 46, 246 },
  { 238, 189, 229, 181 },
  { 190, 230, 183, 182 },
  { 190, 181, 230, 182 },
  { 229, 221, 278, 230 },
  { 238, 150, 189, 190 },
  { 230, 238, 229, 181 },
  { 263, 256, 255, 16 },
  { 272, 224, 223, 264 },
  { 234, 187, 186, 179 },
  { 285, 46, 277, 37 },
  { 185, 186, 177, 234 },
  { 225, 177, 224, 217 },
  { 4, 252, 245, 12 },
  { 267, 266, 26, 259 },
  { 14, 245, 254, 253 },
  { 274, 217, 266, 226 },
  { 162, 202, 155, 154 },
  { 40, 287, 279, 280 },
  { 269, 277, 38, 29 },
  { 237, 149, 198, 197 },
  { 41, 281, 33, 42 },
  { 229, 228, 181, 236 },
  { 234, 186, 177, 226 },
  { 177, 169, 217, 226 },
  { 226, 225, 217, 177 },
  { 261, 260, 20, 253 },
  { 199, 206, 151, 159 },
  { 157, 204, 149, 156 },
  { 202, 194, 147, 154 },
  { 147, 148, 196, 156 },
  { 44, 277, 36, 37 },
  { 276, 284, 227, 236 },
  { 267, 28, 19, 27 },
  { 235, 187, 236, 196 },
  { 245, 6, 285, 45 },
  { 44, 284, 36, 277 },
  { 196, 149, 237, 197 },
  { 227, 187, 179, 236 },
  { 228, 227, 219, 179 },
  { 30, 270, 22, 263 },
  { 215, 214, 207, 167 },
  { 215, 208, 167, 207 },
  { 199, 206, 159, 207 },
  { 246, 197, 237, 198 },
  { 4, 245, 285, 45 },
  { 286, 246, 46, 285 },
  { 21, 30, 269, 261 },
  { 208, 200, 248, 201 },
  { 214, 205, 254, 206 },
  { 246, 197, 206, 254 },
  { 246, 197, 198, 206 },
  { 160, 152, 159, 200 },
  { 191, 198, 150, 151 },
  { 189, 149, 150, 198 },
  { 160, 153, 208, 161 },
  { 264, 209, 216, 256 },
  { 45, 46, 285, 37 },
  { 39, 279, 32, 40 },
  { 151, 192, 199, 200 },
  { 151, 200, 199, 159 },
  { 2, 250, 243, 10 },
  { 14, 253, 254, 262 },
  { 254, 197, 206, 205 },
  { 216, 208, 256, 209 },
  { 147, 194, 202, 195 },
  { 2, 243, 43, 3 },
  { 200, 153, 193, 201 },
  { 36, 277, 269, 29 },
  { 241, 281, 41, 2 },
  { 242, 42, 281, 2 },
  { 24, 264, 263, 16 },
  { 14, 254, 255, 262 },
  { 23, 263, 15, 16 },
  { 210, 202, 203, 155 },
  { 155, 202, 203, 195 },
  { 31, 38, 271, 279 },
  { 6, 254, 247, 14 },
  { 199, 198, 151, 206 },
  { 213, 212, 205, 165 },
  { 195, 250, 203, 243 },
  { 212, 252, 205, 204 },
  { 197, 244, 196, 204 },
  { 279, 278, 38, 271 },
  { 277, 37, 38, 29 },
  { 279, 280, 239, 231 },
  { 271, 264, 263, 24 },
  { 254, 206, 199, 207 },
  { 213, 165, 205, 214 },
  { 28, 20, 21, 261 },
  { 211, 203, 251, 260 },
  { 12, 251, 260, 20 },
  { 165, 212, 157, 164 },
  { 165, 212, 205, 157 },
  { 243, 195, 252, 203 },
  { 251, 243, 252, 203 },
  { 212, 204, 157, 164 },
  { 192, 144, 191, 232 },
  { 214, 206, 207, 159 },
  { 31, 271, 23, 24 },
  { 219, 259, 267, 268 },
  { 255, 247, 7, 8 },
  { 214, 206, 159, 166 },
  { 245, 197, 254, 205 },
  { 255, 256, 8, 16 },
  { 160, 200, 159, 208 },
  { 160, 208, 159, 167 },
  { 168, 160, 167, 208 },
  { 217, 169, 216, 209 },
  { 264, 257, 256, 16 },
  { 219, 171, 211, 220 },
  { 216, 161, 208, 209 },
  { 169, 161, 216, 209 },
  { 219, 218, 211, 171 },
  { 230, 270, 223, 222 },
  { 251, 250, 258, 10 },
  { 256, 249, 8, 16 },
  { 12, 20, 253, 13 },
  { 259, 251, 20, 260 },
  { 212, 155, 203, 204 },
  { 218, 210, 211, 163 },
  { 244, 4, 283, 243 },
  { 220, 260, 213, 212 },
  { 258, 210, 250, 203 },
  { 171, 218, 163, 170 },
  { 171, 218, 211, 163 },
  { 209, 201, 258, 210 },
  { 218, 210, 163, 170 },
  { 213, 205, 262, 214 },
  { 255, 254, 247, 207 },
  { 279, 272, 280, 231 },
  { 12, 260, 253, 20 },
  { 214, 157, 205, 206 },
  { 220, 212, 213, 165 },
  { 223, 270, 263, 215 },
  { 231, 230, 223, 183 },
  { 28, 259, 20, 268 },
  { 231, 272, 223, 271 },
  { 246, 206, 199, 254 },
  { 220, 212, 165, 172 },
  { 173, 220, 165, 172 },
  { 278, 221, 270, 230 },
  { 15, 255, 7, 8 },
  { 253, 245, 254, 205 },
  { 222, 214, 215, 167 },
  { 217, 169, 209, 218 },
  { 215, 262, 263, 255 },
  { 191, 184, 183, 232 },
  { 175, 222, 167, 174 },
  { 222, 214, 167, 174 },
  { 168, 208, 167, 216 },
  { 168, 216, 167, 175 },
  { 176, 168, 175, 216 },
  { 272, 217, 224, 264 },
  { 264, 256, 263, 16 },
  { 41, 2, 1, 241 },
  { 272, 265, 264, 24 },
  { 213, 260, 253, 205 },
  { 224, 169, 216, 217 },
  { 177, 169, 224, 217 },
  { 171, 163, 211, 220 },
  { 233, 185, 234, 194 },
  { 24, 257, 264, 16 },
  { 180, 188, 181, 228 },
  { 226, 218, 219, 171 },
  { 187, 148, 188, 236 },
  { 42, 282, 34, 275 },
  { 233, 273, 281, 282 },
  { 225, 217, 265, 274 },
  { 268, 211, 259, 260 },
  { 178, 179, 171, 226 },
  { 179, 226, 219, 171 },
  { 219, 218, 266, 211 },
  { 266, 218, 258, 211 },
  { 211, 203, 260, 212 },
  { 178, 226, 171, 218 },
  { 222, 165, 213, 214 },
  { 228, 220, 221, 173 },
  { 246, 6, 46, 285 },
  { 283, 275, 42, 35 },
  { 180, 181, 173, 228 },
  { 181, 228, 221, 173 },
  { 213, 260, 261, 253 },
  { 180, 228, 173, 220 },
  { 280, 273, 272, 32 },
  { 185, 184, 232, 177 },
  { 272, 264, 223, 271 },
  { 222, 262, 215, 214 },
  { 215, 214, 262, 207 },
  { 230, 222, 223, 175 },
  { 224, 176, 184, 183 },
  { 247, 0, 47, 7 },
  { 45, 285, 44, 37 },
  { 199, 151, 239, 192 },
  { 183, 230, 175, 182 },
  { 230, 222, 175, 182 },
  { 176, 169, 224, 177 },
  { 176, 224, 175, 183 },
  { 176, 216, 175, 224 },
  { 192, 145, 233, 193 },
  { 276, 236, 227, 228 },
  { 237, 189, 238, 198 },
  { 283, 4, 44, 43 },
  { 268, 211, 260, 220 },
  { 228, 268, 221, 220 },
  { 274, 217, 265, 266 },
  { 227, 226, 179, 234 },
  { 217, 209, 266, 218 },
  { 26, 259, 19, 267 },
  { 233, 145, 194, 193 },
  { 227, 226, 219, 179 },
  { 226, 266, 219, 218 },
  { 276, 219, 268, 228 },
  { 229, 228, 221, 181 },
  { 235, 147, 196, 195 },
  { 244, 195, 204, 252 },
  { 209, 249, 257, 258 },
  { 4, 243, 252, 12 },
  { 242, 195, 283, 243 },
  { 221, 220, 268, 213 },
  { 275, 267, 36, 276 },
  { 236, 148, 188, 189 },
  { 226, 234, 186, 179 },
  { 274, 265, 26, 266 },
  { 219, 211, 268, 220 },
  { 2, 241, 250, 10 },
  { 271, 270, 30, 263 },
  { 267, 275, 36, 27 },
  { 269, 261, 30, 270 },
  { 223, 270, 271, 263 },
  { 187, 188, 179, 236 },
  { 231, 232, 183, 224 },
  { 239, 280, 192, 232 },
  { 31, 30, 271, 38 },
  { 225, 232, 224, 177 },
  { 232, 144, 191, 184 },
  { 232, 184, 183, 224 },
  { 246, 199, 239, 287 },
  { 6, 246, 46, 287 },
  { 231, 191, 183, 232 },
  { 41, 241, 1, 0 },
  { 242, 193, 250, 241 },
  { 241, 193, 281, 242 },
  { 40, 240, 287, 280 },
  { 233, 185, 192, 232 },
  { 225, 185, 233, 232 },
  { 185, 145, 194, 233 },
  { 192, 145, 185, 233 },
  { 231, 272, 232, 224 },
  { 261, 253, 22, 262 },
  { 32, 273, 25, 33 },
  { 31, 271, 24, 32 },
  { 185, 146, 234, 194 },
  { 233, 185, 225, 234 },
  { 225, 185, 177, 234 },
  { 14, 245, 5, 6 },
  { 227, 235, 234, 187 },
  { 235, 194, 234, 187 },
  { 194, 147, 187, 235 },
  { 187, 147, 196, 235 },
  { 250, 241, 249, 10 },
  { 2, 10, 243, 3 },
  { 275, 35, 36, 27 },
  { 245, 6, 45, 5 },
  { 244, 196, 237, 197 },
  { 229, 237, 236, 189 },
  { 189, 149, 198, 237 },
  { 196, 149, 189, 237 },
  { 198, 150, 189, 238 },
  { 191, 150, 198, 238 },
  { 200, 193, 240, 248 },
  { 273, 225, 280, 272 },
  { 191, 239, 231, 238 },
  { 191, 198, 239, 238 },
  { 198, 151, 191, 239 },
  { 231, 191, 232, 239 },
  { 273, 34, 33, 42 },
  { 40, 32, 33, 273 },
  { 227, 274, 267, 219 },
  { 199, 248, 247, 207 },
  { 0, 247, 248, 8 },
  { 240, 192, 233, 193 },
  { 199, 192, 239, 240 },
  { 2, 243, 283, 43 },
  { 217, 209, 216, 264 },
  { 1, 241, 249, 8 },
  { 1, 10, 249, 241 },
  { 1, 2, 10, 241 },
  { 199, 200, 248, 207 },
  { 208, 200, 207, 248 },
  { 275, 235, 282, 227 },
  { 243, 195, 244, 252 },
  { 194, 193, 202, 242 },
  { 242, 193, 233, 194 },
  { 243, 4, 283, 43 },
  { 3, 4, 12, 243 },
  { 244, 195, 235, 196 },
  { 284, 235, 227, 236 },
  { 276, 268, 269, 221 },
  { 276, 228, 268, 221 },
  { 284, 196, 235, 236 },
  { 284, 237, 236, 229 },
  { 21, 269, 29, 28 },
  { 260, 252, 253, 205 },
  { 6, 245, 254, 14 },
  { 259, 20, 19, 28 },
  { 3, 12, 251, 243 },
  { 245, 252, 197, 205 },
  { 252, 204, 197, 205 },
  { 4, 285, 44, 45 },
  { 229, 269, 277, 278 },
  { 238, 198, 239, 286 },
  { 277, 46, 38, 37 },
  { 237, 196, 244, 284 },
  { 231, 286, 278, 238 },
  { 279, 272, 271, 32 },
  { 286, 198, 246, 237 },
  { 278, 221, 269, 270 },
  { 278, 286, 277, 229 },
  { 200, 193, 248, 201 },
  { 262, 205, 253, 254 },
  { 262, 205, 254, 214 },
  { 12, 252, 245, 253 },
  { 6, 246, 247, 254 },
  { 246, 198, 239, 199 },
  { 272, 225, 280, 232 },
  { 47, 46, 287, 6 },
  { 31, 271, 32, 279 },
  { 215, 262, 255, 207 },
  { 263, 255, 15, 16 },
  { 32, 272, 271, 24 },
  { 214, 254, 207, 206 },
  { 14, 22, 255, 15 },
  { 15, 14, 7, 255 },
  { 0, 247, 240, 248 },
  { 199, 240, 247, 248 },
  { 199, 200, 240, 248 },
  { 281, 193, 233, 242 },
  { 210, 201, 250, 202 },
  { 202, 193, 201, 250 },
  { 250, 193, 201, 241 },
  { 248, 241, 8, 249 },
  { 256, 248, 207, 255 },
  { 249, 16, 9, 8 },
  { 1, 249, 9, 8 },
  { 1, 10, 9, 249 },
  { 256, 208, 207, 248 },
  { 248, 241, 249, 201 },
  { 250, 249, 258, 10 },
  { 2, 241, 242, 250 },
  { 202, 193, 250, 242 },
  { 195, 202, 250, 242 },
  { 217, 209, 257, 266 },
  { 26, 267, 19, 27 },
  { 218, 258, 211, 210 },
  { 218, 209, 258, 210 },
  { 18, 251, 11, 259 },
  { 243, 250, 203, 251 },
  { 211, 258, 259, 251 },
  { 244, 204, 197, 252 },
  { 245, 244, 197, 252 },
  { 4, 244, 245, 252 },
  { 275, 274, 34, 267 },
  { 23, 22, 15, 263 },
  { 267, 259, 28, 268 },
  { 36, 269, 28, 29 },
  { 13, 14, 22, 253 },
  { 13, 253, 5, 14 },
  { 253, 245, 5, 14 },
  { 253, 12, 5, 245 },
  { 13, 12, 5, 253 },
  { 270, 261, 22, 262 },
  { 247, 248, 8, 255 },
  { 21, 22, 30, 261 },
  { 221, 261, 269, 270 },
  { 263, 22, 15, 255 },
  { 262, 254, 255, 207 },
  { 215, 256, 207, 255 },
  { 242, 281, 241, 2 },
  { 40, 280, 279, 32 },
  { 209, 201, 256, 249 },
  { 256, 201, 248, 249 },
  { 248, 249, 8, 256 },
  { 216, 208, 215, 256 },
  { 215, 208, 207, 256 },
  { 272, 264, 271, 24 },
  { 255, 248, 8, 256 },
  { 258, 250, 251, 203 },
  { 265, 26, 25, 34 },
  { 209, 249, 256, 257 },
  { 257, 249, 256, 16 },
  { 24, 16, 17, 257 },
  { 16, 257, 9, 17 },
  { 257, 18, 9, 17 },
  { 249, 18, 9, 257 },
  { 16, 249, 9, 257 },
  { 266, 257, 18, 258 },
  { 266, 209, 257, 258 },
  { 26, 257, 18, 266 },
  { 209, 201, 249, 258 },
  { 258, 201, 249, 250 },
  { 34, 265, 26, 274 },
  { 266, 258, 259, 211 },
  { 34, 267, 26, 27 },
  { 251, 20, 11, 259 },
  { 259, 20, 11, 19 },
  { 18, 259, 11, 19 },
  { 26, 18, 19, 259 },
  { 244, 196, 235, 284 },
  { 269, 268, 28, 261 },
  { 13, 253, 261, 20 },
  { 13, 261, 21, 20 },
  { 267, 36, 28, 27 },
  { 219, 211, 259, 268 },
  { 12, 251, 252, 260 },
  { 12, 252, 253, 260 },
  { 227, 274, 275, 267 },
  { 13, 22, 261, 253 },
  { 13, 22, 21, 261 },
  { 38, 278, 30, 271 },
  { 215, 256, 255, 263 },
  { 269, 38, 30, 29 },
  { 21, 30, 29, 269 },
  { 270, 213, 261, 262 },
  { 221, 213, 270, 222 },
  { 213, 253, 261, 262 },
  { 213, 205, 253, 262 },
  { 278, 270, 30, 271 },
  { 271, 263, 23, 24 },
  { 270, 222, 262, 215 },
  { 223, 222, 270, 215 },
  { 271, 30, 23, 263 },
  { 39, 279, 40, 287 },
  { 39, 287, 40, 47 },
  { 272, 232, 280, 231 },
  { 280, 232, 239, 231 },
  { 272, 225, 232, 224 },
  { 264, 209, 256, 257 },
  { 217, 209, 264, 257 },
  { 264, 216, 215, 256 },
  { 264, 256, 215, 263 },
  { 223, 264, 215, 263 },
  { 223, 216, 215, 264 },
  { 224, 216, 223, 264 },
  { 281, 42, 41, 2 },
  { 280, 272, 279, 32 },
  { 217, 257, 264, 265 },
  { 265, 257, 264, 24 },
  { 32, 24, 25, 265 },
  { 24, 265, 17, 25 },
  { 265, 26, 17, 25 },
  { 257, 26, 17, 265 },
  { 24, 257, 17, 265 },
  { 287, 40, 47, 0 },
  { 284, 276, 36, 277 },
  { 282, 194, 233, 234 },
  { 42, 275, 34, 35 },
  { 2, 242, 283, 243 },
  { 274, 266, 26, 267 },
  { 34, 274, 26, 267 },
  { 219, 266, 267, 259 },
  { 275, 284, 44, 283 },
  { 276, 219, 267, 268 },
  { 227, 219, 267, 276 },
  { 227, 267, 275, 276 },
  { 238, 237, 286, 229 },
  { 285, 6, 46, 45 },
  { 36, 37, 277, 29 },
  { 4, 244, 285, 245 },
  { 276, 268, 28, 269 },
  { 36, 276, 28, 269 },
  { 221, 268, 269, 261 },
  { 286, 239, 287, 246 },
  { 237, 286, 277, 285 },
  { 278, 230, 270, 223 },
  { 223, 264, 263, 271 },
  { 229, 276, 277, 269 },
  { 277, 276, 36, 269 },
  { 287, 199, 239, 240 },
  { 238, 198, 286, 237 },
  { 280, 233, 192, 232 },
  { 231, 278, 271, 223 },
  { 278, 270, 271, 223 },
  { 40, 273, 280, 32 },
  { 225, 217, 272, 265 },
  { 272, 217, 264, 265 },
  { 273, 225, 233, 280 },
  { 275, 282, 274, 227 },
  { 274, 282, 234, 227 },
  { 40, 280, 273, 281 },
  { 273, 280, 233, 281 },
  { 41, 40, 33, 281 },
  { 227, 234, 274, 226 },
  { 274, 234, 225, 226 },
  { 225, 265, 272, 273 },
  { 273, 265, 272, 32 },
  { 32, 265, 25, 273 },
  { 265, 34, 25, 273 },
  { 34, 35, 275, 27 },
  { 277, 284, 276, 229 },
  { 283, 195, 235, 244 },
  { 243, 195, 283, 244 },
  { 229, 228, 276, 221 },
  { 276, 284, 236, 229 },
  { 283, 44, 275, 35 },
  { 235, 284, 275, 283 },
  { 285, 197, 237, 246 },
  { 245, 197, 285, 246 },
  { 229, 221, 269, 278 },
  { 39, 38, 279, 46 },
  { 277, 286, 46, 285 },
  { 238, 286, 278, 229 },
  { 231, 239, 286, 238 },
  { 230, 238, 231, 278 },
  { 287, 240, 239, 280 },
  { 0, 287, 40, 240 },
  { 239, 240, 192, 280 },
  { 233, 282, 281, 242 },
  { 282, 274, 34, 275 },
  { 281, 280, 233, 240 },
  { 240, 193, 233, 281 },
  { 240, 193, 281, 241 },
  { 0, 240, 281, 241 },
  { 0, 281, 41, 241 },
  { 0, 40, 41, 281 },
  { 0, 240, 40, 281 },
  { 40, 280, 281, 240 },
  { 273, 42, 281, 282 },
  { 42, 273, 34, 282 },
  { 282, 273, 34, 274 },
  { 273, 282, 225, 274 },
  { 273, 233, 225, 282 },
  { 235, 194, 282, 234 },
  { 275, 235, 283, 282 },
  { 283, 235, 242, 282 },
  { 42, 283, 242, 282 },
  { 42, 275, 283, 282 },
  { 2, 242, 42, 283 },
  { 242, 195, 235, 283 },
  { 235, 244, 284, 283 },
  { 275, 235, 227, 284 },
  { 275, 284, 227, 276 },
  { 284, 275, 36, 276 },
  { 44, 275, 36, 284 },
  { 237, 196, 284, 236 },
  { 277, 237, 285, 284 },
  { 285, 237, 244, 284 },
  { 44, 285, 244, 284 },
  { 44, 277, 285, 284 },
  { 4, 244, 44, 285 },
  { 244, 197, 237, 285 },
  { 247, 287, 47, 0 },
  { 231, 239, 279, 286 },
  { 231, 286, 279, 278 },
  { 286, 278, 38, 279 },
  { 46, 286, 38, 279 },
  { 46, 277, 38, 286 },
  { 286, 277, 38, 278 },
  { 247, 199, 287, 240 },
  { 0, 247, 287, 240 },
  { 246, 199, 287, 247 },
  { 6, 246, 287, 247 },
  { 47, 287, 247, 6 },
  { 286, 239, 279, 287 },
  { 286, 279, 46, 287 },
  { 39, 46, 279, 287 }
};

static const int O[1728][4] = {
  { 4,0,5,4 },
  { 2,2,2,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,4 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 2,2,2,0 },
  { 0,0,1,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,3,3,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 0,0,2,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,3 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,1 },
  { 0,0,0,0 },
  { 2,0,0,2 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,1,1 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,1,0 },
  { 4,0,0,4 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,4,4,4 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 0,0,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 6,2,4,6 },
  { 0,0,0,2 },
  { 6,2,4,6 },
  { 2,6,4,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 0,4,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,2,0 },
  { 0,0,0,0 },
  { 0,4,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 0,0,0,0 },
  { 1,3,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,2,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,2,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 2,2,2,0 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,2,0,3 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 2,0,0,2 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,3,3 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 4,4,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,2,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 2,0,2,0 },
  { 0,0,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 3,3,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,2,0 },
  { 0,0,0,0 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,4,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,2,0 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,2,0 },
  { 0,0,2,0 },
  { 0,3,3,2 },
  { 0,0,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,2,0 },
  { 0,0,2,0 },
  { 2,2,2,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,4,4,0 },
  { 0,5,5,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 2,2,2,0 },
  { 0,0,0,0 },
  { 0,2,2,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 0,0,1,3 },
  { 0,2,0,3 },
  { 2,2,0,3 },
  { 2,2,0,2 },
  { 2,2,0,0 },
  { 0,0,1,3 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 3,0,0,1 },
  { 0,0,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,4,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,1,0,1 },
  { 0,1,1,1 },
  { 0,1,1,3 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 1,1,1,0 },
  { 1,1,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 1,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 0,0,0,2 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,4,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,0,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 2,2,0,3 },
  { 0,1,3,3 },
  { 0,2,2,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,2 },
  { 2,0,0,0 },
  { 2,0,0,0 },
  { 2,2,0,0 },
  { 0,2,0,2 },
  { 2,2,0,2 },
  { 2,2,0,2 },
  { 0,2,2,2 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,1,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 2,0,0,2 },
  { 2,2,0,2 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 2,6,4,6 },
  { 0,0,0,0 },
  { 0,2,0,3 },
  { 0,1,1,1 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,1,0 },
  { 0,2,0,3 },
  { 2,2,0,0 },
  { 0,0,2,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 1,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 3,3,2,0 },
  { 4,0,0,4 },
  { 0,0,4,0 },
  { 0,4,4,4 },
  { 0,0,0,0 },
  { 0,2,2,2 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 6,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 2,2,0,2 },
  { 4,0,5,5 },
  { 0,0,0,0 },
  { 0,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,4,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,5,5,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 4,4,0,4 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 0,0,0,0 },
  { 0,4,4,4 },
  { 0,0,0,4 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 0,2,0,2 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 2,2,0,3 },
  { 0,0,0,0 },
  { 0,1,0,1 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,2,0 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,6,0,2 },
  { 0,0,0,0 },
  { 0,4,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 1,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 3,3,0,1 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,2 },
  { 2,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,0,0,0 },
  { 2,2,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,2,2 },
  { 2,0,0,0 },
  { 2,0,0,2 },
  { 2,2,0,2 },
  { 2,2,0,0 },
  { 2,0,0,0 },
  { 4,0,4,4 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,0,0,2 },
  { 2,2,0,2 },
  { 2,2,0,2 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 3,0,0,1 },
  { 0,0,0,1 },
  { 0,0,0,0 },
  { 0,0,2,0 },
  { 2,2,0,2 },
  { 2,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,1,0,5 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,4,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 0,0,4,0 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 5,0,0,1 },
  { 0,0,4,4 },
  { 0,2,2,2 },
  { 4,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,4 },
  { 0,0,0,0 },
  { 0,4,4,4 },
  { 0,0,0,2 },
  { 2,6,0,4 },
  { 4,0,4,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 6,2,0,4 },
  { 0,2,4,0 },
  { 4,4,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 0,2,2,2 },
  { 0,2,2,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 4,0,5,5 },
  { 0,1,0,1 },
  { 0,1,0,0 },
  { 4,0,0,4 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 6,2,4,6 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 2,0,4,6 },
  { 2,4,0,6 },
  { 5,1,0,5 },
  { 4,0,0,0 },
  { 4,0,4,5 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,4,0,0 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,4,4,4 },
  { 0,1,0,0 },
  { 0,1,0,5 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,4,4,0 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 3,3,0,1 },
  { 0,0,0,0 },
  { 4,0,4,5 },
  { 0,0,0,0 },
  { 0,0,4,5 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,5,5 },
  { 1,1,0,1 },
  { 1,1,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,4 },
  { 0,0,4,4 },
  { 4,4,0,4 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,6,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,1,0 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,5 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 1,1,0,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 1,1,0,5 },
  { 4,6,6,2 },
  { 0,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,6,4,0 },
  { 0,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,4 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,1,0 },
  { 2,7,4,6 },
  { 4,0,4,4 },
  { 2,2,0,3 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,0 },
  { 1,1,0,1 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,6,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,2,2,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,2,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 0,0,4,0 },
  { 0,0,4,4 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,1 },
  { 0,1,3,1 },
  { 4,4,0,4 },
  { 0,0,0,0 },
  { 1,3,0,1 },
  { 1,1,0,1 },
  { 2,2,0,0 },
  { 6,2,4,0 },
  { 0,0,0,1 },
  { 4,2,6,6 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 5,3,0,1 },
  { 0,0,2,0 },
  { 0,0,0,0 },
  { 0,2,2,0 },
  { 2,2,0,0 },
  { 0,1,1,1 },
  { 0,0,4,0 },
  { 4,0,4,4 },
  { 4,0,5,5 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,4 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 2,2,0,0 },
  { 0,2,2,0 },
  { 0,0,0,4 },
  { 4,4,0,4 },
  { 0,4,4,4 },
  { 2,6,4,6 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,2,2,0 },
  { 2,2,0,0 },
  { 2,2,0,0 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 2,2,0,0 },
  { 0,0,1,0 },
  { 0,4,4,4 },
  { 4,4,4,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 5,0,1,5 },
  { 2,2,0,2 },
  { 2,3,0,3 },
  { 6,2,0,4 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 4,4,0,0 },
  { 4,4,4,0 },
  { 0,1,1,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 2,2,0,2 },
  { 2,6,0,4 },
  { 4,4,4,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 4,0,4,4 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 0,4,4,4 },
  { 4,4,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 6,0,4,4 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,4,4,4 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,1,0,5 },
  { 0,2,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 4,0,0,0 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 4,4,0,6 },
  { 4,0,5,0 },
  { 0,0,0,0 },
  { 0,0,4,5 },
  { 5,1,0,5 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 4,4,4,0 },
  { 5,0,1,1 },
  { 0,1,0,1 },
  { 0,1,1,1 },
  { 0,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 1,1,0,0 },
  { 0,4,4,4 },
  { 4,0,4,4 },
  { 4,4,4,0 },
  { 1,1,0,1 },
  { 0,0,0,0 },
  { 0,0,0,4 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 0,0,4,0 },
  { 4,4,4,0 },
  { 0,0,4,0 },
  { 4,0,4,4 },
  { 4,4,4,0 },
  { 4,0,4,4 },
  { 0,0,4,4 },
  { 0,4,4,0 },
  { 4,4,4,0 },
  { 0,0,4,0 },
  { 0,1,5,0 },
  { 4,4,4,0 },
  { 0,0,0,0 },
  { 0,4,4,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 2,0,2,6 },
  { 5,1,0,5 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 1,1,0,1 },
  { 0,1,0,1 },
  { 1,1,0,5 },
  { 0,1,5,1 },
  { 0,0,0,0 },
  { 0,4,4,4 },
  { 0,0,0,0 },
  { 0,0,0,4 },
  { 4,4,4,0 },
  { 4,0,4,4 },
  { 0,4,4,4 },
  { 0,4,4,0 },
  { 4,0,4,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 4,0,4,4 },
  { 0,4,4,0 },
  { 0,4,4,4 },
  { 4,0,4,4 },
  { 4,4,4,0 },
  { 2,2,0,0 },
  { 0,0,4,0 },
  { 4,0,0,4 },
  { 4,0,4,4 },
  { 0,4,4,4 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 4,4,0,0 },
  { 4,4,4,0 },
  { 4,0,4,0 },
  { 0,1,0,0 },
  { 0,4,4,4 },
  { 4,4,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,4,5 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,4,4,0 },
  { 4,0,5,0 },
  { 4,0,5,4 },
  { 1,1,1,0 },
  { 1,1,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 1,1,0,1 },
  { 1,1,0,0 },
  { 0,1,0,0 },
  { 0,1,0,1 },
  { 1,1,0,1 },
  { 0,4,4,6 },
  { 1,1,0,5 },
  { 0,0,0,0 },
  { 0,0,0,4 },
  { 4,4,4,0 },
  { 4,0,4,4 },
  { 0,4,4,4 },
  { 0,4,4,0 },
  { 4,0,4,0 },
  { 0,5,4,7 },
  { 0,0,4,0 },
  { 0,2,0,0 },
  { 4,0,4,4 },
  { 6,2,0,2 },
  { 0,0,4,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,6,4,4 },
  { 4,4,0,4 },
  { 6,2,0,2 },
  { 0,0,4,0 },
  { 4,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,1,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 0,2,0,3 },
  { 0,2,0,0 },
  { 0,0,2,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,4 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 4,0,0,0 },
  { 0,0,0,0 },
  { 4,4,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,4 },
  { 4,0,4,0 },
  { 0,4,4,0 },
  { 4,4,0,4 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,4,0,4 },
  { 0,0,0,0 },
  { 0,2,0,2 },
  { 2,2,0,2 },
  { 0,0,0,0 },
  { 4,4,0,4 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,3,0,1 },
  { 7,0,5,3 },
  { 0,3,3,1 },
  { 0,0,0,2 },
  { 0,0,4,0 },
  { 0,0,0,2 },
  { 2,2,0,0 },
  { 2,2,0,2 },
  { 6,2,0,2 },
  { 6,0,4,2 },
  { 6,4,4,0 },
  { 6,2,4,0 },
  { 4,0,0,2 },
  { 0,4,0,0 },
  { 4,0,4,0 },
  { 0,0,4,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,2,0 },
  { 4,0,2,0 },
  { 4,0,0,0 },
  { 6,2,4,0 },
  { 2,2,0,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 4,0,4,0 },
  { 0,2,0,0 },
  { 0,0,0,0 },
  { 0,0,2,0 },
  { 4,0,2,0 },
  { 4,0,0,0 },
  { 6,2,4,0 },
  { 2,2,0,0 },
  { 2,0,4,7 },
  { 0,0,0,0 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 4,0,4,0 },
  { 4,0,4,0 },
  { 0,0,4,0 },
  { 2,2,0,3 },
  { 7,2,0,3 },
  { 2,2,0,2 },
  { 6,2,0,2 },
  { 4,0,2,6 },
  { 0,0,0,0 },
  { 0,0,4,0 },
  { 4,4,0,0 }
};

static const unsigned C[288] = {
  1721,
  1507,
  1699,
  1468,
  1711,
  1532,
  1724,
  1495,
  1548,
  1557,
  1510,
  1568,
  1577,
  1580,
  1530,
  1537,
  1557,
  1614,
  1569,
  1569,
  1573,
  1584,
  1580,
  1593,
  1614,
  1659,
  1621,
  1660,
  1632,
  1629,
  1593,
  1489,
  1658,
  1653,
  1691,
  1666,
  1705,
  1629,
  1719,
  1727,
  1688,
  1686,
  1699,
  1456,
  1711,
  1628,
  1727,
  1724,
  839,
  861,
  855,
  872,
  788,
  888,
  881,
  903,
  637,
  683,
  681,
  681,
  658,
  722,
  677,
  726,
  726,
  738,
  679,
  742,
  549,
  752,
  723,
  755,
  738,
  778,
  697,
  814,
  666,
  799,
  723,
  813,
  813,
  794,
  814,
  835,
  800,
  880,
  777,
  850,
  806,
  859,
  821,
  836,
  871,
  886,
  881,
  902,
  1120,
  1130,
  1124,
  1137,
  1135,
  1147,
  1118,
  1158,
  908,
  969,
  950,
  961,
  907,
  971,
  932,
  898,
  978,
  992,
  950,
  1001,
  970,
  1042,
  1013,
  1037,
  1038,
  1092,
  924,
  1094,
  984,
  1070,
  1013,
  1078,
  1073,
  1092,
  1065,
  1127,
  1069,
  1123,
  1106,
  1117,
  1074,
  1129,
  1127,
  1138,
  1123,
  1145,
  1118,
  1158,
  1397,
  1409,
  1414,
  1421,
  1383,
  1429,
  1431,
  1436,
  1214,
  1229,
  1191,
  1281,
  1192,
  1294,
  1111,
  1268,
  1269,
  1274,
  1179,
  1322,
  1258,
  1338,
  1264,
  1313,
  1314,
  1358,
  1289,
  1337,
  1302,
  1345,
  1311,
  1360,
  1360,
  1416,
  1337,
  1392,
  1345,
  1375,
  1357,
  1401,
  1398,
  1416,
  1384,
  1421,
  1392,
  1430,
  1167,
  1437,
  1678,
  1683,
  1694,
  1700,
  1706,
  1712,
  1641,
  1722,
  1498,
  1562,
  1513,
  1549,
  1521,
  1588,
  1493,
  1546,
  1546,
  1600,
  1517,
  1575,
  1336,
  1588,
  1493,
  1604,
  1605,
  1647,
  1517,
  1625,
  1386,
  1670,
  1592,
  1644,
  1605,
  1693,
  1655,
  1703,
  1664,
  1673,
  1675,
  1715,
  1642,
  1693,
  1694,
  1702,
  1706,
  1712,
  1675,
  1725,
  1721,
  1685,
  1700,
  1663,
  1712,
  1669,
  1723,
  1724,
  1548,
  1562,
  1562,
  1576,
  1577,
  1588,
  1538,
  1582,
  1602,
  1614,
  1564,
  1622,
  1577,
  1633,
  1591,
  1637,
  1647,
  1659,
  1622,
  1626,
  1633,
  1670,
  1644,
  1644,
  1657,
  1693,
  1692,
  1705,
  1704,
  1719,
  1719,
  1727,
  1688,
  1689,
  1698,
  1701,
  1710,
  1712,
  1726,
  1727
};

  this->clear();

  std::vector<Vertex_handle> vertices;

  vertices.reserve(6*6*8);
  Cell_handle cells[1728];

  FT domain_x(domain().xmax() - domain().xmin());
  FT domain_y(domain().ymax() - domain().ymin());
  FT domain_z(domain().zmax() - domain().zmin());

  for (unsigned i = 0; i < 6; ++i)
  {
    for (unsigned j = 0; j < 6; ++j)
    {
      for (unsigned k = 0; k < 8; ++k)
      {
        Vertex_handle vh = tds().create_vertex();
        vertices.push_back(vh);

        FT x = (FT(i) * domain_x / FT(6)) + domain().xmin();
        if (k % 2)
          x += FT(1) * domain_x / FT(12);
        FT y = (FT(j) * domain_y / FT(6)) + domain().ymin();
        if (k % 2)
          y += FT(1) * domain_y / FT(12);
        FT z = (FT(k) * domain_z / FT(8)) + domain().zmin();

        vh->set_point(Weighted_point(Bare_point(x, y, z), 0));
      }
    }
  }

  for (Cell_handle* iter=cells, *end_iter=cells+1728; iter!=end_iter; ++iter)
    *iter = tds().create_cell();



  for(unsigned i = 0; i < 1728; ++i){
    cells[i]->set_vertices(vertices[V[i][0]], vertices[V[i][1]], vertices[V[i][2]], vertices[V[i][3]]);
    cells[i]->set_neighbors(cells[N[i][0]], cells[N[i][1]], cells[N[i][2]], cells[N[i][3]]);
    set_offsets(cells[i],O[i][0],O[i][1],O[i][2],O[i][3]);
  }

  for(unsigned int i = 0; i < 288; ++i){
    vertices[i]->set_cell(cells[C[i]]);
  }

  tds().set_dimension(3);
  this->set_cover(make_array(1,1,1));

  return vertices;
}

#endif // CGAL_INCLUDE_FROM_PERIODIC_3_REGULAR_TRIANGULATION_3_H
