*** Settings ***
Documentation       Check the ports status

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Start Mockoon    ${MOCKOON_JSON}
Suite Teardown      Stop Mockoon
Test Timeout        120s


*** Variables ***
${MOCKOON_JSON}     ${CURDIR}${/}keysight.json

${cmd}              ${CENTREON_PLUGINS}
...                 --plugin=network::keysight::nvos::restapi::plugin
...                 --custommode=api
...                 --hostname=${HOSTNAME}
...                 --api-username=username
...                 --api-password=password
...                 --proto=http
...                 --port=${APIPORT}


*** Test Cases ***
ports ${tc}
    [Tags]    network    restapi    notauto
    ${command}    Catenate
    ...    ${cmd}
    ...    --mode=ports
    ...    ${extraoptions}
    Log    ${cmd}
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:         tc    extraoptions                                                                                    expected_result    --
            ...       1     --verbose                                                                                       OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.percentage'=0.00%;;;0;100 checking port 'P01' license status: valid link operational status: up [admin: enabled] checking port 'P12' license status: valid link operational status: up [admin: enabled] checking port 'P14' license status: valid link operational status: up [admin: enabled] traffic out: 0.00%, traffic-out : Buffer creation packets packets-out : Buffer creation, packets-dropped : Buffer creation, packets-pass : Buffer creation, packets-insp : Buffer creation checking port 'P17' license status: valid link operational status: up [admin: enabled] traffic out: 0.00%, traffic-out : Buffer creation packets packets-out : Buffer creation, packets-dropped : Buffer creation, packets-pass : Buffer creation, packets-insp : Buffer creation
            ...       2     --filter-name                                                                                   OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       3     --unknown-license-status=\\\%{status}                                                           UNKNOWN: port 'P01' license status: valid - port 'P12' license status: valid - port 'P14' license status: valid - port 'P17' license status: valid | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       4     --warning-license-status='\\\%{status} =~ /invalid_software_version/'                           OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0; 
            ...       5     --critical-license-status=\\\%{name}                                                            CRITICAL: port 'P01' license status: valid - port 'P12' license status: valid - port 'P14' license status: valid - port 'P17' license status: valid | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0; 
            ...       6     --unknown-link-status=\\\%{adminStatus}                                                         UNKNOWN: port 'P01' link operational status: up [admin: enabled] - port 'P12' link operational status: up [admin: enabled] - port 'P14' link operational status: up [admin: enabled] - port 'P17' link operational status: up [admin: enabled] | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       7     --warning-link-status=\\\%{name}                                                                WARNING: port 'P01' link operational status: up [admin: enabled] - port 'P12' link operational status: up [admin: enabled] - port 'P14' link operational status: up [admin: enabled] - port 'P17' link operational status: up [admin: enabled] | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       8     --critical-link-status='\\\%{adminStatus} eq "enabled" and \\\%{operationalStatus} ne "up"'     OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       9     --warning-traffic-out-prct --critical-traffic-out-prct                                          OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       10    --warning-packets-out --critical-packets-out                                                    OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       11    --warning-traffic-out=0 --critical-traffic-out=100                                              OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;0:0;0:100;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;0:0;0:100;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       12    --warning-packets-dropped=10 --critical-packets-dropped=0                                       OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;0:10;0:0;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;0:10;0:0;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       13    --warning-packets-pass --critical-packets-pass                                                  OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;;;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;;;0;
            ...       14    --warning-packets-insp=150 --critical-packets-insp=5                                            OK: All ports are ok | 'P14#port.traffic.out.percentage'=0.00%;;;0;100 'P14#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P14#port.packets.out.count'=0;;;0; 'P14#port.packets.dropped.count'=0;;;0; 'P14#port.packets.pass.count'=0;;;0; 'P14#port.packets.insp.count'=0;0:150;0:5;0; 'P17#port.traffic.out.percentage'=0.00%;;;0;100 'P17#port.traffic.out.bytespersecond'=0.00B/s;;;0; 'P17#port.packets.out.count'=0;;;0; 'P17#port.packets.dropped.count'=0;;;0; 'P17#port.packets.pass.count'=0;;;0; 'P17#port.packets.insp.count'=0;0:150;0:5;0;
